/*
 * Decompiled with CFR 0.152.
 */
package org.dhallj.cbor;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.dhallj.cbor.AdditionalInfo;
import org.dhallj.cbor.CborException;
import org.dhallj.cbor.HalfFloat;
import org.dhallj.cbor.MajorType;
import org.dhallj.cbor.NullVisitor;
import org.dhallj.cbor.Visitor;

public abstract class Reader {
    private static final BigInteger TWO = new BigInteger("2");

    public final <R> R nextSymbol(Visitor<R> visitor) {
        this.skip55799();
        byte by = this.read();
        switch (MajorType.fromByte(by)) {
            case UNSIGNED_INTEGER: {
                return visitor.onUnsignedInteger(this.readUnsignedInteger(by));
            }
            case NEGATIVE_INTEGER: {
                return visitor.onNegativeInteger(this.readNegativeInteger(by));
            }
            case BYTE_STRING: {
                return visitor.onByteString(this.readByteString(by));
            }
            case TEXT_STRING: {
                return visitor.onTextString(this.readTextString(by));
            }
            case ARRAY: {
                return this.readArrayStart(by, visitor);
            }
            case MAP: {
                return visitor.onMap(this.readMapStart(by));
            }
            case SEMANTIC_TAG: {
                throw new CborException("We should have skipped semantic tags");
            }
            case PRIMITIVE: {
                return this.readPrimitive(by, visitor);
            }
        }
        throw new CborException("Invalid CBOR major type " + Byte.toString(by));
    }

    protected abstract byte read();

    protected abstract byte peek();

    protected abstract byte[] read(int var1);

    public final BigInteger readUnsignedInteger() {
        this.skip55799();
        return this.readUnsignedInteger(this.read());
    }

    public final BigInteger readPositiveBigNum() {
        this.skip55799();
        BigInteger bigInteger = this.readBigNum();
        if (bigInteger.compareTo(BigInteger.ZERO) < 0) {
            throw new CborException(bigInteger.toString() + " is not a positive big num");
        }
        return bigInteger;
    }

    public final BigInteger readBigNum() {
        this.skip55799();
        byte by = this.read();
        switch (MajorType.fromByte(by)) {
            case UNSIGNED_INTEGER: {
                return this.readUnsignedInteger(by);
            }
            case NEGATIVE_INTEGER: {
                return this.readNegativeInteger(by);
            }
            case SEMANTIC_TAG: {
                AdditionalInfo additionalInfo = AdditionalInfo.fromByte(by);
                BigInteger bigInteger = this.readBigInteger(additionalInfo, by);
                long l = bigInteger.longValue();
                BigInteger bigInteger2 = this.readUnsignedInteger();
                long l2 = bigInteger2.longValue();
                BigInteger bigInteger3 = this.readBigInteger(l2);
                if (l == 2L) {
                    return bigInteger3;
                }
                if (l == 3L) {
                    return BigInteger.valueOf(-1L).subtract(bigInteger3);
                }
                throw new CborException(Long.toString(l) + " is not a valid tag for a bignum");
            }
        }
        throw new CborException("Not a valid major type for an Unsigned Integer: " + MajorType.fromByte(by).toString());
    }

    public final BigDecimal readBigDecimal() {
        this.skip55799();
        byte by = this.read();
        switch (MajorType.fromByte(by)) {
            case SEMANTIC_TAG: {
                AdditionalInfo additionalInfo = AdditionalInfo.fromByte(by);
                BigInteger bigInteger = this.readBigInteger(additionalInfo, by);
                long l = bigInteger.longValue();
                if (l == 4L) {
                    BigInteger bigInteger2 = this.readArrayStart();
                    if (bigInteger2.equals(TWO)) {
                        BigInteger bigInteger3 = this.readBigNum();
                        int n = -bigInteger3.intValue();
                        BigInteger bigInteger4 = this.readBigNum();
                        return new BigDecimal(bigInteger4, n);
                    }
                    throw new CborException("Invalid decimal fraction");
                }
                throw new CborException(Long.toString(l) + " is not a valid tag for a decimal fraction");
            }
        }
        throw new CborException("Next symbol is not a decimal fraction");
    }

    public final String readNullableTextString() {
        this.skip55799();
        byte by = this.read();
        switch (MajorType.fromByte(by)) {
            case TEXT_STRING: {
                return this.readTextString(by);
            }
            case PRIMITIVE: {
                return this.readPrimitive(by, NullVisitor.instanceForString);
            }
        }
        throw new CborException("Next symbol is neither a text string or null");
    }

    public final byte[] readNullableByteString() {
        this.skip55799();
        byte by = this.read();
        switch (MajorType.fromByte(by)) {
            case BYTE_STRING: {
                return this.readByteString(by);
            }
            case PRIMITIVE: {
                return this.readPrimitive(by, NullVisitor.instanceForByteArray);
            }
        }
        throw new CborException("Next symbol is neither a byte string or null");
    }

    public final String tryReadTextString() {
        this.skip55799();
        byte by = this.peek();
        switch (MajorType.fromByte(by)) {
            case TEXT_STRING: {
                return this.readTextString(this.read());
            }
        }
        return null;
    }

    public final BigInteger readArrayStart() {
        this.skip55799();
        byte by = this.read();
        switch (MajorType.fromByte(by)) {
            case ARRAY: {
                AdditionalInfo additionalInfo = AdditionalInfo.fromByte(by);
                BigInteger bigInteger = this.readBigInteger(additionalInfo, by);
                if (bigInteger.compareTo(BigInteger.ZERO) < 0) {
                    throw new CborException("Indefinite array not needed for Dhall");
                }
                return bigInteger;
            }
        }
        throw new CborException("Next symbol is not an array");
    }

    public final <R> Map<String, R> readMap(Visitor<R> visitor) {
        this.skip55799();
        byte by = this.read();
        switch (MajorType.fromByte(by)) {
            case MAP: {
                int n = this.readMapStart(by).intValue();
                HashMap<String, R> hashMap = new HashMap<String, R>(n);
                for (int i = 0; i < n; ++i) {
                    String string = this.readNullableTextString();
                    R r = this.nextSymbol(visitor);
                    hashMap.put(string, r);
                }
                return hashMap;
            }
        }
        throw new CborException("Cannot read map - major type is " + MajorType.fromByte(by).toString());
    }

    private final BigInteger readUnsignedInteger(byte by) {
        AdditionalInfo additionalInfo = AdditionalInfo.fromByte(by);
        return this.readBigInteger(additionalInfo, by);
    }

    private final BigInteger readNegativeInteger(byte by) {
        AdditionalInfo additionalInfo = AdditionalInfo.fromByte(by);
        return BigInteger.valueOf(-1L).subtract(this.readBigInteger(additionalInfo, by));
    }

    private final byte[] readByteString(byte by) {
        AdditionalInfo additionalInfo = AdditionalInfo.fromByte(by);
        BigInteger bigInteger = this.readBigInteger(additionalInfo, by);
        if (bigInteger.compareTo(BigInteger.ZERO) < 0) {
            throw new CborException("Indefinite byte string not needed for Dhall");
        }
        return this.read(bigInteger.intValue());
    }

    private final String readTextString(byte by) {
        AdditionalInfo additionalInfo = AdditionalInfo.fromByte(by);
        BigInteger bigInteger = this.readBigInteger(additionalInfo, by);
        if (bigInteger.compareTo(BigInteger.ZERO) < 0) {
            throw new CborException("Indefinite text string not needed for Dhall");
        }
        return new String(this.read(bigInteger.intValue()), Charset.forName("UTF-8"));
    }

    private final <R> R readArrayStart(byte by, Visitor<R> visitor) {
        AdditionalInfo additionalInfo = AdditionalInfo.fromByte(by);
        BigInteger bigInteger = this.readBigInteger(additionalInfo, by);
        if (bigInteger.compareTo(BigInteger.ZERO) < 0) {
            throw new CborException("Indefinite array not needed for Dhall");
        }
        this.skip55799();
        byte by2 = this.read();
        switch (MajorType.fromByte(by2)) {
            case UNSIGNED_INTEGER: {
                return visitor.onArray(bigInteger, this.readUnsignedInteger(by2));
            }
            case TEXT_STRING: {
                return visitor.onVariableArray(bigInteger, this.readTextString(by2));
            }
        }
        throw new CborException("Invalid start to CBOR-encoded Dhall expression " + MajorType.fromByte(by).toString());
    }

    private final BigInteger readMapStart(byte by) {
        AdditionalInfo additionalInfo = AdditionalInfo.fromByte(by);
        BigInteger bigInteger = this.readBigInteger(additionalInfo, by);
        if (bigInteger.compareTo(BigInteger.ZERO) < 0) {
            throw new CborException("Indefinite array not needed for Dhall");
        }
        return bigInteger;
    }

    private static final String unassignedMessage(int n) {
        StringBuilder stringBuilder = new StringBuilder("Primitive ");
        stringBuilder.append(n);
        stringBuilder.append(" is unassigned");
        return stringBuilder.toString();
    }

    private static final String notValidMessage(int n) {
        StringBuilder stringBuilder = new StringBuilder("Primitive ");
        stringBuilder.append(n);
        stringBuilder.append(" is not valid");
        return stringBuilder.toString();
    }

    private final <R> R readPrimitive(byte by, Visitor<R> visitor) {
        int n = by & 0x1F;
        if (0 <= n && n <= 19) {
            throw new CborException(Reader.unassignedMessage(n));
        }
        if (n == 20) {
            return visitor.onFalse();
        }
        if (n == 21) {
            return visitor.onTrue();
        }
        if (n == 22) {
            return visitor.onNull();
        }
        if (n == 23) {
            throw new CborException(Reader.unassignedMessage(n));
        }
        if (n == 24) {
            throw new CborException("Simple value not needed for Dhall");
        }
        if (n == 25) {
            int n2 = 0;
            for (int i = 0; i < 2; ++i) {
                int n3 = this.read() & 0xFF;
                n2 <<= 8;
                n2 |= n3;
            }
            return visitor.onHalfFloat(HalfFloat.toFloat(n2));
        }
        if (n == 26) {
            int n4 = 0;
            for (int i = 0; i < 4; ++i) {
                int n5 = this.read() & 0xFF;
                n4 <<= 8;
                n4 |= n5;
            }
            return visitor.onSingleFloat(Float.intBitsToFloat(n4));
        }
        if (n == 27) {
            long l = 0L;
            for (int i = 0; i < 8; ++i) {
                int n6 = this.read() & 0xFF;
                l <<= 8;
                l |= (long)n6;
            }
            return visitor.onDoubleFloat(Double.longBitsToDouble(l));
        }
        if (28 <= n && n <= 30) {
            throw new CborException(Reader.unassignedMessage(n));
        }
        if (n == 31) {
            throw new CborException("Break stop code not needed for Dhall");
        }
        throw new CborException(Reader.notValidMessage(n));
    }

    private final void skip55799() {
        byte by = this.peek();
        switch (MajorType.fromByte(by)) {
            case SEMANTIC_TAG: {
                AdditionalInfo additionalInfo = AdditionalInfo.fromByte(by);
                switch (additionalInfo) {
                    case DIRECT: {
                        return;
                    }
                }
                BigInteger bigInteger = this.readBigInteger(additionalInfo, this.read());
                int n = bigInteger.intValue();
                if (n != 55799) {
                    throw new CborException("Unrecognized CBOR semantic tag " + Integer.toString(n));
                }
                this.skip55799();
            }
        }
    }

    private final BigInteger readBigInteger(AdditionalInfo additionalInfo, byte by) {
        switch (additionalInfo) {
            case DIRECT: {
                return BigInteger.valueOf(by & 0x1F);
            }
            case ONE_BYTE: {
                return this.readBigInteger(1L);
            }
            case TWO_BYTES: {
                return this.readBigInteger(2L);
            }
            case FOUR_BYTES: {
                return this.readBigInteger(4L);
            }
            case EIGHT_BYTES: {
                return this.readBigInteger(8L);
            }
            case RESERVED: {
                throw new CborException("Additional info RESERVED should not require reading a uintXX");
            }
            case INDEFINITE: {
                return BigInteger.valueOf(-1L);
            }
        }
        throw new IllegalArgumentException("Invalid AdditionalInfo");
    }

    private final BigInteger readBigInteger(long l) {
        BigInteger bigInteger = BigInteger.ZERO;
        for (long i = 0L; i < l; ++i) {
            int n = this.read() & 0xFF;
            bigInteger = bigInteger.shiftLeft(8).or(BigInteger.valueOf(n));
        }
        return bigInteger;
    }

    public static final class ByteArrayReader
    extends Reader {
        private final byte[] bytes;
        private int cursor = 0;

        public ByteArrayReader(byte[] byArray) {
            this.bytes = byArray;
        }

        @Override
        protected byte read() {
            return this.bytes[this.cursor++];
        }

        @Override
        protected byte peek() {
            return this.bytes[this.cursor];
        }

        @Override
        protected byte[] read(int n) {
            byte[] byArray = new byte[n];
            System.arraycopy(this.bytes, this.cursor, byArray, 0, n);
            this.cursor += n;
            return byArray;
        }
    }
}

