/*
 * Decompiled with CFR 0.152.
 */
package org.dhallj.core;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dhallj.core.ArrayIterable;
import org.dhallj.core.Expr;
import org.dhallj.core.ExprState;
import org.dhallj.core.ExternalVisitor;
import org.dhallj.core.Operator;
import org.dhallj.core.VisitState;

final class Constructors {
    Constructors() {
    }

    static final class RemoteImport
    extends Expr {
        final URI url;
        final Expr using;
        final Expr.ImportMode mode;
        final byte[] hash;

        RemoteImport(URI uRI, Expr expr, Expr.ImportMode importMode, byte[] byArray) {
            super(28);
            this.url = uRI;
            this.using = expr;
            this.mode = importMode;
            this.hash = byArray;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onRemoteImport(this.url, this.using, this.mode, this.hash);
        }

        @Override
        final <A> void advance(VisitState<A> visitState) {
            switch (visitState.current.state) {
                case 0: {
                    visitState.visitor.prepareRemoteImport(this.url, this.using, this.mode, this.hash);
                    visitState.current.state = 1;
                    if (this.using != null) {
                        visitState.stack.push(visitState.current);
                        visitState.stack.push(new ExprState(this.using, 0));
                        break;
                    }
                    visitState.valueStack.push(null);
                }
                case 1: {
                    visitState.valueStack.push(visitState.visitor.onRemoteImport(this.url, visitState.valueStack.poll(), this.mode, this.hash));
                }
            }
        }
    }

    static final class ClasspathImport
    extends Expr {
        final Path path;
        final Expr.ImportMode mode;
        final byte[] hash;

        ClasspathImport(Path path, Expr.ImportMode importMode, byte[] byArray) {
            super(29);
            this.path = path;
            this.mode = importMode;
            this.hash = byArray;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onClasspathImport(this.path, this.mode, this.hash);
        }

        @Override
        final <A> void advance(VisitState<A> visitState) {
            visitState.valueStack.push(visitState.visitor.onClasspathImport(this.path, this.mode, this.hash));
        }
    }

    static final class LocalImport
    extends Expr {
        final Path path;
        final Expr.ImportMode mode;
        final byte[] hash;

        LocalImport(Path path, Expr.ImportMode importMode, byte[] byArray) {
            super(27);
            this.path = path;
            this.mode = importMode;
            this.hash = byArray;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onLocalImport(this.path, this.mode, this.hash);
        }

        @Override
        final <A> void advance(VisitState<A> visitState) {
            visitState.valueStack.push(visitState.visitor.onLocalImport(this.path, this.mode, this.hash));
        }
    }

    static final class EnvImport
    extends Expr {
        final String name;
        final Expr.ImportMode mode;
        final byte[] hash;

        EnvImport(String string, Expr.ImportMode importMode, byte[] byArray) {
            super(26);
            this.name = string;
            this.mode = importMode;
            this.hash = byArray;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onEnvImport(this.name, this.mode, this.hash);
        }

        @Override
        final <A> void advance(VisitState<A> visitState) {
            visitState.valueStack.push(visitState.visitor.onEnvImport(this.name, this.mode, this.hash));
        }
    }

    static final class MissingImport
    extends Expr {
        final Expr.ImportMode mode;
        final byte[] hash;

        MissingImport(Expr.ImportMode importMode, byte[] byArray) {
            super(25);
            this.mode = importMode;
            this.hash = byArray;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onMissingImport(this.mode, this.hash);
        }

        @Override
        final <A> void advance(VisitState<A> visitState) {
            visitState.valueStack.push(visitState.visitor.onMissingImport(this.mode, this.hash));
        }
    }

    static final class With
    extends Expr {
        final Expr base;
        final String[] path;
        final Expr value;

        With(Expr expr, String[] stringArray, Expr expr2) {
            super(30);
            this.base = expr;
            this.path = stringArray;
            this.value = expr2;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onWith(this.base, this.path, this.value);
        }

        @Override
        final <A> void advance(VisitState<A> visitState) {
            switch (visitState.current.state) {
                case 0: {
                    visitState.visitor.prepareWith(this.path);
                    visitState.current.state = 1;
                    visitState.stack.push(visitState.current);
                    visitState.stack.push(new ExprState(this.base, 0));
                    break;
                }
                case 1: {
                    visitState.visitor.prepareWithValue(this.path);
                    visitState.current.state = 2;
                    visitState.stack.push(visitState.current);
                    visitState.stack.push(new ExprState(this.value, 0));
                    break;
                }
                case 2: {
                    Object a = visitState.valueStack.poll();
                    Object a2 = visitState.valueStack.poll();
                    visitState.valueStack.push(visitState.visitor.onWith(a2, this.path, a));
                }
            }
        }
    }

    static final class ToMap
    extends Expr {
        final Expr base;
        final Expr type;

        ToMap(Expr expr, Expr expr2) {
            super(24);
            this.base = expr;
            this.type = expr2;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onToMap(this.base, this.type);
        }

        @Override
        final <A> void advance(VisitState<A> visitState) {
            switch (visitState.current.state) {
                case 0: {
                    visitState.visitor.prepareToMap(this.type);
                    visitState.current.state = 1;
                    visitState.stack.push(visitState.current);
                    visitState.stack.push(new ExprState(this.base, 0));
                    break;
                }
                case 1: {
                    visitState.current.state = 2;
                    if (this.type != null) {
                        visitState.stack.push(visitState.current);
                        visitState.stack.push(new ExprState(this.type, 0));
                        break;
                    }
                    visitState.valueStack.push(null);
                }
                case 2: {
                    Object a = visitState.valueStack.poll();
                    Object a2 = visitState.valueStack.poll();
                    visitState.valueStack.push(visitState.visitor.onToMap(a2, a));
                }
            }
        }
    }

    static final class Merge
    extends Expr {
        final Expr handlers;
        final Expr union;
        final Expr type;

        Merge(Expr expr, Expr expr2, Expr expr3) {
            super(23);
            this.handlers = expr;
            this.union = expr2;
            this.type = expr3;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onMerge(this.handlers, this.union, this.type);
        }

        @Override
        final <A> void advance(VisitState<A> visitState) {
            switch (visitState.current.state) {
                case 0: {
                    visitState.visitor.prepareMerge(this.type);
                    visitState.current.state = 1;
                    visitState.stack.push(visitState.current);
                    visitState.stack.push(new ExprState(this.handlers, 0));
                    break;
                }
                case 1: {
                    visitState.current.state = 2;
                    visitState.stack.push(visitState.current);
                    visitState.stack.push(new ExprState(this.union, 0));
                    break;
                }
                case 2: {
                    visitState.current.state = 3;
                    if (this.type != null) {
                        visitState.stack.push(visitState.current);
                        visitState.stack.push(new ExprState(this.type, 0));
                        break;
                    }
                    visitState.valueStack.push(null);
                }
                case 3: {
                    Object a = visitState.valueStack.poll();
                    Object a2 = visitState.valueStack.poll();
                    Object a3 = visitState.valueStack.poll();
                    visitState.valueStack.push(visitState.visitor.onMerge(a3, a2, a));
                }
            }
        }
    }

    static final class Annotated
    extends Expr {
        final Expr base;
        final Expr type;

        Annotated(Expr expr, Expr expr2) {
            super(21);
            this.base = expr;
            this.type = expr2;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onAnnotated(this.base, this.type);
        }

        @Override
        final <A> void advance(VisitState<A> visitState) {
            if (visitState.current.state == 0) {
                visitState.visitor.prepareAnnotated(this.type);
                visitState.current.state = 1;
                visitState.stack.push(visitState.current);
                visitState.stack.push(new ExprState(this.base, 0));
            } else if (visitState.current.state == 1) {
                visitState.current.state = 2;
                visitState.stack.push(visitState.current);
                visitState.stack.push(new ExprState(this.type, 0));
            } else {
                Object a = visitState.valueStack.poll();
                Object a2 = visitState.valueStack.poll();
                visitState.valueStack.push(visitState.visitor.onAnnotated(a2, a));
            }
        }
    }

    static final class Let
    extends Expr {
        final String name;
        final Expr type;
        final Expr value;
        final Expr body;

        Let(String string, Expr expr, Expr expr2, Expr expr3) {
            super(8);
            this.name = string;
            this.type = expr;
            this.value = expr2;
            this.body = expr3;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onLet(this.name, this.type, this.value, this.body);
        }

        @Override
        final <A> void advance(VisitState<A> visitState) {
            ArrayList<String> arrayList;
            List<Object> list;
            if (visitState.current.state == 0) {
                list = new ArrayList<Expr.LetBinding<Expr>>();
                list.add(new Expr.LetBinding<Expr>(this.name, this.type, this.value));
                Let.gatherLetBindings(this.body, list);
                visitState.current.state = 1;
                visitState.current.size = list.size();
                arrayList = new ArrayList<String>(visitState.current.size);
                for (Object object : list) {
                    arrayList.add(((Expr.LetBinding)object).getName());
                }
                visitState.letBindingNamesStack.push(arrayList);
                visitState.visitor.prepareLet(list.size());
            } else {
                list = visitState.letBindingsStack.poll();
            }
            if (list.isEmpty()) {
                if (visitState.current.state == 1) {
                    visitState.current.state = 3;
                    visitState.stack.push(visitState.current);
                    visitState.stack.push(new ExprState(Let.gatherLetBindings(this.body, null), 0));
                    visitState.letBindingsStack.push(list);
                } else {
                    Object object;
                    arrayList = visitState.letBindingNamesStack.poll();
                    LinkedList linkedList = new LinkedList();
                    object = visitState.valueStack.poll();
                    for (int i = 0; i < visitState.current.size; ++i) {
                        Object a = visitState.valueStack.poll();
                        Object a2 = visitState.valueStack.poll();
                        linkedList.push(new Expr.LetBinding((String)arrayList.get(visitState.current.size - 1 - i), a2, a));
                    }
                    visitState.valueStack.push(visitState.visitor.onLet(linkedList, object));
                }
            } else {
                arrayList = (Expr.LetBinding)list.get(0);
                switch (visitState.current.state) {
                    case 1: {
                        visitState.current.state = 2;
                        visitState.visitor.prepareLetBinding(((Expr.LetBinding)((Object)arrayList)).getName(), (Expr)((Expr.LetBinding)((Object)arrayList)).getType());
                        if (((Expr.LetBinding)((Object)arrayList)).hasType()) {
                            visitState.stack.push(visitState.current);
                            visitState.stack.push(new ExprState((Expr)((Expr.LetBinding)((Object)arrayList)).getType(), 0));
                            visitState.letBindingsStack.push(list);
                            break;
                        }
                        visitState.valueStack.push(null);
                    }
                    case 2: {
                        visitState.current.state = 1;
                        visitState.visitor.bind(((Expr.LetBinding)((Object)arrayList)).getName(), (Expr)((Expr.LetBinding)((Object)arrayList)).getType());
                        visitState.stack.push(visitState.current);
                        visitState.stack.push(new ExprState((Expr)((Expr.LetBinding)((Object)arrayList)).getValue(), 0));
                        list.remove(0);
                        visitState.letBindingsStack.push(list);
                    }
                }
            }
        }

        private static final Expr gatherLetBindings(Expr expr, List<Expr.LetBinding<Expr>> list) {
            Expr expr2 = expr.getNonNote();
            while (expr2.tag == 8) {
                Let let = (Let)expr2;
                if (list != null) {
                    list.add(new Expr.LetBinding<Expr>(let.name, let.type, let.value));
                }
                expr2 = let.body.getNonNote();
            }
            return expr2;
        }
    }

    static final class EmptyListLiteral
    extends Expr {
        final Expr type;

        EmptyListLiteral(Expr expr) {
            super(11);
            this.type = expr;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onEmptyList(this.type);
        }

        @Override
        final <A> void advance(VisitState<A> visitState) {
            if (visitState.current.state == 0) {
                if (visitState.visitor.flattenToMapLists() && EmptyListLiteral.isToMapListType(this.type)) {
                    visitState.stack.push(new ExprState(Expr.Constants.EMPTY_RECORD_LITERAL, 0));
                } else if (visitState.visitor.prepareEmptyList(this.type)) {
                    visitState.current.state = 1;
                    visitState.stack.push(visitState.current);
                    visitState.stack.push(new ExprState(this.type, 0));
                } else {
                    visitState.valueStack.push(null);
                }
            } else {
                visitState.valueStack.push(visitState.visitor.onEmptyList(visitState.valueStack.poll()));
            }
        }

        private static final boolean isToMapListType(Expr expr) {
            Expr expr2 = Expr.Util.getListArg(expr);
            if (expr2 == null) {
                return false;
            }
            List<Map.Entry<String, Expr>> list = Expr.Util.asRecordType(expr2);
            if (list == null) {
                return false;
            }
            Map.Entry<Expr, Expr> entry = Expr.Util.flattenToMapRecord(list);
            if (entry == null) {
                return false;
            }
            String string = Expr.Util.asBuiltIn(entry.getKey());
            return string != null && string.equals("Text");
        }
    }

    static final class NonEmptyListLiteral
    extends Expr {
        final Expr[] values;

        NonEmptyListLiteral(Expr[] exprArray) {
            super(10);
            this.values = exprArray;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onNonEmptyList(new ArrayIterable<Expr>(this.values), this.values.length);
        }

        @Override
        final <A> void advance(VisitState<A> visitState) {
            if (visitState.current.state == 0) {
                Expr expr;
                boolean bl = false;
                if (visitState.visitor.flattenToMapLists() && (expr = NonEmptyListLiteral.flattenToMapList(this.values)) != null) {
                    visitState.stack.push(new ExprState(expr, 0));
                    bl = true;
                }
                if (!bl) {
                    visitState.visitor.prepareNonEmptyList(this.values.length);
                    visitState.visitor.prepareNonEmptyListElement(0);
                    visitState.current.state = 1;
                    visitState.stack.push(visitState.current);
                    visitState.stack.push(new ExprState(this.values[visitState.current.state - 1], 0));
                }
            } else if (visitState.current.state == this.values.length) {
                ArrayList arrayList = new ArrayList();
                for (int i = 0; i < this.values.length; ++i) {
                    arrayList.add(visitState.valueStack.poll());
                }
                Collections.reverse(arrayList);
                visitState.valueStack.push(visitState.visitor.onNonEmptyList(arrayList));
            } else {
                visitState.visitor.prepareNonEmptyListElement(visitState.current.state);
                ++visitState.current.state;
                visitState.stack.push(visitState.current);
                visitState.stack.push(new ExprState(this.values[visitState.current.state - 1], 0));
            }
        }

        private static final Expr flattenToMapList(Expr[] exprArray) {
            LinkedHashMap<String, Expr> linkedHashMap = new LinkedHashMap<String, Expr>(exprArray.length);
            for (Expr expr : exprArray) {
                List<Map.Entry<String, Expr>> list = Expr.Util.asRecordLiteral(expr);
                if (list == null) {
                    return null;
                }
                Map.Entry<Expr, Expr> entry = Expr.Util.flattenToMapRecord(list);
                if (entry == null) {
                    return null;
                }
                String string = Expr.Util.asSimpleTextLiteral(entry.getKey());
                if (string == null) {
                    return null;
                }
                linkedHashMap.put(string, entry.getValue());
            }
            Set set = linkedHashMap.entrySet();
            return Expr.makeRecordLiteral(set.toArray(new Map.Entry[set.size()]));
        }
    }

    static final class UnionType
    extends Expr {
        final Map.Entry<String, Expr>[] fields;

        UnionType(Map.Entry<String, Expr>[] entryArray) {
            super(14);
            this.fields = entryArray;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onUnionType(new ArrayIterable<Map.Entry<String, Expr>>(this.fields), this.fields.length);
        }

        @Override
        final <A> void advance(VisitState<A> visitState) {
            if (visitState.current.state == 0) {
                visitState.visitor.prepareUnionType(this.fields.length);
                if (this.fields.length == 0) {
                    visitState.valueStack.push(visitState.visitor.onUnionType(new ArrayList()));
                } else {
                    visitState.current = new ExprState(visitState.current.expr, 1, this.fields, visitState.visitor.sortFields());
                    visitState.stack.push(visitState.current);
                    Map.Entry<String, Expr> entry = visitState.current.sortedFields[visitState.current.state - 1];
                    visitState.visitor.prepareUnionTypeField(entry.getKey(), entry.getValue(), visitState.current.state - 1);
                    Expr expr = entry.getValue();
                    if (expr == null) {
                        visitState.valueStack.push(null);
                    } else {
                        visitState.stack.push(new ExprState(expr, 0));
                    }
                }
            } else if (visitState.current.state == this.fields.length) {
                ArrayList arrayList = new ArrayList();
                for (int i = visitState.current.sortedFields.length - 1; i >= 0; --i) {
                    arrayList.add(new AbstractMap.SimpleImmutableEntry(visitState.current.sortedFields[i].getKey(), visitState.valueStack.poll()));
                }
                Collections.reverse(arrayList);
                visitState.valueStack.push(visitState.visitor.onUnionType(arrayList));
            } else {
                ++visitState.current.state;
                Map.Entry<String, Expr> entry = visitState.current.sortedFields[visitState.current.state - 1];
                Expr expr = entry.getValue();
                visitState.visitor.prepareUnionTypeField(entry.getKey(), expr, visitState.current.state - 1);
                visitState.stack.push(visitState.current);
                if (expr == null) {
                    visitState.valueStack.push(null);
                } else {
                    visitState.stack.push(new ExprState(expr, 0));
                }
            }
        }
    }

    static final class RecordType
    extends Expr {
        final Map.Entry<String, Expr>[] fields;

        RecordType(Map.Entry<String, Expr>[] entryArray) {
            super(13);
            this.fields = entryArray;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onRecordType(new ArrayIterable<Map.Entry<String, Expr>>(this.fields), this.fields.length);
        }

        @Override
        final <A> void advance(VisitState<A> visitState) {
            if (visitState.current.state == 0) {
                visitState.visitor.prepareRecordType(this.fields.length);
                if (this.fields.length == 0) {
                    visitState.valueStack.push(visitState.visitor.onRecordType(new ArrayList()));
                } else {
                    visitState.current = new ExprState(visitState.current.expr, 1, this.fields, visitState.visitor.sortFields());
                    visitState.stack.push(visitState.current);
                    Map.Entry<String, Expr> entry = visitState.current.sortedFields[visitState.current.state - 1];
                    visitState.visitor.prepareRecordTypeField(entry.getKey(), entry.getValue(), visitState.current.state - 1);
                    visitState.stack.push(new ExprState(entry.getValue(), 0));
                }
            } else if (visitState.current.state == visitState.current.sortedFields.length) {
                ArrayList arrayList = new ArrayList();
                for (int i = visitState.current.sortedFields.length - 1; i >= 0; --i) {
                    arrayList.add(new AbstractMap.SimpleImmutableEntry(visitState.current.sortedFields[i].getKey(), visitState.valueStack.poll()));
                }
                Collections.reverse(arrayList);
                visitState.valueStack.push(visitState.visitor.onRecordType(arrayList));
            } else {
                ++visitState.current.state;
                Map.Entry<String, Expr> entry = visitState.current.sortedFields[visitState.current.state - 1];
                visitState.visitor.prepareRecordTypeField(entry.getKey(), entry.getValue(), visitState.current.state - 1);
                visitState.stack.push(visitState.current);
                visitState.stack.push(new ExprState(entry.getValue(), 0));
            }
        }
    }

    static final class RecordLiteral
    extends Expr {
        final Map.Entry<String, Expr>[] fields;

        RecordLiteral(Map.Entry<String, Expr>[] entryArray) {
            super(12);
            this.fields = entryArray;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onRecord(new ArrayIterable<Map.Entry<String, Expr>>(this.fields), this.fields.length);
        }

        @Override
        final <A> void advance(VisitState<A> visitState) {
            if (visitState.current.state == 0) {
                visitState.visitor.prepareRecord(this.fields.length);
                if (this.fields.length == 0) {
                    visitState.valueStack.push(visitState.visitor.onRecord(new ArrayList()));
                } else {
                    visitState.current = new ExprState(visitState.current.expr, 1, this.fields, visitState.visitor.sortFields());
                    visitState.stack.push(visitState.current);
                    Map.Entry<String, Expr> entry = visitState.current.sortedFields[visitState.current.state - 1];
                    visitState.visitor.prepareRecordField(entry.getKey(), entry.getValue(), visitState.current.state - 1);
                    visitState.stack.push(new ExprState(entry.getValue(), 0));
                }
            } else if (visitState.current.state == visitState.current.sortedFields.length) {
                ArrayList arrayList = new ArrayList();
                for (int i = visitState.current.sortedFields.length - 1; i >= 0; --i) {
                    arrayList.add(new AbstractMap.SimpleImmutableEntry(visitState.current.sortedFields[i].getKey(), visitState.valueStack.poll()));
                }
                Collections.reverse(arrayList);
                visitState.valueStack.push(visitState.visitor.onRecord(arrayList));
            } else {
                ++visitState.current.state;
                Map.Entry<String, Expr> entry = visitState.current.sortedFields[visitState.current.state - 1];
                visitState.visitor.prepareRecordField(entry.getKey(), entry.getValue(), visitState.current.state - 1);
                visitState.stack.push(visitState.current);
                visitState.stack.push(new ExprState(entry.getValue(), 0));
            }
        }
    }

    static final class Identifier
    extends Expr {
        final String name;
        final long index;

        Identifier(String string, long l) {
            super(5);
            this.name = string;
            this.index = l;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onIdentifier(this.name, this.index);
        }

        @Override
        final <A> void advance(VisitState<A> visitState) {
            visitState.valueStack.push(visitState.visitor.onIdentifier(this, this.name, this.index));
        }
    }

    static final class BuiltIn
    extends Expr {
        final String name;

        BuiltIn(String string) {
            super(4);
            this.name = string;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onBuiltIn(this.name);
        }

        @Override
        final <A> void advance(VisitState<A> visitState) {
            visitState.valueStack.push(visitState.visitor.onBuiltIn(this, this.name));
        }
    }

    static final class ProjectionByType
    extends Expr {
        final Expr base;
        final Expr type;

        ProjectionByType(Expr expr, Expr expr2) {
            super(17);
            this.base = expr;
            this.type = expr2;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onProjectionByType(this.base, this.type);
        }

        @Override
        final <A> void advance(VisitState<A> visitState) {
            if (visitState.current.state == 0) {
                visitState.visitor.prepareProjectionByType();
                visitState.current.state = 1;
                visitState.stack.push(visitState.current);
                visitState.stack.push(new ExprState(this.base, 0));
            } else if (visitState.current.state == 1) {
                visitState.visitor.prepareProjectionByType(this.type);
                visitState.current.state = 2;
                visitState.stack.push(visitState.current);
                visitState.stack.push(new ExprState(this.type, 0));
            } else {
                Object a = visitState.valueStack.poll();
                Object a2 = visitState.valueStack.poll();
                visitState.valueStack.push(visitState.visitor.onProjectionByType(a2, a));
            }
        }
    }

    static final class Projection
    extends Expr {
        final Expr base;
        final String[] fieldNames;

        Projection(Expr expr, String[] stringArray) {
            super(16);
            this.base = expr;
            this.fieldNames = stringArray;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onProjection(this.base, this.fieldNames);
        }

        @Override
        final <A> void advance(VisitState<A> visitState) {
            if (visitState.current.state == 0) {
                visitState.visitor.prepareProjection(this.fieldNames.length);
                visitState.current.state = 1;
                visitState.stack.push(visitState.current);
                visitState.stack.push(new ExprState(this.base, 0));
            } else {
                visitState.valueStack.push(visitState.visitor.onProjection(visitState.valueStack.poll(), this.fieldNames));
            }
        }
    }

    static final class FieldAccess
    extends Expr {
        final Expr base;
        final String fieldName;

        FieldAccess(Expr expr, String string) {
            super(15);
            this.base = expr;
            this.fieldName = string;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onFieldAccess(this.base, this.fieldName);
        }

        @Override
        final <A> void advance(VisitState<A> visitState) {
            if (visitState.current.state == 0) {
                if (visitState.visitor.prepareFieldAccess(this.base, this.fieldName)) {
                    visitState.current.state = 1;
                    visitState.stack.push(visitState.current);
                    visitState.stack.push(new ExprState(this.base, 0));
                } else {
                    visitState.valueStack.push(visitState.visitor.onFieldAccess(null, this.fieldName));
                }
            } else {
                visitState.valueStack.push(visitState.visitor.onFieldAccess(visitState.valueStack.poll(), this.fieldName));
            }
        }
    }

    static final class Assert
    extends Expr {
        final Expr base;

        Assert(Expr expr) {
            super(22);
            this.base = expr;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onAssert(this.base);
        }

        @Override
        final <A> void advance(VisitState<A> visitState) {
            if (visitState.current.state == 0) {
                visitState.visitor.prepareAssert();
                visitState.current.state = 1;
                visitState.stack.push(visitState.current);
                visitState.stack.push(new ExprState(this.base, 0));
            } else {
                visitState.valueStack.push(visitState.visitor.onAssert(visitState.valueStack.poll()));
            }
        }
    }

    static final class Pi
    extends Expr {
        final String name;
        final Expr type;
        final Expr result;

        Pi(String string, Expr expr, Expr expr2) {
            super(7);
            this.name = string;
            this.type = expr;
            this.result = expr2;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onPi(this.name, this.type, this.result);
        }

        @Override
        final <A> void advance(VisitState<A> visitState) {
            switch (visitState.current.state) {
                case 0: {
                    visitState.visitor.preparePi(this.name, this.type);
                    visitState.current.state = 1;
                    visitState.stack.push(visitState.current);
                    visitState.stack.push(new ExprState(this.type, 0));
                    break;
                }
                case 1: {
                    visitState.visitor.bind(this.name, this.type);
                    visitState.current.state = 2;
                    visitState.stack.push(visitState.current);
                    visitState.stack.push(new ExprState(this.result, 0));
                    break;
                }
                case 2: {
                    Object a = visitState.valueStack.poll();
                    Object a2 = visitState.valueStack.poll();
                    visitState.valueStack.push(visitState.visitor.onPi(this.name, a2, a));
                }
            }
        }
    }

    static final class Lambda
    extends Expr {
        final String name;
        final Expr type;
        final Expr result;

        Lambda(String string, Expr expr, Expr expr2) {
            super(6);
            this.name = string;
            this.type = expr;
            this.result = expr2;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onLambda(this.name, this.type, this.result);
        }

        @Override
        final <A> void advance(VisitState<A> visitState) {
            switch (visitState.current.state) {
                case 0: {
                    visitState.visitor.prepareLambda(this.name, this.type);
                    visitState.current.state = 1;
                    visitState.stack.push(visitState.current);
                    visitState.stack.push(new ExprState(this.type, 0));
                    break;
                }
                case 1: {
                    visitState.visitor.bind(this.name, this.type);
                    visitState.current.state = 2;
                    visitState.stack.push(visitState.current);
                    visitState.stack.push(new ExprState(this.result, 0));
                    break;
                }
                case 2: {
                    Object a = visitState.valueStack.poll();
                    Object a2 = visitState.valueStack.poll();
                    visitState.valueStack.push(visitState.visitor.onLambda(this.name, a2, a));
                }
            }
        }
    }

    static final class If
    extends Expr {
        final Expr predicate;
        final Expr thenValue;
        final Expr elseValue;

        If(Expr expr, Expr expr2, Expr expr3) {
            super(20);
            this.predicate = expr;
            this.thenValue = expr2;
            this.elseValue = expr3;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onIf(this.predicate, this.thenValue, this.elseValue);
        }

        @Override
        final <A> void advance(VisitState<A> visitState) {
            if (visitState.current.state == 0) {
                visitState.visitor.prepareIf();
                visitState.current.state = 1;
                visitState.stack.push(visitState.current);
                visitState.stack.push(new ExprState(this.predicate, 0));
            } else if (visitState.current.state == 1) {
                visitState.current.state = 2;
                visitState.stack.push(visitState.current);
                visitState.stack.push(new ExprState(this.thenValue, 0));
            } else if (visitState.current.state == 2) {
                visitState.current.state = 3;
                visitState.stack.push(visitState.current);
                visitState.stack.push(new ExprState(this.elseValue, 0));
            } else {
                Object a = visitState.valueStack.poll();
                Object a2 = visitState.valueStack.poll();
                Object a3 = visitState.valueStack.poll();
                visitState.valueStack.push(visitState.visitor.onIf(a3, a2, a));
            }
        }
    }

    static final class OperatorApplication
    extends Expr {
        final Operator operator;
        final Expr lhs;
        final Expr rhs;

        OperatorApplication(Operator operator, Expr expr, Expr expr2) {
            super(19);
            this.operator = operator;
            this.lhs = expr;
            this.rhs = expr2;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onOperatorApplication(this.operator, this.lhs, this.rhs);
        }

        @Override
        final <A> void advance(VisitState<A> visitState) {
            if (visitState.current.state == 0) {
                visitState.visitor.prepareOperatorApplication(this.operator);
                visitState.current.state = 1;
                visitState.stack.push(visitState.current);
                visitState.stack.push(new ExprState(this.lhs, 0));
            } else if (visitState.current.state == 1) {
                visitState.current.state = 2;
                visitState.stack.push(visitState.current);
                visitState.stack.push(new ExprState(this.rhs, 0));
            } else {
                Object a = visitState.valueStack.poll();
                Object a2 = visitState.valueStack.poll();
                visitState.valueStack.push(visitState.visitor.onOperatorApplication(this.operator, a2, a));
            }
        }
    }

    static final class Application
    extends Expr {
        final Expr base;
        final Expr arg;

        Application(Expr expr, Expr expr2) {
            super(18);
            this.base = expr;
            this.arg = expr2;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onApplication(this.base, this.arg);
        }

        @Override
        final <A> void advance(VisitState<A> visitState) {
            if (visitState.current.state == 0) {
                LinkedList<Expr> linkedList = new LinkedList<Expr>();
                linkedList.push(this.arg);
                Expr expr = Application.gatherApplicationArgs(this.base, linkedList);
                visitState.current.state = 1;
                visitState.current.size = linkedList.size();
                boolean bl = visitState.visitor.prepareApplication(expr, linkedList.size());
                visitState.current.skippedRecursion = !bl;
                visitState.stack.push(visitState.current);
                if (bl) {
                    visitState.stack.push(new ExprState(expr, 0));
                }
                visitState.applicationStack.push(linkedList);
            } else {
                LinkedList<Expr> linkedList = visitState.applicationStack.poll();
                if (linkedList.isEmpty()) {
                    ArrayList arrayList = new ArrayList(visitState.current.size);
                    for (int i = 0; i < visitState.current.size; ++i) {
                        arrayList.add(visitState.valueStack.poll());
                    }
                    Collections.reverse(arrayList);
                    Object a = null;
                    if (!visitState.current.skippedRecursion) {
                        a = visitState.valueStack.poll();
                    }
                    visitState.valueStack.push(visitState.visitor.onApplication(a, arrayList));
                } else {
                    visitState.stack.push(visitState.current);
                    visitState.stack.push(new ExprState(linkedList.poll(), 0));
                    visitState.applicationStack.push(linkedList);
                }
            }
        }

        private static final Expr gatherApplicationArgs(Expr expr, Deque<Expr> deque) {
            Expr expr2 = expr.getNonNote();
            while (expr2.tag == 18) {
                Application application = (Application)expr2;
                if (deque != null) {
                    deque.push(application.arg);
                }
                expr2 = application.base.getNonNote();
            }
            return expr2;
        }
    }

    static final class TextLiteral
    extends Expr {
        final String[] parts;
        final Expr[] interpolated;

        TextLiteral(String[] stringArray, Expr[] exprArray) {
            super(9);
            this.parts = stringArray;
            this.interpolated = exprArray;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onText(this.parts, new ArrayIterable<Expr>(this.interpolated));
        }

        @Override
        final <A> void advance(VisitState<A> visitState) {
            if (visitState.current.state == 0) {
                visitState.visitor.prepareText(this.parts.length);
                visitState.visitor.prepareTextPart(this.parts[0]);
                if (this.interpolated.length == 0) {
                    visitState.valueStack.push(visitState.visitor.onText(this.parts, new ArrayList()));
                } else {
                    visitState.current.state = 1;
                    visitState.stack.push(visitState.current);
                    visitState.stack.push(new ExprState(this.interpolated[visitState.current.state - 1], 0));
                }
            } else if (visitState.current.state == this.interpolated.length) {
                visitState.visitor.prepareTextPart(this.parts[this.parts.length - 1]);
                ArrayList arrayList = new ArrayList();
                for (int i = 0; i < this.interpolated.length; ++i) {
                    arrayList.add(visitState.valueStack.poll());
                }
                Collections.reverse(arrayList);
                visitState.valueStack.push(visitState.visitor.onText(this.parts, arrayList));
            } else {
                ++visitState.current.state;
                visitState.visitor.prepareTextPart(this.parts[visitState.current.state - 1]);
                visitState.stack.push(visitState.current);
                visitState.stack.push(new ExprState(this.interpolated[visitState.current.state - 1], 0));
            }
        }
    }

    static final class TimeZoneLiteral
    extends Expr {
        final int minutes;

        TimeZoneLiteral(int n) {
            super(33);
            this.minutes = n;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onTimeZone(this.minutes);
        }

        @Override
        final <A> void advance(VisitState<A> visitState) {
            visitState.valueStack.push(visitState.visitor.onTimeZone(this, this.minutes));
        }
    }

    static final class TimeLiteral
    extends Expr {
        final int hour;
        final int minute;
        final int second;
        final BigDecimal fractional;

        TimeLiteral(int n, int n2, int n3, BigDecimal bigDecimal) {
            super(32);
            this.hour = n;
            this.minute = n2;
            this.second = n3;
            this.fractional = bigDecimal;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onTime(this.hour, this.minute, this.second, this.fractional);
        }

        @Override
        final <A> void advance(VisitState<A> visitState) {
            visitState.valueStack.push(visitState.visitor.onTime(this, this.hour, this.minute, this.second, this.fractional));
        }
    }

    static final class DateLiteral
    extends Expr {
        final int year;
        final int month;
        final int day;

        DateLiteral(int n, int n2, int n3) {
            super(31);
            this.year = n;
            this.month = n2;
            this.day = n3;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onDate(this.year, this.month, this.day);
        }

        @Override
        final <A> void advance(VisitState<A> visitState) {
            visitState.valueStack.push(visitState.visitor.onDate(this, this.year, this.month, this.day));
        }
    }

    static final class DoubleLiteral
    extends Expr {
        final double value;

        DoubleLiteral(double d) {
            super(3);
            this.value = d;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onDouble(this.value);
        }

        @Override
        final <A> void advance(VisitState<A> visitState) {
            visitState.valueStack.push(visitState.visitor.onDouble(this, this.value));
        }
    }

    static final class IntegerLiteral
    extends Expr {
        final BigInteger value;

        IntegerLiteral(BigInteger bigInteger) {
            super(2);
            this.value = bigInteger;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onInteger(this.value);
        }

        @Override
        final <A> void advance(VisitState<A> visitState) {
            visitState.valueStack.push(visitState.visitor.onInteger(this, this.value));
        }
    }

    static final class NaturalLiteral
    extends Expr {
        final BigInteger value;

        NaturalLiteral(BigInteger bigInteger) {
            super(1);
            this.value = bigInteger;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onNatural(this.value);
        }

        @Override
        final <A> void advance(VisitState<A> visitState) {
            visitState.valueStack.push(visitState.visitor.onNatural(this, this.value));
        }
    }
}

