/*
 * Decompiled with CFR 0.152.
 */
package org.dhallj.core.binary;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dhallj.cbor.Writer;
import org.dhallj.core.Expr;
import org.dhallj.core.Operator;
import org.dhallj.core.Source;
import org.dhallj.core.Visitor;

public final class Encode
implements Visitor<Void> {
    private final Writer writer;

    public Encode(Writer writer) {
        this.writer = writer;
    }

    @Override
    public boolean sortFields() {
        return true;
    }

    @Override
    public boolean flattenToMapLists() {
        return false;
    }

    @Override
    public Void onNote(Void void_, Source source) {
        return void_;
    }

    @Override
    public Void onNatural(Expr expr, BigInteger bigInteger) {
        this.writer.writeArrayStart(2);
        this.writer.writeLong(15L);
        this.writer.writeBigInteger(bigInteger);
        return null;
    }

    @Override
    public Void onInteger(Expr expr, BigInteger bigInteger) {
        this.writer.writeArrayStart(2);
        this.writer.writeLong(16L);
        this.writer.writeBigInteger(bigInteger);
        return null;
    }

    @Override
    public Void onDouble(Expr expr, double d) {
        this.writer.writeDouble(d);
        return null;
    }

    @Override
    public Void onDate(Expr expr, int n, int n2, int n3) {
        this.writer.writeArrayStart(4);
        this.writer.writeLong(30L);
        this.writer.writeLong(n);
        this.writer.writeLong(n2);
        this.writer.writeLong(n3);
        return null;
    }

    @Override
    public Void onTime(Expr expr, int n, int n2, int n3, BigDecimal bigDecimal) {
        this.writer.writeArrayStart(4);
        this.writer.writeLong(31L);
        this.writer.writeLong(n);
        this.writer.writeLong(n2);
        this.writer.writeBigDecimal(bigDecimal.add(BigDecimal.valueOf(n3)));
        return null;
    }

    @Override
    public Void onTimeZone(Expr expr, int n) {
        boolean bl = n >= 0;
        this.writer.writeArrayStart(4);
        this.writer.writeLong(32L);
        this.writer.writeBoolean(bl);
        int n2 = Math.abs(n);
        this.writer.writeLong(n2 / 60);
        this.writer.writeLong(n2 % 60);
        return null;
    }

    @Override
    public Void onBuiltIn(Expr expr, String string) {
        if (string.equals("True")) {
            this.writer.writeBoolean(true);
        } else if (string.equals("False")) {
            this.writer.writeBoolean(false);
        } else {
            this.writer.writeString(string);
        }
        return null;
    }

    @Override
    public Void onIdentifier(Expr expr, String string, long l) {
        if (string.equals("_")) {
            this.writer.writeLong(l);
        } else {
            this.writer.writeArrayStart(2);
            this.writer.writeString(string);
            this.writer.writeLong(l);
        }
        return null;
    }

    @Override
    public void bind(String string, Expr expr) {
    }

    @Override
    public boolean prepareLambda(String string, Expr expr) {
        if (string.equals("_")) {
            this.writer.writeArrayStart(3);
            this.writer.writeLong(1L);
        } else {
            this.writer.writeArrayStart(4);
            this.writer.writeLong(1L);
            this.writer.writeString(string);
        }
        return true;
    }

    @Override
    public Void onLambda(String string, Void void_, Void void_2) {
        return null;
    }

    @Override
    public boolean preparePi(String string, Expr expr) {
        if (string.equals("_")) {
            this.writer.writeArrayStart(3);
            this.writer.writeLong(2L);
        } else {
            this.writer.writeArrayStart(4);
            this.writer.writeLong(2L);
            this.writer.writeString(string);
        }
        return true;
    }

    @Override
    public Void onPi(String string, Void void_, Void void_2) {
        return null;
    }

    @Override
    public boolean prepareLet(int n) {
        this.writer.writeArrayStart(2 + n * 3);
        this.writer.writeLong(25L);
        return true;
    }

    @Override
    public boolean prepareLetBinding(String string, Expr expr) {
        this.writer.writeString(string);
        if (expr == null) {
            this.writer.writeNull();
        }
        return true;
    }

    @Override
    public Void onLet(List<Expr.LetBinding<Void>> list, Void void_) {
        return null;
    }

    private static final String unescapeText(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\\') {
                char c;
                if ((c = string.charAt(++i)) == '\"') {
                    stringBuilder.append('\"');
                    continue;
                }
                if (c == '\\') {
                    stringBuilder.append('\\');
                    continue;
                }
                if (c == 'b') {
                    stringBuilder.append('\b');
                    continue;
                }
                if (c == 'f') {
                    stringBuilder.append('\f');
                    continue;
                }
                if (c == 'n') {
                    stringBuilder.append('\n');
                    continue;
                }
                if (c == 'r') {
                    stringBuilder.append('\r');
                    continue;
                }
                if (c == 't') {
                    stringBuilder.append('\t');
                    continue;
                }
                stringBuilder.append('\\');
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append(string.charAt(i));
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean prepareText(int n) {
        this.writer.writeArrayStart(n * 2);
        this.writer.writeLong(18L);
        return true;
    }

    @Override
    public boolean prepareTextPart(String string) {
        this.writer.writeString(Encode.unescapeText(string));
        return true;
    }

    @Override
    public Void onText(String[] stringArray, List<Void> list) {
        return null;
    }

    @Override
    public boolean prepareNonEmptyList(int n) {
        this.writer.writeArrayStart(n + 2);
        this.writer.writeLong(4L);
        this.writer.writeNull();
        return true;
    }

    @Override
    public boolean prepareNonEmptyListElement(int n) {
        return true;
    }

    @Override
    public Void onNonEmptyList(List<Void> list) {
        return null;
    }

    @Override
    public boolean prepareEmptyList(Expr expr) {
        Expr expr2 = Expr.Util.getListArg(expr);
        this.writer.writeArrayStart(2);
        this.writer.writeLong(expr2 != null ? 4L : 28L);
        if (expr2 != null) {
            expr2.accept(this);
            return false;
        }
        return true;
    }

    @Override
    public Void onEmptyList(Void void_) {
        return null;
    }

    @Override
    public boolean prepareRecord(int n) {
        this.writer.writeArrayStart(2);
        this.writer.writeLong(8L);
        this.writer.writeMapStart(n);
        return true;
    }

    @Override
    public boolean prepareRecordField(String string, Expr expr, int n) {
        this.writer.writeString(string);
        return true;
    }

    @Override
    public Void onRecord(List<Map.Entry<String, Void>> list) {
        return null;
    }

    @Override
    public boolean prepareRecordType(int n) {
        this.writer.writeArrayStart(2);
        this.writer.writeLong(7L);
        this.writer.writeMapStart(n);
        return true;
    }

    @Override
    public boolean prepareRecordTypeField(String string, Expr expr, int n) {
        this.writer.writeString(string);
        return true;
    }

    @Override
    public Void onRecordType(List<Map.Entry<String, Void>> list) {
        return null;
    }

    @Override
    public boolean prepareUnionType(int n) {
        this.writer.writeArrayStart(2);
        this.writer.writeLong(11L);
        this.writer.writeMapStart(n);
        return true;
    }

    @Override
    public boolean prepareUnionTypeField(String string, Expr expr, int n) {
        this.writer.writeString(string);
        if (expr == null) {
            this.writer.writeNull();
        }
        return true;
    }

    @Override
    public Void onUnionType(List<Map.Entry<String, Void>> list) {
        return null;
    }

    @Override
    public boolean prepareFieldAccess(Expr expr, String string) {
        this.writer.writeArrayStart(3);
        this.writer.writeLong(9L);
        return true;
    }

    @Override
    public Void onFieldAccess(Void void_, String string) {
        this.writer.writeString(string);
        return null;
    }

    @Override
    public boolean prepareProjection(int n) {
        this.writer.writeArrayStart(n + 2);
        this.writer.writeLong(10L);
        return true;
    }

    @Override
    public Void onProjection(Void void_, String[] stringArray) {
        for (String string : stringArray) {
            this.writer.writeString(string);
        }
        return null;
    }

    @Override
    public boolean prepareProjectionByType() {
        this.writer.writeArrayStart(3);
        this.writer.writeLong(10L);
        return true;
    }

    @Override
    public boolean prepareProjectionByType(Expr expr) {
        this.writer.writeArrayStart(1);
        return true;
    }

    @Override
    public Void onProjectionByType(Void void_, Void void_2) {
        return null;
    }

    @Override
    public boolean prepareApplication(Expr expr, int n) {
        String string = Expr.Util.asBuiltIn(expr);
        if (string != null && string.equals("Some")) {
            if (n > 1) {
                this.writer.writeArrayStart(n + 1);
                this.writer.writeLong(0L);
            }
            this.writer.writeArrayStart(3);
            this.writer.writeLong(5L);
            this.writer.writeNull();
            return false;
        }
        this.writer.writeArrayStart(n + 2);
        this.writer.writeLong(0L);
        return true;
    }

    @Override
    public Void onApplication(Void void_, List<Void> list) {
        return null;
    }

    @Override
    public boolean prepareOperatorApplication(Operator operator) {
        this.writer.writeArrayStart(4);
        this.writer.writeLong(3L);
        this.writer.writeLong(operator.getLabel());
        return true;
    }

    @Override
    public Void onOperatorApplication(Operator operator, Void void_, Void void_2) {
        return null;
    }

    @Override
    public boolean prepareIf() {
        this.writer.writeArrayStart(4);
        this.writer.writeLong(14L);
        return true;
    }

    @Override
    public Void onIf(Void void_, Void void_2, Void void_3) {
        return null;
    }

    @Override
    public boolean prepareAnnotated(Expr expr) {
        this.writer.writeArrayStart(3);
        this.writer.writeLong(26L);
        return true;
    }

    @Override
    public Void onAnnotated(Void void_, Void void_2) {
        return null;
    }

    @Override
    public boolean prepareAssert() {
        this.writer.writeArrayStart(2);
        this.writer.writeLong(19L);
        return true;
    }

    @Override
    public Void onAssert(Void void_) {
        return null;
    }

    @Override
    public boolean prepareMerge(Expr expr) {
        this.writer.writeArrayStart(expr == null ? 3 : 4);
        this.writer.writeLong(6L);
        return true;
    }

    @Override
    public Void onMerge(Void void_, Void void_2, Void void_3) {
        return null;
    }

    @Override
    public boolean prepareToMap(Expr expr) {
        this.writer.writeArrayStart(expr == null ? 2 : 3);
        this.writer.writeLong(27L);
        return true;
    }

    @Override
    public Void onToMap(Void void_, Void void_2) {
        return null;
    }

    @Override
    public boolean prepareWith(String[] stringArray) {
        this.writer.writeArrayStart(4);
        this.writer.writeLong(29L);
        return true;
    }

    @Override
    public boolean prepareWithValue(String[] stringArray) {
        this.writer.writeArrayStart(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            this.writer.writeString(stringArray[i]);
        }
        return true;
    }

    @Override
    public Void onWith(Void void_, String[] stringArray, Void void_2) {
        return null;
    }

    private final int modeLabel(Expr.ImportMode importMode) {
        if (importMode.equals((Object)Expr.ImportMode.RAW_TEXT)) {
            return 1;
        }
        if (importMode.equals((Object)Expr.ImportMode.LOCATION)) {
            return 2;
        }
        return 0;
    }

    private static final byte[] multihash(byte[] byArray) {
        byte[] byArray2 = new byte[34];
        byArray2[0] = 18;
        byArray2[1] = 32;
        System.arraycopy(byArray, 0, byArray2, 2, 32);
        return byArray2;
    }

    @Override
    public Void onMissingImport(Expr.ImportMode importMode, byte[] byArray) {
        this.writer.writeArrayStart(4);
        this.writer.writeLong(24L);
        if (byArray == null) {
            this.writer.writeNull();
        } else {
            this.writer.writeByteString(Encode.multihash(byArray));
        }
        this.writer.writeLong(this.modeLabel(importMode));
        this.writer.writeLong(7L);
        return null;
    }

    @Override
    public Void onEnvImport(String string, Expr.ImportMode importMode, byte[] byArray) {
        this.writer.writeArrayStart(5);
        this.writer.writeLong(24L);
        if (byArray == null) {
            this.writer.writeNull();
        } else {
            this.writer.writeByteString(Encode.multihash(byArray));
        }
        this.writer.writeLong(this.modeLabel(importMode));
        this.writer.writeLong(6L);
        this.writer.writeString(string);
        return null;
    }

    private static final int pathLabel(Path path) {
        if (path.isAbsolute()) {
            return 2;
        }
        String string = path.iterator().next().toString();
        if (string.equals(".")) {
            return 3;
        }
        if (string.equals("..")) {
            return 4;
        }
        if (string.equals("~")) {
            return 5;
        }
        return -1;
    }

    @Override
    public Void onLocalImport(Path path, Expr.ImportMode importMode, byte[] byArray) {
        int n = 4 + path.getNameCount() - (path.isAbsolute() ? 0 : 1);
        this.writer.writeArrayStart(n);
        this.writer.writeLong(24L);
        if (byArray == null) {
            this.writer.writeNull();
        } else {
            this.writer.writeByteString(Encode.multihash(byArray));
        }
        this.writer.writeLong(this.modeLabel(importMode));
        this.writer.writeLong(Encode.pathLabel(path));
        Iterator<Path> iterator = path.iterator();
        if (!path.isAbsolute()) {
            iterator.next();
        }
        while (iterator.hasNext()) {
            this.writer.writeString(iterator.next().toString());
        }
        return null;
    }

    @Override
    public Void onClasspathImport(Path path, Expr.ImportMode importMode, byte[] byArray) {
        int n = 4 + path.getNameCount();
        this.writer.writeArrayStart(n);
        this.writer.writeLong(24L);
        if (byArray == null) {
            this.writer.writeNull();
        } else {
            this.writer.writeByteString(Encode.multihash(byArray));
        }
        this.writer.writeLong(this.modeLabel(importMode));
        this.writer.writeLong(23L);
        Iterator<Path> iterator = path.iterator();
        while (iterator.hasNext()) {
            this.writer.writeString(iterator.next().toString());
        }
        return null;
    }

    private static final int urlLabel(URI uRI) {
        if (uRI.getScheme().equals("https")) {
            return 1;
        }
        if (uRI.getScheme().equals("http")) {
            return 0;
        }
        return -1;
    }

    private static final List<String> getUrlPathParts(URI uRI) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(uRI.getAuthority());
        String[] stringArray = uRI.getPath().split("/");
        if (stringArray.length == 1) {
            arrayList.add("");
        } else {
            for (int i = 1; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
        }
        return arrayList;
    }

    @Override
    public boolean prepareRemoteImport(URI uRI, Expr expr, Expr.ImportMode importMode, byte[] byArray) {
        List<String> list = Encode.getUrlPathParts(uRI);
        this.writer.writeArrayStart(list.size() + 6);
        this.writer.writeLong(24L);
        if (byArray == null) {
            this.writer.writeNull();
        } else {
            this.writer.writeByteString(Encode.multihash(byArray));
        }
        this.writer.writeLong(this.modeLabel(importMode));
        this.writer.writeLong(Encode.urlLabel(uRI));
        if (expr == null) {
            this.writer.writeNull();
        }
        return true;
    }

    @Override
    public Void onRemoteImport(URI uRI, Void void_, Expr.ImportMode importMode, byte[] byArray) {
        List<String> list = Encode.getUrlPathParts(uRI);
        for (String string : list) {
            this.writer.writeString(string);
        }
        if (uRI.getQuery() == null) {
            this.writer.writeNull();
        } else {
            this.writer.writeString(uRI.getQuery());
        }
        return null;
    }
}

