/*
 * Decompiled with CFR 0.152.
 */
package org.dhallj.core.typechecking;

import org.dhallj.core.Expr;

final class Context {
    private final String key;
    private final Expr value;
    private final Context tail;
    public static final Context EMPTY = new Context(null, null, null);

    Context(String string, Expr expr, Context context) {
        this.key = string;
        this.value = expr;
        this.tail = context;
    }

    public Expr lookup(String string, long l) {
        if (this.key != null && this.key.equals(string)) {
            if (l == 0L) {
                return this.value;
            }
            if (this.tail == null) {
                return null;
            }
            return this.tail.lookup(string, l - 1L);
        }
        if (this.tail == null) {
            return null;
        }
        return this.tail.lookup(string, l);
    }

    public Context insert(String string, Expr expr) {
        return new Context(string, expr, this);
    }

    public Context increment(String string) {
        if (this.key == null) {
            return this;
        }
        return new Context(this.key, this.value.increment(string), this.tail.increment(string));
    }

    public Context decrement(String string) {
        if (this.key == null) {
            return this;
        }
        return new Context(this.key, this.value.decrement(string), this.tail.decrement(string));
    }
}

