/*
 * Decompiled with CFR 0.152.
 */
package org.dhallj.core.typechecking;

import org.dhallj.core.Expr;
import org.dhallj.core.ExternalVisitor;
import org.dhallj.core.typechecking.TypeCheck;
import org.dhallj.core.typechecking.TypeCheckFailure;

final class TypeCheckApplication
extends ExternalVisitor.Constant<Expr> {
    private final Expr arg;
    private final Expr argType;
    private final TypeCheck typeCheck;

    TypeCheckApplication(Expr expr, Expr expr2, TypeCheck typeCheck) {
        super(null);
        this.arg = expr;
        this.argType = expr2;
        this.typeCheck = typeCheck;
    }

    @Override
    public Expr onBuiltIn(String string) {
        if (string.equals("Some")) {
            if (TypeCheck.isType(this.argType.accept(this.typeCheck))) {
                return Expr.makeApplication(Expr.Constants.OPTIONAL, this.argType);
            }
            throw TypeCheckFailure.makeSomeApplicationError(this.arg, this.argType);
        }
        throw TypeCheckFailure.makeBuiltInApplicationError(string, this.arg, this.argType);
    }

    @Override
    public Expr onPi(String string, Expr expr, Expr expr2) {
        if (expr.equivalent(this.argType)) {
            return expr2.substitute(string, this.arg).normalize();
        }
        throw TypeCheckFailure.makeApplicationTypeError(expr, this.argType);
    }
}

