/*
 * Decompiled with CFR 0.152.
 */
package org.dhallj.cbor;

import java.math.BigInteger;
import org.dhallj.cbor.CborException;
import org.dhallj.cbor.Visitor;

final class NullVisitor<R>
implements Visitor<R> {
    static final Visitor<String> instanceForString = new NullVisitor<String>();
    static final Visitor<byte[]> instanceForByteArray = new NullVisitor<byte[]>();

    NullVisitor() {
    }

    @Override
    public R onUnsignedInteger(BigInteger bigInteger) {
        return this.notExpected("Unsigned integer");
    }

    @Override
    public R onNegativeInteger(BigInteger bigInteger) {
        return this.notExpected("Negative integer");
    }

    @Override
    public R onByteString(byte[] byArray) {
        return this.notExpected("Byte string");
    }

    @Override
    public R onTextString(String string) {
        return this.notExpected("Text string");
    }

    @Override
    public R onVariableArray(BigInteger bigInteger, String string) {
        return this.notExpected("Variable array");
    }

    @Override
    public R onArray(BigInteger bigInteger, BigInteger bigInteger2) {
        return this.notExpected("Array");
    }

    @Override
    public R onMap(BigInteger bigInteger) {
        return this.notExpected("Map");
    }

    @Override
    public R onFalse() {
        return this.notExpected("False");
    }

    @Override
    public R onTrue() {
        return this.notExpected("True");
    }

    @Override
    public R onNull() {
        return null;
    }

    @Override
    public R onHalfFloat(float f) {
        return this.notExpected("Half float");
    }

    @Override
    public R onSingleFloat(float f) {
        return this.notExpected("Single float");
    }

    @Override
    public R onDoubleFloat(double d) {
        return this.notExpected("Double float");
    }

    @Override
    public R onTag() {
        return null;
    }

    private R notExpected(String string) {
        throw new CborException(String.format("%s not expected - expected null", string));
    }
}

