/*
 * Decompiled with CFR 0.152.
 */
package org.dhallj.core;

public enum Operator {
    OR("||", 2, true),
    AND("&&", 6, true),
    EQUALS("==", 11, true),
    NOT_EQUALS("!=", 12, true),
    PLUS("+", 3, false),
    TIMES("*", 10, false),
    TEXT_APPEND("++", 4, false),
    LIST_APPEND("#", 5, false),
    COMBINE("\u2227", 7, false),
    PREFER("\u2afd", 8, false),
    COMBINE_TYPES("\u2a53", 9, false),
    IMPORT_ALT("?", 1, false),
    EQUIVALENT("\u2261", 13, false),
    COMPLETE("::", 0, false);

    private static final Operator[] values;
    private final String value;
    private final int precedence;
    private final boolean isBoolOperator;

    private Operator(String string2, int n2, boolean bl) {
        this.value = string2;
        this.precedence = n2;
        this.isBoolOperator = bl;
    }

    public final boolean isBoolOperator() {
        return this.isBoolOperator;
    }

    public final int getLabel() {
        return this.ordinal();
    }

    public final int getPrecedence() {
        return this.precedence;
    }

    public final String toString() {
        return this.value;
    }

    public static final Operator fromLabel(int n) {
        if (n >= 0 && n < values.length) {
            return values[n];
        }
        return null;
    }

    public static final Operator parse(String string) {
        if (string.equals(Operator.OR.value)) {
            return OR;
        }
        if (string.equals(Operator.AND.value)) {
            return AND;
        }
        if (string.equals(Operator.EQUALS.value)) {
            return EQUALS;
        }
        if (string.equals(Operator.NOT_EQUALS.value)) {
            return NOT_EQUALS;
        }
        if (string.equals(Operator.PLUS.value)) {
            return PLUS;
        }
        if (string.equals(Operator.TIMES.value)) {
            return TIMES;
        }
        if (string.equals(Operator.TEXT_APPEND.value)) {
            return TEXT_APPEND;
        }
        if (string.equals(Operator.LIST_APPEND.value)) {
            return LIST_APPEND;
        }
        if (string.equals(Operator.COMBINE.value) || string.equals("/\\")) {
            return COMBINE;
        }
        if (string.equals(Operator.PREFER.value) || string.equals("//")) {
            return PREFER;
        }
        if (string.equals(Operator.COMBINE_TYPES.value) || string.equals("//\\\\")) {
            return COMBINE_TYPES;
        }
        if (string.equals(Operator.IMPORT_ALT.value)) {
            return IMPORT_ALT;
        }
        if (string.equals(Operator.EQUIVALENT.value) || string.equals("===")) {
            return EQUIVALENT;
        }
        if (string.equals(Operator.COMPLETE.value)) {
            return COMPLETE;
        }
        throw new IllegalArgumentException(String.format("No org.dhallj.core.Operator represented by %s", string));
    }

    static {
        values = Operator.values();
    }
}

