/*
 * Decompiled with CFR 0.152.
 */
package org.dhallj.core.normalization;

import java.util.List;
import java.util.Map;
import org.dhallj.core.Expr;
import org.dhallj.core.ExternalVisitor;
import org.dhallj.core.normalization.BetaNormalize;
import org.dhallj.core.normalization.NormalizationUtilities;

final class BetaNormalizeMerge
extends ExternalVisitor.Constant<Expr> {
    private final List<Map.Entry<String, Expr>> handlers;

    private BetaNormalizeMerge(List<Map.Entry<String, Expr>> list) {
        super(null);
        this.handlers = list;
    }

    static final Expr apply(Expr expr, Expr expr2, Expr expr3) {
        List<Map.Entry<String, Expr>> list = Expr.Util.asRecordLiteral(expr);
        Expr expr4 = expr2.accept(new BetaNormalizeMerge(list));
        if (expr4 != null) {
            return expr4.accept(BetaNormalize.instance);
        }
        return Expr.makeMerge(expr, expr2, expr3);
    }

    @Override
    public Expr onFieldAccess(Expr expr, String string) {
        List<Map.Entry<String, Expr>> list = Expr.Util.asUnionType(expr);
        if (list != null) {
            return BetaNormalizeMerge.merge(this.handlers, string);
        }
        return null;
    }

    @Override
    public Expr onApplication(Expr expr, Expr expr2) {
        Map.Entry<Expr, String> entry = Expr.Util.asFieldAccess(expr);
        if (entry != null) {
            List<Map.Entry<String, Expr>> list = Expr.Util.asUnionType(entry.getKey());
            if (list != null) {
                return BetaNormalizeMerge.merge(this.handlers, entry.getValue(), expr2);
            }
            return null;
        }
        String string = Expr.Util.asBuiltIn(expr);
        if (string != null) {
            if (string.equals("Some")) {
                return BetaNormalizeMerge.merge(this.handlers, string, expr2);
            }
            if (string.equals("None")) {
                return BetaNormalizeMerge.merge(this.handlers, string);
            }
        }
        return null;
    }

    private static Expr merge(List<Map.Entry<String, Expr>> list, String string) {
        return (Expr)NormalizationUtilities.lookup(list, string);
    }

    private static Expr merge(List<Map.Entry<String, Expr>> list, String string, Expr expr) {
        Expr expr2 = (Expr)NormalizationUtilities.lookup(list, string);
        if (expr2 != null) {
            return Expr.makeApplication(expr2, expr);
        }
        return null;
    }
}

