/*
 * Decompiled with CFR 0.152.
 */
package org.dhallj.core.typechecking;

import java.math.BigInteger;
import java.net.URI;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.dhallj.core.Expr;
import org.dhallj.core.ExternalVisitor;
import org.dhallj.core.Operator;
import org.dhallj.core.Source;
import org.dhallj.core.normalization.BetaNormalize;
import org.dhallj.core.typechecking.BuiltInTypes;
import org.dhallj.core.typechecking.CheckEquivalence;
import org.dhallj.core.typechecking.Context;
import org.dhallj.core.typechecking.NonNegativeIndices;
import org.dhallj.core.typechecking.TypeCheckApplication;
import org.dhallj.core.typechecking.TypeCheckFailure;
import org.dhallj.core.typechecking.Universe;

public final class TypeCheck
implements ExternalVisitor<Expr> {
    private Context context;
    private static final Comparator<Map.Entry<String, Expr>> entryComparator = new Comparator<Map.Entry<String, Expr>>(){

        @Override
        public int compare(Map.Entry<String, Expr> entry, Map.Entry<String, Expr> entry2) {
            return entry.getKey().compareTo(entry2.getKey());
        }
    };

    public TypeCheck(Context context) {
        this.context = context;
    }

    public TypeCheck() {
        this(Context.EMPTY);
    }

    @Override
    public final Expr onNote(Expr expr, Source source) {
        return expr.accept(this);
    }

    @Override
    public final Expr onNatural(BigInteger bigInteger) {
        return Expr.Constants.NATURAL;
    }

    @Override
    public final Expr onInteger(BigInteger bigInteger) {
        return Expr.Constants.INTEGER;
    }

    @Override
    public final Expr onDouble(double d) {
        return Expr.Constants.DOUBLE;
    }

    @Override
    public final Expr onBuiltIn(String string) {
        if (string.equals("Sort")) {
            throw TypeCheckFailure.makeSortError();
        }
        Expr expr = BuiltInTypes.getType(string);
        if (expr != null) {
            return expr;
        }
        throw TypeCheckFailure.makeUnboundVariableError(string);
    }

    @Override
    public final Expr onIdentifier(String string, long l) {
        Expr expr = this.context.lookup(string, l);
        if (expr != null) {
            return expr;
        }
        throw TypeCheckFailure.makeUnboundVariableError(string);
    }

    @Override
    public final Expr onLambda(String string, Expr expr, Expr expr2) {
        Expr expr3 = expr.accept(this);
        if (Universe.fromExpr(expr3) != null) {
            Context context = this.context;
            Expr expr4 = expr.accept(BetaNormalize.instance);
            this.context = this.context.insert(string, expr4).increment(string);
            Expr expr5 = expr2.accept(this);
            this.context = context;
            return Expr.makePi(string, expr4, expr5);
        }
        throw TypeCheckFailure.makeLambdaInputError(expr3);
    }

    @Override
    public final Expr onPi(String string, Expr expr, Expr expr2) {
        Expr expr3 = expr.accept(this);
        Context context = this.context;
        this.context = this.context.insert(string, expr).increment(string);
        Expr expr4 = expr2.accept(this);
        this.context = context;
        Universe universe = Universe.fromExpr(expr3);
        Universe universe2 = Universe.fromExpr(expr4);
        return Universe.functionCheck(universe, universe2).toExpr();
    }

    @Override
    public final Expr onLet(String string, Expr expr, Expr expr2, Expr expr3) {
        Expr expr4 = expr2.accept(this);
        if (expr != null && !expr.equivalent(expr4)) {
            throw TypeCheckFailure.makeAnnotationError(expr, expr4);
        }
        return expr3.substitute(string, expr2.accept(BetaNormalize.instance)).accept(this);
    }

    @Override
    public final Expr onText(String[] stringArray, Iterable<Expr> iterable) {
        for (Expr expr : iterable) {
            Expr expr2 = expr.accept(this);
            if (TypeCheck.isText(expr2)) continue;
            throw TypeCheckFailure.makeInterpolationError(expr, expr2);
        }
        return Expr.Constants.TEXT;
    }

    @Override
    public final Expr onNonEmptyList(Iterable<Expr> iterable, int n) {
        Iterator<Expr> iterator = iterable.iterator();
        Expr expr = iterator.next().accept(this);
        if (TypeCheck.isType(expr.accept(this))) {
            while (iterator.hasNext()) {
                Expr expr2 = iterator.next().accept(this);
                if (expr2.equivalent(expr)) continue;
                throw TypeCheckFailure.makeListTypeMismatchError(expr, expr2);
            }
            return Expr.makeApplication(Expr.Constants.LIST, expr);
        }
        throw TypeCheckFailure.makeListTypeError(expr);
    }

    @Override
    public final Expr onEmptyList(Expr expr) {
        expr.accept(this);
        Expr expr2 = expr.accept(BetaNormalize.instance);
        Expr expr3 = Expr.Util.getListArg(expr2);
        if (expr3 != null && TypeCheck.isType(expr3.accept(this))) {
            return Expr.makeApplication(Expr.Constants.LIST, expr3);
        }
        throw TypeCheckFailure.makeListTypeError(expr3);
    }

    @Override
    public final Expr onRecord(Iterable<Map.Entry<String, Expr>> iterable, int n) {
        if (n == 0) {
            return Expr.Constants.EMPTY_RECORD_TYPE;
        }
        TreeMap<String, Expr> treeMap = new TreeMap<String, Expr>();
        for (Map.Entry<String, Expr> entry : iterable) {
            treeMap.put(entry.getKey(), entry.getValue().accept(this).accept(BetaNormalize.instance));
        }
        Expr expr = Expr.makeRecordType(treeMap.entrySet());
        expr.accept(this);
        return expr;
    }

    @Override
    public final Expr onRecordType(Iterable<Map.Entry<String, Expr>> iterable, int n) {
        HashSet<String> hashSet = new HashSet<String>(n);
        Universe universe = Universe.TYPE;
        for (Map.Entry<String, Expr> entry : iterable) {
            String string = entry.getKey();
            if (!hashSet.add(string)) {
                throw TypeCheckFailure.makeFieldDuplicateError(string);
            }
            Universe universe2 = Universe.fromExpr(entry.getValue().accept(this));
            if (universe2 != null) {
                universe = universe.max(universe2);
                continue;
            }
            throw TypeCheckFailure.makeFieldTypeError(string);
        }
        return universe.toExpr();
    }

    @Override
    public final Expr onUnionType(Iterable<Map.Entry<String, Expr>> iterable, int n) {
        if (n == 0) {
            return Expr.Constants.TYPE;
        }
        HashSet<String> hashSet = new HashSet<String>();
        Universe universe = null;
        for (Map.Entry<String, Expr> entry : iterable) {
            String string = entry.getKey();
            if (!hashSet.contains(string)) {
                hashSet.add(string);
                Expr expr = entry.getValue();
                if (expr == null) continue;
                Universe universe2 = Universe.fromExpr(expr.accept(this));
                if (universe2 != null) {
                    if (universe == null) {
                        universe = universe2;
                        continue;
                    }
                    if (universe2 == universe) continue;
                    throw TypeCheckFailure.makeAlternativeTypeMismatchError(expr);
                }
                throw TypeCheckFailure.makeAlternativeTypeError(expr);
            }
            throw TypeCheckFailure.makeAlternativeDuplicateError(string);
        }
        if (universe == null) {
            return Expr.Constants.TYPE;
        }
        return universe.toExpr();
    }

    @Override
    public final Expr onFieldAccess(Expr expr, String string) {
        Expr expr2 = expr.accept(this);
        List<Map.Entry<String, Expr>> list = Expr.Util.asRecordType(expr2);
        if (list != null) {
            for (Map.Entry<String, Expr> entry : list) {
                if (!entry.getKey().equals(string)) continue;
                return entry.getValue();
            }
            throw TypeCheckFailure.makeFieldAccessRecordMissingError(string);
        }
        Expr expr3 = expr.accept(BetaNormalize.instance);
        List<Map.Entry<String, Expr>> list2 = Expr.Util.asUnionType(expr3);
        if (list2 != null) {
            for (Map.Entry<String, Expr> entry : list2) {
                if (!entry.getKey().equals(string)) continue;
                if (entry.getValue() == null) {
                    return expr3;
                }
                return Expr.makePi(string, entry.getValue(), expr3);
            }
            throw TypeCheckFailure.makeFieldAccessUnionMissingError(string);
        }
        throw TypeCheckFailure.makeFieldAccessError();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Expr onProjection(Expr expr, String[] stringArray) {
        List<Map.Entry<String, Expr>> list = Expr.Util.asRecordType(expr.accept(this));
        if (list != null) {
            void var6_8;
            HashMap<String, Expr> hashMap = new HashMap<String, Expr>();
            for (Map.Entry<String, Expr> object2 : list) {
                hashMap.put(object2.getKey(), object2.getValue());
            }
            ArrayList arrayList = new ArrayList();
            Object var6_7 = null;
            for (String string : stringArray) {
                Expr expr2 = (Expr)hashMap.remove(string);
                if (expr2 == null) {
                    if (var6_8 == null) {
                        ArrayList arrayList2 = new ArrayList();
                    }
                    var6_8.add(string);
                    continue;
                }
                arrayList.add(new AbstractMap.SimpleImmutableEntry<String, Expr>(string, expr2));
            }
            if (var6_8 == null) {
                return Expr.makeRecordType(arrayList);
            }
            throw TypeCheckFailure.makeFieldAccessRecordMissingError((String)var6_8.get(0));
        }
        throw TypeCheckFailure.makeProjectionError();
    }

    @Override
    public final Expr onProjectionByType(Expr expr, Expr expr2) {
        List<Map.Entry<String, Expr>> list = Expr.Util.asRecordType(expr.accept(this));
        if (list == null) {
            throw TypeCheckFailure.makeProjectionError();
        }
        List<Map.Entry<String, Expr>> list2 = Expr.Util.asRecordType(expr2.accept(BetaNormalize.instance));
        if (list2 == null) {
            throw TypeCheckFailure.makeProjectionError();
        }
        HashMap<String, Expr> hashMap = new HashMap<String, Expr>();
        for (Map.Entry<String, Expr> entry : list) {
            hashMap.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Expr> entry : list2) {
            String string = entry.getKey();
            Expr expr3 = (Expr)hashMap.get(string);
            Expr expr4 = entry.getValue();
            if (expr3 != null && expr3.equivalent(expr4)) continue;
            throw TypeCheckFailure.makeFieldAccessRecordMissingError(string);
        }
        return Expr.makeRecordType(list2);
    }

    @Override
    public final Expr onApplication(Expr expr, Expr expr2) {
        Expr expr3;
        Expr expr4 = expr.accept(this);
        Expr expr5 = expr4.accept(new TypeCheckApplication(expr2, expr3 = expr2.accept(this), this));
        if (expr5 != null) {
            return expr5;
        }
        throw TypeCheckFailure.makeApplicationError(expr, expr2);
    }

    @Override
    public final Expr onOperatorApplication(Operator operator, Expr expr, Expr expr2) {
        Expr expr3 = expr.accept(this);
        Expr expr4 = expr2.accept(this);
        switch (operator) {
            case OR: 
            case AND: 
            case EQUALS: 
            case NOT_EQUALS: {
                if (TypeCheck.isBool(expr3) && TypeCheck.isBool(expr4)) {
                    return Expr.Constants.BOOL;
                }
                throw TypeCheckFailure.makeOperatorError(operator);
            }
            case PLUS: 
            case TIMES: {
                if (TypeCheck.isNatural(expr3) && TypeCheck.isNatural(expr4)) {
                    return Expr.Constants.NATURAL;
                }
                throw TypeCheckFailure.makeOperatorError(operator);
            }
            case TEXT_APPEND: {
                if (TypeCheck.isText(expr3) && TypeCheck.isText(expr4)) {
                    return Expr.Constants.TEXT;
                }
                throw TypeCheckFailure.makeOperatorError(operator);
            }
            case LIST_APPEND: {
                Expr expr5 = Expr.Util.getListArg(expr3);
                Expr expr6 = Expr.Util.getListArg(expr4);
                if (expr5 != null && expr6 != null) {
                    if (expr5.equivalent(expr6)) {
                        return expr3;
                    }
                    throw TypeCheckFailure.makeListAppendError(expr5, expr6);
                }
                throw TypeCheckFailure.makeOperatorError(operator);
            }
            case COMBINE: {
                Expr expr7 = Expr.makeOperatorApplication(Operator.COMBINE_TYPES, expr3, expr4);
                try {
                    expr7.accept(this);
                }
                catch (TypeCheckFailure typeCheckFailure) {
                    throw TypeCheckFailure.makeOperatorError(operator);
                }
                return expr7.accept(BetaNormalize.instance);
            }
            case PREFER: {
                List<Map.Entry<String, Expr>> list = Expr.Util.asRecordType(expr3);
                List<Map.Entry<String, Expr>> list2 = Expr.Util.asRecordType(expr4);
                if (list != null && list2 != null) {
                    return Expr.makeRecordType(TypeCheck.prefer(list, list2));
                }
                throw TypeCheckFailure.makeOperatorError(operator);
            }
            case COMBINE_TYPES: {
                List<Map.Entry<String, Expr>> list = Expr.Util.asRecordType(expr.accept(BetaNormalize.instance));
                List<Map.Entry<String, Expr>> list3 = Expr.Util.asRecordType(expr2.accept(BetaNormalize.instance));
                if (list != null && list3 != null) {
                    if (TypeCheck.isType(expr4) && !list3.iterator().hasNext()) {
                        return expr3;
                    }
                    Universe universe = Universe.fromExpr(expr3);
                    Universe universe2 = Universe.fromExpr(expr4);
                    if (universe != null && universe2 != null) {
                        this.checkRecursiveTypeMerge(list, list3);
                        return universe.max(universe2).toExpr();
                    }
                    throw TypeCheckFailure.makeOperatorError(operator);
                }
                throw TypeCheckFailure.makeOperatorError(operator);
            }
            case IMPORT_ALT: {
                return expr3.accept(this);
            }
            case EQUIVALENT: {
                Expr expr8 = expr3.accept(this);
                Expr expr9 = expr4.accept(this);
                if (expr8 != null && expr9 != null && TypeCheck.isType(expr8) && TypeCheck.isType(expr9)) {
                    if (expr3.equivalent(expr4)) {
                        return Expr.Constants.TYPE;
                    }
                    throw TypeCheckFailure.makeEquivalenceError(expr3, expr4);
                }
                throw TypeCheckFailure.makeOperatorError(operator);
            }
            case COMPLETE: {
                return Expr.Util.desugarComplete(expr, expr2).accept(this);
            }
        }
        return null;
    }

    @Override
    public final Expr onIf(Expr expr, Expr expr2, Expr expr3) {
        Expr expr4 = expr.accept(this);
        if (TypeCheck.isBool(expr4)) {
            Expr expr5 = expr2.accept(this);
            Expr expr6 = expr3.accept(this);
            boolean bl = TypeCheck.isType(expr5.accept(this));
            boolean bl2 = TypeCheck.isType(expr6.accept(this));
            if (bl && bl2) {
                if (expr5.equivalent(expr6)) {
                    return expr5;
                }
                throw TypeCheckFailure.makeIfBranchTypeMismatchError(expr5, expr6);
            }
            if (!bl) {
                throw TypeCheckFailure.makeIfBranchError(expr5);
            }
            throw TypeCheckFailure.makeIfBranchError(expr6);
        }
        throw TypeCheckFailure.makeIfPredicateError(expr4);
    }

    @Override
    public final Expr onAnnotated(Expr expr, Expr expr2) {
        Expr expr3 = expr.accept(this);
        if (expr3.equivalent(expr2)) {
            return expr3;
        }
        throw TypeCheckFailure.makeAnnotationError(expr2, expr3);
    }

    @Override
    public final Expr onAssert(Expr expr) {
        Expr expr2;
        Boolean bl;
        Expr expr3 = expr.accept(this);
        if (TypeCheck.isType(expr3) && (bl = (expr2 = expr.accept(BetaNormalize.instance)).accept(CheckEquivalence.instance)) != null && bl.booleanValue()) {
            return expr2;
        }
        throw TypeCheckFailure.makeAssertError(expr);
    }

    @Override
    public final Expr onMerge(Expr expr, Expr expr2, Expr expr3) {
        Expr expr4 = expr.accept(this);
        List<Map.Entry<String, Expr>> list = Expr.Util.asRecordType(expr4);
        if (list == null) {
            throw TypeCheckFailure.makeMergeHandlersTypeError(expr4);
        }
        Expr expr5 = expr2.accept(this);
        List<Map.Entry<String, Expr>> list2 = Expr.Util.asUnionType(expr5);
        if (list2 != null) {
            Expr expr6 = TypeCheck.getMergeInferredType(list, list2);
            if (expr6 != null) {
                if (expr3 == null || expr6.equivalent(expr3)) {
                    return expr6;
                }
                throw TypeCheckFailure.makeMergeInvalidAnnotationError(expr3, expr6);
            }
            if (expr3 != null) {
                return expr3;
            }
            throw TypeCheckFailure.makeMergeUnionTypeError(expr3);
        }
        Expr expr7 = Expr.Util.getOptionalArg(expr5);
        if (expr7 == null) {
            throw TypeCheckFailure.makeMergeUnionTypeError(expr5);
        }
        Expr expr8 = TypeCheck.getMergeInferredType(list, TypeCheck.makeOptionalConstructors(expr7));
        if (expr8 != null) {
            if (expr3 == null || expr8.equivalent(expr3)) {
                return expr8;
            }
            throw TypeCheckFailure.makeMergeInvalidAnnotationError(expr3, expr8);
        }
        if (expr3 != null) {
            return expr3;
        }
        throw TypeCheckFailure.makeMergeUnionTypeError(expr3);
    }

    @Override
    public final Expr onToMap(Expr expr, Expr expr2) {
        Object object;
        Expr expr3;
        Expr expr4 = expr.accept(this);
        List<Map.Entry<String, Expr>> list = Expr.Util.asRecordType(expr4);
        if (list == null) {
            throw TypeCheckFailure.makeToMapTypeError(expr4);
        }
        Expr expr5 = null;
        for (Map.Entry<String, Expr> object22 : list) {
            expr3 = object22.getValue();
            if (!TypeCheck.isType(expr3.accept(this))) {
                throw TypeCheckFailure.makeToMapRecordKindError(expr3);
            }
            if (expr5 == null) {
                expr5 = expr3;
                continue;
            }
            if (expr3.equivalent(expr5)) continue;
            throw TypeCheckFailure.makeToMapRecordTypeMismatchError(expr5, expr3);
        }
        if (expr5 != null) {
            object = new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<String, Expr>("mapKey", Expr.Constants.TEXT), new AbstractMap.SimpleImmutableEntry<String, Expr>("mapValue", expr5)};
            Expr expr6 = Expr.makeApplication(Expr.Constants.LIST, Expr.makeRecordType(object));
            if (expr2 == null || expr2.equivalent(expr6)) {
                return expr6;
            }
            throw TypeCheckFailure.makeToMapResultTypeMismatchError(expr2, expr6);
        }
        if (expr2 == null) {
            throw TypeCheckFailure.makeToMapMissingAnnotationError();
        }
        object = expr2.accept(this);
        if (!TypeCheck.isType((Expr)object)) {
            throw TypeCheckFailure.makeToMapInvalidAnnotationError(expr2);
        }
        Expr expr7 = expr2.accept(BetaNormalize.instance);
        expr3 = Expr.Util.getListArg(expr7);
        if (expr3 == null) {
            throw TypeCheckFailure.makeToMapInvalidAnnotationError(expr2);
        }
        List<Map.Entry<String, Expr>> list2 = Expr.Util.asRecordType(expr3);
        if (list2 == null) {
            throw TypeCheckFailure.makeToMapInvalidAnnotationError(expr2);
        }
        boolean bl = false;
        boolean bl2 = false;
        for (Map.Entry<String, Expr> entry : list2) {
            if (bl && bl2) {
                throw TypeCheckFailure.makeToMapInvalidAnnotationError(expr2);
            }
            if (entry.getKey().equals("mapKey")) {
                if (TypeCheck.isText(entry.getValue())) {
                    bl = true;
                    continue;
                }
                throw TypeCheckFailure.makeToMapInvalidAnnotationError(expr2);
            }
            if (entry.getKey().equals("mapValue")) {
                bl2 = true;
                continue;
            }
            throw TypeCheckFailure.makeToMapInvalidAnnotationError(expr2);
        }
        if (bl && bl2) {
            return expr7;
        }
        throw TypeCheckFailure.makeToMapInvalidAnnotationError(expr2);
    }

    @Override
    public final Expr onMissingImport(Expr.ImportMode importMode, byte[] byArray) {
        throw TypeCheckFailure.makeUnresolvedImportError();
    }

    @Override
    public final Expr onEnvImport(String string, Expr.ImportMode importMode, byte[] byArray) {
        throw TypeCheckFailure.makeUnresolvedImportError();
    }

    @Override
    public final Expr onLocalImport(Path path, Expr.ImportMode importMode, byte[] byArray) {
        throw TypeCheckFailure.makeUnresolvedImportError();
    }

    @Override
    public final Expr onClasspathImport(Path path, Expr.ImportMode importMode, byte[] byArray) {
        throw TypeCheckFailure.makeUnresolvedImportError();
    }

    @Override
    public final Expr onRemoteImport(URI uRI, Expr expr, Expr.ImportMode importMode, byte[] byArray) {
        throw TypeCheckFailure.makeUnresolvedImportError();
    }

    static final boolean isBool(Expr expr) {
        String string = Expr.Util.asBuiltIn(expr);
        return string != null && string.equals("Bool");
    }

    static final boolean isText(Expr expr) {
        String string = Expr.Util.asBuiltIn(expr);
        return string != null && string.equals("Text");
    }

    static final boolean isList(Expr expr) {
        String string = Expr.Util.asBuiltIn(expr);
        return string != null && string.equals("List");
    }

    static final boolean isNatural(Expr expr) {
        String string = Expr.Util.asBuiltIn(expr);
        return string != null && string.equals("Natural");
    }

    static final boolean isOptional(Expr expr) {
        String string = Expr.Util.asBuiltIn(expr);
        return string != null && string.equals("Optional");
    }

    static final boolean isType(Expr expr) {
        String string = Expr.Util.asBuiltIn(expr);
        return string != null && string.equals("Type");
    }

    private final void checkRecursiveTypeMerge(List<Map.Entry<String, Expr>> list, List<Map.Entry<String, Expr>> list2) {
        HashMap<String, Expr> hashMap = new HashMap<String, Expr>();
        for (Map.Entry<String, Expr> entry : list) {
            hashMap.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Expr> entry : list2) {
            Expr expr = entry.getValue();
            Expr expr2 = (Expr)hashMap.get(entry.getKey());
            if (expr2 == null) continue;
            Expr.makeOperatorApplication(Operator.COMBINE_TYPES, expr2, expr).accept(this);
        }
    }

    private static final List<Map.Entry<String, Expr>> makeOptionalConstructors(Expr expr) {
        ArrayList<Map.Entry<String, Expr>> arrayList = new ArrayList<Map.Entry<String, Expr>>();
        arrayList.add(new AbstractMap.SimpleImmutableEntry<String, Object>("None", null));
        arrayList.add(new AbstractMap.SimpleImmutableEntry<String, Expr>("Some", expr));
        return arrayList;
    }

    private static final Expr getMergeInferredType(List<Map.Entry<String, Expr>> list, List<Map.Entry<String, Expr>> list2) {
        HashMap<String, Expr> hashMap = new HashMap<String, Expr>();
        for (Map.Entry<String, Expr> object : list) {
            hashMap.put(object.getKey(), object.getValue());
        }
        Object object = null;
        for (Map.Entry<String, Expr> entry : list2) {
            String string = entry.getKey();
            Expr expr = (Expr)hashMap.remove(string);
            if (expr == null) {
                throw TypeCheckFailure.makeMergeHandlerMissingError(string);
            }
            final Expr expr2 = entry.getValue();
            if (expr2 == null) {
                if (object == null) {
                    object = expr;
                    continue;
                }
                if (expr.equivalent((Expr)object)) continue;
                throw TypeCheckFailure.makeMergeHandlerTypeMismatchError((Expr)object, expr);
            }
            Expr expr3 = expr.accept(new ExternalVisitor.Constant<Expr>(null){

                @Override
                public Expr onPi(String string, Expr expr, Expr expr22) {
                    if (!expr.equivalent(expr2)) {
                        throw TypeCheckFailure.makeMergeHandlerTypeInvalidError(expr2, expr);
                    }
                    Expr expr3 = expr22.decrement(string);
                    if (!expr3.accept(NonNegativeIndices.instance).booleanValue()) {
                        throw TypeCheckFailure.makeMergeHandlerTypeDisallowedError(expr3);
                    }
                    return expr3;
                }
            });
            if (expr3 == null) {
                throw TypeCheckFailure.makeMergeHandlerTypeNotFunctionError(string, expr2, expr);
            }
            if (object == null) {
                object = expr3;
                continue;
            }
            if (expr3.equivalent((Expr)object)) continue;
            throw TypeCheckFailure.makeMergeHandlerTypeMismatchError((Expr)object, expr3);
        }
        if (hashMap.isEmpty()) {
            return object;
        }
        throw TypeCheckFailure.makeMergeHandlerUnusedError((String)hashMap.keySet().iterator().next());
    }

    private static final Map.Entry<String, Expr>[] prefer(List<Map.Entry<String, Expr>> list, List<Map.Entry<String, Expr>> list2) {
        LinkedHashMap<String, Expr> linkedHashMap = new LinkedHashMap<String, Expr>();
        for (Map.Entry<String, Expr> entryArray2 : list2) {
            linkedHashMap.put(entryArray2.getKey(), entryArray2.getValue());
        }
        ArrayList arrayList = new ArrayList();
        for (Map.Entry<String, Expr> entry : list) {
            String string = entry.getKey();
            Expr expr = (Expr)linkedHashMap.remove(string);
            if (expr == null) {
                arrayList.add(entry);
                continue;
            }
            arrayList.add(new AbstractMap.SimpleImmutableEntry<String, Expr>(string, expr));
        }
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            arrayList.add(entry);
        }
        Map.Entry[] entryArray = arrayList.toArray(new Map.Entry[arrayList.size()]);
        Arrays.sort(entryArray, entryComparator);
        return entryArray;
    }
}

