/*
 * Decompiled with CFR 0.152.
 */
package org.dhallj.core.typechecking;

import org.dhallj.core.Expr;

public enum Universe {
    TYPE,
    KIND,
    SORT;


    public final Universe max(Universe universe) {
        if (this.equals((Object)SORT) || universe.equals((Object)SORT)) {
            return SORT;
        }
        if (this.equals((Object)KIND) || universe.equals((Object)KIND)) {
            return KIND;
        }
        return TYPE;
    }

    public final Expr toExpr() {
        switch (this) {
            case TYPE: {
                return Expr.Constants.TYPE;
            }
            case KIND: {
                return Expr.Constants.KIND;
            }
            case SORT: {
                return Expr.Constants.SORT;
            }
        }
        return null;
    }

    public static final boolean isUniverse(Expr expr) {
        return Universe.fromExpr(expr) != null;
    }

    public static final Universe fromExpr(Expr expr) {
        String string = Expr.Util.asBuiltIn(expr);
        if (string != null) {
            if (string.equals("Type")) {
                return TYPE;
            }
            if (string.equals("Kind")) {
                return KIND;
            }
            if (string.equals("Sort")) {
                return SORT;
            }
        }
        return null;
    }

    public static Universe functionCheck(Universe universe, Universe universe2) {
        if (universe2.equals((Object)TYPE)) {
            return TYPE;
        }
        return universe.max(universe2);
    }
}

