/*
 * Decompiled with CFR 0.152.
 */
package org.dhallj.core.normalization;

import java.util.List;
import org.dhallj.core.Expr;
import org.dhallj.core.Visitor;

public final class Shift
extends Visitor.Identity {
    private final int change;
    private final String name;
    private int cutoff = 0;

    public Shift(boolean bl, String string) {
        this.change = bl ? 1 : -1;
        this.name = string;
    }

    @Override
    public Expr onIdentifier(Expr expr, String string, long l) {
        if (string.equals(this.name) && l >= (long)this.cutoff) {
            return Expr.makeIdentifier(string, l + (long)this.change);
        }
        return expr;
    }

    @Override
    public void bind(String string, Expr expr) {
        if (string.equals(this.name)) {
            ++this.cutoff;
        }
    }

    @Override
    public Expr onLambda(String string, Expr expr, Expr expr2) {
        if (string.equals(this.name)) {
            --this.cutoff;
        }
        return Expr.makeLambda(string, expr, expr2);
    }

    @Override
    public Expr onPi(String string, Expr expr, Expr expr2) {
        if (string.equals(this.name)) {
            --this.cutoff;
        }
        return Expr.makePi(string, expr, expr2);
    }

    @Override
    public Expr onLet(List<Expr.LetBinding<Expr>> list, Expr expr) {
        for (Expr.LetBinding<Expr> letBinding : list) {
            if (!letBinding.getName().equals(this.name)) continue;
            --this.cutoff;
        }
        return Expr.makeLet(list, expr);
    }
}

