/*
 * Decompiled with CFR 0.152.
 */
package org.dhallj.core.typechecking;

import org.dhallj.core.DhallException;
import org.dhallj.core.Expr;
import org.dhallj.core.Operator;

public final class TypeCheckFailure
extends DhallException {
    @Override
    public Throwable fillInStackTrace() {
        return this;
    }

    TypeCheckFailure(String string) {
        super(string);
    }

    static final TypeCheckFailure makeSortError() {
        return new TypeCheckFailure("Sort has no type, kind, or sort");
    }

    static final TypeCheckFailure makeUnboundVariableError(String string) {
        return new TypeCheckFailure("Unbound variable: " + string);
    }

    static final TypeCheckFailure makeOperatorError(Operator operator) {
        String string = operator == Operator.OR || operator == Operator.AND || operator == Operator.EQUALS || operator == Operator.NOT_EQUALS ? operator.toString() + " only works on Bools" : (operator == Operator.PLUS || operator == Operator.TIMES ? operator.toString() + " only works on Naturals" : (operator == Operator.TEXT_APPEND ? operator.toString() + " only works on Text" : (operator == Operator.LIST_APPEND ? operator.toString() + " only works on Lists" : (operator == Operator.COMBINE || operator == Operator.PREFER ? "You can only combine records" : (operator == Operator.COMBINE_TYPES ? operator.toString() + " requires arguments that are record types" : (operator == Operator.EQUIVALENT ? "Incomparable expression" : "Operator error on " + operator.toString()))))));
        return new TypeCheckFailure(string);
    }

    static final TypeCheckFailure makeListAppendError(Expr expr, Expr expr2) {
        return new TypeCheckFailure("You can only append Lists with matching element types");
    }

    static final TypeCheckFailure makeEquivalenceError(Expr expr, Expr expr2) {
        return new TypeCheckFailure("You can only append Lists with matching element types");
    }

    static final TypeCheckFailure makeInterpolationError(Expr expr, Expr expr2) {
        return new TypeCheckFailure("You can only interpolate Text");
    }

    static final TypeCheckFailure makeSomeApplicationError(Expr expr, Expr expr2) {
        return new TypeCheckFailure("Some argument has the wrong type");
    }

    static final TypeCheckFailure makeBuiltInApplicationError(String string, Expr expr, Expr expr2) {
        return new TypeCheckFailure("Can't apply " + string);
    }

    static final TypeCheckFailure makeApplicationTypeError(Expr expr, Expr expr2) {
        return new TypeCheckFailure("Wrong type of function argument");
    }

    static final TypeCheckFailure makeApplicationError(Expr expr, Expr expr2) {
        return new TypeCheckFailure("Not a function");
    }

    static final TypeCheckFailure makeUnresolvedImportError() {
        return new TypeCheckFailure("Can't type-check unresolved import");
    }

    static final TypeCheckFailure makeIfPredicateError(Expr expr) {
        return new TypeCheckFailure("Invalid predicate for if");
    }

    static final TypeCheckFailure makeIfBranchTypeMismatchError(Expr expr, Expr expr2) {
        return new TypeCheckFailure("if branches must have matching types");
    }

    static final TypeCheckFailure makeIfBranchError(Expr expr) {
        return new TypeCheckFailure("if branch is not a term");
    }

    static final TypeCheckFailure makeLambdaInputError(Expr expr) {
        return new TypeCheckFailure("Invalid function input");
    }

    static final TypeCheckFailure makeAssertError(Expr expr) {
        return new TypeCheckFailure("Not an equivalence");
    }

    static final TypeCheckFailure makeFieldAccessError() {
        return new TypeCheckFailure("Not a record or union");
    }

    static final TypeCheckFailure makeFieldAccessRecordMissingError(String string) {
        return new TypeCheckFailure("Missing record field: " + string);
    }

    static final TypeCheckFailure makeFieldAccessUnionMissingError(String string) {
        return new TypeCheckFailure("Missing constructor: " + string);
    }

    static final TypeCheckFailure makeProjectionError() {
        return new TypeCheckFailure("Not a record");
    }

    static final TypeCheckFailure makeFieldTypeError(String string, Expr expr) {
        return new TypeCheckFailure("Invalid field type");
    }

    static final TypeCheckFailure makeFieldDuplicateError(String string) {
        return new TypeCheckFailure("duplicate field: " + string);
    }

    static final TypeCheckFailure makeListTypeMismatchError(Expr expr, Expr expr2) {
        return new TypeCheckFailure("List elements should all have the same type");
    }

    static final TypeCheckFailure makeListTypeError(Expr expr) {
        return new TypeCheckFailure("Invalid type for List");
    }

    static final TypeCheckFailure makeAnnotationError(Expr expr, Expr expr2) {
        return new TypeCheckFailure("Expression doesn't match annotation");
    }

    static final TypeCheckFailure makeAlternativeTypeError(String string, Expr expr) {
        return new TypeCheckFailure("Invalid alternative type");
    }

    static final TypeCheckFailure makeAlternativeDuplicateError(String string) {
        return new TypeCheckFailure("duplicate field: " + string);
    }

    static final TypeCheckFailure makeMergeHandlersTypeError(Expr expr) {
        return new TypeCheckFailure("merge expects a record of handlers");
    }

    static final TypeCheckFailure makeMergeUnionTypeError(Expr expr) {
        return new TypeCheckFailure("toMap expects a union or an Optional");
    }

    static final TypeCheckFailure makeMergeHandlerMissingError(String string) {
        return new TypeCheckFailure("Missing handler: " + string);
    }

    static final TypeCheckFailure makeMergeHandlerUnusedError(String string) {
        return new TypeCheckFailure("Unused handler: " + string);
    }

    static final TypeCheckFailure makeMergeHandlerTypeInvalidError(Expr expr, Expr expr2) {
        return new TypeCheckFailure("Wrong handler input type");
    }

    static final TypeCheckFailure makeMergeHandlerTypeNotFunctionError(String string, Expr expr, Expr expr2) {
        return new TypeCheckFailure("Handler for " + string + " is not a function");
    }

    static final TypeCheckFailure makeMergeHandlerTypeMismatchError(Expr expr, Expr expr2) {
        return new TypeCheckFailure("Handlers should have the same output type");
    }

    static final TypeCheckFailure makeMergeHandlerTypeDisallowedError(Expr expr) {
        return new TypeCheckFailure("Disallowed handler type");
    }

    static final TypeCheckFailure makeMergeInvalidAnnotationError(Expr expr, Expr expr2) {
        return new TypeCheckFailure("Expression doesn't match annotation");
    }

    static final TypeCheckFailure makeToMapTypeError(Expr expr) {
        return new TypeCheckFailure("toMap expects a record value");
    }

    static final TypeCheckFailure makeToMapRecordKindError(Expr expr) {
        return new TypeCheckFailure("toMap expects a record of kind Type");
    }

    static final TypeCheckFailure makeToMapRecordTypeMismatchError(Expr expr, Expr expr2) {
        return new TypeCheckFailure("toMap expects a homogenous record");
    }

    static final TypeCheckFailure makeToMapResultTypeMismatchError(Expr expr, Expr expr2) {
        return new TypeCheckFailure("toMap result type doesn't match annotation");
    }

    static final TypeCheckFailure makeToMapMissingAnnotationError() {
        return new TypeCheckFailure("An empty toMap requires a type annotation");
    }

    static final TypeCheckFailure makeToMapInvalidAnnotationError(Expr expr) {
        return new TypeCheckFailure("An empty toMap was annotated with an invalid type");
    }
}

