/*
 * Decompiled with CFR 0.152.
 */
package org.dhallj.core.normalization;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.dhallj.core.Expr;
import org.dhallj.core.Visitor;

public final class AlphaNormalize
extends Visitor.Identity {
    private int newUnderscoreDepth = 0;
    private int underscoreDepth = 0;
    private final Map<String, LinkedList<Integer>> nameDepths = new HashMap<String, LinkedList<Integer>>();

    @Override
    public Expr onIdentifier(Expr expr, String string, long l) {
        if (string.equals("_")) {
            return Expr.makeIdentifier(string, l + (long)this.newUnderscoreDepth);
        }
        LinkedList<Integer> linkedList = this.nameDepths.get(string);
        if (linkedList == null) {
            return expr;
        }
        if (l < (long)linkedList.size()) {
            return Expr.makeIdentifier("_", this.underscoreDepth - linkedList.get((int)l));
        }
        return Expr.makeIdentifier(string, l - (long)linkedList.size());
    }

    @Override
    public void bind(String string, Expr expr) {
        ++this.underscoreDepth;
        if (!string.equals("_")) {
            ++this.newUnderscoreDepth;
            LinkedList<Integer> linkedList = this.nameDepths.get(string);
            if (linkedList == null) {
                linkedList = new LinkedList();
                this.nameDepths.put(string, linkedList);
            }
            linkedList.push(this.underscoreDepth);
        }
    }

    @Override
    public Expr onLambda(String string, Expr expr, Expr expr2) {
        --this.underscoreDepth;
        if (!string.equals("_")) {
            --this.newUnderscoreDepth;
            this.nameDepths.get(string).pop();
        }
        return Expr.makeLambda("_", expr, expr2);
    }

    @Override
    public Expr onPi(String string, Expr expr, Expr expr2) {
        --this.underscoreDepth;
        if (!string.equals("_")) {
            --this.newUnderscoreDepth;
            this.nameDepths.get(string).pop();
        }
        return Expr.makePi("_", expr, expr2);
    }

    @Override
    public Expr onLet(List<Expr.LetBinding<Expr>> list, Expr expr) {
        ArrayList<Expr.LetBinding<Expr>> arrayList = new ArrayList<Expr.LetBinding<Expr>>(list.size());
        for (Expr.LetBinding<Expr> letBinding : list) {
            String string = letBinding.getName();
            --this.underscoreDepth;
            if (!string.equals("_")) {
                --this.newUnderscoreDepth;
                this.nameDepths.get(string).pop();
            }
            arrayList.add(new Expr.LetBinding<Expr>("_", letBinding.getType(), letBinding.getValue()));
        }
        return Expr.makeLet(arrayList, expr);
    }
}

