/*
 * Decompiled with CFR 0.152.
 */
package org.dhallj.core.normalization;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.dhallj.core.Expr;
import org.dhallj.core.Operator;
import org.dhallj.core.normalization.BetaNormalize;

final class BetaNormalizeOperatorApplication {
    BetaNormalizeOperatorApplication() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static final Expr apply(Operator operator, Expr expr, Expr expr2) {
        if (operator.isBoolOperator()) {
            Boolean bl = Expr.Util.asBoolLiteral(expr);
            Boolean bl2 = Expr.Util.asBoolLiteral(expr2);
            if (operator.equals((Object)Operator.OR)) {
                if (bl != null) {
                    return bl != false ? expr : expr2;
                }
                if (bl2 != null) {
                    return bl2 != false ? expr2 : expr;
                }
                if (!expr.equivalent(expr2)) return Expr.makeOperatorApplication(operator, expr, expr2);
                return expr;
            }
            if (operator.equals((Object)Operator.AND)) {
                if (bl != null) {
                    return bl != false ? expr2 : expr;
                }
                if (bl2 != null) {
                    return bl2 != false ? expr : expr2;
                }
                if (!expr.equivalent(expr2)) return Expr.makeOperatorApplication(operator, expr, expr2);
                return expr;
            }
            if (operator.equals((Object)Operator.EQUALS)) {
                if (bl != null && bl.booleanValue()) {
                    return expr2;
                }
                if (bl2 != null && bl2.booleanValue()) {
                    return expr;
                }
                if (!expr.equivalent(expr2)) return Expr.makeOperatorApplication(operator, expr, expr2);
                return Expr.Constants.TRUE;
            }
            if (!operator.equals((Object)Operator.NOT_EQUALS)) return Expr.makeOperatorApplication(operator, expr, expr2);
            if (bl != null && !bl.booleanValue()) {
                return expr2;
            }
            if (bl2 != null && !bl2.booleanValue()) {
                return expr;
            }
            if (!expr.equivalent(expr2)) return Expr.makeOperatorApplication(operator, expr, expr2);
            return Expr.Constants.FALSE;
        }
        if (operator.equals((Object)Operator.PLUS)) {
            BigInteger bigInteger = Expr.Util.asNaturalLiteral(expr);
            BigInteger bigInteger2 = Expr.Util.asNaturalLiteral(expr2);
            if (bigInteger != null) {
                if (bigInteger2 != null) {
                    return Expr.makeNaturalLiteral(bigInteger.add(bigInteger2));
                }
                if (!bigInteger.equals(BigInteger.ZERO)) return Expr.makeOperatorApplication(operator, expr, expr2);
                return expr2;
            }
            if (bigInteger2 == null || !bigInteger2.equals(BigInteger.ZERO)) return Expr.makeOperatorApplication(operator, expr, expr2);
            return expr;
        }
        if (operator.equals((Object)Operator.TIMES)) {
            BigInteger bigInteger = Expr.Util.asNaturalLiteral(expr);
            BigInteger bigInteger3 = Expr.Util.asNaturalLiteral(expr2);
            if (bigInteger != null) {
                if (bigInteger3 != null) {
                    return Expr.makeNaturalLiteral(bigInteger.multiply(bigInteger3));
                }
                if (bigInteger.equals(BigInteger.ZERO)) {
                    return expr;
                }
                if (!bigInteger.equals(BigInteger.ONE)) return Expr.makeOperatorApplication(operator, expr, expr2);
                return expr2;
            }
            if (bigInteger3 == null) return Expr.makeOperatorApplication(operator, expr, expr2);
            if (bigInteger3.equals(BigInteger.ZERO)) {
                return expr2;
            }
            if (!bigInteger3.equals(BigInteger.ONE)) return Expr.makeOperatorApplication(operator, expr, expr2);
            return expr;
        }
        if (operator.equals((Object)Operator.TEXT_APPEND)) {
            String[] stringArray = new String[]{"", "", ""};
            ArrayList<Expr> arrayList = new ArrayList<Expr>(2);
            arrayList.add(expr);
            arrayList.add(expr2);
            return Expr.makeTextLiteral(stringArray, arrayList).accept(BetaNormalize.instance);
        }
        if (operator.equals((Object)Operator.LIST_APPEND)) {
            List<Expr> list = Expr.Util.asListLiteral(expr);
            List<Expr> list2 = Expr.Util.asListLiteral(expr2);
            if (list != null) {
                if (list.isEmpty()) {
                    return expr2;
                }
                if (list2 == null) return Expr.makeOperatorApplication(operator, expr, expr2);
                ArrayList<Expr> arrayList = new ArrayList<Expr>(list.size() + list2.size());
                arrayList.addAll(list);
                arrayList.addAll(list2);
                return Expr.makeNonEmptyListLiteral(arrayList);
            }
            if (list2 == null || !list2.isEmpty()) return Expr.makeOperatorApplication(operator, expr, expr2);
            return expr;
        }
        if (operator.equals((Object)Operator.PREFER)) {
            List<Map.Entry<String, Expr>> list = Expr.Util.asRecordLiteral(expr);
            List<Map.Entry<String, Expr>> list3 = Expr.Util.asRecordLiteral(expr2);
            if (list != null) {
                if (list3 != null) {
                    TreeMap<String, Expr> treeMap = new TreeMap<String, Expr>();
                    for (Map.Entry<String, Expr> entry : list) {
                        treeMap.put(entry.getKey(), entry.getValue());
                    }
                    for (Map.Entry<String, Expr> entry : list3) {
                        treeMap.put(entry.getKey(), entry.getValue());
                    }
                    return Expr.makeRecordLiteral(treeMap.entrySet());
                }
                if (list.iterator().hasNext()) return Expr.makeOperatorApplication(operator, expr, expr2);
                return expr2;
            }
            if (list3 != null && !list3.iterator().hasNext()) {
                return expr;
            }
            if (!expr.equivalent(expr2)) return Expr.makeOperatorApplication(operator, expr, expr2);
            return expr2;
        }
        if (operator.equals((Object)Operator.COMPLETE)) {
            return Expr.Util.desugarComplete(expr, expr2).accept(BetaNormalize.instance);
        }
        if (operator.equals((Object)Operator.COMBINE)) {
            List<Map.Entry<String, Expr>> list = Expr.Util.asRecordLiteral(expr);
            List<Map.Entry<String, Expr>> list4 = Expr.Util.asRecordLiteral(expr2);
            if (list != null) {
                if (list4 != null) {
                    return BetaNormalizeOperatorApplication.mergeRecursive(expr, expr2, list, list4).accept(BetaNormalize.instance);
                }
                if (list.iterator().hasNext()) return Expr.makeOperatorApplication(operator, expr, expr2);
                return expr2;
            }
            if (list4 == null || list4.iterator().hasNext()) return Expr.makeOperatorApplication(Operator.COMBINE, expr, expr2);
            return expr;
        }
        if (!operator.equals((Object)Operator.COMBINE_TYPES)) return Expr.makeOperatorApplication(operator, expr, expr2);
        List<Map.Entry<String, Expr>> list = Expr.Util.asRecordType(expr);
        List<Map.Entry<String, Expr>> list5 = Expr.Util.asRecordType(expr2);
        if (list != null) {
            if (list5 != null) {
                return BetaNormalizeOperatorApplication.mergeTypesRecursive(expr, expr2, list, list5).accept(BetaNormalize.instance);
            }
            if (list.iterator().hasNext()) return Expr.makeOperatorApplication(operator, expr, expr2);
            return expr2;
        }
        if (list5 == null || list5.iterator().hasNext()) return Expr.makeOperatorApplication(Operator.COMBINE_TYPES, expr, expr2);
        return expr;
    }

    private static final Expr mergeRecursive(Expr expr, Expr expr2, List<Map.Entry<String, Expr>> list, List<Map.Entry<String, Expr>> list2) {
        if (list != null && list2 != null) {
            TreeMap<String, Expr> treeMap = new TreeMap<String, Expr>();
            for (Map.Entry<String, Expr> entry : list) {
                treeMap.put(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, Expr> entry : list2) {
                String string = entry.getKey();
                Expr expr3 = entry.getValue();
                Expr expr4 = (Expr)treeMap.get(string);
                if (expr4 == null) {
                    treeMap.put(string, entry.getValue());
                    continue;
                }
                treeMap.put(string, BetaNormalizeOperatorApplication.mergeRecursive(expr4, expr3, Expr.Util.asRecordType(expr4), Expr.Util.asRecordType(expr3)));
            }
            return Expr.makeRecordLiteral(treeMap.entrySet());
        }
        return Expr.makeOperatorApplication(Operator.COMBINE, expr, expr2);
    }

    private static final Expr mergeTypesRecursive(Expr expr, Expr expr2, List<Map.Entry<String, Expr>> list, List<Map.Entry<String, Expr>> list2) {
        if (list != null && list2 != null) {
            TreeMap<String, Expr> treeMap = new TreeMap<String, Expr>();
            for (Map.Entry<String, Expr> entry : list) {
                treeMap.put(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, Expr> entry : list2) {
                String string = entry.getKey();
                Expr expr3 = entry.getValue();
                Expr expr4 = (Expr)treeMap.get(string);
                if (expr4 == null) {
                    treeMap.put(string, entry.getValue());
                    continue;
                }
                treeMap.put(string, BetaNormalizeOperatorApplication.mergeTypesRecursive(expr4, expr3, Expr.Util.asRecordType(expr4), Expr.Util.asRecordType(expr3)));
            }
            return Expr.makeRecordType(treeMap.entrySet());
        }
        return Expr.makeOperatorApplication(Operator.COMBINE, expr, expr2);
    }
}

