/*
 * Decompiled with CFR 0.152.
 */
package org.dhallj.core;

import java.math.BigInteger;
import java.net.URI;
import java.nio.file.Path;
import java.util.Map;
import org.dhallj.core.ArrayIterable;
import org.dhallj.core.Expr;
import org.dhallj.core.ExternalVisitor;
import org.dhallj.core.Operator;

final class Constructors {
    Constructors() {
    }

    static final class RemoteImport
    extends Expr {
        final URI url;
        final Expr using;
        final Expr.ImportMode mode;
        final byte[] hash;

        RemoteImport(URI uRI, Expr expr, Expr.ImportMode importMode, byte[] byArray) {
            super(28);
            this.url = uRI;
            this.using = expr;
            this.mode = importMode;
            this.hash = byArray;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onRemoteImport(this.url, this.using, this.mode, this.hash);
        }
    }

    static final class ClasspathImport
    extends Expr {
        final Path path;
        final Expr.ImportMode mode;
        final byte[] hash;

        ClasspathImport(Path path, Expr.ImportMode importMode, byte[] byArray) {
            super(29);
            this.path = path;
            this.mode = importMode;
            this.hash = byArray;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onClasspathImport(this.path, this.mode, this.hash);
        }
    }

    static final class LocalImport
    extends Expr {
        final Path path;
        final Expr.ImportMode mode;
        final byte[] hash;

        LocalImport(Path path, Expr.ImportMode importMode, byte[] byArray) {
            super(27);
            this.path = path;
            this.mode = importMode;
            this.hash = byArray;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onLocalImport(this.path, this.mode, this.hash);
        }
    }

    static final class EnvImport
    extends Expr {
        final String name;
        final Expr.ImportMode mode;
        final byte[] hash;

        EnvImport(String string, Expr.ImportMode importMode, byte[] byArray) {
            super(26);
            this.name = string;
            this.mode = importMode;
            this.hash = byArray;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onEnvImport(this.name, this.mode, this.hash);
        }
    }

    static final class MissingImport
    extends Expr {
        final Expr.ImportMode mode;
        final byte[] hash;

        MissingImport(Expr.ImportMode importMode, byte[] byArray) {
            super(25);
            this.mode = importMode;
            this.hash = byArray;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onMissingImport(this.mode, this.hash);
        }
    }

    static final class ToMap
    extends Expr {
        final Expr base;
        final Expr type;

        ToMap(Expr expr, Expr expr2) {
            super(24);
            this.base = expr;
            this.type = expr2;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onToMap(this.base, this.type);
        }
    }

    static final class Merge
    extends Expr {
        final Expr handlers;
        final Expr union;
        final Expr type;

        Merge(Expr expr, Expr expr2, Expr expr3) {
            super(23);
            this.handlers = expr;
            this.union = expr2;
            this.type = expr3;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onMerge(this.handlers, this.union, this.type);
        }
    }

    static final class Annotated
    extends Expr {
        final Expr base;
        final Expr type;

        Annotated(Expr expr, Expr expr2) {
            super(21);
            this.base = expr;
            this.type = expr2;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onAnnotated(this.base, this.type);
        }
    }

    static final class Let
    extends Expr {
        final String name;
        final Expr type;
        final Expr value;
        final Expr body;

        Let(String string, Expr expr, Expr expr2, Expr expr3) {
            super(8);
            this.name = string;
            this.type = expr;
            this.value = expr2;
            this.body = expr3;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onLet(this.name, this.type, this.value, this.body);
        }
    }

    static final class EmptyListLiteral
    extends Expr {
        final Expr type;

        EmptyListLiteral(Expr expr) {
            super(11);
            this.type = expr;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onEmptyList(this.type);
        }
    }

    static final class NonEmptyListLiteral
    extends Expr {
        final Expr[] values;

        NonEmptyListLiteral(Expr[] exprArray) {
            super(10);
            this.values = exprArray;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onNonEmptyList(new ArrayIterable<Expr>(this.values), this.values.length);
        }
    }

    static final class UnionType
    extends Expr {
        final Map.Entry<String, Expr>[] fields;

        UnionType(Map.Entry<String, Expr>[] entryArray) {
            super(14);
            this.fields = entryArray;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onUnionType(new ArrayIterable<Map.Entry<String, Expr>>(this.fields), this.fields.length);
        }
    }

    static final class RecordType
    extends Expr {
        final Map.Entry<String, Expr>[] fields;

        RecordType(Map.Entry<String, Expr>[] entryArray) {
            super(13);
            this.fields = entryArray;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onRecordType(new ArrayIterable<Map.Entry<String, Expr>>(this.fields), this.fields.length);
        }
    }

    static final class RecordLiteral
    extends Expr {
        final Map.Entry<String, Expr>[] fields;

        RecordLiteral(Map.Entry<String, Expr>[] entryArray) {
            super(12);
            this.fields = entryArray;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onRecord(new ArrayIterable<Map.Entry<String, Expr>>(this.fields), this.fields.length);
        }
    }

    static final class Identifier
    extends Expr {
        final String name;
        final long index;

        Identifier(String string, long l) {
            super(5);
            this.name = string;
            this.index = l;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onIdentifier(this.name, this.index);
        }
    }

    static final class BuiltIn
    extends Expr {
        final String name;

        BuiltIn(String string) {
            super(4);
            this.name = string;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onBuiltIn(this.name);
        }
    }

    static final class ProjectionByType
    extends Expr {
        final Expr base;
        final Expr type;

        ProjectionByType(Expr expr, Expr expr2) {
            super(17);
            this.base = expr;
            this.type = expr2;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onProjectionByType(this.base, this.type);
        }
    }

    static final class Projection
    extends Expr {
        final Expr base;
        final String[] fieldNames;

        Projection(Expr expr, String[] stringArray) {
            super(16);
            this.base = expr;
            this.fieldNames = stringArray;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onProjection(this.base, this.fieldNames);
        }
    }

    static final class FieldAccess
    extends Expr {
        final Expr base;
        final String fieldName;

        FieldAccess(Expr expr, String string) {
            super(15);
            this.base = expr;
            this.fieldName = string;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onFieldAccess(this.base, this.fieldName);
        }
    }

    static final class Assert
    extends Expr {
        final Expr base;

        Assert(Expr expr) {
            super(22);
            this.base = expr;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onAssert(this.base);
        }
    }

    static final class Pi
    extends Expr {
        final String name;
        final Expr type;
        final Expr result;

        Pi(String string, Expr expr, Expr expr2) {
            super(7);
            this.name = string;
            this.type = expr;
            this.result = expr2;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onPi(this.name, this.type, this.result);
        }
    }

    static final class Lambda
    extends Expr {
        final String name;
        final Expr type;
        final Expr result;

        Lambda(String string, Expr expr, Expr expr2) {
            super(6);
            this.name = string;
            this.type = expr;
            this.result = expr2;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onLambda(this.name, this.type, this.result);
        }
    }

    static final class If
    extends Expr {
        final Expr predicate;
        final Expr thenValue;
        final Expr elseValue;

        If(Expr expr, Expr expr2, Expr expr3) {
            super(20);
            this.predicate = expr;
            this.thenValue = expr2;
            this.elseValue = expr3;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onIf(this.predicate, this.thenValue, this.elseValue);
        }
    }

    static final class OperatorApplication
    extends Expr {
        final Operator operator;
        final Expr lhs;
        final Expr rhs;

        OperatorApplication(Operator operator, Expr expr, Expr expr2) {
            super(19);
            this.operator = operator;
            this.lhs = expr;
            this.rhs = expr2;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onOperatorApplication(this.operator, this.lhs, this.rhs);
        }
    }

    static final class Application
    extends Expr {
        final Expr base;
        final Expr arg;

        Application(Expr expr, Expr expr2) {
            super(18);
            this.base = expr;
            this.arg = expr2;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onApplication(this.base, this.arg);
        }
    }

    static final class TextLiteral
    extends Expr {
        final String[] parts;
        final Expr[] interpolated;

        TextLiteral(String[] stringArray, Expr[] exprArray) {
            super(9);
            this.parts = stringArray;
            this.interpolated = exprArray;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onText(this.parts, new ArrayIterable<Expr>(this.interpolated));
        }
    }

    static final class DoubleLiteral
    extends Expr {
        final double value;

        DoubleLiteral(double d) {
            super(3);
            this.value = d;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onDouble(this.value);
        }
    }

    static final class IntegerLiteral
    extends Expr {
        final BigInteger value;

        IntegerLiteral(BigInteger bigInteger) {
            super(2);
            this.value = bigInteger;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onInteger(this.value);
        }
    }

    static final class NaturalLiteral
    extends Expr {
        final BigInteger value;

        NaturalLiteral(BigInteger bigInteger) {
            super(1);
            this.value = bigInteger;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onNatural(this.value);
        }
    }
}

