/*
 * Decompiled with CFR 0.152.
 */
package org.dhallj.core;

import java.math.BigInteger;
import java.net.URI;
import java.nio.file.Path;
import java.util.Map;
import org.dhallj.core.Expr;
import org.dhallj.core.Operator;
import org.dhallj.core.Source;

public interface ExternalVisitor<A> {
    public A onNote(Expr var1, Source var2);

    public A onNatural(BigInteger var1);

    public A onInteger(BigInteger var1);

    public A onDouble(double var1);

    public A onBuiltIn(String var1);

    public A onIdentifier(String var1, long var2);

    public A onLambda(String var1, Expr var2, Expr var3);

    public A onPi(String var1, Expr var2, Expr var3);

    public A onLet(String var1, Expr var2, Expr var3, Expr var4);

    public A onText(String[] var1, Iterable<Expr> var2);

    public A onNonEmptyList(Iterable<Expr> var1, int var2);

    public A onEmptyList(Expr var1);

    public A onRecord(Iterable<Map.Entry<String, Expr>> var1, int var2);

    public A onRecordType(Iterable<Map.Entry<String, Expr>> var1, int var2);

    public A onUnionType(Iterable<Map.Entry<String, Expr>> var1, int var2);

    public A onFieldAccess(Expr var1, String var2);

    public A onProjection(Expr var1, String[] var2);

    public A onProjectionByType(Expr var1, Expr var2);

    public A onApplication(Expr var1, Expr var2);

    public A onOperatorApplication(Operator var1, Expr var2, Expr var3);

    public A onIf(Expr var1, Expr var2, Expr var3);

    public A onAnnotated(Expr var1, Expr var2);

    public A onAssert(Expr var1);

    public A onMerge(Expr var1, Expr var2, Expr var3);

    public A onToMap(Expr var1, Expr var2);

    public A onMissingImport(Expr.ImportMode var1, byte[] var2);

    public A onEnvImport(String var1, Expr.ImportMode var2, byte[] var3);

    public A onLocalImport(Path var1, Expr.ImportMode var2, byte[] var3);

    public A onClasspathImport(Path var1, Expr.ImportMode var2, byte[] var3);

    public A onRemoteImport(URI var1, Expr var2, Expr.ImportMode var3, byte[] var4);

    public static class Constant<A>
    implements ExternalVisitor<A> {
        private final A returnValue;

        protected A getReturnValue() {
            return this.returnValue;
        }

        public Constant(A a) {
            this.returnValue = a;
        }

        @Override
        public A onNote(Expr expr, Source source) {
            return expr.accept(this);
        }

        @Override
        public A onNatural(BigInteger bigInteger) {
            return this.getReturnValue();
        }

        @Override
        public A onInteger(BigInteger bigInteger) {
            return this.getReturnValue();
        }

        @Override
        public A onDouble(double d) {
            return this.getReturnValue();
        }

        @Override
        public A onBuiltIn(String string) {
            return this.getReturnValue();
        }

        @Override
        public A onIdentifier(String string, long l) {
            return this.getReturnValue();
        }

        @Override
        public A onLambda(String string, Expr expr, Expr expr2) {
            return this.getReturnValue();
        }

        @Override
        public A onPi(String string, Expr expr, Expr expr2) {
            return this.getReturnValue();
        }

        @Override
        public A onLet(String string, Expr expr, Expr expr2, Expr expr3) {
            return this.getReturnValue();
        }

        @Override
        public A onText(String[] stringArray, Iterable<Expr> iterable) {
            return this.getReturnValue();
        }

        @Override
        public A onNonEmptyList(Iterable<Expr> iterable, int n) {
            return this.getReturnValue();
        }

        @Override
        public A onEmptyList(Expr expr) {
            return this.getReturnValue();
        }

        @Override
        public A onRecord(Iterable<Map.Entry<String, Expr>> iterable, int n) {
            return this.getReturnValue();
        }

        @Override
        public A onRecordType(Iterable<Map.Entry<String, Expr>> iterable, int n) {
            return this.getReturnValue();
        }

        @Override
        public A onUnionType(Iterable<Map.Entry<String, Expr>> iterable, int n) {
            return this.getReturnValue();
        }

        @Override
        public A onFieldAccess(Expr expr, String string) {
            return this.getReturnValue();
        }

        @Override
        public A onProjection(Expr expr, String[] stringArray) {
            return this.getReturnValue();
        }

        @Override
        public A onProjectionByType(Expr expr, Expr expr2) {
            return this.getReturnValue();
        }

        @Override
        public A onApplication(Expr expr, Expr expr2) {
            return this.getReturnValue();
        }

        @Override
        public A onOperatorApplication(Operator operator, Expr expr, Expr expr2) {
            return this.getReturnValue();
        }

        @Override
        public A onIf(Expr expr, Expr expr2, Expr expr3) {
            return this.getReturnValue();
        }

        @Override
        public A onAnnotated(Expr expr, Expr expr2) {
            return this.getReturnValue();
        }

        @Override
        public A onAssert(Expr expr) {
            return this.getReturnValue();
        }

        @Override
        public A onMerge(Expr expr, Expr expr2, Expr expr3) {
            return this.getReturnValue();
        }

        @Override
        public A onToMap(Expr expr, Expr expr2) {
            return this.getReturnValue();
        }

        @Override
        public A onMissingImport(Expr.ImportMode importMode, byte[] byArray) {
            return this.getReturnValue();
        }

        @Override
        public A onEnvImport(String string, Expr.ImportMode importMode, byte[] byArray) {
            return this.getReturnValue();
        }

        @Override
        public A onLocalImport(Path path, Expr.ImportMode importMode, byte[] byArray) {
            return this.getReturnValue();
        }

        @Override
        public A onClasspathImport(Path path, Expr.ImportMode importMode, byte[] byArray) {
            return this.getReturnValue();
        }

        @Override
        public A onRemoteImport(URI uRI, Expr expr, Expr.ImportMode importMode, byte[] byArray) {
            return this.getReturnValue();
        }
    }
}

