/*
 * Decompiled with CFR 0.152.
 */
package org.dhallj.cbor;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.dhallj.cbor.AdditionalInfo;
import org.dhallj.cbor.HalfFloat;
import org.dhallj.cbor.MajorType;

public abstract class Writer {
    private static final int FALSE = 244;
    private static final int TRUE = 245;
    private static final int NULL = 246;
    private static final BigInteger LONG_MAX_VALUE = BigInteger.valueOf(Long.MAX_VALUE);
    private static final BigInteger EIGHT_BYTES_MAX_VALUE = new BigInteger("18446744073709551616");
    private static final Charset UTF_8 = Charset.forName("UTF-8");

    protected abstract void write(byte var1);

    protected abstract void write(byte ... var1);

    public final void writeNull() {
        this.write((byte)-10);
    }

    public final void writeBoolean(boolean bl) {
        this.write((byte)(bl ? 245 : 244));
    }

    public final void writeLong(long l) {
        this.writeTypeAndLength(l >= 0L ? MajorType.UNSIGNED_INTEGER.value : MajorType.NEGATIVE_INTEGER.value, l);
    }

    public final void writeBigInteger(BigInteger bigInteger) {
        if (bigInteger.compareTo(BigInteger.ZERO) >= 0) {
            this.writeTypeAndLength(MajorType.UNSIGNED_INTEGER.value, bigInteger);
        } else {
            this.writeTypeAndLength(MajorType.NEGATIVE_INTEGER.value, bigInteger.add(BigInteger.ONE).negate());
        }
    }

    public final void writeString(String string) {
        byte[] byArray = string.getBytes(UTF_8);
        this.writeTypeAndLength(MajorType.TEXT_STRING.value, byArray.length);
        this.write(byArray);
    }

    public final void writeByteString(byte[] byArray) {
        this.writeTypeAndLength(MajorType.BYTE_STRING.value, byArray.length);
        this.write(byArray);
    }

    public final void writeDouble(double d) {
        int n = MajorType.PRIMITIVE.value << 5;
        if (Double.isNaN(d)) {
            this.write((byte)(n | AdditionalInfo.TWO_BYTES.value), 126, 0);
        } else {
            float f = (float)d;
            if (d == (double)f) {
                int n2 = HalfFloat.fromFloat(f);
                if (HalfFloat.toFloat(n2) == f) {
                    this.write((byte)(n | AdditionalInfo.TWO_BYTES.value), (byte)(n2 >> 8 & 0xFF), (byte)(n2 >> 0 & 0xFF));
                } else {
                    int n3 = Float.floatToIntBits(f);
                    this.write((byte)(n | AdditionalInfo.FOUR_BYTES.value), (byte)(n3 >> 24 & 0xFF), (byte)(n3 >> 16 & 0xFF), (byte)(n3 >> 8 & 0xFF), (byte)(n3 >> 0 & 0xFF));
                }
            } else {
                long l = Double.doubleToLongBits(d);
                this.write((byte)(n | AdditionalInfo.EIGHT_BYTES.value), (byte)(l >> 56 & 0xFFL), (byte)(l >> 48 & 0xFFL), (byte)(l >> 40 & 0xFFL), (byte)(l >> 32 & 0xFFL), (byte)(l >> 24 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l >> 0 & 0xFFL));
            }
        }
    }

    public final void writeArrayStart(int n) {
        this.writeTypeAndLength(MajorType.ARRAY.value, n);
    }

    public final void writeMapStart(int n) {
        this.writeTypeAndLength(MajorType.MAP.value, n);
    }

    private final void writeTypeAndLength(int n, long l) {
        int n2 = n << 5;
        if (l <= 23L) {
            this.write((byte)((long)n2 | l));
        } else if (l < 256L) {
            this.write((byte)(n2 | AdditionalInfo.ONE_BYTE.value), (byte)l);
        } else if (l < 65536L) {
            this.write((byte)(n2 | AdditionalInfo.TWO_BYTES.value), (byte)(l >> 8), (byte)(l & 0xFFL));
        } else if (l < 0x100000000L) {
            this.write((byte)(n2 | AdditionalInfo.FOUR_BYTES.value), (byte)(l >> 24 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l & 0xFFL));
        } else {
            this.write((byte)(n2 | AdditionalInfo.EIGHT_BYTES.value), (byte)(l >> 56 & 0xFFL), (byte)(l >> 48 & 0xFFL), (byte)(l >> 40 & 0xFFL), (byte)(l >> 32 & 0xFFL), (byte)(l >> 24 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l & 0xFFL));
        }
    }

    private final void writeTypeAndLength(int n, BigInteger bigInteger) {
        if (bigInteger.compareTo(LONG_MAX_VALUE) <= 0) {
            this.writeTypeAndLength(n, bigInteger.longValue());
        } else if (bigInteger.compareTo(EIGHT_BYTES_MAX_VALUE) < 0) {
            int n2 = n << 5;
            BigInteger bigInteger2 = BigInteger.valueOf(255L);
            this.write((byte)(n2 | AdditionalInfo.EIGHT_BYTES.value), bigInteger.shiftRight(56).and(bigInteger2).byteValue(), bigInteger.shiftRight(48).and(bigInteger2).byteValue(), bigInteger.shiftRight(40).and(bigInteger2).byteValue(), bigInteger.shiftRight(32).and(bigInteger2).byteValue(), bigInteger.shiftRight(24).and(bigInteger2).byteValue(), bigInteger.shiftRight(16).and(bigInteger2).byteValue(), bigInteger.shiftRight(8).and(bigInteger2).byteValue(), bigInteger.and(bigInteger2).byteValue());
        } else {
            if (n == MajorType.NEGATIVE_INTEGER.value) {
                this.writeTypeAndLength(MajorType.SEMANTIC_TAG.value, 3L);
            } else {
                this.writeTypeAndLength(MajorType.SEMANTIC_TAG.value, 2L);
            }
            byte[] byArray = bigInteger.toByteArray();
            this.writeTypeAndLength(MajorType.BYTE_STRING.value, byArray.length);
            this.write(byArray);
        }
    }

    public static final class SHA256Writer
    extends Writer {
        private final MessageDigest messageDigest;

        public SHA256Writer() {
            MessageDigest messageDigest = null;
            try {
                messageDigest = MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
            this.messageDigest = messageDigest;
        }

        public final byte[] getHashBytes() {
            return this.messageDigest.digest();
        }

        @Override
        protected final void write(byte by) {
            this.messageDigest.update(by);
        }

        @Override
        protected final void write(byte ... byArray) {
            this.messageDigest.update(byArray);
        }
    }

    public static final class ByteArrayWriter
    extends OutputStreamWriter {
        public ByteArrayWriter() {
            super(new ByteArrayOutputStream());
        }

        public final byte[] getBytes() {
            return ((ByteArrayOutputStream)this.stream).toByteArray();
        }
    }

    public static class OutputStreamWriter
    extends Writer {
        protected final OutputStream stream;

        public OutputStreamWriter(OutputStream outputStream) {
            this.stream = outputStream;
        }

        @Override
        protected final void write(byte by) {
            try {
                this.stream.write(by);
            }
            catch (IOException iOException) {
                throw new WrappedIOException(iOException);
            }
        }

        @Override
        protected final void write(byte ... byArray) {
            try {
                this.stream.write(byArray);
            }
            catch (IOException iOException) {
                throw new WrappedIOException(iOException);
            }
        }
    }

    private static final class WrappedIOException
    extends RuntimeException {
        final IOException underlying;

        WrappedIOException(IOException iOException) {
            this.underlying = iOException;
        }
    }
}

