/*
 * Decompiled with CFR 0.152.
 */
package org.dhallj.core.normalization;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import org.dhallj.core.Expr;
import org.dhallj.core.Visitor;

public final class Substitute
extends Visitor.Identity {
    private final String name;
    private int index = 0;
    private final Deque<Expr> replacementStack = new ArrayDeque<Expr>();

    public Substitute(String string, Expr expr) {
        this.name = string;
        this.replacementStack.push(expr);
    }

    @Override
    public void bind(String string, Expr expr) {
        this.replacementStack.push(this.replacementStack.peekFirst().increment(string));
        if (string.equals(this.name)) {
            ++this.index;
        }
    }

    @Override
    public Expr onIdentifier(Expr expr, String string, long l) {
        if (string.equals(this.name)) {
            if (l == (long)this.index) {
                return this.replacementStack.peekFirst();
            }
            if (l > (long)this.index) {
                return Expr.makeIdentifier(string, l - 1L);
            }
            return expr;
        }
        return expr;
    }

    @Override
    public Expr onLambda(String string, Expr expr, Expr expr2) {
        this.replacementStack.pop();
        if (string.equals(this.name)) {
            --this.index;
        }
        return Expr.makeLambda(string, expr, expr2);
    }

    @Override
    public Expr onPi(String string, Expr expr, Expr expr2) {
        this.replacementStack.pop();
        if (string.equals(this.name)) {
            --this.index;
        }
        return Expr.makePi(string, expr, expr2);
    }

    @Override
    public Expr onLet(List<Expr.LetBinding<Expr>> list, Expr expr) {
        for (Expr.LetBinding<Expr> letBinding : list) {
            String string = letBinding.getName();
            this.replacementStack.pop();
            if (!string.equals(this.name)) continue;
            --this.index;
        }
        return Expr.makeLet(list, expr);
    }
}

