/*
 * Decompiled with CFR 0.152.
 */
package org.dhallj.cbor;

public enum AdditionalInfo {
    DIRECT(0),
    ONE_BYTE(24),
    TWO_BYTES(25),
    FOUR_BYTES(26),
    EIGHT_BYTES(27),
    RESERVED(28),
    INDEFINITE(31);

    final int value;

    private AdditionalInfo(int n2) {
        this.value = n2;
    }

    public static AdditionalInfo fromByte(byte by) {
        switch (by & 0x1F) {
            case 24: {
                return ONE_BYTE;
            }
            case 25: {
                return TWO_BYTES;
            }
            case 26: {
                return FOUR_BYTES;
            }
            case 27: {
                return EIGHT_BYTES;
            }
            case 28: 
            case 29: 
            case 30: {
                return RESERVED;
            }
            case 31: {
                return INDEFINITE;
            }
        }
        return DIRECT;
    }
}

