/*
 * Decompiled with CFR 0.152.
 */
package org.dhallj.core;

import java.util.Iterator;
import java.util.NoSuchElementException;

final class ArrayIterable<A>
implements Iterable<A> {
    private final A[] values;

    public ArrayIterable(A[] AArray) {
        this.values = AArray;
    }

    @Override
    public final Iterator<A> iterator() {
        return new ArrayIterator<A>(this.values);
    }

    private static final class ArrayIterator<A>
    implements Iterator<A> {
        private final A[] values;
        private int i = 0;

        ArrayIterator(A[] AArray) {
            this.values = AArray;
        }

        @Override
        public final boolean hasNext() {
            return this.i < this.values.length;
        }

        @Override
        public final A next() {
            try {
                return this.values[this.i++];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

