/*
 * Decompiled with CFR 0.152.
 */
package org.dhallj.core;

import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URI;
import java.nio.file.Path;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.dhallj.cbor.Writer;
import org.dhallj.core.Constructors;
import org.dhallj.core.ExternalVisitor;
import org.dhallj.core.IsResolved;
import org.dhallj.core.Operator;
import org.dhallj.core.Source;
import org.dhallj.core.ToStringVisitor;
import org.dhallj.core.Visitor;
import org.dhallj.core.binary.Encode;
import org.dhallj.core.normalization.AlphaNormalize;
import org.dhallj.core.normalization.BetaNormalize;
import org.dhallj.core.normalization.Shift;
import org.dhallj.core.normalization.Substitute;
import org.dhallj.core.typechecking.TypeCheck;

public abstract class Expr {
    final int tag;
    private final AtomicReference<byte[]> cachedHashBytes = new AtomicReference();
    private static final Expr[] emptyExprArray = new Expr[0];
    private static final Comparator<Map.Entry<String, Expr>> entryComparator = new Comparator<Map.Entry<String, Expr>>(){

        @Override
        public int compare(Map.Entry<String, Expr> entry, Map.Entry<String, Expr> entry2) {
            return entry.getKey().compareTo(entry2.getKey());
        }
    };

    Expr(int n) {
        this.tag = n;
    }

    public abstract <A> A accept(ExternalVisitor<A> var1);

    public final Expr normalize() {
        return this.accept(BetaNormalize.instance);
    }

    public final Expr alphaNormalize() {
        return this.accept(new AlphaNormalize());
    }

    public final Expr increment(String string) {
        return this.accept(new Shift(true, string));
    }

    public final Expr decrement(String string) {
        return this.accept(new Shift(false, string));
    }

    public final Expr substitute(String string, Expr expr) {
        return this.accept(new Substitute(string, expr));
    }

    public final byte[] getEncodedBytes() {
        Writer.ByteArrayWriter byteArrayWriter = new Writer.ByteArrayWriter();
        this.accept(new Encode(byteArrayWriter));
        return byteArrayWriter.getBytes();
    }

    public final byte[] getHashBytes() {
        byte[] byArray = this.cachedHashBytes.get();
        if (byArray == null) {
            Writer.SHA256Writer sHA256Writer = new Writer.SHA256Writer();
            this.accept(new Encode(sHA256Writer));
            byArray = sHA256Writer.getHashBytes();
            if (!this.cachedHashBytes.compareAndSet(null, byArray)) {
                return this.cachedHashBytes.get();
            }
        }
        return byArray;
    }

    public final String hash() {
        return Util.encodeHashBytes(this.getHashBytes());
    }

    public final boolean isResolved() {
        return this.accept(IsResolved.instance);
    }

    public final boolean sameStructure(Expr expr) {
        return this.getFirstDiff(expr) == null;
    }

    public final boolean equivalent(Expr expr) {
        return Arrays.equals(this.normalize().alphaNormalize().getEncodedBytes(), expr.normalize().alphaNormalize().getEncodedBytes());
    }

    public final boolean equals(Object object) {
        if (object instanceof Expr) {
            return this.equivalent((Expr)object);
        }
        return false;
    }

    public final int hashCode() {
        return Arrays.hashCode(this.normalize().alphaNormalize().getEncodedBytes());
    }

    public final String toString() {
        return this.accept(ToStringVisitor.instance).toString();
    }

    private Expr getNonNote() {
        Expr expr = this;
        while (expr.tag == 0) {
            expr = ((Parsed)expr).base;
        }
        return expr;
    }

    public static final Expr makeDoubleLiteral(double d) {
        return new Constructors.DoubleLiteral(d);
    }

    public static final Expr makeNaturalLiteral(BigInteger bigInteger) {
        return new Constructors.NaturalLiteral(bigInteger);
    }

    public static final Expr makeIntegerLiteral(BigInteger bigInteger) {
        return new Constructors.IntegerLiteral(bigInteger);
    }

    public static final Expr makeTextLiteral(String[] stringArray, Expr[] exprArray) {
        return new Constructors.TextLiteral(stringArray, exprArray);
    }

    public static final Expr makeTextLiteral(String[] stringArray, Collection<Expr> collection) {
        return new Constructors.TextLiteral(stringArray, collection.toArray(new Expr[collection.size()]));
    }

    public static final Expr makeTextLiteral(String string) {
        String[] stringArray = new String[]{string};
        return new Constructors.TextLiteral(stringArray, emptyExprArray);
    }

    public static final Expr makeApplication(Expr expr, Expr expr2) {
        return new Constructors.Application(expr, expr2);
    }

    public static final Expr makeApplication(Expr expr, Expr[] exprArray) {
        Expr expr2 = expr;
        for (int i = 0; i < exprArray.length; ++i) {
            expr2 = Expr.makeApplication(expr2, exprArray[i]);
        }
        return expr2;
    }

    public static final Expr makeApplication(Expr expr, List<Expr> list) {
        Expr expr2 = expr;
        for (int i = 0; i < list.size(); ++i) {
            expr2 = Expr.makeApplication(expr2, list.get(i));
        }
        return expr2;
    }

    public static final Expr makeOperatorApplication(Operator operator, Expr expr, Expr expr2) {
        return new Constructors.OperatorApplication(operator, expr, expr2);
    }

    public static final Expr makeIf(Expr expr, Expr expr2, Expr expr3) {
        return new Constructors.If(expr, expr2, expr3);
    }

    public static final Expr makeLambda(String string, Expr expr, Expr expr2) {
        return new Constructors.Lambda(string, expr, expr2);
    }

    public static final Expr makePi(String string, Expr expr, Expr expr2) {
        return new Constructors.Pi(string, expr, expr2);
    }

    public static final Expr makePi(Expr expr, Expr expr2) {
        return Expr.makePi("_", expr, expr2);
    }

    public static final Expr makeAssert(Expr expr) {
        return new Constructors.Assert(expr);
    }

    public static final Expr makeFieldAccess(Expr expr, String string) {
        return new Constructors.FieldAccess(expr, string);
    }

    public static final Expr makeProjection(Expr expr, String[] stringArray) {
        return new Constructors.Projection(expr, stringArray);
    }

    public static final Expr makeProjectionByType(Expr expr, Expr expr2) {
        return new Constructors.ProjectionByType(expr, expr2);
    }

    public static final Expr makeBuiltIn(String string) {
        if (Constants.getBuiltIn(string) == null) {
            throw new IllegalArgumentException(string + " is not a built-in");
        }
        return Constants.getBuiltIn(string);
    }

    public static final Expr makeIdentifier(String string, long l) {
        return new Constructors.Identifier(string, l);
    }

    public static final Expr makeIdentifier(String string) {
        return Expr.makeIdentifier(string, 0L);
    }

    public static final Expr makeRecordLiteral(Map.Entry<String, Expr>[] entryArray) {
        return new Constructors.RecordLiteral(entryArray);
    }

    public static final Expr makeRecordLiteral(Collection<Map.Entry<String, Expr>> collection) {
        return new Constructors.RecordLiteral(collection.toArray(new Map.Entry[collection.size()]));
    }

    public static final Expr makeRecordLiteral(String string, Expr expr) {
        return new Constructors.RecordLiteral(new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<String, Expr>(string, expr)});
    }

    public static final Expr makeRecordType(Map.Entry<String, Expr>[] entryArray) {
        return new Constructors.RecordType(entryArray);
    }

    public static final Expr makeRecordType(Collection<Map.Entry<String, Expr>> collection) {
        return new Constructors.RecordType(collection.toArray(new Map.Entry[collection.size()]));
    }

    public static final Expr makeUnionType(Map.Entry<String, Expr>[] entryArray) {
        return new Constructors.UnionType(entryArray);
    }

    public static final Expr makeUnionType(Collection<Map.Entry<String, Expr>> collection) {
        return new Constructors.UnionType(collection.toArray(new Map.Entry[collection.size()]));
    }

    public static final Expr makeNonEmptyListLiteral(Expr[] exprArray) {
        return new Constructors.NonEmptyListLiteral(exprArray);
    }

    public static final Expr makeNonEmptyListLiteral(Collection<Expr> collection) {
        return new Constructors.NonEmptyListLiteral(collection.toArray(new Expr[collection.size()]));
    }

    public static final Expr makeEmptyListLiteral(Expr expr) {
        return new Constructors.EmptyListLiteral(expr);
    }

    public static final Expr makeNote(Expr expr, Source source) {
        return new Parsed(expr, source);
    }

    public static final Expr makeLet(String string, Expr expr, Expr expr2, Expr expr3) {
        return new Constructors.Let(string, expr, expr2, expr3);
    }

    public static final Expr makeLet(List<LetBinding<Expr>> list, Expr expr) {
        Expr expr2 = expr;
        for (int i = list.size() - 1; i >= 0; --i) {
            LetBinding<Expr> letBinding = list.get(i);
            expr2 = new Constructors.Let(letBinding.getName(), letBinding.getType(), letBinding.getValue(), expr2);
        }
        return expr2;
    }

    public static final Expr makeLet(String string, Expr expr, Expr expr2) {
        return Expr.makeLet(string, null, expr, expr2);
    }

    public static final Expr makeAnnotated(Expr expr, Expr expr2) {
        return new Constructors.Annotated(expr, expr2);
    }

    public static final Expr makeToMap(Expr expr, Expr expr2) {
        return new Constructors.ToMap(expr, expr2);
    }

    public static final Expr makeToMap(Expr expr) {
        return Expr.makeToMap(expr, null);
    }

    public static final Expr makeWith(Expr expr, String[] stringArray, Expr expr2) {
        return new Constructors.With(expr, stringArray, expr2);
    }

    public static final Expr makeMerge(Expr expr, Expr expr2, Expr expr3) {
        return new Constructors.Merge(expr, expr2, expr3);
    }

    public static final Expr makeMerge(Expr expr, Expr expr2) {
        return Expr.makeMerge(expr, expr2, null);
    }

    public static final Expr makeLocalImport(Path path, ImportMode importMode, byte[] byArray) {
        return new Constructors.LocalImport(path, importMode, byArray);
    }

    public static final Expr makeClasspathImport(Path path, ImportMode importMode, byte[] byArray) {
        return new Constructors.ClasspathImport(path, importMode, byArray);
    }

    public static final Expr makeRemoteImport(URI uRI, Expr expr, ImportMode importMode, byte[] byArray) {
        return new Constructors.RemoteImport(uRI, expr, importMode, byArray);
    }

    public static final Expr makeEnvImport(String string, ImportMode importMode, byte[] byArray) {
        return new Constructors.EnvImport(string, importMode, byArray);
    }

    public static final Expr makeMissingImport(ImportMode importMode, byte[] byArray) {
        return new Constructors.MissingImport(importMode, byArray);
    }

    public final <A> A accept(Visitor<A> visitor) {
        State state = new State(this, 0);
        ArrayDeque<State> arrayDeque = new ArrayDeque<State>();
        LinkedList linkedList = new LinkedList();
        ArrayDeque<Object> arrayDeque2 = new ArrayDeque<Object>();
        ArrayDeque<List<LetBinding<Expr>>> arrayDeque3 = new ArrayDeque<List<LetBinding<Expr>>>();
        ArrayDeque arrayDeque4 = new ArrayDeque();
        while (state != null) {
            switch (state.expr.tag) {
                case 0: {
                    Object e2;
                    Parsed parsed = (Parsed)state.expr;
                    switch (state.state) {
                        case 0: {
                            state.state = 1;
                            arrayDeque.push(state);
                            arrayDeque.push(new State(parsed.base, 0));
                            break;
                        }
                        case 1: {
                            e2 = linkedList.poll();
                            linkedList.push(visitor.onNote(e2, parsed.source));
                        }
                    }
                    break;
                }
                case 1: {
                    linkedList.push(visitor.onNatural(state.expr, ((Constructors.NaturalLiteral)state.expr).value));
                    break;
                }
                case 2: {
                    linkedList.push(visitor.onInteger(state.expr, ((Constructors.IntegerLiteral)state.expr).value));
                    break;
                }
                case 3: {
                    linkedList.push(visitor.onDouble(state.expr, ((Constructors.DoubleLiteral)state.expr).value));
                    break;
                }
                case 4: {
                    Constructors.BuiltIn builtIn = (Constructors.BuiltIn)state.expr;
                    linkedList.push(visitor.onBuiltIn(state.expr, builtIn.name));
                    break;
                }
                case 5: {
                    Constructors.Identifier identifier = (Constructors.Identifier)state.expr;
                    linkedList.push(visitor.onIdentifier(state.expr, identifier.name, identifier.index));
                    break;
                }
                case 6: {
                    Object e3;
                    Object e2;
                    Constructors.Lambda lambda = (Constructors.Lambda)state.expr;
                    switch (state.state) {
                        case 0: {
                            visitor.prepareLambda(lambda.name, lambda.type);
                            state.state = 1;
                            arrayDeque.push(state);
                            arrayDeque.push(new State(lambda.type, 0));
                            break;
                        }
                        case 1: {
                            visitor.bind(lambda.name, lambda.type);
                            state.state = 2;
                            arrayDeque.push(state);
                            arrayDeque.push(new State(lambda.result, 0));
                            break;
                        }
                        case 2: {
                            e3 = linkedList.poll();
                            e2 = linkedList.poll();
                            linkedList.push(visitor.onLambda(lambda.name, e2, e3));
                        }
                    }
                    break;
                }
                case 7: {
                    Object e3;
                    Object e2;
                    Constructors.Pi pi = (Constructors.Pi)state.expr;
                    switch (state.state) {
                        case 0: {
                            visitor.preparePi(pi.name, pi.type);
                            state.state = 1;
                            arrayDeque.push(state);
                            arrayDeque.push(new State(pi.type, 0));
                            break;
                        }
                        case 1: {
                            visitor.bind(pi.name, pi.type);
                            state.state = 2;
                            arrayDeque.push(state);
                            arrayDeque.push(new State(pi.result, 0));
                            break;
                        }
                        case 2: {
                            e3 = linkedList.poll();
                            e2 = linkedList.poll();
                            linkedList.push(visitor.onPi(pi.name, e2, e3));
                        }
                    }
                    break;
                }
                case 8: {
                    Object object;
                    ArrayList<String> arrayList;
                    List<LetBinding<Expr>> list;
                    Object e3;
                    Object e2;
                    Constructors.Let let = (Constructors.Let)state.expr;
                    if (state.state == 0) {
                        list = new ArrayList();
                        list.add(new LetBinding<Expr>(let.name, let.type, let.value));
                        Expr.gatherLetBindings(let.body, list);
                        state.state = 1;
                        state.size = list.size();
                        arrayList = new ArrayList<String>(state.size);
                        for (LetBinding object2 : list) {
                            arrayList.add(object2.getName());
                        }
                        arrayDeque4.push(arrayList);
                        visitor.prepareLet(list.size());
                    } else {
                        list = (List)arrayDeque3.poll();
                    }
                    if (list.isEmpty()) {
                        if (state.state == 1) {
                            state.state = 3;
                            arrayDeque.push(state);
                            arrayDeque.push(new State(Expr.gatherLetBindings(let.body, null), 0));
                            arrayDeque3.push(list);
                            break;
                        }
                        arrayList = (List)arrayDeque4.poll();
                        object = new LinkedList();
                        Object i = linkedList.poll();
                        for (int recordLiteral = 0; recordLiteral < state.size; ++recordLiteral) {
                            e3 = linkedList.poll();
                            e2 = linkedList.poll();
                            ((LinkedList)object).push(new LetBinding((String)arrayList.get(state.size - 1 - recordLiteral), e2, e3));
                        }
                        linkedList.push(visitor.onLet(object, i));
                        break;
                    }
                    arrayList = (LetBinding)list.get(0);
                    switch (state.state) {
                        case 1: {
                            state.state = 2;
                            visitor.prepareLetBinding(((LetBinding)((Object)arrayList)).getName(), (Expr)((LetBinding)((Object)arrayList)).getType());
                            if (((LetBinding)((Object)arrayList)).hasType()) {
                                arrayDeque.push(state);
                                arrayDeque.push(new State((Expr)((LetBinding)((Object)arrayList)).getType(), 0));
                                arrayDeque3.push(list);
                                break;
                            }
                            linkedList.push(null);
                        }
                        case 2: {
                            state.state = 1;
                            visitor.bind(((LetBinding)((Object)arrayList)).getName(), (Expr)((LetBinding)((Object)arrayList)).getType());
                            arrayDeque.push(state);
                            arrayDeque.push(new State((Expr)((LetBinding)((Object)arrayList)).getValue(), 0));
                            list.remove(0);
                            arrayDeque3.push(list);
                        }
                    }
                    break;
                }
                case 9: {
                    Object object;
                    ArrayList<String> arrayList = (Constructors.TextLiteral)state.expr;
                    if (state.state == 0) {
                        visitor.prepareText(((Constructors.TextLiteral)((Object)arrayList)).parts.length);
                        visitor.prepareTextPart(((Constructors.TextLiteral)((Object)arrayList)).parts[0]);
                        if (((Constructors.TextLiteral)((Object)arrayList)).interpolated.length == 0) {
                            linkedList.push(visitor.onText(((Constructors.TextLiteral)((Object)arrayList)).parts, new ArrayList()));
                            break;
                        }
                        state.state = 1;
                        arrayDeque.push(state);
                        arrayDeque.push(new State(((Constructors.TextLiteral)((Object)arrayList)).interpolated[state.state - 1], 0));
                        break;
                    }
                    if (state.state == ((Constructors.TextLiteral)((Object)arrayList)).interpolated.length) {
                        visitor.prepareTextPart(((Constructors.TextLiteral)((Object)arrayList)).parts[((Constructors.TextLiteral)((Object)arrayList)).parts.length - 1]);
                        object = new ArrayList();
                        boolean bl = false;
                        while (arrayList < ((Constructors.TextLiteral)((Object)arrayList)).interpolated.length) {
                            object.add(linkedList.poll());
                            ++arrayList;
                        }
                        Collections.reverse(object);
                        linkedList.push(visitor.onText(((Constructors.TextLiteral)((Object)arrayList)).parts, object));
                        break;
                    }
                    ++state.state;
                    visitor.prepareTextPart(((Constructors.TextLiteral)((Object)arrayList)).parts[state.state - 1]);
                    arrayDeque.push(state);
                    arrayDeque.push(new State(((Constructors.TextLiteral)((Object)arrayList)).interpolated[state.state - 1], 0));
                    break;
                }
                case 10: {
                    Object object = (Constructors.NonEmptyListLiteral)state.expr;
                    if (state.state == 0) {
                        boolean bl;
                        Expr expr;
                        boolean emptyListLiteral = false;
                        if (visitor.flattenToMapLists() && (expr = Expr.flattenToMapList(((Constructors.NonEmptyListLiteral)object).values)) != null) {
                            arrayDeque.push(new State(expr, 0));
                            bl = true;
                        }
                        if (bl) break;
                        visitor.prepareNonEmptyList(((Constructors.NonEmptyListLiteral)object).values.length);
                        visitor.prepareNonEmptyListElement(0);
                        state.state = 1;
                        arrayDeque.push(state);
                        arrayDeque.push(new State(((Constructors.NonEmptyListLiteral)object).values[state.state - 1], 0));
                        break;
                    }
                    if (state.state == ((Constructors.NonEmptyListLiteral)object).values.length) {
                        ArrayList arrayList = new ArrayList();
                        for (int i = 0; i < ((Constructors.NonEmptyListLiteral)object).values.length; ++i) {
                            arrayList.add(linkedList.poll());
                        }
                        Collections.reverse(arrayList);
                        linkedList.push(visitor.onNonEmptyList(arrayList));
                        break;
                    }
                    visitor.prepareNonEmptyListElement(state.state);
                    ++state.state;
                    arrayDeque.push(state);
                    arrayDeque.push(new State(((Constructors.NonEmptyListLiteral)object).values[state.state - 1], 0));
                    break;
                }
                case 11: {
                    Constructors.EmptyListLiteral emptyListLiteral = (Constructors.EmptyListLiteral)state.expr;
                    if (state.state == 0) {
                        if (visitor.flattenToMapLists() && Expr.isToMapListType(emptyListLiteral.type)) {
                            arrayDeque.push(new State(Constants.EMPTY_RECORD_LITERAL, 0));
                            break;
                        }
                        if (visitor.prepareEmptyList(emptyListLiteral.type)) {
                            state.state = 1;
                            arrayDeque.push(state);
                            arrayDeque.push(new State(emptyListLiteral.type, 0));
                            break;
                        }
                        linkedList.push(null);
                        break;
                    }
                    linkedList.push(visitor.onEmptyList(linkedList.poll()));
                    break;
                }
                case 12: {
                    Map.Entry<String, Expr> entry;
                    Constructors.RecordLiteral recordLiteral = (Constructors.RecordLiteral)state.expr;
                    if (state.state == 0) {
                        visitor.prepareRecord(recordLiteral.fields.length);
                        if (recordLiteral.fields.length == 0) {
                            linkedList.push(visitor.onRecord(new ArrayList()));
                            break;
                        }
                        state = new State(state.expr, 1, recordLiteral.fields, visitor.sortFields());
                        arrayDeque.push(state);
                        entry = state.sortedFields[state.state - 1];
                        visitor.prepareRecordField(entry.getKey(), entry.getValue(), state.state - 1);
                        arrayDeque.push(new State(entry.getValue(), 0));
                        break;
                    }
                    if (state.state == state.sortedFields.length) {
                        entry = new ArrayList();
                        for (int entry3 = state.sortedFields.length - 1; entry3 >= 0; --entry3) {
                            entry.add(new AbstractMap.SimpleImmutableEntry(state.sortedFields[entry3].getKey(), linkedList.poll()));
                        }
                        Collections.reverse(entry);
                        linkedList.push(visitor.onRecord(entry));
                        break;
                    }
                    ++state.state;
                    entry = state.sortedFields[state.state - 1];
                    visitor.prepareRecordField(entry.getKey(), entry.getValue(), state.state - 1);
                    arrayDeque.push(state);
                    arrayDeque.push(new State(entry.getValue(), 0));
                    break;
                }
                case 13: {
                    Map.Entry<String, Expr> entry = (Constructors.RecordType)state.expr;
                    if (state.state == 0) {
                        visitor.prepareRecordType(((Constructors.RecordType)((Object)entry)).fields.length);
                        if (((Constructors.RecordType)((Object)entry)).fields.length == 0) {
                            linkedList.push(visitor.onRecordType(new ArrayList()));
                            break;
                        }
                        state = new State(state.expr, 1, ((Constructors.RecordType)((Object)entry)).fields, visitor.sortFields());
                        arrayDeque.push(state);
                        Map.Entry<String, Expr> unionType = state.sortedFields[state.state - 1];
                        visitor.prepareRecordTypeField(unionType.getKey(), unionType.getValue(), state.state - 1);
                        arrayDeque.push(new State(unionType.getValue(), 0));
                        break;
                    }
                    if (state.state == state.sortedFields.length) {
                        ArrayList arrayList = new ArrayList();
                        for (int entry2 = state.sortedFields.length - 1; entry2 >= 0; --entry2) {
                            arrayList.add(new AbstractMap.SimpleImmutableEntry(state.sortedFields[entry2].getKey(), linkedList.poll()));
                        }
                        Collections.reverse(arrayList);
                        linkedList.push(visitor.onRecordType(arrayList));
                        break;
                    }
                    ++state.state;
                    Map.Entry<String, Expr> entry3 = state.sortedFields[state.state - 1];
                    visitor.prepareRecordTypeField(entry3.getKey(), entry3.getValue(), state.state - 1);
                    arrayDeque.push(state);
                    arrayDeque.push(new State(entry3.getValue(), 0));
                    break;
                }
                case 14: {
                    Expr expr;
                    Constructors.UnionType unionType = (Constructors.UnionType)state.expr;
                    if (state.state == 0) {
                        visitor.prepareUnionType(unionType.fields.length);
                        if (unionType.fields.length == 0) {
                            linkedList.push(visitor.onUnionType(new ArrayList()));
                            break;
                        }
                        state = new State(state.expr, 1, unionType.fields, visitor.sortFields());
                        arrayDeque.push(state);
                        Map.Entry<String, Expr> fieldAccess = state.sortedFields[state.state - 1];
                        visitor.prepareUnionTypeField(fieldAccess.getKey(), fieldAccess.getValue(), state.state - 1);
                        expr = fieldAccess.getValue();
                        if (expr == null) {
                            linkedList.push(null);
                            break;
                        }
                        arrayDeque.push(new State(expr, 0));
                        break;
                    }
                    if (state.state == unionType.fields.length) {
                        ArrayList arrayList = new ArrayList();
                        for (int i = state.sortedFields.length - 1; i >= 0; --i) {
                            arrayList.add(new AbstractMap.SimpleImmutableEntry(state.sortedFields[i].getKey(), linkedList.poll()));
                        }
                        Collections.reverse(arrayList);
                        linkedList.push(visitor.onUnionType(arrayList));
                        break;
                    }
                    ++state.state;
                    Map.Entry<String, Expr> entry = state.sortedFields[state.state - 1];
                    expr = entry.getValue();
                    visitor.prepareUnionTypeField(entry.getKey(), expr, state.state - 1);
                    arrayDeque.push(state);
                    if (expr == null) {
                        linkedList.push(null);
                        break;
                    }
                    arrayDeque.push(new State(expr, 0));
                    break;
                }
                case 15: {
                    Constructors.FieldAccess fieldAccess = (Constructors.FieldAccess)state.expr;
                    if (state.state == 0) {
                        if (visitor.prepareFieldAccess(fieldAccess.base, fieldAccess.fieldName)) {
                            state.state = 1;
                            arrayDeque.push(state);
                            arrayDeque.push(new State(fieldAccess.base, 0));
                            break;
                        }
                        linkedList.push(visitor.onFieldAccess(null, fieldAccess.fieldName));
                        break;
                    }
                    linkedList.push(visitor.onFieldAccess(linkedList.poll(), fieldAccess.fieldName));
                    break;
                }
                case 16: {
                    Expr expr = (Constructors.Projection)state.expr;
                    if (state.state == 0) {
                        visitor.prepareProjection(expr.fieldNames.length);
                        state.state = 1;
                        arrayDeque.push(state);
                        arrayDeque.push(new State(expr.base, 0));
                        break;
                    }
                    linkedList.push(visitor.onProjection(linkedList.poll(), expr.fieldNames));
                    break;
                }
                case 17: {
                    Constructors.ProjectionByType projectionByType = (Constructors.ProjectionByType)state.expr;
                    if (state.state == 0) {
                        visitor.prepareProjectionByType();
                        state.state = 1;
                        arrayDeque.push(state);
                        arrayDeque.push(new State(projectionByType.base, 0));
                        break;
                    }
                    if (state.state == 1) {
                        visitor.prepareProjectionByType(projectionByType.type);
                        state.state = 2;
                        arrayDeque.push(state);
                        arrayDeque.push(new State(projectionByType.type, 0));
                        break;
                    }
                    Object e3 = linkedList.poll();
                    Object e2 = linkedList.poll();
                    linkedList.push(visitor.onProjectionByType(e2, e3));
                    break;
                }
                case 18: {
                    int n;
                    Object object;
                    Object object2;
                    Constructors.Application application = (Constructors.Application)state.expr;
                    if (state.state == 0) {
                        object2 = new LinkedList();
                        ((LinkedList)object2).push(application.arg);
                        object = Expr.gatherApplicationArgs(application.base, (Deque<Expr>)object2);
                        state.state = 1;
                        state.size = ((LinkedList)object2).size();
                        n = visitor.prepareApplication((Expr)object, ((LinkedList)object2).size()) ? 1 : 0;
                        state.skippedRecursion = n == 0;
                        arrayDeque.push(state);
                        if (n != 0) {
                            arrayDeque.push(new State((Expr)object, 0));
                        }
                        arrayDeque2.push(object2);
                        break;
                    }
                    object2 = (LinkedList)arrayDeque2.poll();
                    if (((AbstractCollection)object2).isEmpty()) {
                        object = new ArrayList(state.size);
                        for (n = 0; n < state.size; ++n) {
                            object.add(linkedList.poll());
                        }
                        Collections.reverse(object);
                        Object a = null;
                        if (!state.skippedRecursion) {
                            a = linkedList.poll();
                        }
                        linkedList.push(visitor.onApplication(a, object));
                        break;
                    }
                    arrayDeque.push(state);
                    arrayDeque.push(new State((Expr)((LinkedList)object2).poll(), 0));
                    arrayDeque2.push(object2);
                    break;
                }
                case 19: {
                    Object object2 = (Constructors.OperatorApplication)state.expr;
                    if (state.state == 0) {
                        visitor.prepareOperatorApplication(((Constructors.OperatorApplication)object2).operator);
                        state.state = 1;
                        arrayDeque.push(state);
                        arrayDeque.push(new State(((Constructors.OperatorApplication)object2).lhs, 0));
                        break;
                    }
                    if (state.state == 1) {
                        state.state = 2;
                        arrayDeque.push(state);
                        arrayDeque.push(new State(((Constructors.OperatorApplication)object2).rhs, 0));
                        break;
                    }
                    Object e3 = linkedList.poll();
                    Object e2 = linkedList.poll();
                    linkedList.push(visitor.onOperatorApplication(((Constructors.OperatorApplication)object2).operator, e2, e3));
                    break;
                }
                case 20: {
                    Object object = (Constructors.If)state.expr;
                    if (state.state == 0) {
                        visitor.prepareIf();
                        state.state = 1;
                        arrayDeque.push(state);
                        arrayDeque.push(new State(((Constructors.If)object).predicate, 0));
                        break;
                    }
                    if (state.state == 1) {
                        state.state = 2;
                        arrayDeque.push(state);
                        arrayDeque.push(new State(((Constructors.If)object).thenValue, 0));
                        break;
                    }
                    if (state.state == 2) {
                        state.state = 3;
                        arrayDeque.push(state);
                        arrayDeque.push(new State(((Constructors.If)object).elseValue, 0));
                        break;
                    }
                    Object e = linkedList.poll();
                    Object e3 = linkedList.poll();
                    Object e2 = linkedList.poll();
                    linkedList.push(visitor.onIf(e2, e3, e));
                    break;
                }
                case 21: {
                    Constructors.Annotated annotated = (Constructors.Annotated)state.expr;
                    if (state.state == 0) {
                        visitor.prepareAnnotated(annotated.type);
                        state.state = 1;
                        arrayDeque.push(state);
                        arrayDeque.push(new State(annotated.base, 0));
                        break;
                    }
                    if (state.state == 1) {
                        state.state = 2;
                        arrayDeque.push(state);
                        arrayDeque.push(new State(annotated.type, 0));
                        break;
                    }
                    Object e3 = linkedList.poll();
                    Object e2 = linkedList.poll();
                    linkedList.push(visitor.onAnnotated(e2, e3));
                    break;
                }
                case 22: {
                    Constructors.Assert assert_ = (Constructors.Assert)state.expr;
                    if (state.state == 0) {
                        visitor.prepareAssert();
                        state.state = 1;
                        arrayDeque.push(state);
                        arrayDeque.push(new State(assert_.base, 0));
                        break;
                    }
                    linkedList.push(visitor.onAssert(linkedList.poll()));
                    break;
                }
                case 23: {
                    Object e;
                    Object e3;
                    Object e2;
                    Constructors.Merge merge = (Constructors.Merge)state.expr;
                    switch (state.state) {
                        case 0: {
                            visitor.prepareMerge(merge.type);
                            state.state = 1;
                            arrayDeque.push(state);
                            arrayDeque.push(new State(merge.handlers, 0));
                            break;
                        }
                        case 1: {
                            state.state = 2;
                            arrayDeque.push(state);
                            arrayDeque.push(new State(merge.union, 0));
                            break;
                        }
                        case 2: {
                            state.state = 3;
                            if (merge.type != null) {
                                arrayDeque.push(state);
                                arrayDeque.push(new State(merge.type, 0));
                                break;
                            }
                            linkedList.push(null);
                        }
                        case 3: {
                            e = linkedList.poll();
                            e3 = linkedList.poll();
                            e2 = linkedList.poll();
                            linkedList.push(visitor.onMerge(e2, e3, e));
                        }
                    }
                    break;
                }
                case 24: {
                    Object e3;
                    Object e2;
                    Constructors.ToMap toMap = (Constructors.ToMap)state.expr;
                    switch (state.state) {
                        case 0: {
                            visitor.prepareToMap(toMap.type);
                            state.state = 1;
                            arrayDeque.push(state);
                            arrayDeque.push(new State(toMap.base, 0));
                            break;
                        }
                        case 1: {
                            state.state = 2;
                            if (toMap.type != null) {
                                arrayDeque.push(state);
                                arrayDeque.push(new State(toMap.type, 0));
                                break;
                            }
                            linkedList.push(null);
                        }
                        case 2: {
                            e3 = linkedList.poll();
                            e2 = linkedList.poll();
                            linkedList.push(visitor.onToMap(e2, e3));
                        }
                    }
                    break;
                }
                case 30: {
                    Object e3;
                    Object e2;
                    Constructors.With with = (Constructors.With)state.expr;
                    switch (state.state) {
                        case 0: {
                            visitor.prepareWith(with.path);
                            state.state = 1;
                            arrayDeque.push(state);
                            arrayDeque.push(new State(with.base, 0));
                            break;
                        }
                        case 1: {
                            visitor.prepareWithValue(with.path);
                            state.state = 2;
                            arrayDeque.push(state);
                            arrayDeque.push(new State(with.value, 0));
                            break;
                        }
                        case 2: {
                            e3 = linkedList.poll();
                            e2 = linkedList.poll();
                            linkedList.push(visitor.onWith(e2, with.path, e3));
                        }
                    }
                    break;
                }
                case 25: {
                    Constructors.MissingImport missingImport = (Constructors.MissingImport)state.expr;
                    linkedList.push(visitor.onMissingImport(missingImport.mode, missingImport.hash));
                    break;
                }
                case 26: {
                    Constructors.EnvImport envImport = (Constructors.EnvImport)state.expr;
                    linkedList.push(visitor.onEnvImport(envImport.name, envImport.mode, envImport.hash));
                    break;
                }
                case 27: {
                    Constructors.LocalImport localImport = (Constructors.LocalImport)state.expr;
                    linkedList.push(visitor.onLocalImport(localImport.path, localImport.mode, localImport.hash));
                    break;
                }
                case 28: {
                    Constructors.RemoteImport remoteImport = (Constructors.RemoteImport)state.expr;
                    switch (state.state) {
                        case 0: {
                            visitor.prepareRemoteImport(remoteImport.url, remoteImport.using, remoteImport.mode, remoteImport.hash);
                            state.state = 1;
                            if (remoteImport.using != null) {
                                arrayDeque.push(state);
                                arrayDeque.push(new State(remoteImport.using, 0));
                                break;
                            }
                            linkedList.push(null);
                        }
                        case 1: {
                            linkedList.push(visitor.onRemoteImport(remoteImport.url, linkedList.poll(), remoteImport.mode, remoteImport.hash));
                        }
                    }
                    break;
                }
                case 29: {
                    Constructors.ClasspathImport classpathImport = (Constructors.ClasspathImport)state.expr;
                    linkedList.push(visitor.onClasspathImport(classpathImport.path, classpathImport.mode, classpathImport.hash));
                }
            }
            state = (State)arrayDeque.poll();
        }
        return (A)linkedList.poll();
    }

    private static final Expr gatherApplicationArgs(Expr expr, Deque<Expr> deque) {
        Expr expr2 = expr.getNonNote();
        while (expr2.tag == 18) {
            Constructors.Application application = (Constructors.Application)expr2;
            if (deque != null) {
                deque.push(application.arg);
            }
            expr2 = application.base.getNonNote();
        }
        return expr2;
    }

    private static final Expr gatherLetBindings(Expr expr, List<LetBinding<Expr>> list) {
        Expr expr2 = expr.getNonNote();
        while (expr2.tag == 8) {
            Constructors.Let let = (Constructors.Let)expr2;
            if (list != null) {
                list.add(new LetBinding<Expr>(let.name, let.type, let.value));
            }
            expr2 = let.body.getNonNote();
        }
        return expr2;
    }

    private final Map.Entry<Expr, Expr> getFirstDiff(Expr expr) {
        ArrayDeque<Object> arrayDeque = new ArrayDeque<Object>();
        ArrayDeque<Object> arrayDeque2 = new ArrayDeque<Object>();
        Expr expr2 = this;
        Expr expr3 = expr;
        arrayDeque.add(expr2);
        arrayDeque2.add(expr3);
        block0: while (true) {
            int n;
            Object[] objectArray;
            Expr expr4;
            Expr expr5;
            expr2 = (Expr)arrayDeque.poll();
            expr3 = (Expr)arrayDeque2.poll();
            if (expr2 == null || expr3 == null) break;
            expr2 = expr2.getNonNote();
            expr3 = expr3.getNonNote();
            if (expr2.tag != expr3.tag) break;
            if (expr2.tag == 1) {
                if (!((Constructors.NaturalLiteral)expr2).value.equals(((Constructors.NaturalLiteral)expr3).value)) break;
                continue;
            }
            if (expr2.tag == 2) {
                if (!((Constructors.IntegerLiteral)expr2).value.equals(((Constructors.IntegerLiteral)expr3).value)) break;
                continue;
            }
            if (expr2.tag == 3) {
                if (!Arrays.equals(expr2.getEncodedBytes(), expr3.getEncodedBytes())) break;
                continue;
            }
            if (expr2.tag == 4) {
                expr5 = (Constructors.BuiltIn)expr2;
                expr4 = (Constructors.BuiltIn)expr3;
                if (!expr5.name.equals(expr4.name)) break;
                continue;
            }
            if (expr2.tag == 5) {
                expr5 = (Constructors.Identifier)expr2;
                expr4 = (Constructors.Identifier)expr3;
                if (!((Constructors.Identifier)expr5).name.equals(((Constructors.Identifier)expr4).name) || ((Constructors.Identifier)expr5).index != ((Constructors.Identifier)expr4).index) break;
                continue;
            }
            if (expr2.tag == 6) {
                expr5 = (Constructors.Lambda)expr2;
                expr4 = (Constructors.Lambda)expr3;
                if (!((Constructors.Lambda)expr5).name.equals(((Constructors.Lambda)expr4).name)) break;
                arrayDeque.add(((Constructors.Lambda)expr5).type);
                arrayDeque2.add(((Constructors.Lambda)expr4).type);
                arrayDeque.add(((Constructors.Lambda)expr5).result);
                arrayDeque2.add(((Constructors.Lambda)expr4).result);
                continue;
            }
            if (expr2.tag == 7) {
                expr5 = (Constructors.Pi)expr2;
                expr4 = (Constructors.Pi)expr3;
                if (!((Constructors.Pi)expr5).name.equals(((Constructors.Pi)expr4).name) || ((Constructors.Pi)expr5).type == null ^ ((Constructors.Pi)expr4).type == null) break;
                if (((Constructors.Pi)expr5).type != null) {
                    arrayDeque.add(((Constructors.Pi)expr5).type);
                    arrayDeque2.add(((Constructors.Pi)expr4).type);
                }
                arrayDeque.add(((Constructors.Pi)expr5).result);
                arrayDeque2.add(((Constructors.Pi)expr4).result);
                continue;
            }
            if (expr2.tag == 8) {
                expr5 = (Constructors.Let)expr2;
                expr4 = (Constructors.Let)expr3;
                if (!((Constructors.Let)expr5).name.equals(((Constructors.Let)expr4).name) || ((Constructors.Let)expr5).type == null ^ ((Constructors.Let)expr4).type == null) break;
                if (((Constructors.Let)expr5).type != null) {
                    arrayDeque.add(((Constructors.Let)expr5).type);
                    arrayDeque2.add(((Constructors.Let)expr4).type);
                }
                arrayDeque.add(((Constructors.Let)expr5).value);
                arrayDeque2.add(((Constructors.Let)expr4).value);
                arrayDeque.add(((Constructors.Let)expr5).body);
                arrayDeque2.add(((Constructors.Let)expr4).body);
                continue;
            }
            if (expr2.tag == 9) {
                expr5 = (Constructors.TextLiteral)expr2;
                expr4 = (Constructors.TextLiteral)expr3;
                if (!Arrays.equals(((Constructors.TextLiteral)expr5).interpolated, ((Constructors.TextLiteral)expr4).interpolated)) break;
                for (Expr expr6 : ((Constructors.TextLiteral)expr5).interpolated) {
                    arrayDeque.add(expr6);
                }
                objectArray = ((Constructors.TextLiteral)expr4).interpolated;
                int n2 = objectArray.length;
                n = 0;
                while (true) {
                    if (n >= n2) continue block0;
                    Object object = objectArray[n];
                    arrayDeque2.add(object);
                    ++n;
                }
            }
            if (expr2.tag == 10) {
                expr5 = (Constructors.NonEmptyListLiteral)expr2;
                expr4 = (Constructors.NonEmptyListLiteral)expr3;
                for (Expr expr7 : ((Constructors.NonEmptyListLiteral)expr5).values) {
                    arrayDeque.add(expr7);
                }
                objectArray = ((Constructors.NonEmptyListLiteral)expr4).values;
                int n3 = objectArray.length;
                n = 0;
                while (true) {
                    if (n >= n3) continue block0;
                    Object object = objectArray[n];
                    arrayDeque2.add(object);
                    ++n;
                }
            }
            if (expr2.tag == 11) {
                expr5 = (Constructors.EmptyListLiteral)expr2;
                expr4 = (Constructors.EmptyListLiteral)expr3;
                arrayDeque.add(((Constructors.EmptyListLiteral)expr5).type);
                arrayDeque2.add(((Constructors.EmptyListLiteral)expr4).type);
                continue;
            }
            if (expr2.tag == 12) {
                expr5 = (Constructors.RecordLiteral)expr2;
                expr4 = (Constructors.RecordLiteral)expr3;
                objectArray = ((Constructors.RecordLiteral)expr5).fields;
                Map.Entry<String, Expr>[] entryArray = ((Constructors.RecordLiteral)expr4).fields;
                if (objectArray.length != entryArray.length) break;
                n = 0;
                while (true) {
                    if (n >= objectArray.length) continue block0;
                    if (!((String)objectArray[n].getKey()).equals(entryArray[n].getKey())) {
                        return new AbstractMap.SimpleImmutableEntry<Expr, Expr>((Expr)objectArray[n].getValue(), entryArray[n].getValue());
                    }
                    arrayDeque.add(objectArray[n].getValue());
                    arrayDeque2.add(entryArray[n].getValue());
                    ++n;
                }
            }
            if (expr2.tag == 13) {
                expr5 = (Constructors.RecordType)expr2;
                expr4 = (Constructors.RecordType)expr3;
                objectArray = ((Constructors.RecordType)expr5).fields;
                Map.Entry<String, Expr>[] entryArray = ((Constructors.RecordType)expr4).fields;
                if (objectArray.length != entryArray.length) break;
                n = 0;
                while (true) {
                    if (n >= objectArray.length) continue block0;
                    if (!((String)objectArray[n].getKey()).equals(entryArray[n].getKey())) {
                        return new AbstractMap.SimpleImmutableEntry<Expr, Expr>((Expr)objectArray[n].getValue(), entryArray[n].getValue());
                    }
                    arrayDeque.add(objectArray[n].getValue());
                    arrayDeque2.add(entryArray[n].getValue());
                    ++n;
                }
            }
            if (expr2.tag == 14) {
                expr5 = (Constructors.UnionType)expr2;
                expr4 = (Constructors.UnionType)expr3;
                objectArray = ((Constructors.UnionType)expr5).fields;
                Map.Entry<String, Expr>[] entryArray = ((Constructors.UnionType)expr4).fields;
                if (objectArray.length != entryArray.length) break;
                n = 0;
                while (true) {
                    if (n >= objectArray.length) continue block0;
                    if (!((String)objectArray[n].getKey()).equals(entryArray[n].getKey())) {
                        return new AbstractMap.SimpleImmutableEntry<Expr, Expr>((Expr)objectArray[n].getValue(), entryArray[n].getValue());
                    }
                    if (objectArray[n].getValue() != null && entryArray[n].getValue() != null) {
                        arrayDeque.add(objectArray[n].getValue());
                        arrayDeque2.add(entryArray[n].getValue());
                    } else if (objectArray[n].getValue() == null ^ entryArray[n].getValue() == null) {
                        return new AbstractMap.SimpleImmutableEntry<Expr, Expr>(expr2, expr3);
                    }
                    ++n;
                }
            }
            if (expr2.tag == 15) {
                expr5 = (Constructors.FieldAccess)expr2;
                expr4 = (Constructors.FieldAccess)expr3;
                if (!((Constructors.FieldAccess)expr5).fieldName.equals(((Constructors.FieldAccess)expr4).fieldName)) break;
                arrayDeque.add(((Constructors.FieldAccess)expr5).base);
                arrayDeque2.add(((Constructors.FieldAccess)expr4).base);
                continue;
            }
            if (expr2.tag == 16) {
                expr5 = (Constructors.Projection)expr2;
                expr4 = (Constructors.Projection)expr3;
                if (!Arrays.equals(((Constructors.Projection)expr5).fieldNames, ((Constructors.Projection)expr4).fieldNames)) break;
                arrayDeque.add(((Constructors.Projection)expr5).base);
                arrayDeque2.add(((Constructors.Projection)expr4).base);
                continue;
            }
            if (expr2.tag == 17) {
                expr5 = (Constructors.ProjectionByType)expr2;
                expr4 = (Constructors.ProjectionByType)expr3;
                arrayDeque.add(((Constructors.ProjectionByType)expr5).base);
                arrayDeque2.add(((Constructors.ProjectionByType)expr4).base);
                arrayDeque.add(((Constructors.ProjectionByType)expr5).type);
                arrayDeque2.add(((Constructors.ProjectionByType)expr4).type);
                continue;
            }
            if (expr2.tag == 18) {
                expr5 = (Constructors.Application)expr2;
                expr4 = (Constructors.Application)expr3;
                arrayDeque.add(((Constructors.Application)expr5).base);
                arrayDeque2.add(((Constructors.Application)expr4).base);
                arrayDeque.add(((Constructors.Application)expr5).arg);
                arrayDeque2.add(((Constructors.Application)expr4).arg);
                continue;
            }
            if (expr2.tag == 19) {
                expr5 = (Constructors.OperatorApplication)expr2;
                expr4 = (Constructors.OperatorApplication)expr3;
                if (!((Constructors.OperatorApplication)expr5).operator.equals((Object)((Constructors.OperatorApplication)expr4).operator)) break;
                arrayDeque.add(((Constructors.OperatorApplication)expr5).lhs);
                arrayDeque2.add(((Constructors.OperatorApplication)expr4).lhs);
                arrayDeque.add(((Constructors.OperatorApplication)expr5).rhs);
                arrayDeque2.add(((Constructors.OperatorApplication)expr4).rhs);
                continue;
            }
            if (expr2.tag == 20) {
                expr5 = (Constructors.If)expr2;
                expr4 = (Constructors.If)expr3;
                arrayDeque.add(((Constructors.If)expr5).predicate);
                arrayDeque2.add(((Constructors.If)expr4).predicate);
                arrayDeque.add(((Constructors.If)expr5).thenValue);
                arrayDeque2.add(((Constructors.If)expr4).thenValue);
                arrayDeque.add(((Constructors.If)expr5).elseValue);
                arrayDeque2.add(((Constructors.If)expr4).elseValue);
                continue;
            }
            if (expr2.tag == 21) {
                expr5 = (Constructors.Annotated)expr2;
                expr4 = (Constructors.Annotated)expr3;
                arrayDeque.add(((Constructors.Annotated)expr5).base);
                arrayDeque2.add(((Constructors.Annotated)expr4).base);
                arrayDeque.add(((Constructors.Annotated)expr5).type);
                arrayDeque2.add(((Constructors.Annotated)expr4).type);
                continue;
            }
            if (expr2.tag == 22) {
                expr5 = (Constructors.Assert)expr2;
                expr4 = (Constructors.Assert)expr3;
                arrayDeque.add(((Constructors.Assert)expr5).base);
                arrayDeque2.add(((Constructors.Assert)expr4).base);
                continue;
            }
            if (expr2.tag == 23) {
                expr5 = (Constructors.Merge)expr2;
                expr4 = (Constructors.Merge)expr3;
                if (((Constructors.Merge)expr5).type == null ^ ((Constructors.Merge)expr4).type == null) break;
                arrayDeque.add(((Constructors.Merge)expr5).handlers);
                arrayDeque2.add(((Constructors.Merge)expr4).handlers);
                arrayDeque.add(((Constructors.Merge)expr5).union);
                arrayDeque2.add(((Constructors.Merge)expr4).union);
                if (((Constructors.Merge)expr5).type == null) continue;
                arrayDeque.add(((Constructors.Merge)expr5).type);
                arrayDeque2.add(((Constructors.Merge)expr4).type);
                continue;
            }
            if (expr2.tag == 24) {
                expr5 = (Constructors.ToMap)expr2;
                expr4 = (Constructors.ToMap)expr3;
                if (((Constructors.ToMap)expr5).type == null ^ ((Constructors.ToMap)expr4).type == null) break;
                arrayDeque.add(((Constructors.ToMap)expr5).base);
                arrayDeque2.add(((Constructors.ToMap)expr4).base);
                if (((Constructors.ToMap)expr5).type == null) continue;
                arrayDeque.add(((Constructors.ToMap)expr5).type);
                arrayDeque2.add(((Constructors.ToMap)expr4).type);
                continue;
            }
            if (expr2.tag == 25) {
                expr5 = (Constructors.MissingImport)expr2;
                expr4 = (Constructors.MissingImport)expr3;
                if (!((Constructors.MissingImport)expr5).mode.equals((Object)((Constructors.MissingImport)expr4).mode) || !Arrays.equals(((Constructors.MissingImport)expr5).hash, ((Constructors.MissingImport)expr4).hash)) break;
                continue;
            }
            if (expr2.tag == 26) {
                expr5 = (Constructors.EnvImport)expr2;
                expr4 = (Constructors.EnvImport)expr3;
                if (!((Constructors.EnvImport)expr5).name.equals(((Constructors.EnvImport)expr4).name) || !((Constructors.EnvImport)expr5).mode.equals((Object)((Constructors.EnvImport)expr4).mode) || !Arrays.equals(((Constructors.EnvImport)expr5).hash, ((Constructors.EnvImport)expr4).hash)) break;
                continue;
            }
            if (expr2.tag == 27) {
                expr5 = (Constructors.LocalImport)expr2;
                expr4 = (Constructors.LocalImport)expr3;
                if (!((Constructors.LocalImport)expr5).path.equals(((Constructors.LocalImport)expr4).path) || !((Constructors.LocalImport)expr5).mode.equals((Object)((Constructors.LocalImport)expr4).mode) || !Arrays.equals(((Constructors.LocalImport)expr5).hash, ((Constructors.LocalImport)expr4).hash)) break;
                continue;
            }
            if (expr2.tag == 29) {
                expr5 = (Constructors.ClasspathImport)expr2;
                expr4 = (Constructors.ClasspathImport)expr3;
                if (!((Constructors.ClasspathImport)expr5).path.equals(((Constructors.ClasspathImport)expr4).path) || !((Constructors.ClasspathImport)expr5).mode.equals((Object)((Constructors.ClasspathImport)expr4).mode) || !Arrays.equals(((Constructors.ClasspathImport)expr5).hash, ((Constructors.ClasspathImport)expr4).hash)) break;
                continue;
            }
            if (expr2.tag != 28) continue;
            expr5 = (Constructors.RemoteImport)expr2;
            expr4 = (Constructors.RemoteImport)expr3;
            if (!(((Constructors.RemoteImport)expr5).url.equals(((Constructors.RemoteImport)expr4).url) && ((Constructors.RemoteImport)expr5).mode.equals((Object)((Constructors.RemoteImport)expr4).mode) && Arrays.equals(((Constructors.RemoteImport)expr5).hash, ((Constructors.RemoteImport)expr4).hash))) break;
        }
        if (expr2 == null && expr3 == null) {
            return null;
        }
        return new AbstractMap.SimpleImmutableEntry<Expr, Expr>(expr2, expr3);
    }

    private static final Map.Entry<Expr, Expr> flattenToMapRecord(List<Map.Entry<String, Expr>> list) {
        if (list == null || list.size() != 2) {
            return null;
        }
        Expr expr = null;
        Expr expr2 = null;
        for (Map.Entry<String, Expr> entry : list) {
            if (entry.getKey().equals("mapKey")) {
                expr = entry.getValue();
                continue;
            }
            if (!entry.getKey().equals("mapValue")) continue;
            expr2 = entry.getValue();
        }
        if (expr == null || expr2 == null) {
            return null;
        }
        return new AbstractMap.SimpleImmutableEntry<Object, Object>(expr, expr2);
    }

    private static final Expr flattenToMapList(Expr[] exprArray) {
        LinkedHashMap<String, Expr> linkedHashMap = new LinkedHashMap<String, Expr>(exprArray.length);
        for (Expr expr : exprArray) {
            List<Map.Entry<String, Expr>> list = Util.asRecordLiteral(expr);
            if (list == null) {
                return null;
            }
            Map.Entry<Expr, Expr> entry = Expr.flattenToMapRecord(list);
            if (entry == null) {
                return null;
            }
            String string = Util.asSimpleTextLiteral(entry.getKey());
            if (string == null) {
                return null;
            }
            linkedHashMap.put(string, entry.getValue());
        }
        Set set = linkedHashMap.entrySet();
        return Expr.makeRecordLiteral(set.toArray(new Map.Entry[set.size()]));
    }

    private static final boolean isToMapListType(Expr expr) {
        Expr expr2 = Util.getListArg(expr);
        if (expr2 == null) {
            return false;
        }
        List<Map.Entry<String, Expr>> list = Util.asRecordType(expr2);
        if (list == null) {
            return false;
        }
        Map.Entry<Expr, Expr> entry = Expr.flattenToMapRecord(list);
        if (entry == null) {
            return false;
        }
        String string = Util.asBuiltIn(entry.getKey());
        return string != null && string.equals("Text");
    }

    private static final class State {
        final Expr expr;
        int state;
        int size;
        Map.Entry<String, Expr>[] sortedFields;
        boolean skippedRecursion = false;

        State(Expr expr, int n, int n2) {
            this.expr = expr;
            this.state = n;
            this.size = n2;
            this.sortedFields = null;
        }

        State(Expr expr, int n, Map.Entry<String, Expr>[] entryArray, boolean bl) {
            this.expr = expr;
            this.state = n;
            this.size = 0;
            if (bl) {
                this.sortedFields = new Map.Entry[entryArray.length];
                System.arraycopy(entryArray, 0, this.sortedFields, 0, entryArray.length);
                Arrays.sort(this.sortedFields, entryComparator);
            } else {
                this.sortedFields = entryArray;
            }
        }

        State(Expr expr, int n) {
            this(expr, n, 0);
        }
    }

    public static final class Parsed
    extends Expr {
        final Expr base;
        final Source source;

        public Parsed(Expr expr, Source source) {
            super(0);
            this.base = expr;
            this.source = source;
        }

        public final Source getSource() {
            return this.source;
        }

        @Override
        public final <A> A accept(ExternalVisitor<A> externalVisitor) {
            return externalVisitor.onNote(this.base, this.source);
        }
    }

    public static final class Constants {
        private static final Map.Entry[] emptyFields = new Map.Entry[0];
        public static final Expr UNDERSCORE = Expr.makeIdentifier("_");
        public static final Expr SORT = new Constructors.BuiltIn("Sort");
        public static final Expr KIND = new Constructors.BuiltIn("Kind");
        public static final Expr TYPE = new Constructors.BuiltIn("Type");
        public static final Expr BOOL = new Constructors.BuiltIn("Bool");
        public static final Expr TRUE = new Constructors.BuiltIn("True");
        public static final Expr FALSE = new Constructors.BuiltIn("False");
        public static final Expr LIST = new Constructors.BuiltIn("List");
        public static final Expr OPTIONAL = new Constructors.BuiltIn("Optional");
        public static final Expr DOUBLE = new Constructors.BuiltIn("Double");
        public static final Expr NATURAL = new Constructors.BuiltIn("Natural");
        public static final Expr INTEGER = new Constructors.BuiltIn("Integer");
        public static final Expr TEXT = new Constructors.BuiltIn("Text");
        public static final Expr NONE = new Constructors.BuiltIn("None");
        public static final Expr SOME = new Constructors.BuiltIn("Some");
        public static final Expr NATURAL_FOLD = new Constructors.BuiltIn("Natural/fold");
        public static final Expr LIST_FOLD = new Constructors.BuiltIn("List/fold");
        public static final Expr ZERO = Expr.makeNaturalLiteral(BigInteger.ZERO);
        public static final Expr EMPTY_RECORD_LITERAL = Expr.makeRecordLiteral(emptyFields);
        public static final Expr EMPTY_RECORD_TYPE = Expr.makeRecordType(emptyFields);
        public static final Expr EMPTY_UNION_TYPE = Expr.makeUnionType(emptyFields);
        public static final Expr LOCATION_TYPE = Expr.makeUnionType(new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<String, Expr>("Local", TEXT), new AbstractMap.SimpleImmutableEntry<String, Expr>("Remote", TEXT), new AbstractMap.SimpleImmutableEntry<String, Expr>("Environment", TEXT), new AbstractMap.SimpleImmutableEntry<String, Object>("Missing", null)});
        public static final String MAP_KEY_FIELD_NAME = "mapKey";
        public static final String MAP_VALUE_FIELD_NAME = "mapValue";
        private static final Map<String, Expr> builtIns = new HashMap<String, Expr>(34);
        private static final Set<String> keywords = new HashSet<String>(16);

        static Expr getBuiltIn(String string) {
            return builtIns.get(string);
        }

        public static boolean isBuiltIn(String string) {
            return builtIns.containsKey(string);
        }

        public static boolean isKeyword(String string) {
            return keywords.contains(string);
        }

        static {
            builtIns.put("Bool", BOOL);
            builtIns.put("Double", DOUBLE);
            builtIns.put("Double/show", new Constructors.BuiltIn("Double/show"));
            builtIns.put("False", FALSE);
            builtIns.put("Integer", INTEGER);
            builtIns.put("Integer/clamp", new Constructors.BuiltIn("Integer/clamp"));
            builtIns.put("Integer/negate", new Constructors.BuiltIn("Integer/negate"));
            builtIns.put("Integer/show", new Constructors.BuiltIn("Integer/show"));
            builtIns.put("Integer/toDouble", new Constructors.BuiltIn("Integer/toDouble"));
            builtIns.put("Kind", KIND);
            builtIns.put("List", LIST);
            builtIns.put("List/build", new Constructors.BuiltIn("List/build"));
            builtIns.put("List/fold", new Constructors.BuiltIn("List/fold"));
            builtIns.put("List/head", new Constructors.BuiltIn("List/head"));
            builtIns.put("List/indexed", new Constructors.BuiltIn("List/indexed"));
            builtIns.put("List/last", new Constructors.BuiltIn("List/last"));
            builtIns.put("List/length", new Constructors.BuiltIn("List/length"));
            builtIns.put("List/reverse", new Constructors.BuiltIn("List/reverse"));
            builtIns.put("Natural", NATURAL);
            builtIns.put("Natural/build", new Constructors.BuiltIn("Natural/build"));
            builtIns.put("Natural/even", new Constructors.BuiltIn("Natural/even"));
            builtIns.put("Natural/fold", new Constructors.BuiltIn("Natural/fold"));
            builtIns.put("Natural/isZero", new Constructors.BuiltIn("Natural/isZero"));
            builtIns.put("Natural/odd", new Constructors.BuiltIn("Natural/odd"));
            builtIns.put("Natural/show", new Constructors.BuiltIn("Natural/show"));
            builtIns.put("Natural/subtract", new Constructors.BuiltIn("Natural/subtract"));
            builtIns.put("Natural/toInteger", new Constructors.BuiltIn("Natural/toInteger"));
            builtIns.put("None", NONE);
            builtIns.put("Optional", OPTIONAL);
            builtIns.put("Some", SOME);
            builtIns.put("Sort", SORT);
            builtIns.put("Text", TEXT);
            builtIns.put("Text/replace", new Constructors.BuiltIn("Text/replace"));
            builtIns.put("Text/show", new Constructors.BuiltIn("Text/show"));
            builtIns.put("True", TRUE);
            builtIns.put("Type", TYPE);
            keywords.add("if");
            keywords.add("then");
            keywords.add("else");
            keywords.add("let");
            keywords.add("in");
            keywords.add("using");
            keywords.add("missing");
            keywords.add("assert");
            keywords.add("as");
            keywords.add("Infinity");
            keywords.add("NaN");
            keywords.add("merge");
            keywords.add("Some");
            keywords.add("toMap");
            keywords.add("forall");
            keywords.add("with");
        }
    }

    public static enum ImportMode {
        CODE,
        RAW_TEXT,
        LOCATION;


        public String toString() {
            if (this == RAW_TEXT) {
                return "Text";
            }
            if (this == LOCATION) {
                return "Location";
            }
            return "Code";
        }
    }

    public static final class LetBinding<A> {
        private final String name;
        private final A type;
        private final A value;

        public LetBinding(String string, A a, A a2) {
            this.name = string;
            this.type = a;
            this.value = a2;
        }

        public String getName() {
            return this.name;
        }

        public boolean hasType() {
            return this.type != null;
        }

        public A getType() {
            return this.type;
        }

        public A getValue() {
            return this.value;
        }
    }

    public static final class Util {
        private Util() {
        }

        public static final Expr typeCheck(Expr expr) {
            return expr.accept(new TypeCheck());
        }

        public static final Map.Entry<Expr, Expr> getFirstDiff(Expr expr, Expr expr2) {
            return expr.getFirstDiff(expr2);
        }

        public static final void encodeToStream(Expr expr, OutputStream outputStream) {
            Writer.OutputStreamWriter outputStreamWriter = new Writer.OutputStreamWriter(outputStream);
            expr.accept(new Encode(outputStreamWriter));
        }

        public static String encodeHashBytes(byte[] byArray) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < byArray.length; ++i) {
                String string = Integer.toHexString(0xFF & byArray[i]);
                if (string.length() == 1) {
                    stringBuilder.append('0');
                }
                stringBuilder.append(string);
            }
            return stringBuilder.toString();
        }

        public static final byte[] decodeHashBytes(String string) {
            byte[] byArray = new byte[string.length() / 2];
            for (int i = 0; i < string.length(); i += 2) {
                int n = Character.digit(string.charAt(i), 16);
                int n2 = Character.digit(string.charAt(i + 1), 16);
                byArray[i / 2] = (byte)((n << 4) + n2);
            }
            return byArray;
        }

        public static Expr getListArg(Expr expr) {
            return Util.getElementType(expr, "List");
        }

        public static Expr getOptionalArg(Expr expr) {
            return Util.getElementType(expr, "Optional");
        }

        public static Expr getSomeArg(Expr expr) {
            return Util.getElementType(expr, "Some");
        }

        public static Expr getNoneArg(Expr expr) {
            return Util.getElementType(expr, "None");
        }

        public static final Boolean asBoolLiteral(Expr expr) {
            String string = Util.asBuiltIn(expr);
            if (string != null) {
                if (string.equals("True")) {
                    return true;
                }
                if (string.equals("False")) {
                    return false;
                }
            }
            return null;
        }

        public static final BigInteger asNaturalLiteral(Expr expr) {
            Expr expr2 = expr.getNonNote();
            if (expr2.tag == 1) {
                return ((Constructors.NaturalLiteral)expr2).value;
            }
            return null;
        }

        public static final BigInteger asIntegerLiteral(Expr expr) {
            Expr expr2 = expr.getNonNote();
            if (expr2.tag == 2) {
                return ((Constructors.IntegerLiteral)expr2).value;
            }
            return null;
        }

        public static final Double asDoubleLiteral(Expr expr) {
            Expr expr2 = expr.getNonNote();
            if (expr2.tag == 3) {
                return ((Constructors.DoubleLiteral)expr2).value;
            }
            return null;
        }

        public static final String asSimpleTextLiteral(Expr expr) {
            Expr expr2 = expr.getNonNote();
            if (expr2.tag == 9) {
                Constructors.TextLiteral textLiteral = (Constructors.TextLiteral)expr2;
                if (textLiteral.parts.length == 1) {
                    return textLiteral.parts[0];
                }
                return null;
            }
            return null;
        }

        public static final String asBuiltIn(Expr expr) {
            Expr expr2 = expr.getNonNote();
            if (expr2.tag == 4) {
                return ((Constructors.BuiltIn)expr2).name;
            }
            return null;
        }

        public static final List<Expr> asListLiteral(Expr expr) {
            Expr expr2 = expr.getNonNote();
            if (expr2.tag == 10) {
                return Arrays.asList(((Constructors.NonEmptyListLiteral)expr2).values);
            }
            if (expr2.tag == 11) {
                return new ArrayList<Expr>(0);
            }
            return null;
        }

        public static final List<Map.Entry<String, Expr>> asRecordLiteral(Expr expr) {
            Expr expr2 = expr.getNonNote();
            if (expr2.tag == 12) {
                return Arrays.asList(((Constructors.RecordLiteral)expr2).fields);
            }
            return null;
        }

        public static final List<Map.Entry<String, Expr>> asRecordType(Expr expr) {
            Expr expr2 = expr.getNonNote();
            if (expr2.tag == 13) {
                return Arrays.asList(((Constructors.RecordType)expr2).fields);
            }
            return null;
        }

        public static final List<Map.Entry<String, Expr>> asUnionType(Expr expr) {
            Expr expr2 = expr.getNonNote();
            if (expr2.tag == 14) {
                return Arrays.asList(((Constructors.UnionType)expr2).fields);
            }
            return null;
        }

        public static final Map.Entry<Expr, String> asFieldAccess(Expr expr) {
            Expr expr2 = expr.getNonNote();
            if (expr2.tag == 15) {
                Constructors.FieldAccess fieldAccess = (Constructors.FieldAccess)expr2;
                return new AbstractMap.SimpleImmutableEntry<Expr, String>(fieldAccess.base, fieldAccess.fieldName);
            }
            return null;
        }

        private static Expr getElementType(Expr expr, String string) {
            Expr expr2 = expr.getNonNote();
            if (expr2.tag == 18) {
                Constructors.Application application = (Constructors.Application)expr2;
                Expr expr3 = application.base.getNonNote();
                if (expr3.tag == 4 && ((Constructors.BuiltIn)expr3).name.equals(string)) {
                    return application.arg;
                }
            }
            return null;
        }

        public static final String escapeText(String string, boolean bl) {
            StringBuilder stringBuilder = new StringBuilder();
            if (bl) {
                stringBuilder.append("\\\"");
            }
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '\"') {
                    if (bl) {
                        stringBuilder.append("\\\\\"");
                        continue;
                    }
                    stringBuilder.append("\\\"");
                    continue;
                }
                if (c == '$') {
                    if (bl) {
                        stringBuilder.append("\\\\u0024");
                        continue;
                    }
                    stringBuilder.append("$");
                    continue;
                }
                if (c == '\\') {
                    if (bl) {
                        stringBuilder.append("\\\\");
                        continue;
                    }
                    stringBuilder.append("\\");
                    continue;
                }
                if (c >= '\u0000' && c <= '\u001f') {
                    if (bl) {
                        stringBuilder.append('\\');
                    }
                    String string2 = Long.toHexString(c);
                    stringBuilder.append("\\u");
                    if (string2.length() < 2) {
                        stringBuilder.append('0');
                    }
                    if (string2.length() < 3) {
                        stringBuilder.append('0');
                    }
                    if (string2.length() < 4) {
                        stringBuilder.append('0');
                    }
                    stringBuilder.append(string2);
                    continue;
                }
                stringBuilder.append(c);
            }
            if (bl) {
                stringBuilder.append("\\\"");
            }
            return stringBuilder.toString();
        }

        public static final Expr desugarComplete(Expr expr, Expr expr2) {
            return Expr.makeAnnotated(Expr.makeOperatorApplication(Operator.PREFER, Expr.makeFieldAccess(expr, "default"), expr2), Expr.makeFieldAccess(expr, "Type"));
        }

        public static final Expr applyAsLambda(Expr expr, Expr expr2) {
            Expr expr3 = expr.getNonNote();
            if (expr3.tag == 6) {
                Constructors.Lambda lambda = (Constructors.Lambda)expr3;
                return lambda.result.substitute(lambda.name, expr2);
            }
            return null;
        }
    }
}

