/*
 * Decompiled with CFR 0.152.
 */
package org.dhallj.core.converters;

import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import org.dhallj.core.Expr;
import org.dhallj.core.Visitor;
import org.dhallj.core.converters.JsonHandler;

public final class JsonConverter
extends Visitor.Constant<Boolean> {
    private final JsonHandler handler;
    private final boolean escapeStrings;

    public JsonConverter(JsonHandler jsonHandler, boolean bl) {
        super(false);
        this.handler = jsonHandler;
        this.escapeStrings = bl;
    }

    public JsonConverter(JsonHandler jsonHandler) {
        this(jsonHandler, true);
    }

    public static final String toCompactString(Expr expr) {
        JsonHandler.CompactStringPrinter compactStringPrinter = new JsonHandler.CompactStringPrinter();
        boolean bl = expr.accept(new JsonConverter(compactStringPrinter));
        if (bl) {
            return compactStringPrinter.toString();
        }
        return null;
    }

    private static final String escape(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                char c2;
                if ((c2 = string.charAt(++i)) == '\"') {
                    stringBuilder.append("\\\"");
                    continue;
                }
                if (c2 == '$') {
                    stringBuilder.append("$");
                    continue;
                }
                stringBuilder.append(c);
                stringBuilder.append(c2);
                continue;
            }
            if (c == '\"') {
                stringBuilder.append("\\\"");
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean sortFields() {
        return false;
    }

    @Override
    public boolean flattenToMapLists() {
        return true;
    }

    @Override
    public Boolean onNatural(Expr expr, BigInteger bigInteger) {
        this.handler.onNumber(bigInteger);
        return true;
    }

    @Override
    public Boolean onInteger(Expr expr, BigInteger bigInteger) {
        this.handler.onNumber(bigInteger);
        return true;
    }

    @Override
    public Boolean onDouble(Expr expr, double d) {
        this.handler.onDouble(d);
        return true;
    }

    @Override
    public Boolean onBuiltIn(Expr expr, String string) {
        if (string.equals("True")) {
            this.handler.onBoolean(true);
            return true;
        }
        if (string.equals("False")) {
            this.handler.onBoolean(false);
            return true;
        }
        return false;
    }

    @Override
    public Boolean onText(String[] stringArray, List<Boolean> list) {
        if (stringArray.length == 1) {
            if (this.escapeStrings) {
                this.handler.onString(JsonConverter.escape(stringArray[0]));
            } else {
                this.handler.onString(stringArray[0]);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean prepareNonEmptyList(int n) {
        this.handler.onArrayStart();
        return true;
    }

    @Override
    public boolean prepareNonEmptyListElement(int n) {
        if (n > 0) {
            this.handler.onArrayElementGap();
        }
        return true;
    }

    @Override
    public Boolean onNonEmptyList(List<Boolean> list) {
        for (boolean bl : list) {
            if (bl) continue;
            return false;
        }
        this.handler.onArrayEnd();
        return true;
    }

    @Override
    public Boolean onEmptyList(Boolean bl) {
        this.handler.onArrayStart();
        this.handler.onArrayEnd();
        return true;
    }

    @Override
    public boolean prepareRecord(int n) {
        this.handler.onObjectStart();
        return true;
    }

    @Override
    public boolean prepareRecordField(String string, Expr expr, int n) {
        if (n > 0) {
            this.handler.onObjectFieldGap();
        }
        if (this.escapeStrings) {
            this.handler.onObjectField(JsonConverter.escape(string));
        } else {
            this.handler.onObjectField(string);
        }
        return true;
    }

    @Override
    public Boolean onRecord(List<Map.Entry<String, Boolean>> list) {
        for (Map.Entry<String, Boolean> entry : list) {
            if (entry.getValue().booleanValue()) continue;
            return false;
        }
        this.handler.onObjectEnd();
        return true;
    }

    @Override
    public boolean prepareFieldAccess(Expr expr, String string) {
        List<Map.Entry<String, Expr>> list = Expr.Util.asUnionType(expr);
        if (list != null) {
            for (Map.Entry<String, Expr> entry : list) {
                if (!entry.getKey().equals(string) || entry.getValue() != null) continue;
                this.handler.onString(JsonConverter.escape(string));
                return false;
            }
        }
        return true;
    }

    @Override
    public Boolean onFieldAccess(Boolean bl, String string) {
        return bl == null || bl != false;
    }

    @Override
    public boolean prepareApplication(Expr expr, int n) {
        String string = Expr.Util.asBuiltIn(expr);
        if (string != null && n == 1) {
            if (string.equals("Some")) {
                return false;
            }
            if (string.equals("None")) {
                this.handler.onNull();
                return false;
            }
        } else {
            List<Map.Entry<String, Expr>> list;
            Map.Entry<Expr, String> entry = Expr.Util.asFieldAccess(expr);
            if (entry != null && (list = Expr.Util.asUnionType(entry.getKey())) != null) {
                for (Map.Entry<String, Expr> entry2 : list) {
                    if (!entry2.getKey().equals(entry.getValue()) || entry2.getValue() == null) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public Boolean onApplication(Boolean bl, List<Boolean> list) {
        return bl == null || bl != false;
    }
}

