/*
 * Decompiled with CFR 0.152.
 */
package org.dhallj.core;

import java.math.BigInteger;
import java.net.URI;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dhallj.core.Expr;
import org.dhallj.core.Operator;
import org.dhallj.core.Source;
import org.dhallj.core.ToStringState;
import org.dhallj.core.Visitor;

final class ToStringVisitor
extends Visitor.NoPrepareEvents<ToStringState> {
    public static Visitor<ToStringState> instance = new ToStringVisitor();

    ToStringVisitor() {
    }

    @Override
    public void bind(String string, Expr expr) {
    }

    @Override
    public ToStringState onNote(ToStringState toStringState, Source source) {
        return toStringState;
    }

    @Override
    public ToStringState onNatural(Expr expr, BigInteger bigInteger) {
        return new ToStringState(bigInteger.toString());
    }

    @Override
    public ToStringState onInteger(Expr expr, BigInteger bigInteger) {
        String string = bigInteger.compareTo(BigInteger.ZERO) >= 0 ? "+" + bigInteger.toString() : bigInteger.toString();
        return new ToStringState(string);
    }

    @Override
    public ToStringState onDouble(Expr expr, double d) {
        return new ToStringState(Double.toString(d));
    }

    @Override
    public ToStringState onBuiltIn(Expr expr, String string) {
        return new ToStringState(string);
    }

    private static boolean isAlpha(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isSimpleLabel(String string) {
        if (string.length() == 0) {
            return false;
        }
        char c = string.charAt(0);
        if (!ToStringVisitor.isAlpha(c) && c != '_') {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            c = string.charAt(i);
            if (ToStringVisitor.isAlpha(c) || ToStringVisitor.isDigit(c) || c == '-' || c == '/' || c == '_') continue;
            return false;
        }
        return true;
    }

    private static String escapeName(String string) {
        if (!ToStringVisitor.isSimpleLabel(string) || Expr.Constants.isBuiltIn(string) || Expr.Constants.isKeyword(string)) {
            return "`" + string + "`";
        }
        return string;
    }

    @Override
    public ToStringState onIdentifier(Expr expr, String string, long l) {
        String string2 = ToStringVisitor.escapeName(string);
        return new ToStringState(l == 0L ? string2 : string2 + "@" + Long.toString(l));
    }

    @Override
    public ToStringState onLambda(String string, ToStringState toStringState, ToStringState toStringState2) {
        return new ToStringState("\u03bb(" + ToStringVisitor.escapeName(string) + " : " + toStringState.toString(105, true) + ") \u2192 " + toStringState2.toString(105), 105);
    }

    @Override
    public ToStringState onPi(String string, ToStringState toStringState, ToStringState toStringState2) {
        String string2 = toStringState.toString(105, true);
        String string3 = toStringState2.toString(105);
        return new ToStringState(string.equals("_") ? string2 + " \u2192 " + string3 : "\u2200(" + ToStringVisitor.escapeName(string) + " : " + string2 + ") \u2192 " + string3, 105);
    }

    @Override
    public ToStringState onLet(List<Expr.LetBinding<ToStringState>> list, ToStringState toStringState) {
        String string = toStringState.toString(105);
        for (int i = list.size() - 1; i >= 0; --i) {
            Expr.LetBinding<ToStringState> letBinding = list.get(i);
            String string2 = letBinding.hasType() ? " : " + letBinding.getType().toString(105) : "";
            string = "let " + ToStringVisitor.escapeName(letBinding.getName()) + string2 + " = " + letBinding.getValue().toString(105) + " in " + string;
        }
        return new ToStringState(string, 105);
    }

    @Override
    public ToStringState onText(String[] stringArray, List<ToStringState> list) {
        StringBuilder stringBuilder = new StringBuilder("\"");
        stringBuilder.append(Expr.Util.escapeText(stringArray[0], false));
        int n = 1;
        Iterator<ToStringState> iterator = list.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append("${");
            stringBuilder.append(iterator.next().toString(Integer.MAX_VALUE));
            stringBuilder.append("}");
            stringBuilder.append(Expr.Util.escapeText(stringArray[n++], false));
        }
        if (n < stringArray.length) {
            stringBuilder.append(Expr.Util.escapeText(stringArray[n], false));
        }
        stringBuilder.append("\"");
        return new ToStringState(stringBuilder.toString());
    }

    @Override
    public ToStringState onNonEmptyList(List<ToStringState> list) {
        StringBuilder stringBuilder = new StringBuilder("[");
        Iterator<ToStringState> iterator = list.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next().toString(Integer.MAX_VALUE));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
        return new ToStringState(stringBuilder.toString());
    }

    @Override
    public ToStringState onEmptyList(ToStringState toStringState) {
        return new ToStringState("[] : " + toStringState, 104);
    }

    @Override
    public ToStringState onRecord(List<Map.Entry<String, ToStringState>> list) {
        if (list.isEmpty()) {
            return new ToStringState("{=}");
        }
        StringBuilder stringBuilder = new StringBuilder("{");
        Iterator<Map.Entry<String, ToStringState>> iterator = list.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ToStringState> entry = iterator.next();
            stringBuilder.append(ToStringVisitor.escapeName(entry.getKey()));
            stringBuilder.append(" = ");
            stringBuilder.append(entry.getValue().toString(Integer.MAX_VALUE));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("}");
        return new ToStringState(stringBuilder.toString());
    }

    @Override
    public ToStringState onRecordType(List<Map.Entry<String, ToStringState>> list) {
        StringBuilder stringBuilder = new StringBuilder("{");
        Iterator<Map.Entry<String, ToStringState>> iterator = list.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ToStringState> entry = iterator.next();
            stringBuilder.append(ToStringVisitor.escapeName(entry.getKey()));
            stringBuilder.append(" : ");
            stringBuilder.append(entry.getValue().toString(Integer.MAX_VALUE));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("}");
        return new ToStringState(stringBuilder.toString());
    }

    @Override
    public ToStringState onUnionType(List<Map.Entry<String, ToStringState>> list) {
        StringBuilder stringBuilder = new StringBuilder("<");
        Iterator<Map.Entry<String, ToStringState>> iterator = list.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ToStringState> entry = iterator.next();
            stringBuilder.append(ToStringVisitor.escapeName(entry.getKey()));
            ToStringState toStringState = entry.getValue();
            if (toStringState != null) {
                stringBuilder.append(" : ");
                stringBuilder.append(toStringState.toString());
            }
            if (!iterator.hasNext()) continue;
            stringBuilder.append(" | ");
        }
        stringBuilder.append(">");
        return new ToStringState(stringBuilder.toString());
    }

    @Override
    public ToStringState onFieldAccess(ToStringState toStringState, String string) {
        return new ToStringState(toStringState.toString(99) + "." + string, 99);
    }

    @Override
    public ToStringState onProjection(ToStringState toStringState, String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder(toStringState.toString(99));
        stringBuilder.append(".{");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(stringArray[i]);
            if (i >= stringArray.length - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("}");
        return new ToStringState(stringBuilder.toString(), 99);
    }

    @Override
    public ToStringState onProjectionByType(ToStringState toStringState, ToStringState toStringState2) {
        return new ToStringState(toStringState.toString(99) + ".(" + toStringState2.toString(Integer.MAX_VALUE) + ")", 99);
    }

    @Override
    public ToStringState onApplication(ToStringState toStringState, List<ToStringState> list) {
        StringBuilder stringBuilder = new StringBuilder(toStringState.toString(1));
        stringBuilder.append(" ");
        for (int i = 0; i < list.size(); ++i) {
            stringBuilder.append(list.get(i).toString(1, true));
            if (i >= list.size() - 1) continue;
            stringBuilder.append(" ");
        }
        return new ToStringState(stringBuilder.toString(), 1);
    }

    @Override
    public ToStringState onOperatorApplication(Operator operator, ToStringState toStringState, ToStringState toStringState2) {
        int n = ToStringState.getOperatorLevel(operator);
        return new ToStringState(toStringState.toString(n) + " " + operator.toString() + " " + toStringState2.toString(n, true), n);
    }

    @Override
    public ToStringState onIf(ToStringState toStringState, ToStringState toStringState2, ToStringState toStringState3) {
        return new ToStringState("if " + toStringState.toString(106) + " then " + toStringState2.toString(106) + " else " + toStringState3.toString(106), 106);
    }

    @Override
    public ToStringState onAnnotated(ToStringState toStringState, ToStringState toStringState2) {
        return new ToStringState(toStringState.toString(104) + " : " + toStringState2.toString(104), 104);
    }

    @Override
    public ToStringState onAssert(ToStringState toStringState) {
        return new ToStringState("assert : " + toStringState.toString(100), 100);
    }

    @Override
    public ToStringState onMerge(ToStringState toStringState, ToStringState toStringState2, ToStringState toStringState3) {
        StringBuilder stringBuilder = new StringBuilder("merge ");
        stringBuilder.append(toStringState.toString(102));
        stringBuilder.append(" ");
        stringBuilder.append(toStringState2.toString(0));
        if (toStringState3 != null) {
            stringBuilder.append(" : ");
            stringBuilder.append(toStringState3.toString(102));
        }
        return new ToStringState(stringBuilder.toString(), 102);
    }

    @Override
    public ToStringState onToMap(ToStringState toStringState, ToStringState toStringState2) {
        StringBuilder stringBuilder = new StringBuilder("toMap ");
        stringBuilder.append(toStringState.toString(102, true));
        if (toStringState2 != null) {
            stringBuilder.append(" : ");
            stringBuilder.append(toStringState2.toString(0));
        }
        return new ToStringState(stringBuilder.toString(), 102);
    }

    @Override
    public ToStringState onWith(ToStringState toStringState, String[] stringArray, ToStringState toStringState2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(toStringState.toString(102, true));
        stringBuilder.append(" with ");
        for (int i = 0; i < stringArray.length - 1; ++i) {
            stringBuilder.append(stringArray[i]);
            stringBuilder.append(".");
        }
        stringBuilder.append(stringArray[stringArray.length - 1]);
        stringBuilder.append(" = ");
        stringBuilder.append(toStringState2.toString(102));
        return new ToStringState(stringBuilder.toString(), 102);
    }

    @Override
    public ToStringState onMissingImport(Expr.ImportMode importMode, byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder("missing");
        if (byArray != null) {
            stringBuilder.append(" ");
            stringBuilder.append(Expr.Util.encodeHashBytes(byArray));
        }
        if (importMode != Expr.ImportMode.CODE) {
            stringBuilder.append(" as ");
            stringBuilder.append((Object)importMode);
        }
        return new ToStringState(stringBuilder.toString(), 0);
    }

    @Override
    public ToStringState onEnvImport(String string, Expr.ImportMode importMode, byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder("env:");
        stringBuilder.append(string);
        if (byArray != null) {
            stringBuilder.append(" ");
            stringBuilder.append(Expr.Util.encodeHashBytes(byArray));
        }
        if (importMode != Expr.ImportMode.CODE) {
            stringBuilder.append(" as ");
            stringBuilder.append((Object)importMode);
        }
        return new ToStringState(stringBuilder.toString(), 0);
    }

    @Override
    public ToStringState onLocalImport(Path path, Expr.ImportMode importMode, byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(path.toString());
        if (byArray != null) {
            stringBuilder.append(" ");
            stringBuilder.append(Expr.Util.encodeHashBytes(byArray));
        }
        if (importMode != Expr.ImportMode.CODE) {
            stringBuilder.append(" as ");
            stringBuilder.append((Object)importMode);
        }
        return new ToStringState(stringBuilder.toString(), 0);
    }

    @Override
    public ToStringState onClasspathImport(Path path, Expr.ImportMode importMode, byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder("classpath:");
        stringBuilder.append(path.toString());
        if (byArray != null) {
            stringBuilder.append(" ");
            stringBuilder.append(Expr.Util.encodeHashBytes(byArray));
        }
        if (importMode != Expr.ImportMode.CODE) {
            stringBuilder.append(" as ");
            stringBuilder.append((Object)importMode);
        }
        return new ToStringState(stringBuilder.toString(), 0);
    }

    @Override
    public ToStringState onRemoteImport(URI uRI, ToStringState toStringState, Expr.ImportMode importMode, byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(uRI.toString());
        if (toStringState != null) {
            stringBuilder.append(" using ");
            stringBuilder.append(toStringState.toString(0));
        }
        if (byArray != null) {
            stringBuilder.append(" ");
            stringBuilder.append(Expr.Util.encodeHashBytes(byArray));
        }
        if (importMode != Expr.ImportMode.CODE) {
            stringBuilder.append(" as ");
            stringBuilder.append((Object)importMode);
        }
        return new ToStringState(stringBuilder.toString(), 0);
    }
}

