/*
 * Decompiled with CFR 0.152.
 */
package org.dhallj.core.normalization;

import java.math.BigInteger;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.dhallj.core.Expr;
import org.dhallj.core.Operator;
import org.dhallj.core.normalization.BetaNormalize;

final class BetaNormalizeApplication {
    private static final Map.Entry<String, Expr> indexField = new AbstractMap.SimpleImmutableEntry<String, Expr>("index", Expr.Constants.NATURAL);
    private static final BigInteger TWO = new BigInteger("2");
    private static final Expr[] prependValue = new Expr[]{Expr.makeIdentifier("a")};
    private static final Expr prependExpr = Expr.makeOperatorApplication(Operator.LIST_APPEND, Expr.makeNonEmptyListLiteral(prependValue), Expr.makeIdentifier("as"));

    BetaNormalizeApplication() {
    }

    private static Expr applyLambdas(Expr expr, List<Expr> list) {
        Expr expr2 = null;
        Expr expr3 = expr;
        for (int i = 0; expr3 != null && i < list.size() && (expr3 = Expr.Util.applyAsLambda(expr3, list.get(i))) != null; ++i) {
            expr2 = expr3.accept(BetaNormalize.instance);
        }
        if (expr2 != null) {
            for (int i = i; i < list.size(); ++i) {
                expr2 = Expr.makeApplication(expr2, list.get(i));
            }
            expr2 = expr2.accept(BetaNormalize.instance);
        }
        return expr2;
    }

    private static final Expr booleanToExpr(boolean bl) {
        return bl ? Expr.Constants.TRUE : Expr.Constants.FALSE;
    }

    static final Expr apply(Expr expr, List<Expr> list) {
        String string = Expr.Util.asBuiltIn(expr);
        if (string != null) {
            Expr expr2;
            if (string.equals("Natural/fold") && list.size() >= 4) {
                Expr expr3 = BetaNormalizeApplication.naturalFold(list);
                if (expr3 != null) {
                    return expr3;
                }
            } else if (string.equals("List/fold") && list.size() >= 5) {
                Expr expr4 = BetaNormalizeApplication.listFold(list);
                if (expr4 != null) {
                    return expr4;
                }
            } else if (string.equals("Text/replace") && list.size() >= 3) {
                Expr expr5 = BetaNormalizeApplication.textReplace(list);
                if (expr5 != null) {
                    return expr5;
                }
            } else if (list.size() == 1) {
                Expr expr6 = BetaNormalizeApplication.arity1(string, list.get(0));
                if (expr6 != null) {
                    return expr6;
                }
            } else if (list.size() == 2 && (expr2 = BetaNormalizeApplication.arity2(string, list.get(0), list.get(1))) != null) {
                return expr2;
            }
        } else {
            Expr expr7 = BetaNormalizeApplication.applyLambdas(expr, list);
            if (expr7 != null) {
                return expr7;
            }
        }
        return Expr.makeApplication(expr, list);
    }

    private static final Expr indexedRecordType(Expr expr) {
        Map.Entry[] entryArray = new Map.Entry[]{indexField, new AbstractMap.SimpleImmutableEntry<String, Expr>("value", expr)};
        return Expr.makeRecordType(entryArray);
    }

    private static final boolean isBigIntegerEven(BigInteger bigInteger) {
        return bigInteger.mod(TWO).equals(BigInteger.ZERO);
    }

    private static final boolean isBigIntegerNatural(BigInteger bigInteger) {
        return bigInteger.compareTo(BigInteger.ZERO) >= 0;
    }

    private static final Expr arity1(String string, Expr expr) {
        if (string.equals("Natural/isZero")) {
            BigInteger bigInteger = Expr.Util.asNaturalLiteral(expr);
            if (bigInteger != null) {
                return BetaNormalizeApplication.booleanToExpr(bigInteger.equals(BigInteger.ZERO));
            }
        } else if (string.equals("Natural/even")) {
            BigInteger bigInteger = Expr.Util.asNaturalLiteral(expr);
            if (bigInteger != null) {
                return BetaNormalizeApplication.booleanToExpr(BetaNormalizeApplication.isBigIntegerEven(bigInteger));
            }
        } else if (string.equals("Natural/odd")) {
            BigInteger bigInteger = Expr.Util.asNaturalLiteral(expr);
            if (bigInteger != null) {
                return BetaNormalizeApplication.booleanToExpr(!BetaNormalizeApplication.isBigIntegerEven(bigInteger));
            }
        } else if (string.equals("Natural/toInteger")) {
            BigInteger bigInteger = Expr.Util.asNaturalLiteral(expr);
            if (bigInteger != null) {
                return Expr.makeIntegerLiteral(bigInteger);
            }
        } else if (string.equals("Natural/show")) {
            BigInteger bigInteger = Expr.Util.asNaturalLiteral(expr);
            if (bigInteger != null) {
                return Expr.makeTextLiteral(bigInteger.toString());
            }
        } else if (string.equals("Integer/negate")) {
            BigInteger bigInteger = Expr.Util.asIntegerLiteral(expr);
            if (bigInteger != null) {
                return Expr.makeIntegerLiteral(bigInteger.negate());
            }
        } else if (string.equals("Integer/clamp")) {
            BigInteger bigInteger = Expr.Util.asIntegerLiteral(expr);
            if (bigInteger != null) {
                if (BetaNormalizeApplication.isBigIntegerNatural(bigInteger)) {
                    return Expr.makeNaturalLiteral(bigInteger);
                }
                return Expr.makeNaturalLiteral(BigInteger.ZERO);
            }
        } else if (string.equals("Integer/toDouble")) {
            BigInteger bigInteger = Expr.Util.asIntegerLiteral(expr);
            if (bigInteger != null) {
                return Expr.makeDoubleLiteral(bigInteger.doubleValue());
            }
        } else if (string.equals("Integer/show")) {
            BigInteger bigInteger = Expr.Util.asIntegerLiteral(expr);
            if (bigInteger != null) {
                String string2 = BetaNormalizeApplication.isBigIntegerNatural(bigInteger) ? "+" : "";
                return Expr.makeTextLiteral(string2 + bigInteger.toString());
            }
        } else if (string.equals("Double/show")) {
            Double d = Expr.Util.asDoubleLiteral(expr);
            if (d != null) {
                return Expr.makeTextLiteral(d.toString());
            }
        } else if (string.equals("Text/show")) {
            String string3 = Expr.Util.asSimpleTextLiteral(expr);
            if (string3 != null) {
                return Expr.makeTextLiteral(Expr.Util.escapeText(string3, true));
            }
        } else if (string.equals("Natural/build")) {
            return Expr.makeApplication(Expr.makeApplication(Expr.makeApplication(expr, Expr.Constants.NATURAL), Expr.makeLambda("x", Expr.Constants.NATURAL, Expr.makeOperatorApplication(Operator.PLUS, Expr.makeIdentifier("x"), Expr.makeNaturalLiteral(BigInteger.ONE)))), Expr.makeNaturalLiteral(BigInteger.ZERO)).accept(BetaNormalize.instance);
        }
        return null;
    }

    private static final Expr arity2(String string, Expr expr, Expr expr2) {
        List<Expr> list;
        if (string.equals("List/build")) {
            Expr expr3 = Expr.makeApplication(Expr.Constants.LIST, expr);
            return Expr.makeApplication(Expr.makeApplication(Expr.makeApplication(expr2, expr3), Expr.makeLambda("a", expr, Expr.makeLambda("as", Expr.makeApplication(Expr.Constants.LIST, expr.increment("a")), prependExpr))), Expr.makeEmptyListLiteral(expr3)).accept(BetaNormalize.instance);
        }
        if (string.equals("Natural/subtract")) {
            BigInteger bigInteger = Expr.Util.asNaturalLiteral(expr);
            BigInteger bigInteger2 = Expr.Util.asNaturalLiteral(expr2);
            if (bigInteger != null) {
                if (bigInteger2 != null) {
                    if (bigInteger.compareTo(bigInteger2) < 0) {
                        return Expr.makeNaturalLiteral(bigInteger2.subtract(bigInteger));
                    }
                    return Expr.Constants.ZERO;
                }
                if (bigInteger.equals(BigInteger.ZERO)) {
                    return expr2;
                }
            } else if (bigInteger2 != null && bigInteger2.equals(BigInteger.ZERO)) {
                return Expr.Constants.ZERO;
            }
            if (expr.equivalent(expr2)) {
                return Expr.Constants.ZERO;
            }
        } else if (string.equals("List/length")) {
            List<Expr> list2 = Expr.Util.asListLiteral(expr2);
            if (list2 != null) {
                return Expr.makeNaturalLiteral(BigInteger.valueOf(list2.size()));
            }
        } else if (string.equals("List/reverse")) {
            List<Expr> list3 = Expr.Util.asListLiteral(expr2);
            if (list3 != null) {
                ArrayList<Expr> arrayList = new ArrayList<Expr>(list3);
                Collections.reverse(arrayList);
                if (arrayList.isEmpty()) {
                    return expr2;
                }
                return Expr.makeNonEmptyListLiteral(arrayList);
            }
        } else if (string.equals("List/head")) {
            List<Expr> list4 = Expr.Util.asListLiteral(expr2);
            if (list4 != null) {
                if (list4.isEmpty()) {
                    return Expr.makeApplication(Expr.Constants.NONE, expr);
                }
                return Expr.makeApplication(Expr.Constants.SOME, list4.get(0));
            }
        } else if (string.equals("List/last")) {
            List<Expr> list5 = Expr.Util.asListLiteral(expr2);
            if (list5 != null) {
                if (list5.isEmpty()) {
                    return Expr.makeApplication(Expr.Constants.NONE, expr);
                }
                return Expr.makeApplication(Expr.Constants.SOME, list5.get(list5.size() - 1));
            }
        } else if (string.equals("List/indexed") && (list = Expr.Util.asListLiteral(expr2)) != null) {
            ArrayList<Expr> arrayList = new ArrayList<Expr>(list.size());
            int n = 0;
            for (Expr expr4 : list) {
                ArrayList<Map.Entry<String, Expr>> arrayList2 = new ArrayList<Map.Entry<String, Expr>>();
                arrayList2.add(new AbstractMap.SimpleImmutableEntry<String, Expr>("index", Expr.makeNaturalLiteral(BigInteger.valueOf(n++))));
                arrayList2.add(new AbstractMap.SimpleImmutableEntry<String, Expr>("value", expr4));
                arrayList.add(Expr.makeRecordLiteral(arrayList2));
            }
            if (arrayList.isEmpty()) {
                return Expr.makeEmptyListLiteral(Expr.makeApplication(Expr.Constants.LIST, BetaNormalizeApplication.indexedRecordType(expr)));
            }
            return Expr.makeNonEmptyListLiteral(arrayList);
        }
        return null;
    }

    private static List<Expr> drop(List<Expr> list, int n) {
        ArrayList<Expr> arrayList = new ArrayList<Expr>(list.size() - n);
        for (int i = n; i < list.size(); ++i) {
            arrayList.add(list.get(i));
        }
        return arrayList;
    }

    private static final Expr naturalFold(List<Expr> list) {
        BigInteger bigInteger = Expr.Util.asNaturalLiteral(list.get(0));
        if (bigInteger != null) {
            Expr expr = null;
            expr = bigInteger.equals(BigInteger.ZERO) ? list.get(3) : Expr.makeApplication(list.get(2), Expr.makeApplication(Expr.makeApplication(Expr.makeApplication(Expr.makeApplication(Expr.Constants.NATURAL_FOLD, Expr.makeNaturalLiteral(bigInteger.subtract(BigInteger.ONE))), list.get(1)), list.get(2)), list.get(3))).accept(BetaNormalize.instance);
            if (expr == null) {
                return null;
            }
            if (list.size() == 4) {
                return expr;
            }
            return Expr.makeApplication(expr, BetaNormalizeApplication.drop(list, 4)).accept(BetaNormalize.instance);
        }
        return null;
    }

    private static final Expr listFold(List<Expr> list) {
        List<Expr> list2 = Expr.Util.asListLiteral(list.get(1));
        if (list2 != null) {
            Expr expr = null;
            if (!list2.isEmpty()) {
                Expr expr2;
                Expr expr3 = list2.get(0);
                if (list2.size() == 1) {
                    expr2 = Expr.makeEmptyListLiteral(Expr.makeApplication(Expr.Constants.LIST, list.get(0)));
                } else {
                    ArrayList<Expr> arrayList = new ArrayList<Expr>(list2);
                    arrayList.remove(0);
                    expr2 = Expr.makeNonEmptyListLiteral(arrayList);
                }
                expr = Expr.makeApplication(Expr.makeApplication(list.get(3), expr3), Expr.makeApplication(Expr.makeApplication(Expr.makeApplication(Expr.makeApplication(Expr.makeApplication(Expr.Constants.LIST_FOLD, list.get(0)), expr2), list.get(2)), list.get(3)), list.get(4))).accept(BetaNormalize.instance);
            } else {
                expr = list.get(4);
            }
            if (list.size() == 5) {
                return expr;
            }
            return Expr.makeApplication(expr, BetaNormalizeApplication.drop(list, 5)).accept(BetaNormalize.instance);
        }
        return null;
    }

    private static final Expr textReplace(List<Expr> list) {
        String string = Expr.Util.asSimpleTextLiteral(list.get(0));
        if (string != null) {
            if (string.length() == 0) {
                return list.get(2);
            }
            String string2 = Expr.Util.asSimpleTextLiteral(list.get(2));
            if (string2 != null) {
                String string3 = Pattern.quote(string);
                String[] stringArray = string2.split(string3, -1);
                Expr[] exprArray = new Expr[stringArray.length - 1];
                Expr expr = list.get(1);
                for (int i = 0; i < stringArray.length - 1; ++i) {
                    exprArray[i] = expr;
                }
                return Expr.makeTextLiteral(stringArray, exprArray).accept(BetaNormalize.instance);
            }
        }
        return null;
    }
}

