/*
 * Decompiled with CFR 0.152.
 */
package org.dhallj.imports;

import cats.Applicative;
import cats.effect.kernel.Async;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public interface ImportCache<F> {
    public F get(byte[] var1);

    public F put(byte[] var1, byte[] var2);

    private static class Impl<F>
    implements ImportCache<F> {
        private final Path rootDir;
        private final Async<F> F;

        public <F> Impl(Path rootDir, Async<F> F) {
            this.rootDir = rootDir;
            this.F = F;
        }

        @Override
        public F get(byte[] key) {
            Path p = this.path(key);
            return (F)(Files.exists(p, new LinkOption[0]) ? this.F.delay(() -> this.get$$anonfun$1(p)) : this.F.pure((Object)None$.MODULE$));
        }

        @Override
        public F put(byte[] key, byte[] value) {
            return (F)this.F.delay((Function0)((JFunction0.mcV.sp & Serializable)() -> this.put$$anonfun$1(key, value)));
        }

        private Path path(byte[] key) {
            return this.rootDir.resolve("1220" + this.toHex(key));
        }

        private String toHex(byte[] bs) {
            StringBuilder sb = new StringBuilder();
            Object object = Predef$.MODULE$.byteArrayOps(bs);
            ArrayOps$.MODULE$.foreach$extension(object, (Function1 & Serializable)b -> this.toHex$$anonfun$1(sb, BoxesRunTime.unboxToByte((Object)b)));
            return sb.toString();
        }

        private final Some get$$anonfun$1(Path p$1) {
            return Some$.MODULE$.apply((Object)Files.readAllBytes(p$1));
        }

        private final void put$$anonfun$1(byte[] key$1, byte[] value$1) {
            Files.write(this.path(key$1), value$1, new OpenOption[0]);
        }

        private final /* synthetic */ StringBuilder toHex$$anonfun$1(StringBuilder sb$1, byte b) {
            return sb$1.append(String.format("%02x", BoxesRunTime.boxToByte((byte)b)));
        }
    }

    public static class NoopImportCache<F>
    implements ImportCache<F> {
        private final Applicative<F> F;

        public <F> NoopImportCache(Applicative<F> F) {
            this.F = F;
        }

        @Override
        public F get(byte[] key) {
            return (F)this.F.pure((Object)None$.MODULE$);
        }

        @Override
        public F put(byte[] key, byte[] value) {
            return (F)this.F.unit();
        }
    }
}

