/*
 * Decompiled with CFR 0.152.
 */
package org.dhallj.imports;

import cats.UnorderedFoldable;
import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.effect.kernel.Async;
import cats.implicits$;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.FlatMapOps$;
import fs2.Stream;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Path;
import java.security.MessageDigest;
import org.dhallj.cats.LiftVisitor;
import org.dhallj.core.DhallException;
import org.dhallj.core.Expr;
import org.dhallj.core.Operator;
import org.dhallj.core.binary.Decode;
import org.dhallj.imports.Canonicalization$;
import org.dhallj.imports.CorsComplianceCheck$;
import org.dhallj.imports.ImportCache;
import org.dhallj.imports.ImportContext;
import org.dhallj.imports.ImportContext$Classpath$;
import org.dhallj.imports.ImportContext$Env$;
import org.dhallj.imports.ImportContext$Local$;
import org.dhallj.imports.ImportContext$Missing$;
import org.dhallj.imports.ImportContext$Remote$;
import org.dhallj.imports.ReferentialSanityCheck$;
import org.dhallj.imports.ResolveImportsVisitor$;
import org.dhallj.imports.ToHeaders$;
import org.dhallj.parser.DhallParser;
import org.http4s.EntityDecoder$;
import org.http4s.Headers;
import org.http4s.HttpVersion;
import org.http4s.Media;
import org.http4s.Method;
import org.http4s.Request$;
import org.http4s.Response;
import org.http4s.Status;
import org.http4s.Uri;
import org.http4s.Uri$;
import org.http4s.client.Client;
import org.typelevel.vault.Vault;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.sys.package$;

public final class ResolveImportsVisitor<F>
extends LiftVisitor<F> {
    private final ImportCache<F> semanticCache;
    private final ImportCache<F> semiSemanticCache;
    private final NonEmptyList<ImportContext> parents;
    private final Client<F> Client;
    private final Async<F> F;
    private Map duplicateImportCache;

    public static <F> Object apply(Async<F> async, Client<F> client) {
        return ResolveImportsVisitor$.MODULE$.apply(async, client);
    }

    public static <F> ResolveImportsVisitor<F> apply(ImportCache<F> importCache, Async<F> async, Client<F> client) {
        return ResolveImportsVisitor$.MODULE$.apply(importCache, async, client);
    }

    public static <F> ResolveImportsVisitor<F> apply(ImportCache<F> importCache, ImportCache<F> importCache2, Async<F> async, Client<F> client) {
        return ResolveImportsVisitor$.MODULE$.apply(importCache, importCache2, async, client);
    }

    public static <F> ResolveImportsVisitor<F> apply(ImportCache<F> importCache, ImportCache<F> importCache2, Path path, Async<F> async, Client<F> client) {
        return ResolveImportsVisitor$.MODULE$.apply(importCache, importCache2, path, async, client);
    }

    public static <F> ResolveImportsVisitor<F> apply(ImportCache<F> importCache, Path path, Async<F> async, Client<F> client) {
        return ResolveImportsVisitor$.MODULE$.apply(importCache, path, async, client);
    }

    public static <F> Object apply(Path path, Async<F> async, Client<F> client) {
        return ResolveImportsVisitor$.MODULE$.apply(path, async, client);
    }

    public <F> ResolveImportsVisitor(ImportCache<F> semanticCache, ImportCache<F> semiSemanticCache, NonEmptyList<ImportContext> parents, Client<F> Client2, Async<F> F) {
        this.semanticCache = semanticCache;
        this.semiSemanticCache = semiSemanticCache;
        this.parents = parents;
        this.Client = Client2;
        this.F = F;
        super(F);
        this.duplicateImportCache = (Map)Map$.MODULE$.empty();
    }

    public <F> ResolveImportsVisitor(ImportCache<F> semanticCache, ImportCache<F> semiSemanticCache, List<ImportContext> parents, Client<F> Client2, Async<F> F) {
        this(semanticCache, semiSemanticCache, (NonEmptyList<ImportContext>)NonEmptyList$.MODULE$.fromListUnsafe(parents), Client2, F);
    }

    private Map<Tuple2<ImportContext, Expr.ImportMode>, Expr> duplicateImportCache() {
        return this.duplicateImportCache;
    }

    private void duplicateImportCache_$eq(Map<Tuple2<ImportContext, Expr.ImportMode>, Expr> x$0) {
        this.duplicateImportCache = x$0;
    }

    public F onOperatorApplication(Operator operator, F lhs, F rhs) {
        Object object;
        Operator operator2 = operator;
        Operator operator3 = Operator.IMPORT_ALT;
        if (!(operator2 != null ? !operator2.equals(operator3) : operator3 != null)) {
            Object object2 = implicits$.MODULE$.catsSyntaxApplicativeError(lhs, this.F);
            object = ApplicativeErrorOps$.MODULE$.handleErrorWith$extension(object2, (Function1 & Serializable)_$2 -> rhs, this.F);
        } else {
            object = this.F.map2(lhs, rhs, (Function2 & Serializable)(_$3, _$4) -> Expr.makeOperatorApplication((Operator)operator, (Expr)_$3, (Expr)_$4));
        }
        return (F)object;
    }

    public F onLocalImport(Path path, Expr.ImportMode mode, byte[] hash) {
        return this.onImport(ImportContext$Local$.MODULE$.apply(path), mode, hash);
    }

    public F onClasspathImport(Path path, Expr.ImportMode mode, byte[] hash) {
        return this.onImport(ImportContext$Classpath$.MODULE$.apply(path), mode, hash);
    }

    public F onRemoteImport(URI url, F using, Expr.ImportMode mode, byte[] hash) {
        Object object;
        if (using != null) {
            Object object2 = implicits$.MODULE$.catsSyntaxFlatMapOps(using, this.F);
            object = FlatMapOps$.MODULE$.$greater$greater$eq$extension(object2, (Function1 & Serializable)u -> this.onImport(ImportContext$Remote$.MODULE$.apply(url, (Expr)u), mode, hash), this.F);
        } else {
            object = this.onImport(ImportContext$Remote$.MODULE$.apply(url, null), mode, hash);
        }
        return object;
    }

    public F onEnvImport(String value, Expr.ImportMode mode, byte[] hash) {
        return this.onImport(ImportContext$Env$.MODULE$.apply(value), mode, hash);
    }

    public F onMissingImport(Expr.ImportMode mode, byte[] hash) {
        return this.onImport(ImportContext$Missing$.MODULE$, mode, hash);
    }

    private boolean checkHash(byte[] encoded, byte[] expected) {
        byte[] hashed = MessageDigest.getInstance("SHA-256").digest(encoded);
        return Predef$.MODULE$.wrapByteArray(hashed).sameElements((IterableOnce)Predef$.MODULE$.wrapByteArray(expected));
    }

    private F onImport(ImportContext i, Expr.ImportMode mode, byte[] hash) {
        return (F)implicits$.MODULE$.toFlatMapOps(Canonicalization$.MODULE$.canonicalize((ImportContext)this.parents.head(), i, this.F), this.F).flatMap((Function1 & Serializable)imp -> {
            Expr.ImportMode importMode = mode;
            Expr.ImportMode importMode2 = Expr.ImportMode.LOCATION;
            return implicits$.MODULE$.toFunctorOps(!(importMode != null ? !importMode.equals(importMode2) : importMode2 != null) ? this.importLocation$1((ImportContext)imp) : this.importNonLocation$4((ImportContext)imp, mode, hash), this.F).map((Function1 & Serializable)result -> result);
        });
    }

    private final Object rejectCyclicImports$2(ImportContext imp, NonEmptyList parents) {
        return parents.exists((Function1 & Serializable)_$5 -> {
            ImportContext importContext = _$5;
            ImportContext importContext2 = imp;
            return !(importContext != null ? !importContext.equals(importContext2) : importContext2 != null);
        }) ? this.F.raiseError((Object)new DhallException.ResolutionFailure("Cyclic import - " + imp + " is already imported in chain " + parents)) : this.F.unit();
    }

    private final Object importLocation$1(ImportContext imp) {
        Object object;
        ImportContext importContext = imp;
        if (importContext instanceof ImportContext.Local) {
            Path path;
            ImportContext.Local local = ImportContext$Local$.MODULE$.unapply((ImportContext.Local)importContext);
            Path path2 = path = local._1();
            object = this.makeLocation$1("Local", path2.toString());
        } else if (importContext instanceof ImportContext.Classpath) {
            Path path;
            ImportContext.Classpath classpath = ImportContext$Classpath$.MODULE$.unapply((ImportContext.Classpath)importContext);
            Path path3 = path = classpath._1();
            object = this.F.raiseError((Object)new DhallException.ResolutionFailure("Importing classpath as location is not supported"));
        } else if (importContext instanceof ImportContext.Remote) {
            ImportContext.Remote remote = ImportContext$Remote$.MODULE$.unapply((ImportContext.Remote)importContext);
            URI uRI = remote._1();
            Expr expr = remote._2();
            URI uri = uRI;
            object = this.makeLocation$1("Remote", uri.toString());
        } else if (importContext instanceof ImportContext.Env) {
            String string;
            ImportContext.Env env = ImportContext$Env$.MODULE$.unapply((ImportContext.Env)importContext);
            String value = string = env._1();
            object = this.makeLocation$1("Environment", value);
        } else if (ImportContext$Missing$.MODULE$.equals(importContext)) {
            object = this.F.pure((Object)Expr.makeFieldAccess((Expr)Expr.Constants.LOCATION_TYPE, (String)"Missing"));
        } else {
            throw new MatchError((Object)importContext);
        }
        return object;
    }

    private final Object makeLocation$1(String field, String value) {
        return this.F.pure((Object)Expr.makeApplication((Expr)Expr.makeFieldAccess((Expr)Expr.Constants.LOCATION_TYPE, (String)field), (Expr)Expr.makeTextLiteral((String)value)));
    }

    private final Object checkHashesMatch$1(byte[] encoded, byte[] expected) {
        return this.checkHash(encoded, expected) ? this.F.unit() : this.F.raiseError((Object)new DhallException.ResolutionFailure("Cached expression does not match its hash"));
    }

    private static final Expr loadWithSemanticCache$1$$anonfun$1$$anonfun$1(byte[] bs$1) {
        return Decode.decode((byte[])bs$1);
    }

    private final Object loadWithSemanticCache$8(ImportContext imp, Expr.ImportMode mode, byte[] hash) {
        return hash == null ? this.loadWithSemiSemanticCache$1(imp, mode, hash) : implicits$.MODULE$.toFlatMapOps(this.semanticCache.get(hash), this.F).flatMap((Function1 & Serializable)cached -> {
            byte[] bs;
            Option option = cached;
            return implicits$.MODULE$.toFunctorOps(option instanceof Some && this.checkHash(bs = (byte[])((Some)option).value(), hash) ? this.F.delay(() -> ResolveImportsVisitor.loadWithSemanticCache$1$$anonfun$1$$anonfun$1(bs)) : implicits$.MODULE$.toFlatMapOps(implicits$.MODULE$.toFunctorOps(this.loadWithSemiSemanticCache$1(imp, mode, hash), this.F).map((Function1 & Serializable)e -> {
                byte[] bs = e.alphaNormalize().getEncodedBytes();
                return Tuple2$.MODULE$.apply(e, (Object)bs);
            }), this.F).flatMap((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Expr e = (Expr)tuple2._1();
                byte[] bs = (byte[])tuple2._2();
                return implicits$.MODULE$.toFlatMapOps(this.checkHashesMatch$1(bs, hash), this.F).flatMap((Function1 & Serializable)x$12 -> {
                    BoxedUnit boxedUnit = x$12;
                    return implicits$.MODULE$.toFunctorOps(this.semanticCache.put(hash, bs), this.F).map((Function1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = x$1;
                        return e;
                    });
                });
            }), this.F).map((Function1 & Serializable)e -> e);
        });
    }

    private static final Option fetch$1$$anonfun$1(String value$1) {
        return package$.MODULE$.env().get((Object)value$1);
    }

    private final Object fetch$2$$anonfun$2$$anonfun$1(String value$3) {
        return this.F.raiseError((Object)new DhallException.ResolutionFailure("Missing import - env import " + value$3 + " undefined"));
    }

    private static final String fetch$6$$anonfun$6(Path path$1) {
        return Source$.MODULE$.fromFile(path$1.toString(), Codec$.MODULE$.fallbackSystemCodec()).mkString();
    }

    private final String fetch$8$$anonfun$8(Path path$2) {
        return Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream(path$2.toString()), Codec$.MODULE$.fallbackSystemCodec()).mkString();
    }

    private final /* synthetic */ Object fetch$15$$anonfun$15(ImportContext imp$3, URI uri$2, List headers) {
        Uri uri = Uri$.MODULE$.unsafeFromString(uri$2.toString());
        Method method = Request$.MODULE$.apply$default$1();
        HttpVersion httpVersion = Request$.MODULE$.apply$default$3();
        Stream stream = Request$.MODULE$.apply$default$5();
        Vault vault = Request$.MODULE$.apply$default$6();
        return implicits$.MODULE$.toFlatMapOps(this.F.pure((Object)Request$.MODULE$.apply(method, uri, httpVersion, headers, stream, vault)), this.F).flatMap((Function1 & Serializable)req -> implicits$.MODULE$.toFunctorOps(this.Client.fetch(req, (Function1 & Serializable)x$1 -> {
            Object object;
            Option option;
            Response response = x$1;
            if (response != null && !(option = Status.Successful$.MODULE$.unapply(response)).isEmpty()) {
                Response response2;
                Response resp = response2 = (Response)option.get();
                object = implicits$.MODULE$.toFlatMapOps(EntityDecoder$.MODULE$.decodeText((Media)resp, this.F, EntityDecoder$.MODULE$.decodeText$default$3((Media)resp)), this.F).flatMap((Function1 & Serializable)s -> implicits$.MODULE$.toFunctorOps(implicits$.MODULE$.toUnorderedFoldableOps(this.parents, (UnorderedFoldable)NonEmptyList$.MODULE$.catsDataInstancesForNonEmptyList()).nonEmpty() ? CorsComplianceCheck$.MODULE$.apply((ImportContext)this.parents.head(), imp$3, resp.headers(), this.F) : this.F.unit(), this.F).map((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = x$1;
                    return s;
                }));
            } else {
                object = this.F.raiseError((Object)new DhallException.ResolutionFailure("Missing import - cannot resolve " + uri$2));
            }
            return object;
        }), this.F).map((Function1 & Serializable)resp -> resp));
    }

    private final Object fetch$17(ImportContext imp) {
        Object object;
        ImportContext importContext = imp;
        if (importContext instanceof ImportContext.Env) {
            String string;
            ImportContext.Env env = ImportContext$Env$.MODULE$.unapply((ImportContext.Env)importContext);
            String value = string = env._1();
            object = implicits$.MODULE$.toFlatMapOps(this.F.delay(() -> ResolveImportsVisitor.fetch$1$$anonfun$1(value)), this.F).flatMap((Function1 & Serializable)vO -> implicits$.MODULE$.toFunctorOps(vO.fold(() -> this.fetch$2$$anonfun$2$$anonfun$1(value), (Function1 & Serializable)x -> this.F.pure(x)), this.F).map((Function1 & Serializable)v -> v));
        } else if (importContext instanceof ImportContext.Local) {
            Path path;
            ImportContext.Local local = ImportContext$Local$.MODULE$.unapply((ImportContext.Local)importContext);
            Path path2 = path = local._1();
            object = implicits$.MODULE$.toFunctorOps(this.F.delay(() -> ResolveImportsVisitor.fetch$6$$anonfun$6(path2)), this.F).map((Function1 & Serializable)v -> v);
        } else if (importContext instanceof ImportContext.Classpath) {
            Path path;
            ImportContext.Classpath classpath = ImportContext$Classpath$.MODULE$.unapply((ImportContext.Classpath)importContext);
            Path path3 = path = classpath._1();
            object = implicits$.MODULE$.toFunctorOps(this.F.delay(() -> this.fetch$8$$anonfun$8(path3)), this.F).map((Function1 & Serializable)v -> v);
        } else if (importContext instanceof ImportContext.Remote) {
            ImportContext.Remote remote = ImportContext$Remote$.MODULE$.unapply((ImportContext.Remote)importContext);
            URI uRI = remote._1();
            Expr expr = remote._2();
            URI uri = uRI;
            Expr using = expr;
            object = implicits$.MODULE$.toFlatMapOps(this.F.pure((Object)new Headers(ToHeaders$.MODULE$.apply(using))), this.F).flatMap((Function1 & Serializable)headers -> this.fetch$15$$anonfun$15(imp, uri, headers == null ? null : ((Headers)headers).headers()));
        } else if (ImportContext$Missing$.MODULE$.equals(importContext)) {
            object = this.F.raiseError((Object)new DhallException.ResolutionFailure("Missing import - cannot resolve missing"));
        } else {
            throw new MatchError((Object)importContext);
        }
        return object;
    }

    private static final Expr.Parsed loadWithSemiSemanticCache$3$$anonfun$2$$anonfun$1(String text$1) {
        return DhallParser.parse((String)text$1);
    }

    private static final Expr loadWithSemiSemanticCache$5$$anonfun$4$$anonfun$3$$anonfun$2$$anonfun$1$$anonfun$1(byte[] bs$3) {
        return Decode.decode((byte[])bs$3);
    }

    private static final Expr loadWithSemiSemanticCache$6$$anonfun$5$$anonfun$4$$anonfun$3$$anonfun$2$$anonfun$2(Expr resolved$2) {
        return Expr.Util.typeCheck((Expr)resolved$2);
    }

    private static final Expr loadWithSemiSemanticCache$7$$anonfun$6$$anonfun$5$$anonfun$4$$anonfun$3$$anonfun$3$$anonfun$1(Expr resolved$4) {
        return resolved$4.normalize();
    }

    private final Object loadWithSemiSemanticCache$1(ImportContext imp, Expr.ImportMode mode, byte[] hash) {
        Object object;
        Expr.ImportMode importMode = mode;
        Expr.ImportMode importMode2 = Expr.ImportMode.LOCATION;
        Expr.ImportMode importMode3 = importMode;
        if (!(importMode2 != null ? !importMode2.equals(importMode3) : importMode3 != null)) {
            object = this.F.raiseError((Object)new DhallException.ResolutionFailure("Unreachable - location imports already handled"));
        } else {
            Expr.ImportMode importMode4 = Expr.ImportMode.RAW_TEXT;
            Expr.ImportMode importMode5 = importMode;
            if (!(importMode4 != null ? !importMode4.equals(importMode5) : importMode5 != null)) {
                object = implicits$.MODULE$.toFunctorOps(this.fetch$17(imp), this.F).map((Function1 & Serializable)text -> Expr.makeTextLiteral((String)text));
            } else {
                Expr.ImportMode importMode6 = Expr.ImportMode.CODE;
                Expr.ImportMode importMode7 = importMode;
                if (!(importMode6 != null ? !importMode6.equals(importMode7) : importMode7 != null)) {
                    object = implicits$.MODULE$.toFlatMapOps(this.fetch$17(imp), this.F).flatMap((Function1 & Serializable)text -> implicits$.MODULE$.toFlatMapOps(this.F.delay(() -> ResolveImportsVisitor.loadWithSemiSemanticCache$3$$anonfun$2$$anonfun$1(text)), this.F).flatMap((Function1 & Serializable)parsed -> {
                        ResolveImportsVisitor<F> v = new ResolveImportsVisitor<F>(this.semanticCache, this.semiSemanticCache, (NonEmptyList<ImportContext>)this.parents.$colon$colon((Object)imp), this.Client, this.F);
                        super.duplicateImportCache_$eq(this.duplicateImportCache());
                        return implicits$.MODULE$.toFlatMapOps(implicits$.MODULE$.toFunctorOps(parsed.accept(v), this.F).map((Function1 & Serializable)resolved -> {
                            byte[] semiHash = MessageDigest.getInstance("SHA-256").digest(resolved.getEncodedBytes());
                            return Tuple2$.MODULE$.apply(resolved, (Object)semiHash);
                        }), this.F).flatMap((Function1 & Serializable)x$1 -> {
                            Tuple2 tuple2 = x$1;
                            if (tuple2 == null) {
                                throw new MatchError((Object)tuple2);
                            }
                            Expr resolved = (Expr)tuple2._1();
                            byte[] semiHash = (byte[])tuple2._2();
                            return implicits$.MODULE$.toFlatMapOps(this.semiSemanticCache.get(semiHash), this.F).flatMap((Function1 & Serializable)cached -> {
                                Object object;
                                Option option = cached;
                                if (option instanceof Some) {
                                    byte[] bs = (byte[])((Some)option).value();
                                    object = this.F.delay(() -> ResolveImportsVisitor.loadWithSemiSemanticCache$5$$anonfun$4$$anonfun$3$$anonfun$2$$anonfun$1$$anonfun$1(bs));
                                } else if (None$.MODULE$.equals(option)) {
                                    object = implicits$.MODULE$.toFlatMapOps(this.F.delay(() -> ResolveImportsVisitor.loadWithSemiSemanticCache$6$$anonfun$5$$anonfun$4$$anonfun$3$$anonfun$2$$anonfun$2(resolved)), this.F).flatMap((Function1 & Serializable)x$1 -> {
                                        Expr expr = x$1;
                                        return implicits$.MODULE$.toFlatMapOps(this.F.delay(() -> ResolveImportsVisitor.loadWithSemiSemanticCache$7$$anonfun$6$$anonfun$5$$anonfun$4$$anonfun$3$$anonfun$3$$anonfun$1(resolved)), this.F).flatMap((Function1 & Serializable)normalized -> implicits$.MODULE$.toFunctorOps(this.semiSemanticCache.put(semiHash, normalized.getEncodedBytes()), this.F).map((Function1 & Serializable)x$1 -> {
                                            BoxedUnit boxedUnit = x$1;
                                            return normalized;
                                        }));
                                    });
                                } else {
                                    throw new MatchError((Object)option);
                                }
                                return implicits$.MODULE$.toFunctorOps(object, this.F).map((Function1 & Serializable)expr -> expr);
                            });
                        });
                    }));
                } else {
                    throw new MatchError((Object)importMode);
                }
            }
        }
        return object;
    }

    private final Expr resolve$1$$anonfun$1(Tuple2 p$1) {
        return (Expr)this.duplicateImportCache().get((Object)p$1).get();
    }

    private final Option resolve$2$$anonfun$2$$anonfun$1(Tuple2 p$3, Expr e$3) {
        return this.duplicateImportCache().put((Object)p$3, (Object)e$3);
    }

    private final Object resolve$5(ImportContext imp, Expr.ImportMode mode, byte[] hash) {
        Tuple2 p = Tuple2$.MODULE$.apply((Object)imp, (Object)mode);
        return this.duplicateImportCache().contains((Object)p) ? this.F.delay(() -> this.resolve$1$$anonfun$1(p)) : implicits$.MODULE$.toFlatMapOps(this.loadWithSemanticCache$8(imp, mode, hash), this.F).flatMap((Function1 & Serializable)e -> implicits$.MODULE$.toFunctorOps(this.F.delay(() -> this.resolve$2$$anonfun$2$$anonfun$1(p, e)), this.F).map((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            return e;
        }));
    }

    private final Object importNonLocation$4(ImportContext imp, Expr.ImportMode mode, byte[] hash) {
        return implicits$.MODULE$.toFlatMapOps(ReferentialSanityCheck$.MODULE$.apply((ImportContext)this.parents.head(), imp, this.F), this.F).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = x$12;
            return implicits$.MODULE$.toFlatMapOps(this.rejectCyclicImports$2(imp, this.parents), this.F).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = x$1;
                return implicits$.MODULE$.toFunctorOps(this.resolve$5(imp, mode, hash), this.F).map((Function1 & Serializable)r -> r);
            });
        });
    }
}

