/*
 * Decompiled with CFR 0.152.
 */
package org.dhallj.javagen;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.dhallj.core.Expr;
import org.dhallj.core.Operator;
import org.dhallj.core.Source;
import org.dhallj.core.Visitor;
import org.dhallj.javagen.Code;
import org.dhallj.javagen.Code$;
import org.dhallj.javagen.ToCodeVisitor$;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public final class ToCodeVisitor
extends Visitor.NoPrepareEvents<Code> {
    private final Set<String> constants = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Natural", "Integer", "Double", "True", "False", "Type", "List", "Text"}));

    public static Visitor instance() {
        return ToCodeVisitor$.MODULE$.instance();
    }

    private Nothing$ unsupported() {
        throw new RuntimeException("Java generation only supported for fully-interpreted expressions");
    }

    public Code onNote(Code base, Source source) {
        return base;
    }

    public Code onNatural(Expr self, BigInteger value) {
        return Code$.MODULE$.apply("Expr.makeNaturalLiteral(new BigInteger(\"" + value + "\"))", Code$.MODULE$.$lessinit$greater$default$2());
    }

    public Code onInteger(Expr self, BigInteger value) {
        return Code$.MODULE$.apply("Expr.makeIntegerLiteral(new BigInteger(\"" + value + "\"))", Code$.MODULE$.$lessinit$greater$default$2());
    }

    public Code onDouble(Expr self, double value) {
        return Code$.MODULE$.apply("Expr.makeDoubleLiteral(" + value + ")", Code$.MODULE$.$lessinit$greater$default$2());
    }

    public Code onDate(Expr self, int year, int month, int day) {
        return Code$.MODULE$.apply("Expr.makeDateLiteral(" + year + ", " + month + ", " + day + ")", Code$.MODULE$.$lessinit$greater$default$2());
    }

    public Code onTime(Expr self, int hour, int minute, int second, BigDecimal fractional) {
        return fractional.equals(BigDecimal.ZERO) ? Code$.MODULE$.apply("Expr.makeTimeLiteral(" + hour + ", " + minute + ", " + second + ", BigDecimal.ZERO)", Code$.MODULE$.$lessinit$greater$default$2()) : Code$.MODULE$.apply("Expr.makeTimeLiteral(" + hour + ", " + minute + ", " + second + ", new BigDecimal(" + fractional + "))", Code$.MODULE$.$lessinit$greater$default$2());
    }

    public Code onTimeZone(Expr self, int seconds) {
        return Code$.MODULE$.apply("Expr.makeTimeZoneLiteral(" + seconds + ")", Code$.MODULE$.$lessinit$greater$default$2());
    }

    public Code onBuiltIn(Expr self, String name) {
        return Code$.MODULE$.apply(this.constants.apply((Object)name) ? "Expr.Constants." + name.toUpperCase() : "Expr.makeBuiltIn(\"" + name + "\")", Code$.MODULE$.$lessinit$greater$default$2());
    }

    public Code onIdentifier(Expr self, String name, long index) {
        return Code$.MODULE$.apply("Expr.makeIdentifier(\"" + name + "\", " + index + ")", Code$.MODULE$.$lessinit$greater$default$2());
    }

    public Code onLambda(String name, Code tpe, Code result) {
        return result.merge(tpe, (Function2<String, String, String>)(Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String resultContent = (String)tuple2._1();
            String tpeContent = (String)tuple2._2();
            return "Expr.makeLambda(\"" + name + "\", " + tpeContent + ", " + resultContent + ")";
        });
    }

    public Code onPi(String name, Code tpe, Code result) {
        return result.merge(tpe, (Function2<String, String, String>)(Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String resultContent = (String)tuple2._1();
            String tpeContent = (String)tuple2._2();
            return "Expr.makePi(\"" + name + "\", " + tpeContent + ", " + resultContent + ")";
        });
    }

    public Code onLet(List<Expr.LetBinding<Code>> bindings, Code body) {
        throw this.unsupported();
    }

    private String escape(String input) {
        return input.replace("\"", "\\\"").replace("\\\\", "\\\\\\\\");
    }

    public Code onText(String[] parts, List<Code> interpolated) {
        return parts.length == 1 ? Code$.MODULE$.apply("Expr.makeTextLiteral(\"" + this.escape(parts[0]) + "\")", Code$.MODULE$.$lessinit$greater$default$2()) : Code$.MODULE$.mergeAll((Vector<Code>)((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(interpolated).asScala()).toVector(), (Function1<Vector<String>, String>)(Function1 & Serializable)ids -> {
            Object object = Predef$.MODULE$.refArrayOps((Object[])parts);
            String partArray = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)part -> "\"" + this.escape((String)part) + "\"", ClassTag$.MODULE$.apply(String.class))).mkString(", ");
            return "Expr.makeTextLiteral(new String[] {" + partArray + "}, new Expr[] {" + ids.mkString(", ") + "})";
        });
    }

    public Code onNonEmptyList(List<Code> values) {
        return Code$.MODULE$.mergeAll((Vector<Code>)((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(values).asScala()).toVector(), (Function1<Vector<String>, String>)(Function1 & Serializable)ids -> "Expr.makeNonEmptyListLiteral(new Expr[] {" + ids.mkString(", ") + "})");
    }

    public Code onEmptyList(Code tpe) {
        return tpe.mapContent((Function1<String, String>)(Function1 & Serializable)tpeContent -> "Expr.makeEmptyListLiteral(" + tpeContent + ")");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Code forFields(String constructor, List<Map.Entry<String, Code>> fields) {
        Code code;
        if (fields.isEmpty()) {
            String string = constructor;
            if ("makeRecordLiteral".equals(string)) {
                code = Code$.MODULE$.apply("Expr.Constants.EMPTY_RECORD_LITERAL", Code$.MODULE$.$lessinit$greater$default$2());
                return code;
            } else if ("makeRecordType".equals(string)) {
                code = Code$.MODULE$.apply("Expr.Constants.EMPTY_RECORD_TYPE", Code$.MODULE$.$lessinit$greater$default$2());
                return code;
            } else {
                if (!"makeUnionType".equals(string)) throw new MatchError((Object)string);
                code = Code$.MODULE$.apply("Expr.Constants.EMPTY_UNION_TYPE", Code$.MODULE$.$lessinit$greater$default$2());
            }
            return code;
        } else {
            code = Code$.MODULE$.mergeAll(((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(fields).asScala()).toVector(), (Function1 & Serializable)entry -> Option$.MODULE$.apply(entry.getValue()), (Function1 & Serializable)pairs -> {
                String entries = ((IterableOnceOps)pairs.map((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Map.Entry entry = (Map.Entry)tuple2._1();
                    String id = (String)tuple2._2();
                    return "new SimpleImmutableEntry<String, Expr>(\"" + entry.getKey() + "\", " + id + ")";
                })).mkString(", ");
                return "Expr." + constructor + "(new Entry[] {" + entries + "})";
            });
        }
        return code;
    }

    public Code onRecord(List<Map.Entry<String, Code>> fields) {
        return this.forFields("makeRecordLiteral", fields);
    }

    public Code onRecordType(List<Map.Entry<String, Code>> fields) {
        return this.forFields("makeRecordType", fields);
    }

    public Code onUnionType(List<Map.Entry<String, Code>> fields) {
        return this.forFields("makeUnionType", fields);
    }

    public Code onFieldAccess(Code base, String fieldName) {
        return base.mapContent((Function1<String, String>)(Function1 & Serializable)baseContent -> "Expr.makeFieldAccess(" + baseContent + ", \"" + fieldName + "\")");
    }

    public Code onProjection(Code base, String[] fieldNames) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])fieldNames);
        String fieldNameArray = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)fieldName -> "\"" + fieldName + "\"", ClassTag$.MODULE$.apply(String.class))).mkString(", ");
        return base.mapContent((Function1<String, String>)(Function1 & Serializable)baseContent -> "Expr.makeProjection(" + baseContent + ", new String[] {" + fieldNameArray + "})");
    }

    public Code onProjectionByType(Code base, Code tpe) {
        return base.merge(tpe, (Function2<String, String, String>)(Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String baseContent = (String)tuple2._1();
            String tpeContent = (String)tuple2._2();
            return "Expr.makeProjectionByType(" + baseContent + ", " + tpeContent + ")";
        });
    }

    public Code onApplication(Code base, List<Code> args) {
        return Code$.MODULE$.mergeAll((Vector<Code>)((Vector)((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(args).asScala()).toVector().$plus$colon((Object)base)), (Function1<Vector<String>, String>)(Function1 & Serializable)x$1 -> {
            Option option;
            Vector vector = x$1;
            if (vector == null || (option = package$.MODULE$.$plus$colon().unapply((SeqOps)vector)).isEmpty()) {
                throw new MatchError((Object)vector);
            }
            Tuple2 tuple2 = (Tuple2)option.get();
            String head = (String)tuple2._1();
            Vector tail = (Vector)tuple2._2();
            return "Expr.makeApplication(" + head + ", new Expr[] {" + tail.mkString(", ") + "})";
        });
    }

    public Code onOperatorApplication(Operator operator, Code lhs, Code rhs) {
        String string;
        Operator operator2 = operator;
        Operator operator3 = Operator.OR;
        Operator operator4 = operator2;
        if (!(operator3 != null ? !operator3.equals(operator4) : operator4 != null)) {
            string = "Operator.OR";
        } else {
            Operator operator5 = Operator.AND;
            Operator operator6 = operator2;
            if (!(operator5 != null ? !operator5.equals(operator6) : operator6 != null)) {
                string = "Operator.AND";
            } else {
                Operator operator7 = Operator.EQUALS;
                Operator operator8 = operator2;
                if (!(operator7 != null ? !operator7.equals(operator8) : operator8 != null)) {
                    string = "Operator.EQUALS";
                } else {
                    Operator operator9 = Operator.NOT_EQUALS;
                    Operator operator10 = operator2;
                    if (!(operator9 != null ? !operator9.equals(operator10) : operator10 != null)) {
                        string = "Operator.NOT_EQUALS";
                    } else {
                        Operator operator11 = Operator.PLUS;
                        Operator operator12 = operator2;
                        if (!(operator11 != null ? !operator11.equals(operator12) : operator12 != null)) {
                            string = "Operator.PLUS";
                        } else {
                            Operator operator13 = Operator.TIMES;
                            Operator operator14 = operator2;
                            if (!(operator13 != null ? !operator13.equals(operator14) : operator14 != null)) {
                                string = "Operator.TIMES";
                            } else {
                                Operator operator15 = Operator.TEXT_APPEND;
                                Operator operator16 = operator2;
                                if (!(operator15 != null ? !operator15.equals(operator16) : operator16 != null)) {
                                    string = "Operator.TEXT_APPEND";
                                } else {
                                    Operator operator17 = Operator.LIST_APPEND;
                                    Operator operator18 = operator2;
                                    if (!(operator17 != null ? !operator17.equals(operator18) : operator18 != null)) {
                                        string = "Operator.LIST_APPEND";
                                    } else {
                                        Operator operator19 = Operator.COMBINE;
                                        Operator operator20 = operator2;
                                        if (!(operator19 != null ? !operator19.equals(operator20) : operator20 != null)) {
                                            string = "Operator.COMBINE";
                                        } else {
                                            Operator operator21 = Operator.PREFER;
                                            Operator operator22 = operator2;
                                            if (!(operator21 != null ? !operator21.equals(operator22) : operator22 != null)) {
                                                string = "Operator.PREFER";
                                            } else {
                                                Operator operator23 = Operator.COMBINE_TYPES;
                                                Operator operator24 = operator2;
                                                if (!(operator23 != null ? !operator23.equals(operator24) : operator24 != null)) {
                                                    string = "Operator.COMBINE_TYPES";
                                                } else {
                                                    Operator operator25 = Operator.IMPORT_ALT;
                                                    Operator operator26 = operator2;
                                                    if (!(operator25 != null ? !operator25.equals(operator26) : operator26 != null)) {
                                                        string = "Operator.IMPORT_ALT";
                                                    } else {
                                                        Operator operator27 = Operator.EQUIVALENT;
                                                        Operator operator28 = operator2;
                                                        if (!(operator27 != null ? !operator27.equals(operator28) : operator28 != null)) {
                                                            string = "Operator.EQUIVALENT";
                                                        } else {
                                                            Operator operator29 = Operator.COMPLETE;
                                                            Operator operator30 = operator2;
                                                            if (!(operator29 != null ? !operator29.equals(operator30) : operator30 != null)) {
                                                                string = "Operator.COMPLETE";
                                                            } else {
                                                                throw new MatchError((Object)operator2);
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        String operatorCode = string;
        return lhs.merge(rhs, (Function2<String, String, String>)(Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String lhsContent = (String)tuple2._1();
            String rhsContent = (String)tuple2._2();
            return "Expr.makeOperatorApplication(" + operatorCode + ", " + lhsContent + ", " + rhsContent + ")";
        });
    }

    public Code onIf(Code predicate, Code thenValue, Code elseValue) {
        if (elseValue == null) {
            throw new RuntimeException(predicate.toString());
        }
        return predicate.merge(thenValue, elseValue, (Function3<String, String, String, String>)(Function3 & Serializable)(x$1, x$2, x$3) -> {
            Tuple3 tuple3 = Tuple3$.MODULE$.apply(x$1, x$2, x$3);
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            String predicateContent = (String)tuple3._1();
            String thenValueContent = (String)tuple3._2();
            String elseValueContent = (String)tuple3._3();
            return "Expr.makeIf(" + predicateContent + ", " + thenValueContent + ", " + elseValueContent + ")";
        });
    }

    public Code onAnnotated(Code base, Code tpe) {
        throw this.unsupported();
    }

    public Code onAssert(Code base) {
        throw this.unsupported();
    }

    public Code onMerge(Code handlers, Code union, Code tpe) {
        return handlers.merge(union, tpe, (Function3<String, String, String, String>)(Function3 & Serializable)(x$1, x$2, x$3) -> {
            Tuple3 tuple3 = Tuple3$.MODULE$.apply(x$1, x$2, x$3);
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            String handlersContent = (String)tuple3._1();
            String unionContent = (String)tuple3._2();
            String tpeContent = (String)tuple3._3();
            return "Expr.makeMerge(" + handlersContent + ", " + unionContent + ", " + tpeContent + ")";
        });
    }

    public Code onToMap(Code base, Code tpe) {
        throw this.unsupported();
    }

    public Code onWith(Code base, String[] path, Code value) {
        throw this.unsupported();
    }

    public Code onMissingImport(Expr.ImportMode mode, byte[] hash) {
        throw this.unsupported();
    }

    public Code onEnvImport(String value, Expr.ImportMode mode, byte[] hash) {
        throw this.unsupported();
    }

    public Code onLocalImport(Path path, Expr.ImportMode mode, byte[] hash) {
        throw this.unsupported();
    }

    public Code onClasspathImport(Path path, Expr.ImportMode mode, byte[] hash) {
        throw this.unsupported();
    }

    public Code onRemoteImport(URI url, Code using, Expr.ImportMode mode, byte[] hash) {
        throw this.unsupported();
    }
}

