/*
 * Decompiled with CFR 0.152.
 */
package org.dhallj.jawn;

import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.Deque;
import org.dhallj.core.converters.JsonHandler;
import org.typelevel.jawn.FContext;
import org.typelevel.jawn.Facade;

public class FacadeHandler<J>
implements JsonHandler {
    private final Facade<J> facade;
    private final Deque stack;

    public <J> FacadeHandler(Facade<J> facade) {
        this.facade = facade;
        this.stack = new ArrayDeque();
    }

    public final Deque<FContext<J>> stack() {
        return this.stack;
    }

    public final int position() {
        return 0;
    }

    public void addValue(J value) {
        if (this.stack().isEmpty()) {
            this.stack().push(this.facade.singleContext(this.position()));
        }
        this.stack().peek().add(value, this.position());
    }

    public final J result() {
        return (J)this.stack().pop().finish(this.position());
    }

    public final void onNull() {
        this.addValue(this.facade.jnull(this.position()));
    }

    public final void onBoolean(boolean value) {
        this.addValue(value ? this.facade.jtrue(this.position()) : this.facade.jfalse(this.position()));
    }

    public void onNumber(BigInteger value) {
        this.addValue(this.facade.jnum((CharSequence)value.toString(), -1, -1, this.position()));
    }

    public void onDouble(double value) {
        if (Double.isFinite(value)) {
            String asString = Double.toString(value);
            this.addValue(this.facade.jnum((CharSequence)asString, asString.indexOf(46), asString.indexOf(69), this.position()));
        } else {
            this.addValue(this.facade.jnull(this.position()));
        }
    }

    public void onString(String value) {
        this.addValue(this.facade.jstring((CharSequence)value, this.position()));
    }

    public final void onArrayStart() {
        this.stack().push(this.facade.arrayContext(this.position()));
    }

    public final void onArrayEnd() {
        FContext<J> current = this.stack().pop();
        if (this.stack().isEmpty()) {
            this.stack().push(current);
        } else {
            this.stack().peek().add(current.finish(this.position()), this.position());
        }
    }

    public final void onArrayElementGap() {
    }

    public final void onObjectStart() {
        this.stack().push(this.facade.objectContext(this.position()));
    }

    public final void onObjectEnd() {
        FContext<J> current = this.stack().pop();
        if (this.stack().isEmpty()) {
            this.stack().push(current);
        } else {
            this.stack().peek().add(current.finish(this.position()), this.position());
        }
    }

    public final void onObjectField(String name) {
        this.stack().peek().add((CharSequence)name, this.position());
    }

    public final void onObjectFieldGap() {
    }
}

