/*
 * Decompiled with CFR 0.152.
 */
package org.dhallj.parser.support;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dhallj.core.DhallException;
import org.dhallj.core.Expr;
import org.dhallj.core.Operator;
import org.dhallj.core.Source;
import org.dhallj.parser.support.LetBinding;
import org.dhallj.parser.support.Token;

final class ParsingHelpers {
    ParsingHelpers() {
    }

    private static Source sourceFromToken(Token token) {
        return Source.fromString((String)token.image, (int)token.beginLine, (int)token.beginColumn, (int)token.endLine, (int)token.endColumn);
    }

    private static Source sourceFromTokens(Token token, Token token2) {
        return Source.fromString((String)(token.image + token2.image), (int)token.beginLine, (int)token.beginColumn, (int)token2.endLine, (int)token2.endColumn);
    }

    static final Expr.Parsed makeDoubleLiteral(Token token) {
        double d = Double.parseDouble(token.image);
        if (Double.isInfinite(d) && !token.image.equals("Infinity") && !token.image.equals("-Infinity")) {
            throw new DhallException.ParsingFailure("double out of bounds");
        }
        return new Expr.Parsed(Expr.makeDoubleLiteral((double)d), ParsingHelpers.sourceFromToken(token));
    }

    static final Expr.Parsed makeNaturalLiteral(Token token) {
        BigInteger bigInteger = token.image.startsWith("0x") ? new BigInteger(token.image.substring(2), 16) : new BigInteger(token.image);
        return new Expr.Parsed(Expr.makeNaturalLiteral((BigInteger)bigInteger), ParsingHelpers.sourceFromToken(token));
    }

    static final Expr.Parsed makeIntegerLiteral(Token token) {
        BigInteger bigInteger = token.image.startsWith("0x") ? new BigInteger(token.image.substring(2), 16) : (token.image.startsWith("-0x") ? new BigInteger(token.image.substring(3), 16).negate() : new BigInteger(token.image));
        return new Expr.Parsed(Expr.makeIntegerLiteral((BigInteger)bigInteger), ParsingHelpers.sourceFromToken(token));
    }

    static final boolean isValidDate(int n, int n2, int n3) {
        if (n2 > 0 && n2 <= 12) {
            if (n3 > 0 && n3 < 29) {
                return true;
            }
            if (n3 == 29) {
                if (n2 == 2) {
                    if (n % 4 != 0) {
                        return false;
                    }
                    if (n % 100 != 0) {
                        return true;
                    }
                    return n % 400 == 0;
                }
                return true;
            }
            if (n3 == 30) {
                return n2 != 2;
            }
            if (n3 == 31) {
                return n2 == 1 || n2 == 3 || n2 == 5 || n2 == 7 || n2 == 8 || n2 == 10 || n2 == 12;
            }
            return false;
        }
        return false;
    }

    static final Expr.Parsed makeDateLiteral(Token token) {
        int n;
        int n2;
        int n3 = Integer.parseInt(token.image.substring(0, 4));
        if (!ParsingHelpers.isValidDate(n3, n2 = Integer.parseInt(token.image.substring(5, 7)), n = Integer.parseInt(token.image.substring(8, 10)))) {
            throw new DhallException.ParsingFailure("Invalid temporal literal");
        }
        return new Expr.Parsed(Expr.makeDateLiteral((int)n3, (int)n2, (int)n), ParsingHelpers.sourceFromToken(token));
    }

    static final Expr.Parsed makeTimeZoneLiteral(Token token) {
        boolean bl = token.image.charAt(0) == '+';
        int n = Integer.parseInt(token.image.substring(1, 3));
        int n2 = Integer.parseInt(token.image.substring(4, 6));
        if (n > 23 || n2 > 59) {
            throw new DhallException.ParsingFailure("Invalid temporal literal");
        }
        int n3 = n * 60 + n2;
        int n4 = bl ? n3 : -n3;
        return new Expr.Parsed(Expr.makeTimeZoneLiteral((int)n4), ParsingHelpers.sourceFromToken(token));
    }

    static final Expr.Parsed makeTimeLiteral(Token token, Token token2) {
        int n = Integer.parseInt(token.image.substring(0, 2));
        int n2 = Integer.parseInt(token.image.substring(3, 5));
        int n3 = Integer.parseInt(token.image.substring(6, 8));
        if (n > 23 || n2 > 59 || n3 > 59) {
            throw new DhallException.ParsingFailure("Invalid temporal literal");
        }
        BigDecimal bigDecimal = token.image.length() > 8 ? new BigDecimal(token.image.substring(8)) : BigDecimal.ZERO;
        Expr expr = Expr.makeTimeLiteral((int)n, (int)n2, (int)n3, (BigDecimal)bigDecimal);
        if (token2 != null) {
            int n4;
            if (token2.image.equals("z") || token2.image.equals("Z")) {
                n4 = 0;
            } else if (token2.image.startsWith("+") || token2.image.startsWith("-")) {
                boolean bl = token2.image.charAt(0) == '+';
                int n5 = Integer.parseInt(token2.image.substring(1, 3));
                int n6 = Integer.parseInt(token2.image.substring(4, 6));
                int n7 = n5 * 60 + n6;
                n4 = bl ? n7 : -n7;
            } else {
                throw new DhallException.ParsingFailure("Invalid temporal offset: " + token2.image);
            }
            ArrayList<AbstractMap.SimpleImmutableEntry<String, Expr>> arrayList = new ArrayList<AbstractMap.SimpleImmutableEntry<String, Expr>>(2);
            arrayList.add(new AbstractMap.SimpleImmutableEntry<String, Expr>("time", expr));
            arrayList.add(new AbstractMap.SimpleImmutableEntry<String, Expr>("timeZone", Expr.makeTimeZoneLiteral((int)n4)));
            return new Expr.Parsed(Expr.makeRecordLiteral(arrayList), ParsingHelpers.sourceFromTokens(token, token2));
        }
        return new Expr.Parsed(expr, ParsingHelpers.sourceFromToken(token));
    }

    static final Expr.Parsed makeDateTimeLiteral(Token token, Token token2) {
        int n = Integer.parseInt(token.image.substring(0, 4));
        int n2 = Integer.parseInt(token.image.substring(5, 7));
        int n3 = Integer.parseInt(token.image.substring(8, 10));
        int n4 = Integer.parseInt(token.image.substring(11, 13));
        int n5 = Integer.parseInt(token.image.substring(14, 16));
        int n6 = Integer.parseInt(token.image.substring(17, 19));
        if (!ParsingHelpers.isValidDate(n, n2, n3) || n4 > 23 || n5 > 59 || n6 > 59) {
            throw new DhallException.ParsingFailure("Invalid temporal literal");
        }
        BigDecimal bigDecimal = token.image.length() > 19 ? new BigDecimal(token.image.substring(19)) : BigDecimal.ZERO;
        ArrayList<AbstractMap.SimpleImmutableEntry<String, Expr>> arrayList = new ArrayList<AbstractMap.SimpleImmutableEntry<String, Expr>>(2);
        arrayList.add(new AbstractMap.SimpleImmutableEntry<String, Expr>("date", Expr.makeDateLiteral((int)n, (int)n2, (int)n3)));
        arrayList.add(new AbstractMap.SimpleImmutableEntry<String, Expr>("time", Expr.makeTimeLiteral((int)n4, (int)n5, (int)n6, (BigDecimal)bigDecimal)));
        if (token2 != null) {
            int n7;
            if (token2.image.equals("z") || token2.image.equals("Z")) {
                n7 = 0;
            } else if (token2.image.startsWith("+") || token2.image.startsWith("-")) {
                boolean bl = token2.image.charAt(0) == '+';
                int n8 = Integer.parseInt(token2.image.substring(1, 3));
                int n9 = Integer.parseInt(token2.image.substring(4, 6));
                int n10 = n8 * 60 + n9;
                n7 = bl ? n10 : -n10;
            } else {
                throw new DhallException.ParsingFailure("Invalid temporal offset: " + token2.image);
            }
            arrayList.add(new AbstractMap.SimpleImmutableEntry<String, Expr>("timeZone", Expr.makeTimeZoneLiteral((int)n7)));
        }
        Source source = token2 == null ? ParsingHelpers.sourceFromToken(token) : ParsingHelpers.sourceFromTokens(token, token2);
        return new Expr.Parsed(Expr.makeRecordLiteral(arrayList), source);
    }

    private static String unescapeText(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\\') {
                char c;
                if ((c = string.charAt(++i)) == '\"' || c == '$' || c == '/') {
                    stringBuilder.append(c);
                    continue;
                }
                if (c == 'u') {
                    int n;
                    char c2 = string.charAt(i + 1);
                    if (c2 == '{') {
                        n = 0;
                        while (string.charAt(i + 2 + n) != '}') {
                            ++n;
                        }
                        int n2 = Integer.parseInt(string.substring(i + 2, i + 2 + n), 16);
                        stringBuilder.appendCodePoint(n2);
                        i += n + 2;
                        continue;
                    }
                    n = Integer.parseInt(string.substring(i + 1, i + 5), 16);
                    stringBuilder.append((char)n);
                    i += 4;
                    continue;
                }
                stringBuilder.append('\\');
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append(string.charAt(i));
        }
        return stringBuilder.toString();
    }

    static final Expr.Parsed makeTextLiteral(List<Map.Entry<String, Expr.Parsed>> list, Token token, Token token2) {
        Source source = Source.fromString((String)"", (int)token.beginLine, (int)token.beginColumn, (int)token2.endLine, (int)token2.endColumn);
        ArrayList<String> arrayList = new ArrayList<String>(1);
        ArrayList<Expr.Parsed> arrayList2 = new ArrayList<Expr.Parsed>();
        boolean bl = true;
        for (Map.Entry<String, Expr.Parsed> entry : list) {
            if (entry.getKey() == null) {
                if (bl) {
                    arrayList.add("");
                }
                arrayList2.add(entry.getValue());
                bl = true;
                continue;
            }
            arrayList.add(ParsingHelpers.unescapeText(entry.getKey()));
            bl = false;
        }
        if (arrayList2.size() == arrayList.size()) {
            arrayList.add("");
        }
        return new Expr.Parsed(Expr.makeTextLiteral((String[])arrayList.toArray(new String[arrayList.size()]), arrayList2), source);
    }

    static final void dedent(String[] stringArray) {
        CharSequence charSequence;
        int n;
        List<Character> list = null;
        String[][] stringArrayArray = new String[stringArray.length][];
        for (n = 0; n < stringArray.length; ++n) {
            int n2;
            charSequence = stringArray[n].replace("\r\n", "\n");
            String[] stringArray2 = ((String)charSequence).split("\n", -1);
            stringArrayArray[n] = stringArray2;
            int n3 = n2 = n == 0 ? 0 : 1;
            while (n2 < stringArray2.length) {
                String string = stringArray2[n2];
                if (string.length() > 0 || n2 == stringArray2.length - 1) {
                    int n4;
                    if (list == null) {
                        char c;
                        list = new ArrayList();
                        for (n4 = 0; n4 < string.length() && ((c = string.charAt(n4)) == ' ' || c == '\t'); ++n4) {
                            list.add(Character.valueOf(c));
                        }
                    } else {
                        for (n4 = 0; n4 < list.size(); ++n4) {
                            if (n4 != string.length() && string.charAt(n4) == ((Character)list.get(n4)).charValue()) continue;
                            list = list.subList(0, n4);
                            break;
                        }
                    }
                }
                ++n2;
            }
        }
        int n5 = n = list == null ? 0 : list.size();
        if (n == 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = ParsingHelpers.reEscape(stringArray[i]);
            }
        } else {
            charSequence = new StringBuilder();
            for (int i = 0; i < stringArray.length; ++i) {
                ((StringBuilder)charSequence).setLength(0);
                String[] stringArray3 = stringArrayArray[i];
                for (int j = 0; j < stringArray3.length; ++j) {
                    if (stringArray3[j].length() != 0) {
                        if (i > 0 && j == 0) {
                            ((StringBuilder)charSequence).append(stringArray3[j]);
                        } else {
                            ((StringBuilder)charSequence).append(stringArray3[j].substring(n));
                        }
                    }
                    if (j >= stringArray3.length - 1) continue;
                    ((StringBuilder)charSequence).append("\n");
                }
                stringArray[i] = ParsingHelpers.reEscape(((StringBuilder)charSequence).toString());
            }
        }
    }

    static final String reEscape(String string) {
        return string.replace("\\", "\\\\").replace("\n", "\\n").replace("\t", "\\t");
    }

    static final Expr.Parsed makeSingleQuotedTextLiteral(List<Map.Entry<String, Expr.Parsed>> list, Token token) {
        Source source = ParsingHelpers.sourceFromToken(token);
        Collections.reverse(list);
        ArrayList<String> arrayList = new ArrayList<String>(1);
        ArrayList<Expr.Parsed> arrayList2 = new ArrayList<Expr.Parsed>();
        for (Map.Entry<String, Expr.Parsed> entry : list) {
            if (entry.getKey() == null) {
                if (arrayList.isEmpty()) {
                    arrayList.add("");
                }
                arrayList2.add(entry.getValue());
                continue;
            }
            if (arrayList.size() > arrayList2.size()) {
                arrayList.set(arrayList.size() - 1, (String)arrayList.get(arrayList.size() - 1) + entry.getKey());
                continue;
            }
            arrayList.add(entry.getKey());
        }
        if (arrayList2.size() == arrayList.size()) {
            arrayList.add("");
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        ParsingHelpers.dedent(stringArray);
        return new Expr.Parsed(Expr.makeTextLiteral((String[])stringArray, arrayList2), source);
    }

    static final Expr.Parsed makeApplication(Expr.Parsed parsed, Expr.Parsed parsed2, Token token) {
        return new Expr.Parsed(Expr.makeApplication((Expr)parsed, (Expr)parsed2), (Source)new ESESource(parsed, token.image, parsed2));
    }

    static final Expr.Parsed makeOperatorApplication(Operator operator, Expr.Parsed parsed, Expr.Parsed parsed2, String string, Token token, Token token2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (token != null) {
            stringBuilder.append(token.image);
        }
        stringBuilder.append(string);
        if (token2 != null) {
            stringBuilder.append(token2.image);
        }
        ESESource eSESource = new ESESource(parsed, stringBuilder.toString(), parsed2);
        return new Expr.Parsed(Expr.makeOperatorApplication((Operator)operator, (Expr)parsed, (Expr)parsed2), (Source)eSESource);
    }

    static final Expr.Parsed makeAnnotated(Expr.Parsed parsed, Expr.Parsed parsed2, Token token, Token token2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (token != null) {
            stringBuilder.append(token.image);
        }
        stringBuilder.append(':');
        stringBuilder.append(token2.image);
        ESESource eSESource = new ESESource(parsed, stringBuilder.toString(), parsed2);
        return new Expr.Parsed(Expr.makeAnnotated((Expr)parsed, (Expr)parsed2), (Source)eSESource);
    }

    static final Expr.Parsed makeToMap(Expr.Parsed parsed, Expr.Parsed parsed2, Token token, Token token2, Token token3, Token token4) {
        StringBuilder stringBuilder = new StringBuilder();
        if (token3 != null) {
            stringBuilder.append(token3.image);
        }
        if (token4 != null) {
            stringBuilder.append(":");
            stringBuilder.append(token4.image);
        }
        Source source = parsed2 != null ? new SESESource(token.image + token2.image, parsed, stringBuilder.toString(), parsed2, token.beginLine, token.beginColumn) : new SESource(token.image + token2.image, parsed, token.beginLine, token.beginColumn);
        return new Expr.Parsed(Expr.makeToMap((Expr)parsed, (Expr)parsed2), source);
    }

    static final Expr.Parsed makeToMap(Expr.Parsed parsed, Token token, Token token2) {
        SESource sESource = new SESource(token.image + token2.image, parsed, token.beginLine, token.beginColumn);
        return new Expr.Parsed(Expr.makeToMap((Expr)parsed), (Source)sESource);
    }

    static final Expr.Parsed makeMerge(Expr.Parsed parsed, Expr.Parsed parsed2, Expr.Parsed parsed3, Token token, Token token2, Token token3, Token token4, Token token5) {
        Source source;
        if (parsed3 != null) {
            StringBuilder stringBuilder = new StringBuilder();
            if (token4 != null) {
                stringBuilder.append(token4.image);
            }
            stringBuilder.append(":");
            stringBuilder.append(token5.image);
            source = new SESESESource(token.image + token2.image, parsed, token3.image, parsed2, stringBuilder.toString(), parsed3, token.beginLine, token.beginColumn);
        } else {
            source = new SESESource(token.image + token2.image, parsed, token3.image, parsed2, token.beginLine, token.beginColumn);
        }
        return new Expr.Parsed(Expr.makeMerge((Expr)parsed, (Expr)parsed2, (Expr)parsed3), source);
    }

    static final Expr.Parsed makeLambda(String string, Expr.Parsed parsed, Expr.Parsed parsed2, Token token) {
        Source source = Source.fromString((String)"", (int)token.beginLine, (int)token.beginColumn, (int)parsed2.getSource().getEndLine(), (int)parsed2.getSource().getEndColumn());
        return new Expr.Parsed(Expr.makeLambda((String)string, (Expr)parsed, (Expr)parsed2), source);
    }

    static final Expr.Parsed makePi(String string, Expr.Parsed parsed, Expr.Parsed parsed2, Token token) {
        Source source = Source.fromString((String)"", (int)token.beginLine, (int)token.beginColumn, (int)parsed2.getSource().getEndLine(), (int)parsed2.getSource().getEndColumn());
        return new Expr.Parsed(Expr.makePi((String)string, (Expr)parsed, (Expr)parsed2), source);
    }

    static final Expr.Parsed makePi(Expr.Parsed parsed, Expr.Parsed parsed2) {
        Source source = Source.fromString((String)"", (int)parsed.getSource().getBeginLine(), (int)parsed.getSource().getBeginColumn(), (int)parsed2.getSource().getEndLine(), (int)parsed2.getSource().getEndColumn());
        return new Expr.Parsed(Expr.makePi((Expr)parsed, (Expr)parsed2), source);
    }

    static final Expr.Parsed makeIf(Expr.Parsed parsed, Expr.Parsed parsed2, Expr.Parsed parsed3, Token token) {
        Source source = Source.fromString((String)"", (int)token.beginLine, (int)token.beginColumn, (int)parsed3.getSource().getEndLine(), (int)parsed3.getSource().getEndColumn());
        return new Expr.Parsed(Expr.makeIf((Expr)parsed, (Expr)parsed2, (Expr)parsed3), source);
    }

    static final Expr.Parsed makeLet(List<LetBinding> list, Expr.Parsed parsed, String string) {
        Collections.reverse(list);
        Expr.Parsed parsed2 = parsed;
        String string2 = string;
        for (LetBinding letBinding : list) {
            Source source = letBinding.type == null ? new SESESource(letBinding.text1, letBinding.value, letBinding.text2 + string2, parsed2, letBinding.beginLine, letBinding.beginColumn) : new SESESESource(letBinding.text0, letBinding.type, letBinding.text1, letBinding.value, letBinding.text2 + string2, parsed2, letBinding.beginLine, letBinding.beginColumn);
            parsed2 = new Expr.Parsed(Expr.makeLet((String)letBinding.name, (Expr)letBinding.type, (Expr)letBinding.value, (Expr)parsed2), source);
            string2 = "";
        }
        return parsed2;
    }

    static Expr.Parsed makeAssert(Expr.Parsed parsed, Token token, Token token2, Token token3) {
        StringBuilder stringBuilder = new StringBuilder("assert");
        if (token2 != null) {
            stringBuilder.append(token2.image);
        }
        stringBuilder.append(':');
        stringBuilder.append(token3.image);
        SESource sESource = new SESource(stringBuilder.toString(), parsed, token.beginLine, token.beginColumn);
        return new Expr.Parsed(Expr.makeAssert((Expr)parsed), (Source)sESource);
    }

    static Expr.Parsed makeFieldAccess(Expr.Parsed parsed, String string, Token token, Token token2, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (token != null) {
            stringBuilder.append(token.image);
        }
        stringBuilder.append('.');
        if (token2 != null) {
            stringBuilder.append(token2.image);
        }
        stringBuilder.append(string);
        ESSource eSSource = new ESSource(parsed, stringBuilder.toString(), n, n2);
        return new Expr.Parsed(Expr.makeFieldAccess((Expr)parsed, (String)string), (Source)eSSource);
    }

    static Expr.Parsed makeProjection(Expr.Parsed parsed, List<String> list, int n, int n2) {
        Source source = Source.fromString((String)"", (int)parsed.getSource().getBeginLine(), (int)parsed.getSource().getBeginColumn(), (int)n, (int)n2);
        return new Expr.Parsed(Expr.makeProjection((Expr)parsed, (String[])list.toArray(new String[list.size()])), source);
    }

    static Expr.Parsed makeProjectionByType(Expr.Parsed parsed, Expr.Parsed parsed2, int n, int n2) {
        Source source = Source.fromString((String)"", (int)parsed.getSource().getBeginLine(), (int)parsed.getSource().getBeginColumn(), (int)n, (int)n2);
        return new Expr.Parsed(Expr.makeProjectionByType((Expr)parsed, (Expr)parsed2), source);
    }

    private static final boolean isBuiltIn(String string) {
        return string.charAt(0) != '`' && Expr.Constants.isBuiltIn((String)string);
    }

    private static final String unescapeLabel(String string) {
        return string.charAt(0) != '`' ? string : string.substring(1, string.length() - 1);
    }

    static final Expr.Parsed makeBuiltInOrIdentifier(Token token) {
        if (ParsingHelpers.isBuiltIn(token.image)) {
            return new Expr.Parsed(Expr.makeBuiltIn((String)token.image), ParsingHelpers.sourceFromToken(token));
        }
        return new Expr.Parsed(Expr.makeIdentifier((String)ParsingHelpers.unescapeLabel(token.image)), ParsingHelpers.sourceFromToken(token));
    }

    static final Expr.Parsed makeIdentifier(Token token, Token token2, Token token3, Token token4) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(token.image);
        if (token2 != null) {
            stringBuilder.append(token2.image);
        }
        stringBuilder.append("@");
        if (token3 != null) {
            stringBuilder.append(token3.image);
        }
        stringBuilder.append(token4.image);
        Source source = Source.fromString((String)stringBuilder.toString(), (int)token.beginLine, (int)token.beginColumn, (int)token4.endLine, (int)token4.endColumn);
        long l = token4.image.startsWith("0x") ? Long.parseLong(token4.image.substring(2), 16) : Long.parseLong(token4.image);
        return new Expr.Parsed(Expr.makeIdentifier((String)ParsingHelpers.unescapeLabel(token.image), (long)l), source);
    }

    static final Expr.Parsed makeRecordLiteral(List<Map.Entry<List<String>, Expr.Parsed>> list, Token token, Token token2) {
        Expr expr;
        Object object;
        Object object2;
        int n = token2 == null ? token.endLine : token2.endLine;
        int n2 = token2 == null ? token.endColumn : token2.endColumn;
        Source source = Source.fromString((String)"", (int)token.beginLine, (int)token.beginColumn, (int)n, (int)n2);
        ArrayList<AbstractMap.SimpleImmutableEntry<Object, Expr>> arrayList = new ArrayList<AbstractMap.SimpleImmutableEntry<Object, Expr>>(list.size());
        for (Map.Entry<List<String>, Expr.Parsed> object32 : list) {
            List<String> i = object32.getKey();
            object2 = i.remove(0);
            object = (Expr)object32.getValue();
            expr = object == null ? Expr.makeIdentifier((String)object2) : object;
            if (i.isEmpty()) {
                arrayList.add(new AbstractMap.SimpleImmutableEntry<Object, Expr>(object2, expr));
                continue;
            }
            Collections.reverse(i);
            Expr expr2 = expr;
            for (String string : i) {
                expr2 = Expr.makeRecordLiteral((String)string, (Expr)expr2);
            }
            arrayList.add(new AbstractMap.SimpleImmutableEntry<Object, Expr>(object2, expr2));
        }
        ArrayList arrayList2 = new ArrayList(arrayList.size());
        HashSet<Expr> hashSet = new HashSet<Expr>();
        for (int i = 0; i < arrayList.size(); ++i) {
            object2 = (Map.Entry)arrayList.get(i);
            object = (String)object2.getKey();
            if (hashSet.contains(object)) continue;
            expr = (Expr)object2.getValue();
            for (int j = i + 1; j < arrayList.size(); ++j) {
                Map.Entry entry = (Map.Entry)arrayList.get(j);
                if (!((String)entry.getKey()).equals(object2.getKey())) continue;
                expr = Expr.makeOperatorApplication((Operator)Operator.COMBINE, (Expr)expr, (Expr)((Expr)entry.getValue()));
            }
            arrayList2.add(new AbstractMap.SimpleImmutableEntry<Expr, Expr>((Expr)object, expr));
            hashSet.add((Expr)object);
        }
        return new Expr.Parsed(Expr.makeRecordLiteral((Collection)arrayList2), source);
    }

    static final Expr.Parsed makeRecordType(List<Map.Entry<String, Expr.Parsed>> list, Token token, Token token2) {
        int n = token2 == null ? token.endLine : token2.endLine;
        int n2 = token2 == null ? token.endColumn : token2.endColumn;
        Source source = Source.fromString((String)"", (int)token.beginLine, (int)token.beginColumn, (int)n, (int)n2);
        return new Expr.Parsed(Expr.makeRecordType(list), source);
    }

    static final Expr.Parsed makeUnionType(List<Map.Entry<String, Expr.Parsed>> list, Token token, Token token2) {
        int n = token2 == null ? token.endLine : token2.endLine;
        int n2 = token2 == null ? token.endColumn : token2.endColumn;
        Source source = Source.fromString((String)"", (int)token.beginLine, (int)token.beginColumn, (int)n, (int)n2);
        return new Expr.Parsed(Expr.makeUnionType(list), source);
    }

    static final Expr.Parsed makeWith(Expr expr, List<String> list, Expr.Parsed parsed, Token token) {
        Source source = ParsingHelpers.sourceFromToken(token);
        return new Expr.Parsed(Expr.makeWith((Expr)expr, (String[])list.toArray(new String[list.size()]), (Expr)parsed), source);
    }

    static final Expr.Parsed makeNonEmptyListLiteral(List<Expr.Parsed> list, List<String> list2, Token token, Token token2) {
        InterspersedSource interspersedSource = new InterspersedSource(list2, list, token.beginLine, token.beginColumn, token2.endLine, token2.endColumn);
        return new Expr.Parsed(Expr.makeNonEmptyListLiteral((Expr[])((Expr[])list.toArray(new Expr.Parsed[list.size()]))), (Source)interspersedSource);
    }

    static final Expr.Parsed makeEmptyListLiteral(Expr.Parsed parsed, String string, Token token) {
        SESource sESource = new SESource(string, parsed, token.beginLine, token.beginColumn);
        return new Expr.Parsed(Expr.makeEmptyListLiteral((Expr)parsed), (Source)sESource);
    }

    static final Expr.Parsed makeParenthesized(Expr.Parsed parsed, Token token, Token token2) {
        SESSource sESSource = new SESSource("(", parsed, ")", token.beginLine, token.beginColumn, token2.endLine, token2.endColumn);
        return new Expr.Parsed((Expr)parsed, (Source)sESSource);
    }

    static final Expr.Parsed makeImport(Token token, Token token2, Token token3, Expr.Parsed parsed) {
        Expr.ImportMode importMode;
        Source source = ParsingHelpers.sourceFromToken(token);
        byte[] byArray = token2 == null ? null : Expr.Util.decodeHashBytes((String)token2.image.substring(7));
        Expr expr = null;
        Expr.ImportMode importMode2 = token3 == null ? Expr.ImportMode.CODE : (importMode = token3.image.equals("Text") ? Expr.ImportMode.RAW_TEXT : Expr.ImportMode.LOCATION);
        if (token.image.equals("missing")) {
            expr = Expr.makeMissingImport((Expr.ImportMode)importMode, (byte[])byArray);
        } else {
            if (token.image.startsWith("http")) {
                try {
                    expr = Expr.makeRemoteImport((URI)new URI(token.image), (Expr)parsed, (Expr.ImportMode)importMode, (byte[])byArray);
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new DhallException.ParsingFailure("Invalid URL", (Throwable)uRISyntaxException);
                }
            }
            if (token.image.startsWith("env:")) {
                expr = Expr.makeEnvImport((String)token.image.substring(4), (Expr.ImportMode)importMode, (byte[])byArray);
            } else if (token.image.startsWith("classpath:")) {
                expr = Expr.makeClasspathImport((Path)Paths.get(token.image.substring(10), new String[0]), (Expr.ImportMode)importMode, (byte[])byArray);
            } else {
                try {
                    expr = Expr.makeLocalImport((Path)Paths.get(token.image, new String[0]), (Expr.ImportMode)importMode, (byte[])byArray);
                }
                catch (InvalidPathException invalidPathException) {
                    throw new DhallException.ParsingFailure("Invalid path", (Throwable)invalidPathException);
                }
            }
        }
        return new Expr.Parsed(expr, source);
    }

    private static final class InterspersedSource
    extends Source {
        private final List<String> i0;
        private final List<Expr.Parsed> i1;

        InterspersedSource(List<String> list, List<Expr.Parsed> list2, int n, int n2, int n3, int n4) {
            super(n, n2, n3, n4);
            this.i0 = list;
            this.i1 = list2;
        }

        public final void printText(StringBuilder stringBuilder) {
            Iterator<String> iterator = this.i0.iterator();
            Iterator<Expr.Parsed> iterator2 = this.i1.iterator();
            while (iterator.hasNext() && iterator2.hasNext()) {
                stringBuilder.append(iterator.next());
                iterator2.next().getSource().printText(stringBuilder);
            }
            if (iterator.hasNext()) {
                stringBuilder.append(iterator.next());
            }
        }
    }

    private static final class SESESESource
    extends Source {
        private final String i0;
        private final Expr.Parsed i1;
        private final String i2;
        private final Expr.Parsed i3;
        private final String i4;
        private final Expr.Parsed i5;

        SESESESource(String string, Expr.Parsed parsed, String string2, Expr.Parsed parsed2, String string3, Expr.Parsed parsed3, int n, int n2) {
            super(n, n2, parsed3.getSource().getEndLine(), parsed3.getSource().getEndColumn());
            this.i0 = string;
            this.i1 = parsed;
            this.i2 = string2;
            this.i3 = parsed2;
            this.i4 = string3;
            this.i5 = parsed3;
        }

        public final void printText(StringBuilder stringBuilder) {
            stringBuilder.append(this.i0);
            this.i1.getSource().printText(stringBuilder);
            stringBuilder.append(this.i2);
            this.i3.getSource().printText(stringBuilder);
            stringBuilder.append(this.i4);
            this.i5.getSource().printText(stringBuilder);
        }
    }

    private static final class SESESource
    extends Source {
        private final String i0;
        private final Expr.Parsed i1;
        private final String i2;
        private final Expr.Parsed i3;

        SESESource(String string, Expr.Parsed parsed, String string2, Expr.Parsed parsed2, int n, int n2) {
            super(n, n2, parsed2.getSource().getEndLine(), parsed2.getSource().getEndColumn());
            this.i0 = string;
            this.i1 = parsed;
            this.i2 = string2;
            this.i3 = parsed2;
        }

        public final void printText(StringBuilder stringBuilder) {
            stringBuilder.append(this.i0);
            this.i1.getSource().printText(stringBuilder);
            stringBuilder.append(this.i2);
            this.i3.getSource().printText(stringBuilder);
        }
    }

    private static final class SESSource
    extends Source {
        private final String i0;
        private final Expr.Parsed i1;
        private final String i2;

        SESSource(String string, Expr.Parsed parsed, String string2, int n, int n2, int n3, int n4) {
            super(n, n2, n3, n4);
            this.i0 = string;
            this.i1 = parsed;
            this.i2 = string2;
        }

        public final void printText(StringBuilder stringBuilder) {
            stringBuilder.append(this.i0);
            this.i1.getSource().printText(stringBuilder);
            stringBuilder.append(this.i2);
        }
    }

    private static final class SESource
    extends Source {
        private final String i0;
        private final Expr.Parsed i1;

        SESource(String string, Expr.Parsed parsed, int n, int n2) {
            super(n, n2, parsed.getSource().getEndLine(), parsed.getSource().getEndColumn());
            this.i0 = string;
            this.i1 = parsed;
        }

        public final void printText(StringBuilder stringBuilder) {
            stringBuilder.append(this.i0);
            this.i1.getSource().printText(stringBuilder);
        }
    }

    private static final class ESSource
    extends Source {
        private final Expr.Parsed i0;
        private final String i1;

        ESSource(Expr.Parsed parsed, String string, int n, int n2) {
            super(parsed.getSource().getBeginLine(), parsed.getSource().getBeginColumn(), n, n2);
            this.i0 = parsed;
            this.i1 = string;
        }

        public final void printText(StringBuilder stringBuilder) {
            this.i0.getSource().printText(stringBuilder);
            stringBuilder.append(this.i1);
        }
    }

    private static final class ESESource
    extends Source {
        private final Expr.Parsed i0;
        private final String i1;
        private final Expr.Parsed i2;

        ESESource(Expr.Parsed parsed, String string, Expr.Parsed parsed2) {
            super(parsed.getSource().getBeginLine(), parsed.getSource().getBeginColumn(), parsed2.getSource().getEndLine(), parsed2.getSource().getEndColumn());
            this.i0 = parsed;
            this.i1 = string;
            this.i2 = parsed2;
        }

        public final void printText(StringBuilder stringBuilder) {
            this.i0.getSource().printText(stringBuilder);
            stringBuilder.append(this.i1);
            this.i2.getSource().printText(stringBuilder);
        }
    }
}

