/*
 * Decompiled with CFR 0.152.
 */
package org.dhallj.parser.support;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.dhallj.parser.support.Comment;
import org.dhallj.parser.support.SimpleCharStream;
import org.dhallj.parser.support.TokenMgrException;

final class WhitespaceManager {
    private final List<Comment> comments = new ArrayList<Comment>();
    private char curr = '\u0000';

    WhitespaceManager() {
    }

    private boolean advance(SimpleCharStream simpleCharStream) {
        try {
            this.curr = simpleCharStream.readChar();
            return false;
        }
        catch (IOException iOException) {
            return true;
        }
    }

    private void advanceNotEof(SimpleCharStream simpleCharStream) {
        if (this.advance(simpleCharStream)) {
            WhitespaceManager.fail(this.curr, simpleCharStream);
        }
    }

    private static boolean isCommentChar(char c) {
        return c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd' || c == '\t';
    }

    private static void fail(int n, SimpleCharStream simpleCharStream) {
        throw new TokenMgrException(false, 0, simpleCharStream.getEndLine(), simpleCharStream.getEndColumn(), simpleCharStream.GetImage(), n, 0);
    }

    List<Comment> consume(SimpleCharStream simpleCharStream, char c) {
        if (c == '{') {
            return this.consumeWithComments(simpleCharStream, true);
        }
        if (c == '-') {
            return this.consumeWithComments(simpleCharStream, false);
        }
        if (this.advance(simpleCharStream)) {
            return null;
        }
        if (this.curr == '{' || this.curr == '-') {
            boolean bl;
            boolean bl2 = bl = this.curr == '{';
            if (this.advance(simpleCharStream)) {
                simpleCharStream.backup(1);
                return null;
            }
            if (this.curr == '-') {
                return this.consumeWithComments(simpleCharStream, bl);
            }
            simpleCharStream.backup(2);
            return null;
        }
        simpleCharStream.backup(1);
        return null;
    }

    private Comment consumeLineComment(SimpleCharStream simpleCharStream) {
        int n = 2;
        int n2 = simpleCharStream.getBeginLine();
        int n3 = simpleCharStream.getBeginColumn();
        while (true) {
            this.advanceNotEof(simpleCharStream);
            if (WhitespaceManager.isCommentChar(this.curr)) {
                ++n;
                continue;
            }
            if (this.curr == '\n') break;
            if (this.curr == '\r') {
                if (!this.advance(simpleCharStream) && this.curr == '\n') break;
                WhitespaceManager.fail(this.curr, simpleCharStream);
                break;
            }
            if (Character.isHighSurrogate(this.curr)) {
                if (this.advance(simpleCharStream) || !Character.isLowSurrogate(this.curr)) {
                    WhitespaceManager.fail(this.curr, simpleCharStream);
                }
                n += 2;
                continue;
            }
            WhitespaceManager.fail(this.curr, simpleCharStream);
        }
        return new Comment(new String(simpleCharStream.GetSuffix(n)), n2, n3, simpleCharStream.getEndLine(), simpleCharStream.getEndColumn());
    }

    private Comment consumeBlockComment(SimpleCharStream simpleCharStream) {
        int n = 1;
        int n2 = 2;
        int n3 = simpleCharStream.getBeginLine();
        int n4 = simpleCharStream.getBeginColumn();
        this.advanceNotEof(simpleCharStream);
        do {
            if (this.curr == '-') {
                this.advanceNotEof(simpleCharStream);
                if (this.curr == '}') {
                    --n;
                    continue;
                }
                ++n2;
                this.advanceNotEof(simpleCharStream);
                continue;
            }
            if (this.curr == '{') {
                this.advanceNotEof(simpleCharStream);
                if (this.curr == '-') {
                    ++n;
                    continue;
                }
                ++n2;
                this.advanceNotEof(simpleCharStream);
                continue;
            }
            if (WhitespaceManager.isCommentChar(this.curr) || this.curr == '\n') {
                ++n2;
                this.advanceNotEof(simpleCharStream);
                continue;
            }
            if (this.curr == '\r') {
                if (this.advance(simpleCharStream) || this.curr != '\n') {
                    WhitespaceManager.fail(this.curr, simpleCharStream);
                }
                ++n2;
                this.advanceNotEof(simpleCharStream);
                continue;
            }
            if (Character.isHighSurrogate(this.curr)) {
                if (this.advance(simpleCharStream) || !Character.isLowSurrogate(this.curr)) {
                    WhitespaceManager.fail(this.curr, simpleCharStream);
                }
                n2 += 2;
                this.advanceNotEof(simpleCharStream);
                continue;
            }
            WhitespaceManager.fail(this.curr, simpleCharStream);
        } while (n > 0);
        return new Comment(new String(simpleCharStream.GetSuffix(n2)), n3, n4, simpleCharStream.getEndLine(), simpleCharStream.getEndColumn());
    }

    /*
     * Unable to fully structure code
     */
    private List<Comment> consumeWithComments(SimpleCharStream var1_1, boolean var2_2) {
        this.comments.clear();
        if (var2_2) {
            this.comments.add(this.consumeBlockComment(var1_1));
        } else {
            this.comments.add(this.consumeLineComment(var1_1));
        }
        block6: while (true) {
            if (this.advance(var1_1)) {
                return this.comments;
            }
            switch (this.curr) {
                case '\t': 
                case '\n': 
                case ' ': {
                    continue block6;
                }
                case '{': {
                    this.advance(var1_1);
                    if (this.curr == '-') {
                        this.comments.add(this.consumeBlockComment(var1_1));
                        continue block6;
                    }
                    var1_1.backup(2);
                    return this.comments;
                }
                case '-': {
                    this.advance(var1_1);
                    if (this.curr == '-') {
                        this.comments.add(this.consumeLineComment(var1_1));
                        continue block6;
                    }
                    var1_1.backup(2);
                    return this.comments;
                }
                case '\r': {
                    this.advanceNotEof(var1_1);
                    if (this.curr != '\n') ** break;
                    continue block6;
                    var1_1.backup(2);
                    return this.comments;
                }
            }
            break;
        }
        var1_1.backup(1);
        return null;
    }
}

