/*
 * Decompiled with CFR 0.152.
 */
package org.dhallj.parser.support;

import java.util.TreeSet;
import org.dhallj.parser.support.Token;

public class ParseException
extends Exception {
    private static final long serialVersionUID = 1L;
    private static final String INDENT = "    ";
    protected static String EOL = "\n";
    public Token currentToken;
    public int[][] expectedTokenSequences;
    public String[] tokenImage;

    public ParseException(Token token, int[][] nArray, String[] stringArray) {
        this(token, nArray, stringArray, null);
    }

    public ParseException(Token token, int[][] nArray, String[] stringArray, String string) {
        super(ParseException.initialise(token, nArray, stringArray, string));
        this.currentToken = token;
        this.expectedTokenSequences = nArray;
        this.tokenImage = stringArray;
    }

    public ParseException() {
    }

    public ParseException(String string) {
        super(string);
    }

    private static String initialise(Token token, int[][] nArray, String[] stringArray, String string) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 0; i < nArray.length; ++i) {
            if (n2 < nArray[i].length) {
                n2 = nArray[i].length;
            }
            for (int j = 0; j < nArray[i].length; ++j) {
                treeSet.add(stringArray[nArray[i][j]]);
            }
        }
        for (String string2 : treeSet) {
            stringBuffer.append(INDENT).append(string2).append(EOL);
        }
        stringBuilder.append("Encountered unexpected token:");
        Object object = token.next;
        for (n = 0; n < n2; ++n) {
            String string3 = ((Token)object).image;
            String string4 = ParseException.add_escapes(string3);
            if (n != 0) {
                stringBuilder.append(" ");
            }
            if (((Token)object).kind == 0) {
                stringBuilder.append(stringArray[0]);
                break;
            }
            stringBuilder.append(" \"");
            stringBuilder.append(string4);
            stringBuilder.append("\"");
            stringBuilder.append(" " + stringArray[((Token)object).kind]);
            object = ((Token)object).next;
        }
        stringBuilder.append(EOL).append(INDENT).append("at line " + token.next.beginLine + ", column " + token.next.beginColumn);
        stringBuilder.append(".").append(EOL);
        if (nArray.length != 0) {
            n = nArray.length;
            stringBuilder.append(EOL).append("Was expecting" + (n == 1 ? ":" : " one of:") + EOL + EOL);
            stringBuilder.append(stringBuffer.toString());
        }
        return stringBuilder.toString();
    }

    static String add_escapes(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        block10: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '\b': {
                    stringBuffer.append("\\b");
                    continue block10;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block10;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block10;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    continue block10;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block10;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block10;
                }
                case '\'': {
                    stringBuffer.append("\\'");
                    continue block10;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block10;
                }
                default: {
                    char c = string.charAt(i);
                    if (c < ' ' || c > '~') {
                        String string2 = "0000" + Integer.toString(c, 16);
                        stringBuffer.append("\\u" + string2.substring(string2.length() - 4, string2.length()));
                        continue block10;
                    }
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }
}

