/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.businesshours;

import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BinaryOperator;
import org.dhatim.businesshours.BusinessTemporal;
import org.dhatim.businesshours.CronExpression;

public class BusinessPeriod {
    private final BusinessTemporal start;
    private final BusinessTemporal end;

    public BusinessPeriod(BusinessTemporal start, BusinessTemporal end) {
        this.start = Objects.requireNonNull(start);
        this.end = Objects.requireNonNull(end);
    }

    public boolean alwaysOpen() {
        return this.end.increment().equals(this.start);
    }

    public boolean isInPeriod(Temporal temporal) {
        return this.start.compareTo(temporal) <= 0 && this.end.compareTo(temporal) >= 0;
    }

    public long timeBeforeOpening(Temporal temporal, ChronoUnit unit) {
        return this.alwaysOpen() ? Long.MAX_VALUE : this.start.since(temporal, unit);
    }

    public CronExpression getStartCron() {
        return this.alwaysOpen() ? null : new CronExpression(this.start);
    }

    public CronExpression getEndCron() {
        return this.alwaysOpen() ? null : new CronExpression(this.end.increment());
    }

    public BusinessTemporal getStart() {
        return this.start;
    }

    public BusinessTemporal getEnd() {
        return this.end;
    }

    public int hashCode() {
        int hash = 5;
        hash = 59 * hash + Objects.hashCode(this.start);
        hash = 59 * hash + Objects.hashCode(this.end);
        return hash;
    }

    public boolean equals(Object obj) {
        return Optional.ofNullable(obj).filter(BusinessPeriod.class::isInstance).filter(other -> this.start.equals(((BusinessPeriod)other).start)).filter(other -> this.end.equals(((BusinessPeriod)other).end)).isPresent();
    }

    public static Set<BusinessPeriod> merge(Collection<BusinessPeriod> periods) {
        ArrayList<BusinessPeriod> sortedPeriods = new ArrayList<BusinessPeriod>(periods);
        Collections.sort(sortedPeriods, Comparator.comparing(BusinessPeriod::getStart));
        HashSet<BusinessPeriod> mergedPeriods = new HashSet<BusinessPeriod>(periods.size());
        BusinessPeriod currentPeriod = null;
        for (BusinessPeriod period : sortedPeriods) {
            if (currentPeriod == null) {
                currentPeriod = period;
                continue;
            }
            if (currentPeriod.isInPeriod(period.getStart())) {
                currentPeriod = new BusinessPeriod(currentPeriod.getStart(), (BusinessTemporal)BinaryOperator.maxBy(Comparator.naturalOrder()).apply(currentPeriod.getEnd(), period.getEnd()));
                continue;
            }
            if (currentPeriod.getEnd().increment().equals(period.getStart())) {
                currentPeriod = new BusinessPeriod(currentPeriod.getStart(), period.getEnd());
                continue;
            }
            mergedPeriods.add(currentPeriod);
            currentPeriod = period;
        }
        Optional.ofNullable(currentPeriod).ifPresent(mergedPeriods::add);
        return mergedPeriods;
    }
}

