/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.businesshours;

import java.time.DayOfWeek;
import java.time.temporal.ChronoField;
import java.time.temporal.ValueRange;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.ToIntFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dhatim.businesshours.BusinessPeriod;
import org.dhatim.businesshours.BusinessTemporal;

class BusinessHoursParser {
    private static final Map<ChronoField, Map.Entry<Pattern, ToIntFunction<String>>> SUPPORTED_FIELDS = Collections.unmodifiableMap(new HashMap<ChronoField, Map.Entry<Pattern, ToIntFunction<String>>>(){
        {
            this.put(ChronoField.MINUTE_OF_HOUR, new AbstractMap.SimpleImmutableEntry<Pattern, ToIntFunction<String>>(Pattern.compile("(?:min|minute) *\\{(.*?)\\}"), Integer::parseInt));
            this.put(ChronoField.HOUR_OF_DAY, new AbstractMap.SimpleImmutableEntry<Pattern, ToIntFunction<String>>(Pattern.compile("(?:hr|hour) *\\{(.*?)\\}"), x$0 -> BusinessHoursParser.hourStringToInt(x$0)));
            this.put(ChronoField.DAY_OF_WEEK, new AbstractMap.SimpleImmutableEntry<Pattern, ToIntFunction<String>>(Pattern.compile("(?:wday|wd) *\\{(.*?)\\}"), x$0 -> BusinessHoursParser.weekDayStringToInt(x$0)));
        }
    });
    private static final Pattern TWELVE_HOURS_TIME_PATTERN = Pattern.compile("(\\d{1,2})(am|noon|pm)");
    private static final Map<String, Integer> WEEKDAYS_MAPPING = Collections.unmodifiableMap(new HashMap<String, Integer>(){
        {
            this.put("mo", DayOfWeek.MONDAY.getValue());
            this.put("tu", DayOfWeek.TUESDAY.getValue());
            this.put("we", DayOfWeek.WEDNESDAY.getValue());
            this.put("th", DayOfWeek.THURSDAY.getValue());
            this.put("fr", DayOfWeek.FRIDAY.getValue());
            this.put("sa", DayOfWeek.SATURDAY.getValue());
            this.put("su", DayOfWeek.SUNDAY.getValue());
        }
    });

    BusinessHoursParser() {
    }

    private static int hourStringToInt(String hour) {
        try {
            return Integer.parseInt(hour);
        }
        catch (NumberFormatException e) {
            Matcher matcher = TWELVE_HOURS_TIME_PATTERN.matcher(hour);
            if (matcher.matches()) {
                int result = Integer.parseInt(matcher.group(1));
                String dayHalf = matcher.group(2);
                if ("am".equals(dayHalf) && result == 12) {
                    result = 0;
                } else if ("pm".equals(dayHalf) && result != 12) {
                    result += 12;
                }
                return result;
            }
            throw new IllegalArgumentException("Invalid hour format: " + hour);
        }
    }

    private static int weekDayStringToInt(String weekDay) {
        int result;
        try {
            result = Integer.parseInt(weekDay);
        }
        catch (NumberFormatException e) {
            result = Optional.of(weekDay).filter(wd -> wd.length() >= 2).map(wd -> wd.toLowerCase(Locale.ENGLISH).substring(0, 2)).map(WEEKDAYS_MAPPING::get).orElseThrow(() -> new IllegalArgumentException("Invalid weekday value: " + weekDay));
        }
        return result;
    }

    private static Set<String> getStringRanges(String subPeriod, Pattern pattern) {
        HashSet<String> ranges = new HashSet<String>();
        Matcher matcher = pattern.matcher(subPeriod);
        while (matcher.find()) {
            String match = matcher.group(1).trim();
            Arrays.stream(match.split(" ")).forEach(ranges::add);
        }
        return ranges;
    }

    private static Stream<ValueRange> getRange(String stringRange, ValueRange fullRange, ToIntFunction<String> valueParser) {
        int start;
        int end;
        String[] boundaries = stringRange.split("-");
        switch (boundaries.length) {
            case 1: {
                start = end = valueParser.applyAsInt(boundaries[0]);
                break;
            }
            case 2: {
                start = valueParser.applyAsInt(boundaries[0]);
                end = valueParser.applyAsInt(boundaries[1]);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid range: " + stringRange);
            }
        }
        return start <= end ? Stream.of(ValueRange.of(start, end)) : Stream.of(ValueRange.of(start, fullRange.getMaximum()), ValueRange.of(fullRange.getMinimum(), end));
    }

    private static List<ValueRange> defaultRange(List<ValueRange> providedRanges, ValueRange fullRange) {
        return providedRanges.isEmpty() ? Collections.singletonList(fullRange) : providedRanges;
    }

    private static Set<NavigableMap<ChronoField, ValueRange>> getRangeCombinations(SortedMap<ChronoField, List<ValueRange>> acceptedRanges) {
        int combinationNb = acceptedRanges.values().stream().mapToInt(List::size).reduce(1, (a, b) -> a * b);
        HashSet<NavigableMap<ChronoField, ValueRange>> combinations = new HashSet<NavigableMap<ChronoField, ValueRange>>(combinationNb);
        for (int i = 0; i < combinationNb; ++i) {
            int divisor = 1;
            TreeMap<ChronoField, ValueRange> combination = new TreeMap<ChronoField, ValueRange>();
            for (Map.Entry<ChronoField, List<ValueRange>> entry : acceptedRanges.entrySet()) {
                List<ValueRange> ranges = entry.getValue();
                combination.put(entry.getKey(), ranges.get(i / divisor % ranges.size()));
                divisor *= entry.getValue().size();
            }
            combinations.add(combination);
        }
        return combinations;
    }

    private static int getRangeLength(ValueRange range) {
        return range.checkValidIntValue(range.getMaximum(), null) - range.checkValidIntValue(range.getMinimum(), null) + 1;
    }

    private static Stream<BusinessPeriod> toBusinessPeriods(NavigableMap<ChronoField, ValueRange> ranges) {
        ChronoField firstField = (ChronoField)ranges.firstKey();
        ValueRange firstRange = (ValueRange)ranges.get(firstField);
        NavigableMap<ChronoField, ValueRange> remainingRanges = ranges.tailMap(firstField, false);
        int periodNb = remainingRanges.values().stream().mapToInt(BusinessHoursParser::getRangeLength).reduce(1, (a, b) -> a * b);
        ArrayList<BusinessPeriod> periods = new ArrayList<BusinessPeriod>();
        for (int i = 0; i < periodNb; ++i) {
            int divisor = 1;
            HashMap<ChronoField, Integer> startFields = new HashMap<ChronoField, Integer>();
            HashMap<ChronoField, Integer> endFields = new HashMap<ChronoField, Integer>();
            startFields.put(firstField, firstRange.checkValidIntValue(firstRange.getMinimum(), firstField));
            endFields.put(firstField, firstRange.checkValidIntValue(firstRange.getMaximum(), firstField));
            for (Map.Entry entry : remainingRanges.entrySet()) {
                ChronoField field = (ChronoField)entry.getKey();
                ValueRange range = (ValueRange)entry.getValue();
                int rangeLength = BusinessHoursParser.getRangeLength(range);
                int value = range.checkValidIntValue(range.getMinimum(), field) + i / divisor % rangeLength;
                startFields.put(field, value);
                endFields.put(field, value);
                divisor *= rangeLength;
            }
            periods.add(new BusinessPeriod(BusinessTemporal.of(startFields), BusinessTemporal.of(endFields)));
        }
        return periods.stream();
    }

    public static Set<BusinessPeriod> parse(String businessHours) {
        return BusinessPeriod.merge(Arrays.stream(businessHours.split(",")).flatMap(BusinessHoursParser::parseSubBusinessHours).collect(Collectors.toSet()));
    }

    private static Stream<BusinessPeriod> parseSubBusinessHours(String subPeriod) {
        TreeMap<ChronoField, List<ValueRange>> acceptedRanges = new TreeMap<ChronoField, List<ValueRange>>();
        SUPPORTED_FIELDS.forEach((field, parsingElts) -> acceptedRanges.put((ChronoField)field, BusinessHoursParser.defaultRange(BusinessHoursParser.getStringRanges(subPeriod, (Pattern)parsingElts.getKey()).stream().flatMap(stringRange -> BusinessHoursParser.getRange(stringRange, field.range(), (ToIntFunction)parsingElts.getValue())).collect(Collectors.toList()), field.range())));
        return BusinessHoursParser.getRangeCombinations(acceptedRanges).stream().flatMap(BusinessHoursParser::toBusinessPeriods);
    }
}

