/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.businesshours;

import java.time.DateTimeException;
import java.time.Duration;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;

public class BusinessTemporal
implements Temporal,
Comparable<Temporal> {
    private final NavigableMap<ChronoField, Integer> fieldValues;

    private BusinessTemporal(Map<ChronoField, Integer> fieldValues) {
        this.fieldValues = Collections.unmodifiableNavigableMap(new TreeMap<ChronoField, Integer>(fieldValues));
        BusinessTemporal.validateFields(this.fieldValues.navigableKeySet());
    }

    public static BusinessTemporal of(Map<ChronoField, Integer> fieldValues) {
        return new BusinessTemporal(fieldValues);
    }

    private static BusinessTemporal from(TemporalAccessor temporal, Set<ChronoField> supportedFields) {
        HashMap<ChronoField, Integer> fieldValues = new HashMap<ChronoField, Integer>();
        supportedFields.forEach(field -> fieldValues.put((ChronoField)field, temporal.get((TemporalField)field)));
        return new BusinessTemporal(fieldValues);
    }

    private static void validateFields(SortedSet<ChronoField> fields) {
        TemporalUnit expectedBaseUnit = fields.first().getBaseUnit();
        for (ChronoField field : fields) {
            if (!field.getBaseUnit().equals(expectedBaseUnit)) {
                throw new DateTimeException("the fields must be contiguous");
            }
            if (!field.range().isFixed()) {
                throw new DateTimeException("the fields must have a fixed range");
            }
            expectedBaseUnit = field.getRangeUnit();
        }
    }

    @Override
    public <R> R query(TemporalQuery<R> query) {
        if (query == TemporalQueries.precision()) {
            return (R)((ChronoField)this.fieldValues.firstKey()).getBaseUnit();
        }
        return Temporal.super.query(query);
    }

    @Override
    public boolean isSupported(TemporalField field) {
        if (field instanceof ChronoField) {
            return this.fieldValues.keySet().contains(field);
        }
        return field.isSupportedBy(this);
    }

    @Override
    public long getLong(TemporalField field) {
        if (field instanceof ChronoField) {
            return ((Integer)Optional.ofNullable(this.fieldValues.get(field)).orElseThrow(() -> new UnsupportedTemporalTypeException("Unsupported field: " + field))).longValue();
        }
        return field.getFrom(this);
    }

    @Override
    public boolean isSupported(TemporalUnit unit) {
        if (unit instanceof ChronoUnit) {
            return this.fieldValues.keySet().stream().map(TemporalField::getBaseUnit).anyMatch(unit::equals);
        }
        return unit.isSupportedBy(this);
    }

    @Override
    public Temporal with(TemporalField field, long newValue) {
        if (field instanceof ChronoField) {
            ChronoField chronoField = (ChronoField)field;
            HashMap<ChronoField, Integer> newFieldValues = new HashMap<ChronoField, Integer>(this.fieldValues);
            Optional.ofNullable(newFieldValues.replace(chronoField, chronoField.checkValidIntValue(newValue))).orElseThrow(() -> new UnsupportedTemporalTypeException("Unsupported field: " + field));
            return new BusinessTemporal(newFieldValues);
        }
        return field.adjustInto(this, newValue);
    }

    @Override
    public Temporal plus(long amountToAdd, TemporalUnit unit) {
        if (unit instanceof ChronoUnit) {
            HashMap<ChronoField, Integer> newFieldValues = new HashMap<ChronoField, Integer>(this.fieldValues);
            SortedSet<ChronoField> relevantFields = this.fieldsBiggerThan((ChronoUnit)unit);
            for (ChronoField field : relevantFields) {
                long rangeLength = field.range().getMaximum() - field.range().getMinimum() + 1L;
                long sum = (long)((Integer)this.fieldValues.get(field)).intValue() + amountToAdd - field.range().getMinimum();
                newFieldValues.put(field, field.checkValidIntValue(field.range().getMinimum() + Math.floorMod(sum, rangeLength)));
                amountToAdd = Math.floorDiv(sum, rangeLength);
            }
            return new BusinessTemporal(newFieldValues);
        }
        return unit.addTo(this, amountToAdd);
    }

    private Duration durationUntil(Temporal end) {
        TemporalUnit endPrecision = end.query(TemporalQueries.precision());
        return this.fieldValues.entrySet().stream().map(entry -> Duration.of(end.get((TemporalField)entry.getKey()) - (Integer)entry.getValue(), ((ChronoField)entry.getKey()).getBaseUnit())).reduce(Duration.ZERO, Duration::plus).plus(BusinessTemporal.getLong(end, endPrecision, ((ChronoField)this.fieldValues.firstKey()).getBaseUnit()), endPrecision);
    }

    @Override
    public long until(Temporal endExclusive, TemporalUnit unit) {
        BusinessTemporal end = BusinessTemporal.from(endExclusive, this.fieldValues.keySet());
        if (unit instanceof ChronoUnit) {
            return BusinessTemporal.durationInUnit(this.durationUntil(end), unit);
        }
        return unit.between(this, end);
    }

    public BusinessTemporal increment() {
        return (BusinessTemporal)this.plus(1L, ((ChronoField)this.fieldValues.firstKey()).getBaseUnit());
    }

    public long since(Temporal temporal, ChronoUnit unit) {
        Duration duration = this.durationUntil(temporal).multipliedBy(-1L);
        if (duration.isNegative()) {
            duration = duration.plus(((ChronoField)this.fieldValues.lastKey()).getRangeUnit().getDuration());
        }
        return BusinessTemporal.durationInUnit(duration, unit);
    }

    private SortedSet<ChronoField> fieldsBiggerThan(ChronoUnit unit) {
        return this.fieldValues.tailMap(this.fieldValues.keySet().stream().filter(f -> f.getBaseUnit().equals(unit)).findAny().orElseThrow(() -> new UnsupportedTemporalTypeException("Unsupported unit: " + unit)), true).navigableKeySet();
    }

    @Override
    public int compareTo(Temporal t) {
        return Long.signum(-this.until(t, ((ChronoField)this.fieldValues.firstKey()).getBaseUnit()));
    }

    public int hashCode() {
        return this.fieldValues.hashCode();
    }

    public boolean equals(Object obj) {
        return Optional.ofNullable(obj).filter(BusinessTemporal.class::isInstance).filter(other -> this.fieldValues.equals(((BusinessTemporal)other).fieldValues)).isPresent();
    }

    private static long durationInUnit(Duration duration, TemporalUnit unit) {
        return duration.toNanos() / unit.getDuration().toNanos();
    }

    private static long getLong(Temporal temporal, TemporalUnit baseUnit, TemporalUnit rangeUnit) {
        long result = 0L;
        long weight = 1L;
        TemporalUnit currentUnit = baseUnit;
        for (ChronoField field : ChronoField.values()) {
            if (field.getBaseUnit() != currentUnit || currentUnit.getDuration().compareTo(rangeUnit.getDuration()) >= 0) continue;
            result += (temporal.getLong(field) - field.range().getMinimum()) * weight;
            weight *= field.range().getMaximum() - field.range().getMinimum() + 1L;
            currentUnit = (ChronoUnit)field.getRangeUnit();
        }
        return result % BusinessTemporal.durationInUnit(rangeUnit.getDuration(), baseUnit);
    }
}

