/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.cdr;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dhatim.Smooks;
import org.dhatim.cdr.Parameter;
import org.dhatim.cdr.SmooksConfigurationException;
import org.dhatim.cdr.SmooksResourceConfiguration;
import org.dhatim.cdr.SmooksResourceConfigurationList;
import org.dhatim.cdr.SmooksResourceConfigurationStore;
import org.dhatim.cdr.extension.ExtensionContext;
import org.dhatim.container.ExecutionContext;
import org.dhatim.container.standalone.StandaloneApplicationContext;
import org.dhatim.expression.ExpressionEvaluator;
import org.dhatim.io.StreamUtils;
import org.dhatim.net.URIUtil;
import org.dhatim.profile.DefaultProfileSet;
import org.dhatim.resource.URIResourceLocator;
import org.dhatim.util.ClassUtil;
import org.dhatim.xml.DomUtils;
import org.dhatim.xml.LocalDTDEntityResolver;
import org.dhatim.xml.LocalEntityResolver;
import org.dhatim.xml.XmlUtil;
import org.dhatim.xml.XsdDOMValidator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public final class XMLConfigDigester {
    public static final String DTD_V10 = "http://www.milyn.org/dtd/smooksres-list-1.0.dtd";
    public static final String XSD_V10 = "http://www.milyn.org/xsd/smooks-1.0.xsd";
    public static final String XSD_V11 = "http://www.milyn.org/xsd/smooks-1.1.xsd";
    private static Log logger = LogFactory.getLog(XMLConfigDigester.class);
    private final SmooksResourceConfigurationList resourcelist;
    private final Stack<SmooksConfig> configStack = new Stack();
    private ClassLoader classLoader;
    private Map<String, Smooks> extendedConfigDigesters = new HashMap<String, Smooks>();
    private static ThreadLocal<Boolean> extentionDigestOn = new ThreadLocal();

    public XMLConfigDigester(SmooksResourceConfigurationList list) {
        this.resourcelist = list;
        this.configStack.push(new SmooksConfig("root-config"));
    }

    public static SmooksResourceConfigurationList digestConfig(InputStream stream, String baseURI, Map<String, Smooks> extendedConfigDigesters) throws SAXException, IOException, URISyntaxException, SmooksConfigurationException {
        return XMLConfigDigester.digestConfig(stream, baseURI, extendedConfigDigesters, null);
    }

    public static SmooksResourceConfigurationList digestConfig(InputStream stream, String baseURI, Map<String, Smooks> extendedConfigDigesters, ClassLoader classLoader) throws SAXException, IOException, URISyntaxException, SmooksConfigurationException {
        SmooksResourceConfigurationList list = new SmooksResourceConfigurationList(baseURI);
        XMLConfigDigester.setExtentionDigestOff();
        XMLConfigDigester digester = new XMLConfigDigester(list);
        if (classLoader != null) {
            digester.classLoader = classLoader;
        }
        digester.extendedConfigDigesters = extendedConfigDigesters;
        digester.digestConfigRecursively(new InputStreamReader(stream), baseURI);
        return list;
    }

    public static SmooksResourceConfigurationList digestConfig(InputStream stream, String baseURI) throws SAXException, IOException, URISyntaxException, SmooksConfigurationException {
        return XMLConfigDigester.digestConfig(stream, baseURI, (ClassLoader)null);
    }

    public static SmooksResourceConfigurationList digestConfig(InputStream stream, String baseURI, ClassLoader classLoader) throws SAXException, IOException, URISyntaxException, SmooksConfigurationException {
        SmooksResourceConfigurationList list = new SmooksResourceConfigurationList(baseURI);
        XMLConfigDigester.setExtentionDigestOff();
        XMLConfigDigester digester = new XMLConfigDigester(list);
        if (classLoader != null) {
            digester.classLoader = classLoader;
        }
        digester.digestConfigRecursively(new InputStreamReader(stream), baseURI);
        return list;
    }

    public SmooksResourceConfigurationList getResourceList() {
        return this.resourcelist;
    }

    private void digestConfigRecursively(Reader stream, String baseURI) throws IOException, SAXException, URISyntaxException, SmooksConfigurationException {
        String streamData = StreamUtils.readStream(stream);
        try {
            Document configDoc = XmlUtil.parseStream(new StringReader(streamData), (EntityResolver)this.getDTDEntityResolver(), XmlUtil.VALIDATION_TYPE.DTD, true);
            logger.debug((Object)"Using a deprecated Smooks configuration DTD 'http://www.milyn.org/dtd/smooksres-list-1.0.dtd'.  Update configuration to use XSD 'http://www.milyn.org/xsd/smooks-1.0.xsd'.");
            this.digestV10DTDValidatedConfig(configDoc);
            logger.debug((Object)"Using a deprecated Smooks configuration DTD 'http://www.milyn.org/dtd/smooksres-list-1.0.dtd'.  Update configuration to use XSD 'http://www.milyn.org/xsd/smooks-1.0.xsd'.");
        }
        catch (Exception e) {
            Document configDoc;
            try {
                configDoc = XmlUtil.parseStream(new StringReader(streamData));
            }
            catch (ParserConfigurationException ee) {
                throw new SAXException("Unable to parse Smooks configuration.", ee);
            }
            XsdDOMValidator validator = new XsdDOMValidator(configDoc);
            String defaultNS = validator.getDefaultNamespace().toString();
            validator.validate();
            this.configStack.peek().defaultNS = defaultNS;
            if (XSD_V10.equals(defaultNS)) {
                if (validator.getNamespaces().size() > 1) {
                    throw new SmooksConfigurationException("Unsupported use of multiple configuration namespaces from inside a v1.0 Smooks configuration. Configuration extension not supported from a v1.0 configuration.  Use the v1.1 configuration namespace.");
                }
                this.digestV10XSDValidatedConfig(baseURI, configDoc);
            }
            if (XSD_V11.equals(defaultNS)) {
                this.digestV11XSDValidatedConfig(baseURI, configDoc);
            }
            throw new SAXException("Cannot parse Smooks configuration.  Unsupported default Namespace '" + defaultNS + "'.");
        }
        if (this.resourcelist.isEmpty()) {
            throw new SAXException("Invalid Content Delivery Resource archive definition file: 0 Content Delivery Resource definitions.");
        }
    }

    private void digestV10DTDValidatedConfig(Document configDoc) throws SAXException {
        int cdrIndex = 1;
        Element currentElement = (Element)XmlUtil.getNode(configDoc, "/smooks-resource-list");
        String defaultSelector = DomUtils.getAttributeValue(currentElement, "default-selector");
        String defaultNamespace = DomUtils.getAttributeValue(currentElement, "default-namespace");
        String defaultUseragent = DomUtils.getAttributeValue(currentElement, "default-useragent");
        String defaultPath = DomUtils.getAttributeValue(currentElement, "default-path");
        String resourceSelector = "/smooks-resource-list/smooks-resource[" + cdrIndex + "]";
        while ((currentElement = (Element)XmlUtil.getNode(configDoc, resourceSelector)) != null) {
            SmooksResourceConfiguration resourceConfig;
            String selector = DomUtils.getAttributeValue(currentElement, "selector");
            String namespace = DomUtils.getAttributeValue(currentElement, "namespace");
            String useragents = DomUtils.getAttributeValue(currentElement, "useragent");
            String path = DomUtils.getAttributeValue(currentElement, "path");
            try {
                resourceConfig = new SmooksResourceConfiguration(selector != null ? selector : defaultSelector, namespace != null ? namespace : defaultNamespace, useragents != null ? useragents : defaultUseragent, path != null ? path : defaultPath);
            }
            catch (IllegalArgumentException e) {
                throw new SAXException("Invalid unit definition.", e);
            }
            this.digestParameters(currentElement, resourceConfig);
            this.resourcelist.add(resourceConfig);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Adding smooks-resource config from [" + this.resourcelist.getName() + "]: " + resourceConfig));
            }
            resourceSelector = "/smooks-resource-list/smooks-resource[" + ++cdrIndex + "]";
        }
    }

    private void digestV10XSDValidatedConfig(String baseURI, Document configDoc) throws SAXException, URISyntaxException, SmooksConfigurationException {
        Element currentElement = configDoc.getDocumentElement();
        String defaultSelector = DomUtils.getAttributeValue(currentElement, "default-selector");
        String defaultNamespace = DomUtils.getAttributeValue(currentElement, "default-selector-namespace");
        String defaultProfile = DomUtils.getAttributeValue(currentElement, "default-target-profile");
        NodeList configNodes = currentElement.getChildNodes();
        for (int i = 0; i < configNodes.getLength(); ++i) {
            if (configNodes.item(i).getNodeType() != 1) continue;
            Element configElement = (Element)configNodes.item(i);
            this.assertElementPermitted(configElement);
            if (DomUtils.getName(configElement).equals("profiles")) {
                this.digestProfiles(configElement);
                continue;
            }
            if (DomUtils.getName(configElement).equals("import")) {
                this.digestImport(configElement, new URI(baseURI));
                continue;
            }
            if (!DomUtils.getName(configElement).equals("resource-config")) continue;
            this.digestResourceConfig(configElement, defaultSelector, defaultNamespace, defaultProfile, null);
        }
    }

    private void digestV11XSDValidatedConfig(String baseURI, Document configDoc) throws SAXException, URISyntaxException, SmooksConfigurationException {
        Element currentElement = configDoc.getDocumentElement();
        String defaultSelector = DomUtils.getAttributeValue(currentElement, "default-selector");
        String defaultNamespace = DomUtils.getAttributeValue(currentElement, "default-selector-namespace");
        String defaultProfile = DomUtils.getAttributeValue(currentElement, "default-target-profile");
        String defaultConditionRef = DomUtils.getAttributeValue(currentElement, "default-condition-ref");
        NodeList configNodes = currentElement.getChildNodes();
        for (int i = 0; i < configNodes.getLength(); ++i) {
            if (configNodes.item(i).getNodeType() != 1) continue;
            Element configElement = (Element)configNodes.item(i);
            this.assertElementPermitted(configElement);
            String elementName = DomUtils.getName(configElement);
            String namespaceURI = configElement.getNamespaceURI();
            if (namespaceURI == null || namespaceURI.equals(XSD_V11)) {
                if (elementName.equals("params")) {
                    this.digestParams(configElement);
                    continue;
                }
                if (elementName.equals("conditions")) {
                    this.digestConditions(configElement);
                    continue;
                }
                if (elementName.equals("profiles")) {
                    this.digestProfiles(configElement);
                    continue;
                }
                if (elementName.equals("import")) {
                    this.digestImport(configElement, new URI(baseURI));
                    continue;
                }
                if (elementName.equals("reader")) {
                    this.digestReaderConfig(configElement, defaultProfile);
                    continue;
                }
                if (!elementName.equals("resource-config")) continue;
                this.digestResourceConfig(configElement, defaultSelector, defaultNamespace, defaultProfile, defaultConditionRef);
                continue;
            }
            this.digestExtendedResourceConfig(configElement, defaultSelector, defaultNamespace, defaultProfile, defaultConditionRef);
        }
    }

    private void digestParams(Element paramsElement) {
        NodeList paramNodes = paramsElement.getElementsByTagName("param");
        if (paramNodes.getLength() > 0) {
            SmooksResourceConfiguration globalParamsConfig = new SmooksResourceConfiguration("global-parameters");
            this.digestParameters(paramsElement, globalParamsConfig);
            this.resourcelist.add(globalParamsConfig);
        }
    }

    private void assertElementPermitted(Element configElement) {
        String elementName;
        if (XMLConfigDigester.isExtensionConfig() && !(elementName = DomUtils.getName(configElement)).equals("import") && !elementName.equals("resource-config")) {
            throw new SmooksConfigurationException("Configuration element '" + elementName + "' not supported in an extension configuration.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void digestImport(Element importElement, URI baseURI) throws SAXException, URISyntaxException, SmooksConfigurationException {
        String file = DomUtils.getAttributeValue(importElement, "file");
        if (file == null) {
            throw new IllegalStateException("Invalid resource import.  'file' attribute must be specified.");
        }
        URIResourceLocator resourceLocator = new URIResourceLocator();
        resourceLocator.setBaseURI(baseURI);
        try {
            URI fileURI = resourceLocator.resolveURI(file);
            this.pushConfig(file, fileURI);
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Importing resource configuration '" + file + "' from inside '" + this.configStack.peek().configFile + "'."));
                }
                try (InputStream resourceStream = resourceLocator.getResource(file);){
                    List importParams = DomUtils.getElements(importElement, "param", null);
                    if (!importParams.isEmpty()) {
                        String importConfig = StreamUtils.readStreamAsString(resourceStream);
                        for (Element importParam : importParams) {
                            String paramName = DomUtils.getAttributeValue(importParam, "name");
                            String paramValue = XmlUtil.serialize(importParam.getChildNodes());
                            importConfig = importConfig.replaceAll("@" + paramName + "@", paramValue);
                        }
                        this.digestConfigRecursively(new StringReader(importConfig), URIUtil.getParent(fileURI).toString());
                    } else {
                        this.digestConfigRecursively(new InputStreamReader(resourceStream), URIUtil.getParent(fileURI).toString());
                    }
                }
            }
            finally {
                this.popConfig();
            }
        }
        catch (IOException e) {
            throw new SmooksConfigurationException("Failed to load Smooks configuration resource <import> '" + file + "': " + e.getMessage(), e);
        }
    }

    private void digestReaderConfig(Element configElement, String defaultProfile) {
        String profiles = DomUtils.getAttributeValue(configElement, "targetProfile");
        String readerClass = DomUtils.getAttributeValue(configElement, "class");
        SmooksResourceConfiguration resourceConfig = new SmooksResourceConfiguration("org.xml.sax.driver", profiles != null ? profiles : defaultProfile, readerClass);
        this.configureHandlers(configElement, resourceConfig);
        this.configureFeatures(configElement, resourceConfig);
        this.configureParams(configElement, resourceConfig);
        this.resourcelist.add(resourceConfig);
    }

    private void configureHandlers(Element configElement, SmooksResourceConfiguration resourceConfig) {
        Element handlersElement = DomUtils.getElement(configElement, "handlers", 1);
        if (handlersElement != null) {
            NodeList handlers = handlersElement.getChildNodes();
            for (int i = 0; i < handlers.getLength(); ++i) {
                if (handlers.item(i).getNodeType() != 1) continue;
                Element handler = (Element)handlers.item(i);
                String handlerClass = handler.getAttribute("class");
                resourceConfig.setParameter("sax-handler", handlerClass);
            }
        }
    }

    private void configureFeatures(Element configElement, SmooksResourceConfiguration resourceConfig) {
        Element featuresElement = DomUtils.getElement(configElement, "features", 1);
        if (featuresElement != null) {
            NodeList features = featuresElement.getChildNodes();
            for (int i = 0; i < features.getLength(); ++i) {
                if (features.item(i).getNodeType() != 1) continue;
                Element feature = (Element)features.item(i);
                String uri = feature.getAttribute("feature");
                if (DomUtils.getName(feature).equals("setOn")) {
                    resourceConfig.setParameter("feature-on", uri);
                    continue;
                }
                resourceConfig.setParameter("feature-off", uri);
            }
        }
    }

    private void configureParams(Element configElement, SmooksResourceConfiguration resourceConfig) {
        Element paramsElement = DomUtils.getElement(configElement, "params", 1);
        if (paramsElement != null) {
            NodeList params = paramsElement.getChildNodes();
            for (int i = 0; i < params.getLength(); ++i) {
                if (params.item(i).getNodeType() != 1) continue;
                Element param = (Element)params.item(i);
                String name = param.getAttribute("name");
                String value = DomUtils.getAllText(param, true);
                resourceConfig.setParameter(name, value);
            }
        }
    }

    private void digestResourceConfig(Element configElement, String defaultSelector, String defaultNamespace, String defaultProfile, String defaultConditionRef) throws SAXException {
        SmooksResourceConfiguration resourceConfig;
        String selector = DomUtils.getAttributeValue(configElement, "selector");
        String namespace = DomUtils.getAttributeValue(configElement, "selector-namespace");
        String profiles = DomUtils.getAttributeValue(configElement, "target-profile");
        Element resourceElement = XMLConfigDigester.getElementByTagName(configElement, "resource");
        Element conditionElement = XMLConfigDigester.getElementByTagName(configElement, "condition");
        String resource = null;
        try {
            if (resourceElement != null) {
                resource = DomUtils.getAllText(resourceElement, true);
            }
            resourceConfig = new SmooksResourceConfiguration(selector != null ? selector : defaultSelector, namespace != null ? namespace : defaultNamespace, profiles != null ? profiles : defaultProfile, resource);
            if (resourceElement != null) {
                resourceConfig.setResourceType(DomUtils.getAttributeValue(resourceElement, "type"));
            }
            if (conditionElement != null) {
                ExpressionEvaluator evaluator = this.digestCondition(conditionElement);
                resourceConfig.setConditionEvaluator(evaluator);
            } else if (defaultConditionRef != null) {
                ExpressionEvaluator evaluator = this.getConditionEvaluator(defaultConditionRef);
                resourceConfig.setConditionEvaluator(evaluator);
            }
        }
        catch (IllegalArgumentException e) {
            throw new SAXException("Invalid unit definition.", e);
        }
        this.digestParameters(configElement, resourceConfig);
        this.resourcelist.add(resourceConfig);
        if (resource == null) {
            if (resourceConfig.getParameters("restype") != null) {
                logger.debug((Object)("Resource 'null' for resource config: " + resourceConfig + ".  This is probably an error because the configuration contains a 'resdata' param, which suggests it is following the old DTD based configuration model.  The new model requires the resource to be specified in the <resource> element."));
            } else {
                logger.debug((Object)("Resource 'null' for resource config: " + resourceConfig + ". This is not invalid!"));
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Adding smooks-resource config from [" + this.resourcelist.getName() + "]: " + resourceConfig));
        }
    }

    private void digestExtendedResourceConfig(Element configElement, String defaultSelector, String defaultNamespace, String defaultProfile, String defaultConditionRef) {
        String configNamespace = configElement.getNamespaceURI();
        Smooks configDigester = this.getExtenededConfigDigester(configNamespace);
        ExecutionContext executionContext = configDigester.createExecutionContext();
        Element conditionElement = DomUtils.getElement(configElement, "condition", 1);
        ExtensionContext extentionContext = conditionElement != null && (conditionElement.getNamespaceURI().equals(XSD_V10) || conditionElement.getNamespaceURI().equals(XSD_V11)) ? new ExtensionContext(this, defaultSelector, defaultNamespace, defaultProfile, this.digestCondition(conditionElement)) : (defaultConditionRef != null ? new ExtensionContext(this, defaultSelector, defaultNamespace, defaultProfile, this.getConditionEvaluator(defaultConditionRef)) : new ExtensionContext(this, defaultSelector, defaultNamespace, defaultProfile, null));
        ExtensionContext.setExtensionContext(extentionContext, executionContext);
        configDigester.filterSource(executionContext, new DOMSource(configElement), null);
        List<SmooksResourceConfiguration> resources = extentionContext.getResources();
        for (SmooksResourceConfiguration resource : resources) {
            this.resourcelist.add(resource);
        }
    }

    private Smooks getExtenededConfigDigester(String configNamespace) {
        Smooks smooks = this.extendedConfigDigesters.get(configNamespace);
        if (smooks == null) {
            URI namespaceURI;
            try {
                namespaceURI = new URI(configNamespace);
            }
            catch (URISyntaxException e) {
                throw new SmooksConfigurationException("Unable to parse extended config namespace URI '" + configNamespace + "'.", e);
            }
            String resourcePath = "/META-INF" + namespaceURI.getPath() + "-smooks.xml";
            File resourceFile = new File(resourcePath);
            String baseURI = resourceFile.getParent().replace('\\', '/');
            this.assertExtendedConfigOK(configNamespace, resourcePath);
            smooks = new Smooks(StandaloneApplicationContext.createNewInstance(false));
            XMLConfigDigester.setExtentionDigestOn();
            try {
                SmooksResourceConfigurationStore configStore = smooks.getApplicationContext().getStore();
                SmooksResourceConfigurationList extConfigList = new SmooksResourceConfigurationList(baseURI);
                XMLConfigDigester configDigester = new XMLConfigDigester(extConfigList);
                configDigester.extendedConfigDigesters = this.extendedConfigDigesters;
                configDigester.digestConfigRecursively(new InputStreamReader(ClassUtil.getResourceAsStream(resourcePath, this.classLoader)), baseURI);
                configStore.addSmooksResourceConfigurationList(extConfigList);
            }
            catch (Exception e) {
                throw new SmooksConfigurationException("Failed to construct Smooks instance for processing extended configuration resource '" + resourcePath + "'.", e);
            }
            finally {
                XMLConfigDigester.setExtentionDigestOff();
            }
            this.extendedConfigDigesters.put(configNamespace, smooks);
        }
        if (this.classLoader != null) {
            smooks.setClassLoader(this.classLoader);
        }
        return smooks;
    }

    private void assertExtendedConfigOK(String configNamespace, String resourcePath) {
        XsdDOMValidator validator;
        Document configDoc;
        InputStream resourceStream = ClassUtil.getResourceAsStream(resourcePath, this.classLoader);
        if (resourceStream == null) {
            throw new SmooksConfigurationException("Unable to locate Smooks digest configuration '" + resourcePath + "' for extended resource configuration namespace '" + configNamespace + "'.  This resource must be available on the classpath.");
        }
        try {
            configDoc = XmlUtil.parseStream(resourceStream);
        }
        catch (Exception e) {
            throw new SmooksConfigurationException("Unable to parse namespace URI '" + configNamespace + "'.", e);
        }
        try {
            validator = new XsdDOMValidator(configDoc);
        }
        catch (SAXException e) {
            throw new SmooksConfigurationException("Unable to create XsdDOMValidator instance for extended resource config '" + resourcePath + "'.", e);
        }
        String defaultNS = validator.getDefaultNamespace().toString();
        if (!XSD_V10.equals(defaultNS) && !XSD_V11.equals(defaultNS)) {
            throw new SmooksConfigurationException("Extended resource configuration '" + resourcePath + "' default namespace must be a valid Smooks configuration namespace.");
        }
        if (validator.getNamespaces().size() > 1) {
            throw new SmooksConfigurationException("Extended resource configuration '" + resourcePath + "' defines configurations from multiple namespaces.  This is not permitted.  Only use configurations from the base Smooks config namespaces e.g. '" + XSD_V11 + "'.");
        }
    }

    private static boolean isExtensionConfig() {
        return extentionDigestOn.get();
    }

    private static void setExtentionDigestOn() {
        extentionDigestOn.set(true);
    }

    private static void setExtentionDigestOff() {
        extentionDigestOn.set(false);
    }

    private static Element getElementByTagName(Element configElement, String name) {
        NodeList elements = configElement.getElementsByTagName(name);
        if (elements.getLength() != 0) {
            return (Element)elements.item(0);
        }
        return null;
    }

    private void digestConditions(Element conditionsElement) {
        NodeList conditions = conditionsElement.getElementsByTagName("condition");
        for (int i = 0; i < conditions.getLength(); ++i) {
            Element conditionElement = (Element)conditions.item(i);
            String id = DomUtils.getAttributeValue(conditionElement, "id");
            if (id == null) continue;
            this.addConditionEvaluator(id, this.digestCondition(conditionElement));
        }
    }

    public ExpressionEvaluator digestCondition(Element conditionElement) throws SmooksConfigurationException {
        String evaluatorConditionExpression;
        String idRef = DomUtils.getAttributeValue(conditionElement, "idRef");
        if (idRef != null) {
            return this.getConditionEvaluator(idRef);
        }
        String evaluatorClassName = DomUtils.getAttributeValue(conditionElement, "evaluator");
        if (evaluatorClassName == null || evaluatorClassName.trim().equals("")) {
            evaluatorClassName = "org.dhatim.javabean.expression.BeanMapExpressionEvaluator";
        }
        if ((evaluatorConditionExpression = DomUtils.getAllText(conditionElement, true)) == null || evaluatorConditionExpression.trim().equals("")) {
            throw new SmooksConfigurationException("smooks-resource/condition must specify a condition expression as child text e.g. <condition evaluator=\"....\">A + B > C</condition>.");
        }
        return ExpressionEvaluator.Factory.createInstance(evaluatorClassName, evaluatorConditionExpression);
    }

    private void digestProfiles(Element profilesElement) {
        NodeList configNodes = profilesElement.getChildNodes();
        for (int i = 0; i < configNodes.getLength(); ++i) {
            if (configNodes.item(i).getNodeType() != 1) continue;
            Element profileNode = (Element)configNodes.item(i);
            String baseProfile = DomUtils.getAttributeValue(profileNode, "base-profile");
            String subProfiles = DomUtils.getAttributeValue(profileNode, "sub-profiles");
            DefaultProfileSet profileSet = new DefaultProfileSet(baseProfile);
            if (subProfiles != null) {
                profileSet.addProfiles(subProfiles.split(","));
            }
            this.resourcelist.add(profileSet);
        }
    }

    private void digestParameters(Element resourceConfigElement, SmooksResourceConfiguration resourceConfig) {
        NodeList configNodes = resourceConfigElement.getElementsByTagName("param");
        for (int i = 0; i < configNodes.getLength(); ++i) {
            Element paramNode = (Element)configNodes.item(i);
            String paramName = DomUtils.getAttributeValue(paramNode, "name");
            String paramType = DomUtils.getAttributeValue(paramNode, "type");
            String paramValue = DomUtils.getAllText(paramNode, true);
            Parameter paramInstance = resourceConfig.setParameter(paramName, paramType, paramValue);
            paramInstance.setXML(paramNode);
        }
    }

    private LocalEntityResolver getDTDEntityResolver() {
        return new LocalDTDEntityResolver();
    }

    public String getCurrentPath() {
        StringBuilder pathBuilder = new StringBuilder();
        for (int i = this.configStack.size() - 1; i >= 0; --i) {
            pathBuilder.insert(0, "]");
            pathBuilder.insert(0, ((SmooksConfig)this.configStack.get(i)).configFile);
            pathBuilder.insert(0, "/[");
        }
        return pathBuilder.toString();
    }

    private void pushConfig(String file, URI fileURI) {
        for (SmooksConfig smooksConfig : this.configStack) {
            if (!fileURI.equals(smooksConfig.fileURI)) continue;
            throw new SmooksConfigurationException("Invalid circular reference to config file '" + fileURI + "' from inside config file '" + this.getCurrentPath() + "'.");
        }
        SmooksConfig config = new SmooksConfig(file);
        config.parent = this.configStack.peek();
        config.fileURI = fileURI;
        this.configStack.push(config);
    }

    private void popConfig() {
        SmooksConfig parentConfig;
        SmooksConfig currentConfig = this.configStack.pop();
        if (XSD_V11.equals(currentConfig.defaultNS) && !this.configStack.isEmpty() && (parentConfig = this.configStack.peek()).defaultNS.equals(XSD_V10)) {
            this.configStack.push(currentConfig);
            throw new SmooksConfigurationException("Unsupported import of a v1.1 configuration from inside a v1.0 configuration.  Path to configuration: '" + this.getCurrentPath() + "'.");
        }
    }

    public void addConditionEvaluator(String id, ExpressionEvaluator evaluator) {
        this.assertUniqueConditionId(id);
        this.configStack.peek().conditionEvaluators.put(id, evaluator);
    }

    public ExpressionEvaluator getConditionEvaluator(String idRef) {
        SmooksConfig smooksConfig = this.configStack.peek();
        while (smooksConfig != null) {
            ExpressionEvaluator evaluator = (ExpressionEvaluator)smooksConfig.conditionEvaluators.get(idRef);
            if (evaluator != null) {
                return evaluator;
            }
            smooksConfig = smooksConfig.parent;
        }
        throw new SmooksConfigurationException("Unknown condition idRef '" + idRef + "'.");
    }

    private void assertUniqueConditionId(String id) {
        if (this.configStack.peek().conditionEvaluators.containsKey(id)) {
            throw new SmooksConfigurationException("Duplicate condition ID '" + id + "'.");
        }
    }

    private static class SmooksConfig {
        private String defaultNS;
        private SmooksConfig parent;
        private final String configFile;
        private final Map<String, ExpressionEvaluator> conditionEvaluators = new HashMap<String, ExpressionEvaluator>();
        public URI fileURI;

        private SmooksConfig(String configFile) {
            this.configFile = configFile;
        }
    }
}

