/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.classpath;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dhatim.assertion.AssertArgument;
import org.dhatim.classpath.Filter;

public class Scanner {
    private static Log logger = LogFactory.getLog(Scanner.class);
    private Filter filter;

    public Scanner(Filter filter) {
        AssertArgument.isNotNull(filter, "filter");
        this.filter = filter;
    }

    public void scanClasspath(ClassLoader classLoader) throws IOException {
        if (!(classLoader instanceof URLClassLoader)) {
            logger.warn((Object)("Not scanning classpath for ClassLoader '" + classLoader.getClass().getName() + "'.  ClassLoader must implement '" + URLClassLoader.class.getName() + "'."));
            return;
        }
        URL[] urls = ((URLClassLoader)classLoader).getURLs();
        HashSet<String> alreadyScanned = new HashSet<String>();
        for (URL url : urls) {
            File file;
            String urlPath = url.getFile();
            if ((urlPath = URLDecoder.decode(urlPath, "UTF-8")).startsWith("file:")) {
                urlPath = urlPath.substring(5);
            }
            if (urlPath.indexOf(33) > 0) {
                urlPath = urlPath.substring(0, urlPath.indexOf(33));
            }
            if (alreadyScanned.contains((file = new File(urlPath)).getAbsolutePath())) {
                logger.debug((Object)("Ignoring classpath URL '" + file.getAbsolutePath() + "'.  Already scanned this URL."));
                continue;
            }
            if (file.isDirectory()) {
                this.handleDirectory(file, null);
            } else {
                this.handleArchive(file);
            }
            alreadyScanned.add(file.getAbsolutePath());
        }
    }

    private void handleArchive(File file) throws IOException {
        if (this.filter.isIgnorable(file.getName())) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Ignoring archive: " + file));
            }
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Scanning archive: " + file.getAbsolutePath()));
        }
        ZipFile zip = new ZipFile(file);
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String name = entry.getName();
            this.filter.filter(name);
        }
    }

    private void handleDirectory(File file, String path) {
        if (path != null && this.filter.isIgnorable(path)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Ignoring directory (and subdirectories): " + path));
            }
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Scanning directory: " + file.getAbsolutePath()));
        }
        for (File child : file.listFiles()) {
            String newPath;
            String string = newPath = path == null ? child.getName() : path + '/' + child.getName();
            if (child.isDirectory()) {
                this.handleDirectory(child, newPath);
                continue;
            }
            this.filter.filter(newPath);
        }
    }
}

