/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.csv;

import java.nio.charset.Charset;
import java.util.List;
import org.dhatim.GenericReaderConfigurator;
import org.dhatim.ReaderConfigurator;
import org.dhatim.assertion.AssertArgument;
import org.dhatim.cdr.SmooksConfigurationException;
import org.dhatim.cdr.SmooksResourceConfiguration;
import org.dhatim.csv.CSVBinding;
import org.dhatim.csv.CSVBindingType;
import org.dhatim.csv.CSVRecordParserFactory;
import org.dhatim.flatfile.FlatFileReader;

public class CSVReaderConfigurator
implements ReaderConfigurator {
    private String csvFields;
    private char separatorChar = (char)44;
    private char quoteChar = (char)34;
    private char escapeChar = (char)92;
    private int skipLineCount = 0;
    private Charset encoding = Charset.forName("UTF-8");
    private String rootElementName = "csv-set";
    private String recordElementName = "csv-record";
    private CSVBinding binding;
    private String targetProfile;
    private boolean indent = false;
    private boolean strict = true;

    public CSVReaderConfigurator(String csvFields) {
        AssertArgument.isNotNullAndNotEmpty(csvFields, "csvFields");
        this.csvFields = csvFields;
    }

    public CSVReaderConfigurator setSeparatorChar(char separatorChar) {
        AssertArgument.isNotNull(Character.valueOf(separatorChar), "separatorChar");
        this.separatorChar = separatorChar;
        return this;
    }

    public CSVReaderConfigurator setQuoteChar(char quoteChar) {
        AssertArgument.isNotNull(Character.valueOf(quoteChar), "quoteChar");
        this.quoteChar = quoteChar;
        return this;
    }

    public CSVReaderConfigurator setEscapeChar(char escapeChar) {
        AssertArgument.isNotNull(Character.valueOf(escapeChar), "escapeChar");
        this.escapeChar = escapeChar;
        return this;
    }

    public CSVReaderConfigurator setSkipLineCount(int skipLineCount) {
        AssertArgument.isNotNull(skipLineCount, "skipLineCount");
        this.skipLineCount = skipLineCount;
        return this;
    }

    public CSVReaderConfigurator setEncoding(Charset encoding) {
        AssertArgument.isNotNull(encoding, "encoding");
        this.encoding = encoding;
        return this;
    }

    public CSVReaderConfigurator setRootElementName(String csvRootElementName) {
        AssertArgument.isNotNullAndNotEmpty(csvRootElementName, "rootElementName");
        this.rootElementName = csvRootElementName;
        return this;
    }

    public CSVReaderConfigurator setRecordElementName(String csvRecordElementName) {
        AssertArgument.isNotNullAndNotEmpty(csvRecordElementName, "recordElementName");
        this.recordElementName = csvRecordElementName;
        return this;
    }

    public CSVReaderConfigurator setIndent(boolean indent) {
        this.indent = indent;
        return this;
    }

    public CSVReaderConfigurator setStrict(boolean strict) {
        this.strict = strict;
        return this;
    }

    public CSVReaderConfigurator setBinding(CSVBinding binding) {
        this.binding = binding;
        return this;
    }

    public CSVReaderConfigurator setTargetProfile(String targetProfile) {
        AssertArgument.isNotNullAndNotEmpty(targetProfile, "targetProfile");
        this.targetProfile = targetProfile;
        return this;
    }

    @Override
    public List<SmooksResourceConfiguration> toConfig() {
        GenericReaderConfigurator configurator = new GenericReaderConfigurator(FlatFileReader.class);
        configurator.getParameters().setProperty("parserFactory", CSVRecordParserFactory.class.getName());
        configurator.getParameters().setProperty("fields", this.csvFields);
        configurator.getParameters().setProperty("separator", Character.toString(this.separatorChar));
        configurator.getParameters().setProperty("quote-char", Character.toString(this.quoteChar));
        configurator.getParameters().setProperty("escape-char", Character.toString(this.escapeChar));
        configurator.getParameters().setProperty("skip-line-count", Integer.toString(this.skipLineCount));
        configurator.getParameters().setProperty("encoding", this.encoding.name());
        configurator.getParameters().setProperty("rootElementName", this.rootElementName);
        configurator.getParameters().setProperty("recordElementName", this.recordElementName);
        configurator.getParameters().setProperty("indent", Boolean.toString(this.indent));
        configurator.getParameters().setProperty("strict", Boolean.toString(this.strict));
        if (this.binding != null) {
            configurator.getParameters().setProperty("bindBeanId", this.binding.getBeanId());
            configurator.getParameters().setProperty("bindBeanClass", this.binding.getBeanClass().getName());
            configurator.getParameters().setProperty("bindingType", this.binding.getBindingType().toString());
            if (this.binding.getBindingType() == CSVBindingType.MAP) {
                if (this.binding.getKeyField() == null) {
                    throw new SmooksConfigurationException("CSV 'MAP' Binding must specify a 'keyField' property on the binding configuration.");
                }
                configurator.getParameters().setProperty("bindMapKeyField", this.binding.getKeyField());
            }
        }
        configurator.setTargetProfile(this.targetProfile);
        return configurator.toConfig();
    }
}

