/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.delivery;

import org.dhatim.SmooksException;
import org.dhatim.container.ExecutionContext;
import org.dhatim.delivery.AbstractParser;
import org.dhatim.delivery.replay.EndElementEvent;
import org.dhatim.delivery.replay.SAXEventReplay;
import org.dhatim.delivery.replay.StartElementEvent;
import org.dhatim.namespace.NamespaceDeclarationStack;
import org.dhatim.xml.NamespaceMappings;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DefaultHandler2;

public abstract class SmooksContentHandler
extends DefaultHandler2
implements SAXEventReplay {
    private ExecutionContext executionContext;
    private SmooksContentHandler parentContentHandler;
    private SmooksContentHandler nestedContentHandler;
    private NamespaceDeclarationStack namespaceDeclarationStack;
    private boolean endReplayed = false;
    private SAXEventReplay lastEvent = null;
    private StartElementEvent startEvent = new StartElementEvent();
    private EndElementEvent endEvent = new EndElementEvent();
    private int depth = 0;

    public SmooksContentHandler(ExecutionContext executionContext, SmooksContentHandler parentContentHandler) {
        this.executionContext = executionContext;
        this.parentContentHandler = parentContentHandler;
        this.attachHandler();
        if (parentContentHandler != null) {
            parentContentHandler.nestedContentHandler = this;
        }
    }

    public NamespaceDeclarationStack getNamespaceDeclarationStack() {
        if (this.namespaceDeclarationStack == null) {
            this.namespaceDeclarationStack = NamespaceMappings.getNamespaceDeclarationStack(this.executionContext);
            if (this.namespaceDeclarationStack == null) {
                throw new IllegalStateException("NamespaceDeclarationStack instance not set on ExecutionContext.");
            }
        }
        return this.namespaceDeclarationStack;
    }

    public void replayStartElement() {
        this.parentContentHandler.replay(this);
    }

    @Override
    public final void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.getNamespaceDeclarationStack().pushNamespaces(qName, uri, attributes);
        this.startEvent.set(uri, localName, qName, attributes);
        this.lastEvent = this.startEvent;
        ++this.depth;
        this.startElement(this.startEvent);
        if (this.nestedContentHandler != null) {
            this.replay(this.nestedContentHandler);
        }
    }

    public abstract void startElement(StartElementEvent var1) throws SAXException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            this.endEvent.set(uri, localName, qName);
            this.lastEvent = this.endEvent;
            this.endElement(this.endEvent);
            --this.depth;
        }
        finally {
            if (!this.endReplayed && this.depth == 0 && this.parentContentHandler != null) {
                this.endReplayed = true;
                this.replay(this.parentContentHandler);
                XMLReader xmlReader = AbstractParser.getXMLReader(this.executionContext);
                xmlReader.setContentHandler(this.parentContentHandler);
                this.parentContentHandler.resetNestedContentHandler();
            }
        }
        this.getNamespaceDeclarationStack().popNamespaces();
    }

    public abstract void endElement(EndElementEvent var1) throws SAXException;

    @Override
    public void replay(ContentHandler handler) throws SmooksException {
        if (this.lastEvent != null) {
            this.lastEvent.replay(handler);
        }
    }

    private void attachHandler() {
        this.executionContext.setAttribute(DefaultHandler2.class, this);
    }

    public static SmooksContentHandler getHandler(ExecutionContext executionContext) {
        return (SmooksContentHandler)executionContext.getAttribute(DefaultHandler2.class);
    }

    public void detachHandler() {
        this.executionContext.removeAttribute(DefaultHandler2.class);
    }

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public SmooksContentHandler getParentContentHandler() {
        return this.parentContentHandler;
    }

    public SmooksContentHandler getNestedContentHandler() {
        return this.nestedContentHandler;
    }

    public void resetNestedContentHandler() {
        this.nestedContentHandler = null;
    }

    public abstract void cleanup();
}

