/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.event.report;

import freemarker.template.utility.HtmlEscape;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import org.dhatim.event.report.AbstractReportGenerator;
import org.dhatim.event.report.ReportConfiguration;
import org.dhatim.event.report.model.DOMReport;
import org.dhatim.event.report.model.Report;
import org.dhatim.util.FreeMarkerTemplate;

public class HtmlReportGenerator
extends AbstractReportGenerator {
    public HtmlReportGenerator(Writer outputWriter) {
        this(new ReportConfiguration(outputWriter));
    }

    public HtmlReportGenerator(String outputFile) throws IOException {
        super(new ReportConfiguration(HtmlReportGenerator.createOutputWriter(outputFile)));
        File file = new File(outputFile);
        if (file.getParentFile() != null) {
            this.getReportConfiguration().setTempOutDir(file.getParentFile());
        }
    }

    protected HtmlReportGenerator(ReportConfiguration reportConfiguration) {
        super(reportConfiguration);
    }

    @Override
    public void applyTemplate(Report report) throws IOException {
        System.out.println();
        System.out.println("****************************************************************************************");
        System.out.println("  HTML REPORT GENERATOR IN USE!!!");
        System.out.println("  Please disable in Production mode.  This feature is a major performance drain!!");
        System.out.println("****************************************************************************************");
        System.out.println();
        FreeMarkerTemplate template = report instanceof DOMReport ? new FreeMarkerTemplate("html/template-dom.html", HtmlReportGenerator.class) : new FreeMarkerTemplate("html/template-sax.html", HtmlReportGenerator.class);
        Writer writer = this.getReportConfiguration().getOutputWriter();
        HashMap<String, Report> templateModel = new HashMap<String, Report>();
        templateModel.put("report", report);
        templateModel.put("htmlEscape", (Report)new HtmlEscape());
        writer.write(template.apply(templateModel));
    }

    private static Writer createOutputWriter(String outputFile) throws IOException {
        File file = new File(outputFile);
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        return new FileWriter(file);
    }
}

