/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.javabean;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dhatim.assertion.AssertArgument;
import org.dhatim.cdr.SmooksConfigurationException;
import org.dhatim.container.ExecutionContext;
import org.dhatim.util.ClassUtil;

public abstract class BeanUtils {
    private static Log logger = LogFactory.getLog(BeanUtils.class);

    public static Method createSetterMethod(String setterName, Object bean, Class<?> setterParamType) {
        String setterNamePlural;
        Method beanSetterMethod = ClassUtil.getSetterMethod(setterName, bean, setterParamType);
        if (beanSetterMethod != null || !List.class.isAssignableFrom(setterParamType) || (beanSetterMethod = ClassUtil.getSetterMethod(setterNamePlural = setterName + "s", bean, setterParamType)) == null) {
            // empty if block
        }
        if (beanSetterMethod == null && Integer.class.isAssignableFrom(setterParamType)) {
            beanSetterMethod = ClassUtil.getSetterMethod(setterName, bean, Integer.TYPE);
        }
        if (beanSetterMethod == null && Long.class.isAssignableFrom(setterParamType)) {
            beanSetterMethod = ClassUtil.getSetterMethod(setterName, bean, Long.TYPE);
        }
        if (beanSetterMethod == null && Float.class.isAssignableFrom(setterParamType)) {
            beanSetterMethod = ClassUtil.getSetterMethod(setterName, bean, Float.TYPE);
        }
        if (beanSetterMethod == null && Double.class.isAssignableFrom(setterParamType)) {
            beanSetterMethod = ClassUtil.getSetterMethod(setterName, bean, Double.TYPE);
        }
        if (beanSetterMethod == null && Character.class.isAssignableFrom(setterParamType)) {
            beanSetterMethod = ClassUtil.getSetterMethod(setterName, bean, Character.TYPE);
        }
        if (beanSetterMethod == null && Short.class.isAssignableFrom(setterParamType)) {
            beanSetterMethod = ClassUtil.getSetterMethod(setterName, bean, Short.TYPE);
        }
        if (beanSetterMethod == null && Byte.class.isAssignableFrom(setterParamType)) {
            beanSetterMethod = ClassUtil.getSetterMethod(setterName, bean, Byte.TYPE);
        }
        if (beanSetterMethod == null && Boolean.class.isAssignableFrom(setterParamType)) {
            beanSetterMethod = ClassUtil.getSetterMethod(setterName, bean, Boolean.TYPE);
        }
        return beanSetterMethod;
    }

    @Deprecated
    public static Object getBean(String beanId, ExecutionContext execContext) {
        Object bean = execContext.getBeanContext().getBean(beanId);
        if (bean == null) {
            throw new SmooksConfigurationException("Bean instance [" + beanId + "] not available and bean runtime class not set on configuration.");
        }
        return bean;
    }

    public static Object convertListToArray(List<?> list, Class<?> arrayClass) {
        AssertArgument.isNotNull(list, "list");
        AssertArgument.isNotNull(arrayClass, "arrayClass");
        int length = list.size();
        Object arrayObj = Array.newInstance(arrayClass, list.size());
        for (int i = 0; i < length; ++i) {
            try {
                Array.set(arrayObj, i, list.get(i));
                continue;
            }
            catch (ClassCastException e) {
                logger.error((Object)("Failed to cast type '" + list.get(i).getClass().getName() + "' to '" + arrayClass.getName() + "'."), (Throwable)e);
            }
        }
        return arrayObj;
    }
}

