/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.javabean.decoders;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dhatim.javabean.DataDecodeException;
import org.dhatim.javabean.DataDecoder;
import org.dhatim.javabean.DecodeType;

@DecodeType(value={String.class})
public class BinaryDecoder
implements DataDecoder {
    private static final Pattern BINARY_PATTERN = Pattern.compile("^[01]+$");

    @Override
    public Object decode(String data) throws DataDecodeException {
        Matcher binaryMatcher = BINARY_PATTERN.matcher(data);
        if (binaryMatcher.matches()) {
            return data;
        }
        throw new DataDecodeException("Failed to decode binary sequence '" + data + "'.");
    }
}

