/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.javabean.ext;

import java.util.Collection;
import java.util.Map;
import org.dhatim.SmooksException;
import org.dhatim.cdr.SmooksConfigurationException;
import org.dhatim.container.ExecutionContext;
import org.dhatim.delivery.dom.DOMVisitBefore;
import org.dhatim.util.ClassUtil;
import org.dhatim.xml.DomUtils;
import org.w3c.dom.Element;

public class PropertyChecker
implements DOMVisitBefore {
    @Override
    public void visitBefore(Element element, ExecutionContext execContext) throws SmooksException {
        BeanType beanType = this.getBeanType(element);
        boolean isPropertSpecified = DomUtils.getAttributeValue(element, "property") != null;
        boolean isSetterMethodSpecified = DomUtils.getAttributeValue(element, "setterMethod") != null;
        String bindingType = DomUtils.getName(element);
        if (isPropertSpecified && isSetterMethodSpecified) {
            throw new SmooksConfigurationException("'" + bindingType + "' binding specifies a 'property' and a 'setterMethod' attribute.  Only one of both may be set.");
        }
        if (isPropertSpecified && beanType == BeanType.COLLECTION) {
            throw new SmooksConfigurationException("'" + bindingType + "' binding specifies a 'property' attribute.  This is not valid for a Collection target.");
        }
        if (isPropertSpecified && beanType == BeanType.ARRAY) {
            throw new SmooksConfigurationException("'" + bindingType + "' binding specifies a 'property' attribute.  This is not valid for an Array target.");
        }
        if (isSetterMethodSpecified && beanType == BeanType.COLLECTION) {
            throw new SmooksConfigurationException("'" + bindingType + "' binding specifies a 'setterMethod' attribute.  This is not valid for a Collection target.");
        }
        if (isSetterMethodSpecified && beanType == BeanType.ARRAY) {
            throw new SmooksConfigurationException("'" + bindingType + "' binding specifies a 'setterMethod' attribute.  This is not valid for an Array target.");
        }
        if (!isPropertSpecified && !isSetterMethodSpecified && beanType == BeanType.OTHER) {
            throw new SmooksConfigurationException("'" + bindingType + "' binding for bean class '" + this.getBeanTypeName(element) + "' must specify a 'property' or 'setterMethod' attribute.");
        }
    }

    private BeanType getBeanType(Element bindingElement) {
        String beanClassName = this.getBeanTypeName(bindingElement);
        if (beanClassName.endsWith("[]")) {
            return BeanType.ARRAY;
        }
        Class<?> beanClass = this.getBeanClass(bindingElement);
        if (Collection.class.isAssignableFrom(beanClass)) {
            return BeanType.COLLECTION;
        }
        if (Map.class.isAssignableFrom(beanClass)) {
            return BeanType.MAP;
        }
        return BeanType.OTHER;
    }

    private Class<?> getBeanClass(Element bindingElement) {
        Class beanClass;
        String beanClassName = this.getBeanTypeName(bindingElement);
        try {
            beanClass = ClassUtil.forName(beanClassName, this.getClass());
        }
        catch (ClassNotFoundException e) {
            throw new SmooksConfigurationException("Bean class '" + beanClassName + "' not avilable on classpath.");
        }
        return beanClass;
    }

    private String getBeanTypeName(Element bindingElement) {
        return ((Element)bindingElement.getParentNode()).getAttribute("class");
    }

    private static enum BeanType {
        ARRAY,
        COLLECTION,
        MAP,
        OTHER;

    }
}

