/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.routing.jms;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public enum AcknowledgeModeEnum {
    CLIENT_ACKNOWLEDGE(2),
    AUTO_ACKNOWLEDGE(1),
    DUPS_OK_ACKNOWLEDGE(3);

    private static final Log log;
    private int jmsAckModeInt;

    private AcknowledgeModeEnum(int jmsAckModeInt) {
        this.jmsAckModeInt = jmsAckModeInt;
    }

    public int getAcknowledgeModeInt() {
        return this.jmsAckModeInt;
    }

    public static AcknowledgeModeEnum getAckMode(String ackMode) {
        if (ackMode != null) {
            try {
                return AcknowledgeModeEnum.valueOf(ackMode);
            }
            catch (IllegalArgumentException e) {
                log.debug((Object)("' " + ackMode + "' is invalid : " + ". Will use default '" + (Object)((Object)AUTO_ACKNOWLEDGE)));
            }
        }
        return AUTO_ACKNOWLEDGE;
    }

    static {
        log = LogFactory.getLog(AcknowledgeModeEnum.class);
    }
}

