/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.rules.regex;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dhatim.SmooksException;
import org.dhatim.assertion.AssertArgument;
import org.dhatim.container.ExecutionContext;
import org.dhatim.resource.URIResourceLocator;
import org.dhatim.rules.RuleEvalResult;
import org.dhatim.rules.RuleProvider;
import org.dhatim.rules.regex.RegexRuleEvalResult;

public class RegexProvider
implements RuleProvider {
    private static Log logger = LogFactory.getLog(RegexProvider.class);
    private String src;
    private String providerName;
    private Map<String, Pattern> rules = new HashMap<String, Pattern>();

    public RegexProvider() {
    }

    public RegexProvider(String src) {
        this.setSrc(src);
    }

    @Override
    public RuleEvalResult evaluate(String ruleName, CharSequence selectedData, ExecutionContext context) throws SmooksException {
        AssertArgument.isNotNullAndNotEmpty(ruleName, "ruleName");
        AssertArgument.isNotNull(selectedData, "selectedData");
        Pattern pattern = this.rules.get(ruleName);
        if (pattern == null) {
            throw new SmooksException("Unknown rule name '" + ruleName + "' on Regex RuleProvider '" + this.providerName + "'.");
        }
        boolean matched = pattern.matcher(selectedData).matches();
        return new RegexRuleEvalResult(matched, ruleName, this.providerName, pattern, selectedData.toString());
    }

    @Override
    public String getName() {
        return this.providerName;
    }

    @Override
    public void setName(String name) {
        this.providerName = name;
    }

    @Override
    public String getSrc() {
        return this.src;
    }

    @Override
    public void setSrc(String src) {
        this.src = src;
        this.loadRules(src);
    }

    protected void loadRules(String ruleFile) {
        InputStream ruleStream;
        if (ruleFile == null) {
            throw new SmooksException("ruleFile not specified.");
        }
        try {
            ruleStream = new URIResourceLocator().getResource(ruleFile);
        }
        catch (IOException e) {
            throw new SmooksException("Failed to open rule file '" + ruleFile + "'.", e);
        }
        Properties rawRuleTable = new Properties();
        try {
            rawRuleTable.load(ruleStream);
        }
        catch (IOException e) {
            throw new SmooksException("Error reading InputStream to rule file '" + ruleFile + "'.", e);
        }
        finally {
            try {
                ruleStream.close();
            }
            catch (IOException e) {
                logger.debug((Object)("Error closing InputStream to Regex Rule file '" + ruleFile + "'."), (Throwable)e);
            }
        }
        Set<Map.Entry<Object, Object>> ruleEntrySet = rawRuleTable.entrySet();
        for (Map.Entry<Object, Object> rule : ruleEntrySet) {
            String ruleName = (String)rule.getKey();
            String rulePattern = (String)rule.getValue();
            this.rules.put(ruleName, Pattern.compile(rulePattern));
        }
    }
}

