/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.smooks.edi.unedifact.model.r41;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.dhatim.edisax.model.internal.DelimiterType;
import org.dhatim.edisax.model.internal.Delimiters;
import org.dhatim.edisax.util.EDIUtils;
import org.dhatim.smooks.edi.EDIWritable;
import org.dhatim.smooks.edi.unedifact.model.r41.types.DateTime;
import org.dhatim.smooks.edi.unedifact.model.r41.types.Party;
import org.dhatim.smooks.edi.unedifact.model.r41.types.Ref;
import org.dhatim.smooks.edi.unedifact.model.r41.types.SyntaxIdentifier;

public class UNB41
implements Serializable,
EDIWritable {
    private static final long serialVersionUID = 1L;
    private SyntaxIdentifier syntaxIdentifier;
    private Party sender;
    private Party recipient;
    private DateTime date;
    private String controlRef;
    private Ref recipientRef;
    private String applicationRef;
    private String processingPriorityCode;
    private String ackRequest;
    private String agreementId;
    private String testIndicator;

    @Override
    public void write(Writer writer, Delimiters delimiters) throws IOException {
        StringWriter nodeWriter = new StringWriter();
        ArrayList<String> nodeTokens = new ArrayList<String>();
        ((Writer)nodeWriter).write("UNB");
        ((Writer)nodeWriter).write(delimiters.getField());
        if (this.syntaxIdentifier != null) {
            this.syntaxIdentifier.write(nodeWriter, delimiters);
            nodeTokens.add(((Object)nodeWriter).toString());
            nodeWriter.getBuffer().setLength(0);
        }
        ((Writer)nodeWriter).write(delimiters.getField());
        if (this.sender != null) {
            this.sender.write(nodeWriter, delimiters);
            nodeTokens.add(((Object)nodeWriter).toString());
            nodeWriter.getBuffer().setLength(0);
        }
        ((Writer)nodeWriter).write(delimiters.getField());
        if (this.recipient != null) {
            this.recipient.write(nodeWriter, delimiters);
            nodeTokens.add(((Object)nodeWriter).toString());
            nodeWriter.getBuffer().setLength(0);
        }
        ((Writer)nodeWriter).write(delimiters.getField());
        if (this.date != null) {
            this.date.write(nodeWriter, delimiters);
            nodeTokens.add(((Object)nodeWriter).toString());
            nodeWriter.getBuffer().setLength(0);
        }
        ((Writer)nodeWriter).write(delimiters.getField());
        if (this.controlRef != null) {
            ((Writer)nodeWriter).write(delimiters.escape(this.controlRef));
            nodeTokens.add(((Object)nodeWriter).toString());
            nodeWriter.getBuffer().setLength(0);
        }
        ((Writer)nodeWriter).write(delimiters.getField());
        if (this.recipientRef != null) {
            this.recipientRef.write(nodeWriter, delimiters);
            nodeTokens.add(((Object)nodeWriter).toString());
            nodeWriter.getBuffer().setLength(0);
        }
        ((Writer)nodeWriter).write(delimiters.getField());
        if (this.applicationRef != null) {
            ((Writer)nodeWriter).write(delimiters.escape(this.applicationRef));
            nodeTokens.add(((Object)nodeWriter).toString());
            nodeWriter.getBuffer().setLength(0);
        }
        ((Writer)nodeWriter).write(delimiters.getField());
        if (this.processingPriorityCode != null) {
            ((Writer)nodeWriter).write(delimiters.escape(this.processingPriorityCode));
            nodeTokens.add(((Object)nodeWriter).toString());
            nodeWriter.getBuffer().setLength(0);
        }
        ((Writer)nodeWriter).write(delimiters.getField());
        if (this.ackRequest != null) {
            ((Writer)nodeWriter).write(delimiters.escape(this.ackRequest));
            nodeTokens.add(((Object)nodeWriter).toString());
            nodeWriter.getBuffer().setLength(0);
        }
        ((Writer)nodeWriter).write(delimiters.getField());
        if (this.agreementId != null) {
            ((Writer)nodeWriter).write(delimiters.escape(this.agreementId));
            nodeTokens.add(((Object)nodeWriter).toString());
            nodeWriter.getBuffer().setLength(0);
        }
        ((Writer)nodeWriter).write(delimiters.getField());
        if (this.testIndicator != null) {
            ((Writer)nodeWriter).write(delimiters.escape(this.testIndicator));
            nodeTokens.add(((Object)nodeWriter).toString());
            nodeWriter.getBuffer().setLength(0);
        }
        nodeTokens.add(((Object)nodeWriter).toString());
        writer.write(EDIUtils.concatAndTruncate(nodeTokens, DelimiterType.FIELD, delimiters));
        writer.write(delimiters.getSegment());
        writer.flush();
    }

    public SyntaxIdentifier getSyntaxIdentifier() {
        return this.syntaxIdentifier;
    }

    public void setSyntaxIdentifier(SyntaxIdentifier syntaxIdentifier) {
        this.syntaxIdentifier = syntaxIdentifier;
    }

    public Party getSender() {
        return this.sender;
    }

    public void setSender(Party sender) {
        this.sender = sender;
    }

    public Party getRecipient() {
        return this.recipient;
    }

    public void setRecipient(Party recipient) {
        this.recipient = recipient;
    }

    public DateTime getDate() {
        return this.date;
    }

    public void setDate(DateTime date) {
        this.date = date;
    }

    public String getControlRef() {
        return this.controlRef;
    }

    public void setControlRef(String controlRef) {
        this.controlRef = controlRef;
    }

    public Ref getRecipientRef() {
        return this.recipientRef;
    }

    public void setRecipientRef(Ref recipientRef) {
        this.recipientRef = recipientRef;
    }

    public String getApplicationRef() {
        return this.applicationRef;
    }

    public void setApplicationRef(String applicationRef) {
        this.applicationRef = applicationRef;
    }

    public String getProcessingPriorityCode() {
        return this.processingPriorityCode;
    }

    public void setProcessingPriorityCode(String processingPriorityCode) {
        this.processingPriorityCode = processingPriorityCode;
    }

    public String getAckRequest() {
        return this.ackRequest;
    }

    public void setAckRequest(String ackRequest) {
        this.ackRequest = ackRequest;
    }

    public String getAgreementId() {
        return this.agreementId;
    }

    public void setAgreementId(String agreementId) {
        this.agreementId = agreementId;
    }

    public String getTestIndicator() {
        return this.testIndicator;
    }

    public void setTestIndicator(String testIndicator) {
        this.testIndicator = testIndicator;
    }
}

