/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.delivery;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dhatim.assertion.AssertArgument;
import org.dhatim.cdr.SmooksConfigurationException;
import org.dhatim.cdr.SmooksResourceConfiguration;
import org.dhatim.cdr.SmooksResourceConfigurationFactory;
import org.dhatim.cdr.annotation.Configurator;
import org.dhatim.cdr.xpath.SelectorStep;
import org.dhatim.container.ApplicationContext;
import org.dhatim.delivery.ContentHandler;
import org.dhatim.delivery.ContentHandlerConfigMapTable;
import org.dhatim.delivery.VisitLifecycleCleanable;
import org.dhatim.delivery.Visitor;
import org.dhatim.delivery.annotation.VisitAfterIf;
import org.dhatim.delivery.annotation.VisitBeforeIf;
import org.dhatim.delivery.dom.DOMVisitAfter;
import org.dhatim.delivery.dom.DOMVisitBefore;
import org.dhatim.delivery.dom.Phase;
import org.dhatim.delivery.dom.VisitPhase;
import org.dhatim.delivery.dom.serialize.SerializationUnit;
import org.dhatim.delivery.sax.SAXVisitAfter;
import org.dhatim.delivery.sax.SAXVisitBefore;
import org.dhatim.event.types.ConfigBuilderEvent;
import org.dhatim.expression.MVELExpressionEvaluator;
import org.dhatim.xml.NamespaceMappings;
import org.jaxen.saxpath.SAXPathException;

public class VisitorConfigMap {
    private static Log logger = LogFactory.getLog(VisitorConfigMap.class);
    private ApplicationContext applicationContext;
    private ContentHandlerConfigMapTable<DOMVisitBefore> domAssemblyVisitBefores = new ContentHandlerConfigMapTable();
    private ContentHandlerConfigMapTable<DOMVisitAfter> domAssemblyVisitAfters = new ContentHandlerConfigMapTable();
    private ContentHandlerConfigMapTable<DOMVisitBefore> domProcessingVisitBefores = new ContentHandlerConfigMapTable();
    private ContentHandlerConfigMapTable<DOMVisitAfter> domProcessingVisitAfters = new ContentHandlerConfigMapTable();
    private ContentHandlerConfigMapTable<SerializationUnit> domSerializationVisitors = new ContentHandlerConfigMapTable();
    private ContentHandlerConfigMapTable<SAXVisitBefore> saxVisitBefores = new ContentHandlerConfigMapTable();
    private ContentHandlerConfigMapTable<SAXVisitAfter> saxVisitAfters = new ContentHandlerConfigMapTable();
    private ContentHandlerConfigMapTable<VisitLifecycleCleanable> visitCleanables = new ContentHandlerConfigMapTable();
    private List<ConfigBuilderEvent> configBuilderEvents = new ArrayList<ConfigBuilderEvent>();
    private int visitorCount = 0;
    private int saxVisitorCount = 0;
    private int domVisitorCount = 0;

    public VisitorConfigMap(ApplicationContext applicationContext) {
        AssertArgument.isNotNull(applicationContext, "applicationContext");
        this.applicationContext = applicationContext;
    }

    public ContentHandlerConfigMapTable<DOMVisitBefore> getDomAssemblyVisitBefores() {
        return this.domAssemblyVisitBefores;
    }

    public void setDomAssemblyVisitBefores(ContentHandlerConfigMapTable<DOMVisitBefore> domAssemblyVisitBefores) {
        this.domAssemblyVisitBefores = domAssemblyVisitBefores;
    }

    public ContentHandlerConfigMapTable<DOMVisitAfter> getDomAssemblyVisitAfters() {
        return this.domAssemblyVisitAfters;
    }

    public void setDomAssemblyVisitAfters(ContentHandlerConfigMapTable<DOMVisitAfter> domAssemblyVisitAfters) {
        this.domAssemblyVisitAfters = domAssemblyVisitAfters;
    }

    public ContentHandlerConfigMapTable<DOMVisitBefore> getDomProcessingVisitBefores() {
        return this.domProcessingVisitBefores;
    }

    public void setDomProcessingVisitBefores(ContentHandlerConfigMapTable<DOMVisitBefore> domProcessingVisitBefores) {
        this.domProcessingVisitBefores = domProcessingVisitBefores;
    }

    public ContentHandlerConfigMapTable<DOMVisitAfter> getDomProcessingVisitAfters() {
        return this.domProcessingVisitAfters;
    }

    public void setDomProcessingVisitAfters(ContentHandlerConfigMapTable<DOMVisitAfter> domProcessingVisitAfters) {
        this.domProcessingVisitAfters = domProcessingVisitAfters;
    }

    public ContentHandlerConfigMapTable<SerializationUnit> getDomSerializationVisitors() {
        return this.domSerializationVisitors;
    }

    public void setDomSerializationVisitors(ContentHandlerConfigMapTable<SerializationUnit> domSerializationVisitors) {
        this.domSerializationVisitors = domSerializationVisitors;
    }

    public ContentHandlerConfigMapTable<SAXVisitBefore> getSaxVisitBefores() {
        return this.saxVisitBefores;
    }

    public void setSaxVisitBefores(ContentHandlerConfigMapTable<SAXVisitBefore> saxVisitBefores) {
        this.saxVisitBefores = saxVisitBefores;
    }

    public ContentHandlerConfigMapTable<SAXVisitAfter> getSaxVisitAfters() {
        return this.saxVisitAfters;
    }

    public void setSaxVisitAfters(ContentHandlerConfigMapTable<SAXVisitAfter> saxVisitAfters) {
        this.saxVisitAfters = saxVisitAfters;
    }

    public ContentHandlerConfigMapTable<VisitLifecycleCleanable> getVisitCleanables() {
        return this.visitCleanables;
    }

    public void setVisitCleanables(ContentHandlerConfigMapTable<VisitLifecycleCleanable> visitCleanables) {
        this.visitCleanables = visitCleanables;
    }

    public void setConfigBuilderEvents(List<ConfigBuilderEvent> configBuilderEvents) {
        this.configBuilderEvents = configBuilderEvents;
    }

    public int getVisitorCount() {
        return this.visitorCount;
    }

    public int getSaxVisitorCount() {
        return this.saxVisitorCount;
    }

    public int getDomVisitorCount() {
        return this.domVisitorCount;
    }

    public SmooksResourceConfiguration addVisitor(Visitor visitor, String targetSelector, String targetSelectorNS, boolean configure) {
        SmooksResourceConfiguration resourceConfig;
        AssertArgument.isNotNull(visitor, "visitor");
        AssertArgument.isNotNull(targetSelector, "targetSelector");
        if (visitor instanceof SmooksResourceConfigurationFactory) {
            resourceConfig = ((SmooksResourceConfigurationFactory)((Object)visitor)).createConfiguration();
            resourceConfig.setResource(visitor.getClass().getName());
            resourceConfig.setSelector(targetSelector);
        } else {
            resourceConfig = new SmooksResourceConfiguration(targetSelector, visitor.getClass().getName());
        }
        resourceConfig.setSelectorNamespaceURI(targetSelectorNS);
        this.addVisitor(visitor, resourceConfig, configure);
        return resourceConfig;
    }

    public void addVisitor(Visitor visitor, SmooksResourceConfiguration resourceConfig, boolean configure) {
        String elementName = resourceConfig.getTargetElement();
        try {
            SelectorStep.setNamespaces(resourceConfig.getSelectorSteps(), NamespaceMappings.getMappings(this.applicationContext));
        }
        catch (SAXPathException e) {
            throw new SmooksConfigurationException("Error configuring resource selector.", e);
        }
        if (configure) {
            Configurator.processFieldContextAnnotation(visitor, this.applicationContext);
            Configurator.processFieldConfigAnnotations(visitor, resourceConfig, false);
            Configurator.initialise(visitor);
            this.applicationContext.getStore().getInitializedObjects().add(visitor);
        }
        if (VisitorConfigMap.isSAXVisitor(visitor) || VisitorConfigMap.isDOMVisitor(visitor)) {
            ++this.visitorCount;
        }
        if (VisitorConfigMap.isSAXVisitor(visitor)) {
            ++this.saxVisitorCount;
            if (visitor instanceof SAXVisitBefore && VisitorConfigMap.visitBeforeAnnotationsOK(resourceConfig, visitor)) {
                this.saxVisitBefores.addMapping(elementName, resourceConfig, (SAXVisitBefore)visitor);
            }
            if (visitor instanceof SAXVisitAfter && VisitorConfigMap.visitAfterAnnotationsOK(resourceConfig, visitor)) {
                this.saxVisitAfters.addMapping(elementName, resourceConfig, (SAXVisitAfter)visitor);
            }
            this.logExecutionEvent(resourceConfig, "Added as a SAX resource.");
        }
        if (VisitorConfigMap.isDOMVisitor(visitor)) {
            ++this.domVisitorCount;
            if (visitor instanceof SerializationUnit) {
                this.domSerializationVisitors.addMapping(elementName, resourceConfig, (SerializationUnit)visitor);
                this.logExecutionEvent(resourceConfig, "Added as a DOM " + SerializationUnit.class.getSimpleName() + " resource.");
            } else {
                Phase phaseAnnotation = visitor.getClass().getAnnotation(Phase.class);
                String visitPhase = resourceConfig.getStringParameter("VisitPhase", VisitPhase.PROCESSING.toString());
                if (phaseAnnotation != null && phaseAnnotation.value() == VisitPhase.ASSEMBLY) {
                    if (visitor instanceof DOMVisitBefore && VisitorConfigMap.visitBeforeAnnotationsOK(resourceConfig, visitor)) {
                        this.domAssemblyVisitBefores.addMapping(elementName, resourceConfig, (DOMVisitBefore)visitor);
                    }
                    if (visitor instanceof DOMVisitAfter && VisitorConfigMap.visitAfterAnnotationsOK(resourceConfig, visitor)) {
                        this.domAssemblyVisitAfters.addMapping(elementName, resourceConfig, (DOMVisitAfter)visitor);
                    }
                } else if (visitPhase.equalsIgnoreCase(VisitPhase.ASSEMBLY.toString())) {
                    if (visitor instanceof DOMVisitBefore && VisitorConfigMap.visitBeforeAnnotationsOK(resourceConfig, visitor)) {
                        this.domAssemblyVisitBefores.addMapping(elementName, resourceConfig, (DOMVisitBefore)visitor);
                    }
                    if (visitor instanceof DOMVisitAfter && VisitorConfigMap.visitAfterAnnotationsOK(resourceConfig, visitor)) {
                        this.domAssemblyVisitAfters.addMapping(elementName, resourceConfig, (DOMVisitAfter)visitor);
                    }
                } else {
                    if (visitor instanceof DOMVisitBefore && VisitorConfigMap.visitBeforeAnnotationsOK(resourceConfig, visitor)) {
                        this.domProcessingVisitBefores.addMapping(elementName, resourceConfig, (DOMVisitBefore)visitor);
                    }
                    if (visitor instanceof DOMVisitAfter && VisitorConfigMap.visitAfterAnnotationsOK(resourceConfig, visitor)) {
                        this.domProcessingVisitAfters.addMapping(elementName, resourceConfig, (DOMVisitAfter)visitor);
                    }
                }
                this.logExecutionEvent(resourceConfig, "Added as a DOM " + visitPhase + " Phase resource.");
            }
        }
        if (visitor instanceof VisitLifecycleCleanable) {
            this.visitCleanables.addMapping(elementName, resourceConfig, (VisitLifecycleCleanable)visitor);
        }
    }

    private void logExecutionEvent(SmooksResourceConfiguration resourceConfig, String message) {
        if (this.configBuilderEvents != null) {
            this.configBuilderEvents.add(new ConfigBuilderEvent(resourceConfig, message));
        }
    }

    protected static boolean isDOMVisitor(ContentHandler contentHandler) {
        return contentHandler instanceof DOMVisitBefore || contentHandler instanceof DOMVisitAfter || contentHandler instanceof SerializationUnit;
    }

    protected static boolean isSAXVisitor(ContentHandler contentHandler) {
        return contentHandler instanceof SAXVisitBefore || contentHandler instanceof SAXVisitAfter;
    }

    protected static boolean visitBeforeAnnotationsOK(SmooksResourceConfiguration resourceConfig, ContentHandler contentHandler) {
        Class<?> handlerClass = contentHandler.getClass();
        VisitBeforeIf visitBeforeIf = handlerClass.getAnnotation(VisitBeforeIf.class);
        if (visitBeforeIf != null) {
            MVELExpressionEvaluator conditionEval = new MVELExpressionEvaluator();
            conditionEval.setExpression(visitBeforeIf.condition());
            return conditionEval.eval(resourceConfig);
        }
        return true;
    }

    protected static boolean visitAfterAnnotationsOK(SmooksResourceConfiguration resourceConfig, ContentHandler contentHandler) {
        Class<?> handlerClass = contentHandler.getClass();
        VisitAfterIf visitAfterIf = handlerClass.getAnnotation(VisitAfterIf.class);
        if (visitAfterIf != null) {
            MVELExpressionEvaluator conditionEval = new MVELExpressionEvaluator();
            conditionEval.setExpression(visitAfterIf.condition());
            return conditionEval.eval(resourceConfig);
        }
        return true;
    }

    public void addAll(VisitorConfigMap visitorConfigMap) {
        if (visitorConfigMap != null) {
            this.domAssemblyVisitBefores.addAll(visitorConfigMap.getDomAssemblyVisitBefores());
            this.domAssemblyVisitAfters.addAll(visitorConfigMap.getDomAssemblyVisitAfters());
            this.domProcessingVisitBefores.addAll(visitorConfigMap.getDomProcessingVisitBefores());
            this.domProcessingVisitAfters.addAll(visitorConfigMap.getDomProcessingVisitAfters());
            this.domSerializationVisitors.addAll(visitorConfigMap.getDomSerializationVisitors());
            this.saxVisitBefores.addAll(visitorConfigMap.getSaxVisitBefores());
            this.saxVisitAfters.addAll(visitorConfigMap.getSaxVisitAfters());
            this.visitCleanables.addAll(visitorConfigMap.getVisitCleanables());
            this.visitorCount += visitorConfigMap.getVisitorCount();
            this.saxVisitorCount += visitorConfigMap.getSaxVisitorCount();
            this.domVisitorCount += visitorConfigMap.getDomVisitorCount();
        }
    }
}

