/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.delivery.sax;

import java.util.ArrayList;
import java.util.List;
import org.dhatim.container.ExecutionContext;
import org.dhatim.delivery.SmooksContentHandler;
import org.dhatim.delivery.sax.SAXVisitAfter;
import org.dhatim.delivery.sax.SAXVisitBefore;
import org.dhatim.delivery.sax.SAXVisitChildren;
import org.dhatim.delivery.sax.SAXVisitor;

public class DynamicSAXElementVisitorList {
    private List<SAXVisitBefore> visitBefores = new ArrayList<SAXVisitBefore>();
    private List<SAXVisitChildren> childVisitors = new ArrayList<SAXVisitChildren>();
    private List<SAXVisitAfter> visitAfters = new ArrayList<SAXVisitAfter>();

    public DynamicSAXElementVisitorList(ExecutionContext executionContext) {
        executionContext.setAttribute(DynamicSAXElementVisitorList.class, this);
    }

    public List<SAXVisitBefore> getVisitBefores() {
        return this.visitBefores;
    }

    public List<SAXVisitChildren> getChildVisitors() {
        return this.childVisitors;
    }

    public List<SAXVisitAfter> getVisitAfters() {
        return this.visitAfters;
    }

    public static DynamicSAXElementVisitorList getList(ExecutionContext executionContext) {
        return (DynamicSAXElementVisitorList)executionContext.getAttribute(DynamicSAXElementVisitorList.class);
    }

    public static void addDynamicVisitor(SAXVisitor visitor, ExecutionContext executionContext) {
        SmooksContentHandler contentHandler = SmooksContentHandler.getHandler(executionContext);
        SmooksContentHandler nestedContentHandler = contentHandler.getNestedContentHandler();
        if (nestedContentHandler == null) {
            DynamicSAXElementVisitorList list = DynamicSAXElementVisitorList.getList(executionContext);
            if (visitor instanceof SAXVisitBefore) {
                list.visitBefores.add((SAXVisitBefore)visitor);
            }
            if (visitor instanceof SAXVisitChildren) {
                list.childVisitors.add((SAXVisitChildren)visitor);
            }
            if (visitor instanceof SAXVisitAfter) {
                list.visitAfters.add((SAXVisitAfter)visitor);
            }
        } else {
            DynamicSAXElementVisitorList.addDynamicVisitor(visitor, nestedContentHandler.getExecutionContext());
        }
    }

    public static void propogateDynamicVisitors(ExecutionContext parentExecutionContext, ExecutionContext childExecutionContext) {
        DynamicSAXElementVisitorList parentList = DynamicSAXElementVisitorList.getList(parentExecutionContext);
        if (parentList != null) {
            DynamicSAXElementVisitorList childList = DynamicSAXElementVisitorList.getList(childExecutionContext);
            if (childList == null) {
                childList = new DynamicSAXElementVisitorList(childExecutionContext);
            }
            childList.visitBefores.addAll(parentList.visitBefores);
            childList.childVisitors.addAll(parentList.childVisitors);
            childList.visitAfters.addAll(parentList.visitAfters);
        }
    }

    public static void removeDynamicVisitor(SAXVisitor visitor, ExecutionContext executionContext) {
        DynamicSAXElementVisitorList list = DynamicSAXElementVisitorList.getList(executionContext);
        list.visitBefores.remove(visitor);
        list.childVisitors.remove(visitor);
        list.visitAfters.remove(visitor);
    }
}

