/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.delivery.sax;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.dhatim.assertion.AssertArgument;
import org.dhatim.delivery.sax.SAXElement;
import org.dhatim.delivery.sax.SAXElementWriterUtil;
import org.dhatim.delivery.sax.SAXText;
import org.dhatim.delivery.sax.SAXVisitor;
import org.dhatim.delivery.sax.TextType;

public class SAXToXMLWriter {
    private SAXVisitor owner;
    private boolean encodeSpecialChars;

    public SAXToXMLWriter(SAXVisitor owner, boolean encodeSpecialChars) {
        AssertArgument.isNotNull(owner, "owner");
        this.owner = owner;
        this.encodeSpecialChars = encodeSpecialChars;
    }

    public void writeStartElement(SAXElement element, Writer writer) throws IOException {
        SAXElementWriterUtil.writeStartElement(element, writer, this.encodeSpecialChars);
    }

    public void writeStartElement(SAXElement element) throws IOException {
        SAXElementWriterUtil.writeStartElement(element, element.getWriter(this.owner), this.encodeSpecialChars);
    }

    public void writeEndElement(SAXElement element, Writer writer) throws IOException {
        SAXElementWriterUtil.writeEndElement(element, writer);
    }

    public void writeEndElement(SAXElement element) throws IOException {
        SAXElementWriterUtil.writeEndElement(element, element.getWriter(this.owner));
    }

    public void writeText(SAXElement element, Writer writer) throws IOException {
        List<SAXText> textList = element.getText();
        if (textList == null) {
            return;
        }
        for (SAXText text : textList) {
            SAXElementWriterUtil.writeText(text, writer);
        }
    }

    public void writeText(SAXElement element) throws IOException {
        this.writeText(element, element.getWriter(this.owner));
    }

    public void writeText(SAXText text, Writer writer) throws IOException {
        SAXElementWriterUtil.writeText(text, writer);
    }

    public void writeText(SAXText text, SAXElement associatedElement) throws IOException {
        SAXElementWriterUtil.writeText(text, associatedElement.getWriter(this.owner));
    }

    public void writeText(String text, Writer writer) throws IOException {
        SAXElementWriterUtil.writeText(text, TextType.TEXT, writer);
    }

    public void writeText(String text, SAXElement associatedElement) throws IOException {
        SAXElementWriterUtil.writeText(text, TextType.TEXT, associatedElement.getWriter(this.owner));
    }

    public void writeEmptyElement(SAXElement element, Writer writer) throws IOException {
        SAXElementWriterUtil.writeEmptyElement(element, writer, this.encodeSpecialChars);
    }

    public void writeEmptyElement(SAXElement element) throws IOException {
        SAXElementWriterUtil.writeEmptyElement(element, element.getWriter(this.owner), this.encodeSpecialChars);
    }
}

