/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.event;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dhatim.delivery.VisitSequence;
import org.dhatim.event.ExecutionEvent;
import org.dhatim.event.ExecutionEventListener;
import org.dhatim.event.report.annotation.VisitAfterReport;
import org.dhatim.event.report.annotation.VisitBeforeReport;
import org.dhatim.event.types.ElementPresentEvent;
import org.dhatim.event.types.ElementVisitEvent;
import org.dhatim.event.types.FilterLifecycleEvent;
import org.dhatim.expression.MVELExpressionEvaluator;

public class BasicExecutionEventListener
implements ExecutionEventListener {
    private static Log logger = LogFactory.getLog(BasicExecutionEventListener.class);
    private List<ExecutionEvent> events = new ArrayList<ExecutionEvent>();
    private List<? extends Class<? extends ExecutionEvent>> filterEvents;

    public void setFilterEvents(Class<? extends ExecutionEvent> ... filterEvents) {
        this.filterEvents = filterEvents != null ? Arrays.asList(filterEvents) : null;
    }

    @Override
    public void onEvent(ExecutionEvent event) {
        if (this.ignoreEvent(event)) {
            return;
        }
        if (event != null) {
            this.events.add(event);
        } else {
            logger.warn((Object)"Invalid call to onEvent method.  null 'event' arg.");
        }
    }

    protected boolean ignoreEvent(ExecutionEvent event) {
        if (event instanceof FilterLifecycleEvent) {
            return false;
        }
        if (event instanceof ElementPresentEvent) {
            return false;
        }
        if (this.filterEvents != null && !this.filterEvents.contains(event.getClass())) {
            return true;
        }
        if (event instanceof ElementVisitEvent) {
            ElementVisitEvent visitEvent = (ElementVisitEvent)event;
            Object handler = visitEvent.getConfigMapping().getContentHandler();
            if (visitEvent.getSequence() == VisitSequence.BEFORE) {
                VisitBeforeReport reportAnnotation = handler.getClass().getAnnotation(VisitBeforeReport.class);
                if (reportAnnotation != null) {
                    return !this.evalReportCondition(visitEvent, reportAnnotation.condition());
                }
            } else {
                VisitAfterReport reportAnnotation = handler.getClass().getAnnotation(VisitAfterReport.class);
                if (reportAnnotation != null) {
                    return !this.evalReportCondition(visitEvent, reportAnnotation.condition());
                }
            }
        }
        return false;
    }

    private boolean evalReportCondition(ElementVisitEvent visitEvent, String condition) {
        MVELExpressionEvaluator conditionEval = new MVELExpressionEvaluator();
        conditionEval.setExpression(condition);
        return conditionEval.eval(visitEvent.getResourceConfig());
    }

    public List<ExecutionEvent> getEvents() {
        return this.events;
    }
}

