/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.javabean.decoders;

import java.text.NumberFormat;
import java.text.ParseException;
import org.dhatim.javabean.DataDecodeException;
import org.dhatim.javabean.DecodeType;
import org.dhatim.javabean.decoders.NumberDecoder;

@DecodeType(value={Integer.class, int.class})
public class IntegerDecoder
extends NumberDecoder {
    @Override
    public Object decode(String data) throws DataDecodeException {
        NumberFormat format = this.getNumberFormat();
        if (format != null) {
            try {
                Number number = format.parse(data.trim());
                if (this.isPercentage()) {
                    return (int)(number.doubleValue() * 100.0);
                }
                return number.intValue();
            }
            catch (ParseException e) {
                throw new DataDecodeException("Failed to decode Integer value '" + data + "' using NumberFormat instance " + format + ".", e);
            }
        }
        try {
            return Integer.parseInt(data.trim());
        }
        catch (NumberFormatException e) {
            throw new DataDecodeException("Failed to decode Integer value '" + data + "'.", e);
        }
    }
}

